/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.sensors.footSwitch;

import java.util.List;
import us.ihmc.commonWalkingControlModules.controlModules.CenterOfPressureResolver;
import us.ihmc.commonWalkingControlModules.desiredFootStep.DesiredFootstepCalculatorTools;
import us.ihmc.commonWalkingControlModules.sensors.footSwitch.HeelSwitch;
import us.ihmc.commonWalkingControlModules.sensors.footSwitch.ToeSwitch;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.yoGraphics.BagOfBalls;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicReferenceFrame;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.spatial.interfaces.SpatialForceReadOnly;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.robotics.contactable.ContactablePlaneBody;
import us.ihmc.robotics.math.filters.AlphaFilteredYoVariable;
import us.ihmc.robotics.math.filters.GlitchFilteredYoBoolean;
import us.ihmc.robotics.sensors.ForceSensorDataReadOnly;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class WrenchBasedFootSwitch
implements HeelSwitch,
ToeSwitch {
    private static final double MIN_FORCE_TO_COMPUTE_COP = 5.0;
    private final DoubleProvider contactThresholdForce;
    private final DoubleProvider secondContactThresholdForce;
    private final DoubleProvider footSwitchCoPThresholdFraction;
    private final YoRegistry registry;
    private final ForceSensorDataReadOnly forceSensorData;
    private final YoBoolean isForceMagnitudePastThreshold;
    private final GlitchFilteredYoBoolean filteredIsForceMagnitudePastThreshold;
    private final YoBoolean isForceMagnitudePastSecondThreshold;
    private final YoBoolean hasFootHitGround;
    private final YoBoolean isCoPPastThreshold;
    private final YoBoolean trustFootSwitch;
    private final YoBoolean controllerDetectedTouchdown;
    private final GlitchFilteredYoBoolean filteredHasFootHitGround;
    private final YoDouble footForceMagnitude;
    private final YoDouble alphaFootLoadFiltering;
    private final AlphaFilteredYoVariable footLoadPercentage;
    private final Wrench footWrench;
    private final BagOfBalls footswitchCOPBagOfBalls;
    private final YoBoolean pastThreshold;
    private final YoBoolean heelHitGround;
    private final YoBoolean toeHitGround;
    private final GlitchFilteredYoBoolean pastThresholdFilter;
    private final GlitchFilteredYoBoolean heelHitGroundFilter;
    private final GlitchFilteredYoBoolean toeHitGroundFilter;
    private final YoFramePoint2D yoResolvedCoP;
    private final FramePoint2D resolvedCoP;
    private final FramePoint3D resolvedCoP3d = new FramePoint3D();
    private final CenterOfPressureResolver copResolver = new CenterOfPressureResolver();
    private final ContactablePlaneBody contactablePlaneBody;
    private final double footLength;
    private final double footMinX;
    private final double footMaxX;
    private final FrameVector3D footForce = new FrameVector3D();
    private final FrameVector3D footTorque = new FrameVector3D();
    private final YoFrameVector3D yoFootForce;
    private final YoFrameVector3D yoFootTorque;
    private final YoFrameVector3D yoFootForceInFoot;
    private final YoFrameVector3D yoFootTorqueInFoot;
    private final YoFrameVector3D yoFootForceInWorld;
    private final YoFrameVector3D yoFootTorqueInWorld;
    private final double robotTotalWeight;
    private double minThresholdX;
    private double maxThresholdX;
    private final boolean showForceSensorFrames = false;
    private final YoGraphicReferenceFrame yoGraphicForceSensorMeasurementFrame;
    private final YoGraphicReferenceFrame yoGraphicForceSensorFootFrame;
    private final AppearanceDefinition redAppearance = YoAppearance.Red();
    private final AppearanceDefinition blueAppearance = YoAppearance.Blue();
    private Wrench footWrenchInBodyFixedFrame = new Wrench();

    public WrenchBasedFootSwitch(String namePrefix, ForceSensorDataReadOnly forceSensorData, double robotTotalWeight, ContactablePlaneBody contactablePlaneBody, DoubleProvider contactThresholdForce, DoubleProvider secondContactThresholdForce, DoubleProvider footSwitchCoPThresholdFraction, YoGraphicsListRegistry yoGraphicsListRegistry, YoRegistry parentRegistry) {
        this.registry = new YoRegistry(namePrefix + this.getClass().getSimpleName());
        this.contactThresholdForce = contactThresholdForce;
        this.secondContactThresholdForce = secondContactThresholdForce;
        this.footSwitchCoPThresholdFraction = footSwitchCoPThresholdFraction;
        this.yoFootForce = new YoFrameVector3D(namePrefix + "Force", forceSensorData.getMeasurementFrame(), this.registry);
        this.yoFootTorque = new YoFrameVector3D(namePrefix + "Torque", forceSensorData.getMeasurementFrame(), this.registry);
        this.yoFootForceInFoot = new YoFrameVector3D(namePrefix + "ForceFootFrame", (ReferenceFrame)contactablePlaneBody.getFrameAfterParentJoint(), this.registry);
        this.yoFootTorqueInFoot = new YoFrameVector3D(namePrefix + "TorqueFootFrame", (ReferenceFrame)contactablePlaneBody.getFrameAfterParentJoint(), this.registry);
        this.yoFootForceInWorld = new YoFrameVector3D(namePrefix + "ForceWorldFrame", ReferenceFrame.getWorldFrame(), this.registry);
        this.yoFootTorqueInWorld = new YoFrameVector3D(namePrefix + "TorqueWorldFrame", ReferenceFrame.getWorldFrame(), this.registry);
        this.yoGraphicForceSensorMeasurementFrame = null;
        this.yoGraphicForceSensorFootFrame = null;
        this.footForceMagnitude = new YoDouble(namePrefix + "FootForceMag", this.registry);
        this.isForceMagnitudePastThreshold = new YoBoolean(namePrefix + "ForcePastThreshold", this.registry);
        this.hasFootHitGround = new YoBoolean(namePrefix + "FootHitGround", this.registry);
        this.trustFootSwitch = new YoBoolean(namePrefix + "TrustFootSwitch", this.registry);
        this.controllerDetectedTouchdown = new YoBoolean(namePrefix + "ControllerDetectedTouchdown", this.registry);
        this.trustFootSwitch.set(true);
        this.filteredHasFootHitGround = new GlitchFilteredYoBoolean(namePrefix + "FilteredFootHitGround", this.registry, this.hasFootHitGround, 2);
        this.filteredIsForceMagnitudePastThreshold = new GlitchFilteredYoBoolean(namePrefix + "FilteredForcePastThresh", this.registry, this.isForceMagnitudePastThreshold, 2);
        this.isForceMagnitudePastSecondThreshold = new YoBoolean(namePrefix + "ForcePastSecondThresh", this.registry);
        this.isCoPPastThreshold = new YoBoolean(namePrefix + "CoPPastThresh", this.registry);
        this.robotTotalWeight = robotTotalWeight;
        this.alphaFootLoadFiltering = new YoDouble(namePrefix + "AlphaFootLoadFiltering", this.registry);
        this.alphaFootLoadFiltering.set(0.1);
        this.footLoadPercentage = new AlphaFilteredYoVariable(namePrefix + "FootLoadPercentage", this.registry, (DoubleProvider)this.alphaFootLoadFiltering);
        double copVisualizerSize = 0.025;
        this.footswitchCOPBagOfBalls = new BagOfBalls(1, copVisualizerSize, namePrefix + "FootswitchCOP", this.registry, yoGraphicsListRegistry);
        this.pastThreshold = new YoBoolean(namePrefix + "PastFootswitchThreshold", this.registry);
        this.heelHitGround = new YoBoolean(namePrefix + "HeelHitGround", this.registry);
        this.toeHitGround = new YoBoolean(namePrefix + "ToeHitGround", this.registry);
        int filterWindowSize = 3;
        this.pastThresholdFilter = new GlitchFilteredYoBoolean(namePrefix + "PastFootswitchThresholdFilter", this.registry, this.pastThreshold, filterWindowSize);
        this.heelHitGroundFilter = new GlitchFilteredYoBoolean(namePrefix + "HeelHitGroundFilter", this.registry, this.heelHitGround, filterWindowSize);
        this.toeHitGroundFilter = new GlitchFilteredYoBoolean(namePrefix + "ToeHitGroundFilter", this.registry, this.toeHitGround, filterWindowSize);
        this.contactablePlaneBody = contactablePlaneBody;
        this.yoResolvedCoP = new YoFramePoint2D(namePrefix + "ResolvedCoP", "", contactablePlaneBody.getSoleFrame(), this.registry);
        this.resolvedCoP = new FramePoint2D(contactablePlaneBody.getSoleFrame());
        this.forceSensorData = forceSensorData;
        this.footWrench = new Wrench(forceSensorData.getMeasurementFrame(), (ReferenceFrame)null);
        this.footMinX = WrenchBasedFootSwitch.computeMinX(contactablePlaneBody);
        this.footMaxX = WrenchBasedFootSwitch.computeMaxX(contactablePlaneBody);
        this.footLength = WrenchBasedFootSwitch.computeLength(contactablePlaneBody);
        parentRegistry.addChild(this.registry);
    }

    public boolean hasFootHitGround() {
        this.isForceMagnitudePastThreshold.set(this.isForceMagnitudePastThreshold());
        this.filteredIsForceMagnitudePastThreshold.update();
        if (this.secondContactThresholdForce != null) {
            this.isForceMagnitudePastSecondThreshold.set(this.yoFootForceInFoot.getZ() > this.secondContactThresholdForce.getValue());
        } else {
            this.isForceMagnitudePastSecondThreshold.set(false);
        }
        this.isCoPPastThreshold.set(this.isCoPPastThreshold());
        this.hasFootHitGround.set(this.filteredIsForceMagnitudePastThreshold.getBooleanValue() && this.isCoPPastThreshold.getBooleanValue() || this.isForceMagnitudePastSecondThreshold.getBooleanValue());
        this.filteredHasFootHitGround.update();
        if (this.trustFootSwitch.getBooleanValue()) {
            return this.filteredHasFootHitGround.getBooleanValue();
        }
        return this.controllerDetectedTouchdown.getBooleanValue();
    }

    public void reset() {
        this.pastThresholdFilter.set(false);
        this.heelHitGroundFilter.set(false);
        this.toeHitGroundFilter.set(false);
        this.controllerDetectedTouchdown.set(false);
    }

    @Override
    public void resetHeelSwitch() {
        this.heelHitGroundFilter.set(false);
    }

    @Override
    public void resetToeSwitch() {
        this.toeHitGroundFilter.set(false);
    }

    @Override
    public boolean hasHeelHitGround() {
        this.heelHitGround.set(this.isForceMagnitudePastThreshold());
        this.heelHitGroundFilter.update();
        return this.heelHitGroundFilter.getBooleanValue();
    }

    @Override
    public boolean hasToeHitGround() {
        this.toeHitGround.set(this.isForceMagnitudePastThreshold());
        this.toeHitGroundFilter.update();
        return this.toeHitGroundFilter.getBooleanValue();
    }

    public double computeFootLoadPercentage() {
        this.readSensorData(this.footWrench);
        this.footForce.setIncludingFrame((FrameTuple3DReadOnly)this.yoFootForceInFoot);
        this.footForce.clipToMinMax(0.0, Double.MAX_VALUE);
        this.footForceMagnitude.set(this.footForce.length());
        this.footLoadPercentage.update(this.footForce.getZ() / this.robotTotalWeight);
        return this.footLoadPercentage.getDoubleValue();
    }

    public void computeAndPackFootWrench(Wrench footWrenchToPack) {
        this.readSensorData(footWrenchToPack);
    }

    public ReferenceFrame getMeasurementFrame() {
        return this.forceSensorData.getMeasurementFrame();
    }

    private boolean isCoPPastThreshold() {
        if (Double.isNaN(this.footSwitchCoPThresholdFraction.getValue())) {
            return true;
        }
        this.updateCoP();
        this.minThresholdX = this.footMinX + this.footSwitchCoPThresholdFraction.getValue() * this.footLength;
        this.maxThresholdX = this.footMaxX - this.footSwitchCoPThresholdFraction.getValue() * this.footLength;
        if (this.toeHitGroundFilter.getBooleanValue()) {
            this.pastThreshold.set(this.resolvedCoP.getX() <= this.maxThresholdX);
        } else if (this.heelHitGroundFilter.getBooleanValue()) {
            this.pastThreshold.set(this.resolvedCoP.getX() >= this.minThresholdX);
        } else {
            this.pastThreshold.set(this.resolvedCoP.getX() >= this.minThresholdX && this.resolvedCoP.getX() <= this.maxThresholdX);
        }
        this.pastThresholdFilter.update();
        AppearanceDefinition appearanceDefinition = this.pastThresholdFilter.getBooleanValue() ? this.redAppearance : this.blueAppearance;
        this.footswitchCOPBagOfBalls.setBall((FramePoint3DReadOnly)this.resolvedCoP3d, appearanceDefinition, 0);
        return this.pastThresholdFilter.getBooleanValue();
    }

    public void computeAndPackCoP(FramePoint2D copToPack) {
        this.updateCoP();
        copToPack.setIncludingFrame((FrameTuple2DReadOnly)this.resolvedCoP);
    }

    public void updateCoP() {
        this.readSensorData(this.footWrench);
        if (Math.abs(this.footWrench.getLinearPartZ()) < 5.0) {
            this.yoResolvedCoP.setToNaN();
            this.resolvedCoP3d.setToNaN(ReferenceFrame.getWorldFrame());
            this.resolvedCoP.setToNaN();
        } else {
            this.copResolver.resolveCenterOfPressureAndNormalTorque((FramePoint2DBasics)this.resolvedCoP, (SpatialForceReadOnly)this.footWrench, this.contactablePlaneBody.getSoleFrame());
            this.yoResolvedCoP.set((FrameTuple2DReadOnly)this.resolvedCoP);
            this.resolvedCoP3d.setToZero(this.resolvedCoP.getReferenceFrame());
            this.resolvedCoP3d.set((FrameTuple2DReadOnly)this.resolvedCoP);
            this.resolvedCoP3d.changeFrame(ReferenceFrame.getWorldFrame());
        }
    }

    private void readSensorData(Wrench footWrenchToPack) {
        this.forceSensorData.getWrench(footWrenchToPack);
        this.footForce.setToZero(footWrenchToPack.getReferenceFrame());
        this.footForce.set((FrameTuple3DReadOnly)footWrenchToPack.getLinearPart());
        this.yoFootForce.set((FrameTuple3DReadOnly)this.footForce);
        this.footTorque.setToZero(footWrenchToPack.getReferenceFrame());
        this.footTorque.set((FrameTuple3DReadOnly)footWrenchToPack.getAngularPart());
        this.yoFootTorque.set((FrameTuple3DReadOnly)this.footTorque);
        this.footForceMagnitude.set(this.footForce.length());
        this.footWrenchInBodyFixedFrame.setIncludingFrame((WrenchReadOnly)footWrenchToPack);
        this.footWrenchInBodyFixedFrame.changeFrame((ReferenceFrame)this.contactablePlaneBody.getRigidBody().getBodyFixedFrame());
        this.footForce.setToZero(this.footWrenchInBodyFixedFrame.getReferenceFrame());
        this.footForce.set((FrameTuple3DReadOnly)this.footWrenchInBodyFixedFrame.getLinearPart());
        this.footTorque.setToZero(this.footWrenchInBodyFixedFrame.getReferenceFrame());
        this.footTorque.set((FrameTuple3DReadOnly)this.footWrenchInBodyFixedFrame.getAngularPart());
        this.footForce.changeFrame((ReferenceFrame)this.contactablePlaneBody.getFrameAfterParentJoint());
        this.yoFootForceInFoot.set((FrameTuple3DReadOnly)this.footForce);
        this.footTorque.changeFrame((ReferenceFrame)this.contactablePlaneBody.getFrameAfterParentJoint());
        this.yoFootTorqueInFoot.set((FrameTuple3DReadOnly)this.footTorque);
        this.footForce.changeFrame(ReferenceFrame.getWorldFrame());
        this.footTorque.changeFrame(ReferenceFrame.getWorldFrame());
        this.yoFootForceInWorld.set((FrameTuple3DReadOnly)this.footForce);
        this.yoFootTorqueInWorld.set((FrameTuple3DReadOnly)this.footTorque);
        this.updateSensorVisualizer();
    }

    private void updateSensorVisualizer() {
        if (this.yoGraphicForceSensorMeasurementFrame != null) {
            this.yoGraphicForceSensorMeasurementFrame.update();
        }
        if (this.yoGraphicForceSensorFootFrame != null) {
            this.yoGraphicForceSensorFootFrame.update();
        }
    }

    private boolean isForceMagnitudePastThreshold() {
        this.readSensorData(this.footWrench);
        return this.yoFootForceInFoot.getZ() > this.contactThresholdForce.getValue();
    }

    private static double computeLength(ContactablePlaneBody contactablePlaneBody) {
        FrameVector3D forward = new FrameVector3D(contactablePlaneBody.getSoleFrame(), 1.0, 0.0, 0.0);
        List<FramePoint3D> maxForward = DesiredFootstepCalculatorTools.computeMaximumPointsInDirection(contactablePlaneBody.getContactPointsCopy(), forward, 1);
        FrameVector3D back = new FrameVector3D(contactablePlaneBody.getSoleFrame(), -1.0, 0.0, 0.0);
        List<FramePoint3D> maxBack = DesiredFootstepCalculatorTools.computeMaximumPointsInDirection(contactablePlaneBody.getContactPointsCopy(), back, 1);
        return maxForward.get(0).getX() - maxBack.get(0).getX();
    }

    private static double computeMinX(ContactablePlaneBody contactablePlaneBody) {
        FrameVector3D back = new FrameVector3D(contactablePlaneBody.getSoleFrame(), -1.0, 0.0, 0.0);
        List<FramePoint3D> maxBack = DesiredFootstepCalculatorTools.computeMaximumPointsInDirection(contactablePlaneBody.getContactPointsCopy(), back, 1);
        return maxBack.get(0).getX();
    }

    private static double computeMaxX(ContactablePlaneBody contactablePlaneBody) {
        FrameVector3D front = new FrameVector3D(contactablePlaneBody.getSoleFrame(), 1.0, 0.0, 0.0);
        List<FramePoint3D> maxFront = DesiredFootstepCalculatorTools.computeMaximumPointsInDirection(contactablePlaneBody.getContactPointsCopy(), front, 1);
        return maxFront.get(0).getX();
    }

    public boolean getForceMagnitudePastThreshhold() {
        return this.isForceMagnitudePastThreshold.getBooleanValue();
    }

    public ContactablePlaneBody getContactablePlaneBody() {
        return this.contactablePlaneBody;
    }

    @Deprecated
    public void setFootContactState(boolean hasFootHitGround) {
        this.controllerDetectedTouchdown.set(hasFootHitGround);
    }

    public void trustFootSwitchInSwing(boolean trustFootSwitch) {
        this.trustFootSwitch.set(trustFootSwitch);
    }

    @Deprecated
    public void trustFootSwitchInSupport(boolean trustFootSwitch) {
        throw new RuntimeException("This is not a different implementation by default.");
    }

    public YoRegistry getRegistry() {
        return this.registry;
    }
}

