/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.sensors.footSwitch;

import java.util.Collection;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.robotics.contactable.ContactablePlaneBody;
import us.ihmc.robotics.robotSide.QuadrantDependentList;
import us.ihmc.robotics.robotSide.RobotQuadrant;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SegmentDependentList;
import us.ihmc.robotics.sensors.FootSwitchInterface;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint2D;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class KinematicsBasedFootSwitch
implements FootSwitchInterface {
    private final YoRegistry registry;
    private final YoBoolean hitGround;
    private final YoBoolean fixedOnGround;
    private final DoubleProvider switchZThreshold;
    private final YoDouble soleZ;
    private final YoDouble ankleZ;
    private final double totalRobotWeight;
    private final ContactablePlaneBody foot;
    private final ContactablePlaneBody[] otherFeet;
    private final YoFramePoint2D yoResolvedCoP;
    FramePoint3D tmpFramePoint = new FramePoint3D();
    private final Vector3D footForce = new Vector3D();

    public KinematicsBasedFootSwitch(String footName, SegmentDependentList<RobotSide, ? extends ContactablePlaneBody> bipedFeet, DoubleProvider switchZThreshold, double totalRobotWeight, RobotSide side, YoRegistry parentRegistry) {
        this.registry = new YoRegistry(footName + this.getClass().getSimpleName());
        this.foot = (ContactablePlaneBody)bipedFeet.get((Enum)side);
        ContactablePlaneBody oppositeFoot = (ContactablePlaneBody)bipedFeet.get((Enum)side.getOppositeSide());
        this.otherFeet = new ContactablePlaneBody[]{oppositeFoot};
        this.totalRobotWeight = totalRobotWeight;
        this.hitGround = new YoBoolean(footName + "hitGround", this.registry);
        this.fixedOnGround = new YoBoolean(footName + "fixedOnGround", this.registry);
        this.soleZ = new YoDouble(footName + "soleZ", this.registry);
        this.ankleZ = new YoDouble(footName + "ankleZ", this.registry);
        this.switchZThreshold = switchZThreshold;
        this.yoResolvedCoP = new YoFramePoint2D(footName + "ResolvedCoP", "", this.foot.getSoleFrame(), this.registry);
        parentRegistry.addChild(this.registry);
    }

    public KinematicsBasedFootSwitch(String footName, ContactablePlaneBody foot, Collection<? extends ContactablePlaneBody> otherFeet, DoubleProvider switchZThreshold, double totalRobotWeight, YoRegistry parentRegistry) {
        this.registry = new YoRegistry(footName + this.getClass().getSimpleName());
        this.foot = foot;
        this.otherFeet = otherFeet.toArray(new ContactablePlaneBody[otherFeet.size()]);
        this.totalRobotWeight = totalRobotWeight;
        this.hitGround = new YoBoolean(footName + "hitGround", this.registry);
        this.fixedOnGround = new YoBoolean(footName + "fixedOnGround", this.registry);
        this.soleZ = new YoDouble(footName + "soleZ", this.registry);
        this.ankleZ = new YoDouble(footName + "ankleZ", this.registry);
        this.switchZThreshold = switchZThreshold;
        this.yoResolvedCoP = new YoFramePoint2D(footName + "ResolvedCoP", "", foot.getSoleFrame(), this.registry);
        parentRegistry.addChild(this.registry);
    }

    public KinematicsBasedFootSwitch(String footName, QuadrantDependentList<? extends ContactablePlaneBody> quadrupedFeet, DoubleProvider switchZThreshold, double totalRobotWeight, RobotQuadrant quadrant, YoRegistry parentRegistry) {
        this.registry = new YoRegistry(footName + this.getClass().getSimpleName());
        this.foot = (ContactablePlaneBody)quadrupedFeet.get((Enum)quadrant);
        ContactablePlaneBody acrossBodyFrontFoot = (ContactablePlaneBody)quadrupedFeet.get((Enum)quadrant.getAcrossBodyFrontQuadrant());
        ContactablePlaneBody acrossBodyHindFoot = (ContactablePlaneBody)quadrupedFeet.get((Enum)quadrant.getAcrossBodyHindQuadrant());
        ContactablePlaneBody sameSideFoot = (ContactablePlaneBody)quadrupedFeet.get((Enum)quadrant.getSameSideQuadrant());
        this.otherFeet = new ContactablePlaneBody[]{acrossBodyFrontFoot, acrossBodyHindFoot, sameSideFoot};
        this.totalRobotWeight = totalRobotWeight;
        this.hitGround = new YoBoolean(footName + "hitGround", this.registry);
        this.fixedOnGround = new YoBoolean(footName + "fixedOnGround", this.registry);
        this.soleZ = new YoDouble(footName + "soleZ", this.registry);
        this.ankleZ = new YoDouble(footName + "ankleZ", this.registry);
        this.switchZThreshold = switchZThreshold;
        this.yoResolvedCoP = new YoFramePoint2D(footName + "ResolvedCoP", "", this.foot.getSoleFrame(), this.registry);
        parentRegistry.addChild(this.registry);
    }

    private Point3DReadOnly getPointInWorld(ReferenceFrame frame) {
        this.tmpFramePoint.setToZero(frame);
        this.tmpFramePoint.changeFrame(ReferenceFrame.getWorldFrame());
        return this.tmpFramePoint;
    }

    public boolean hasFootHitGround() {
        double lowestFootZ;
        double thisFootZ = this.getPointInWorld(this.foot.getSoleFrame()).getZ();
        this.hitGround.set(thisFootZ - (lowestFootZ = this.getLowestFootZInWorld()) < this.switchZThreshold.getValue());
        this.soleZ.set(thisFootZ);
        this.ankleZ.set(this.getPointInWorld((ReferenceFrame)this.foot.getFrameAfterParentJoint()).getZ());
        return this.hitGround.getBooleanValue();
    }

    private double getLowestFootZInWorld() {
        double lowestZ = Double.MAX_VALUE;
        for (int i = 0; i < this.otherFeet.length; ++i) {
            double z = this.getPointInWorld(this.otherFeet[i].getSoleFrame()).getZ();
            if (!(z < lowestZ)) continue;
            lowestZ = z;
        }
        return lowestZ;
    }

    public double computeFootLoadPercentage() {
        return Double.NaN;
    }

    public void computeAndPackCoP(FramePoint2D copToPack) {
        copToPack.setToNaN(this.getMeasurementFrame());
    }

    public void updateCoP() {
        this.yoResolvedCoP.setToZero();
    }

    public void computeAndPackFootWrench(Wrench footWrenchToPack) {
        footWrenchToPack.setToZero((ReferenceFrame)this.foot.getRigidBody().getBodyFixedFrame(), this.foot.getSoleFrame());
        if (this.hasFootHitGround()) {
            this.footForce.set(0.0, 0.0, this.totalRobotWeight);
            footWrenchToPack.getLinearPart().setMatchingFrame(ReferenceFrame.getWorldFrame(), (Tuple3DReadOnly)this.footForce);
        }
    }

    public ReferenceFrame getMeasurementFrame() {
        return this.foot.getSoleFrame();
    }

    public void reset() {
    }

    public boolean getForceMagnitudePastThreshhold() {
        double lowestFootZ;
        double thisFootZ = this.getPointInWorld(this.foot.getSoleFrame()).getZ();
        this.fixedOnGround.set(thisFootZ - (lowestFootZ = this.getLowestFootZInWorld()) < this.switchZThreshold.getValue() * 2.0);
        return this.fixedOnGround.getBooleanValue();
    }

    @Deprecated
    public void setFootContactState(boolean hasFootHitGround) {
    }

    public void trustFootSwitchInSwing(boolean trustFootSwitch) {
    }

    public void trustFootSwitchInSupport(boolean trustFootSwitch) {
    }
}

