/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.sensors.footSwitch;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.factory.LinearSolverFactory_DDRM;
import org.ejml.interfaces.linsol.LinearSolverDense;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.robotModels.FullLeggedRobotModel;
import us.ihmc.robotics.math.filters.GlitchFilteredYoBoolean;
import us.ihmc.robotics.screwTheory.GeometricJacobian;
import us.ihmc.robotics.sensors.FootSwitchInterface;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class ComputedForceBasedFootSwitch<E extends Enum<E>>
implements FootSwitchInterface {
    private final String name = this.getClass().getSimpleName();
    private final YoRegistry registry;
    private final GeometricJacobian jacobian;
    private final OneDoFJointBasics[] jointsFromRootToSole;
    private final DMatrixRMaj jacobianInverse;
    private final DMatrixRMaj footWrench = new DMatrixRMaj(6, 1);
    private final DMatrixRMaj jointTorques;
    private final GlitchFilteredYoBoolean isInContact;
    private final DoubleProvider contactThresholdForce;
    private final YoBoolean pastThreshold;
    private final YoDouble measuredZForce;
    private final FrameVector3D footForce = new FrameVector3D();
    private final Wrench wrench = new Wrench();
    private final LinearSolverDense<DMatrixRMaj> solver = LinearSolverFactory_DDRM.pseudoInverse((boolean)true);
    private final double standingZForce;
    private MovingReferenceFrame soleFrame;

    public ComputedForceBasedFootSwitch(FullLeggedRobotModel<E> robotModel, E robotSegment, DoubleProvider contactThresholdForce, YoRegistry parentRegistry) {
        String prefix = ((Enum)robotSegment).toString() + this.name;
        this.registry = new YoRegistry(prefix);
        int filterWindowSize = 3;
        this.measuredZForce = new YoDouble(prefix + "measuredZForce", this.registry);
        this.pastThreshold = new YoBoolean(prefix + "PastFootswitchThreshold", this.registry);
        this.contactThresholdForce = contactThresholdForce;
        this.isInContact = new GlitchFilteredYoBoolean(prefix + "IsInContact", this.registry, this.pastThreshold, filterWindowSize);
        RigidBodyBasics body = robotModel.getRootBody();
        RigidBodyBasics foot = robotModel.getFoot(robotSegment);
        this.soleFrame = robotModel.getSoleFrame(robotSegment);
        this.jacobian = new GeometricJacobian(body, foot, (ReferenceFrame)this.soleFrame);
        this.jointsFromRootToSole = MultiBodySystemTools.createOneDoFJointPath((RigidBodyBasics)body, (RigidBodyBasics)foot);
        this.jointTorques = new DMatrixRMaj(this.jointsFromRootToSole.length, 1);
        this.jacobianInverse = new DMatrixRMaj(this.jointsFromRootToSole.length, 3);
        parentRegistry.addChild(this.registry);
        double totalMass = robotModel.getTotalMass();
        this.standingZForce = totalMass * 9.81;
    }

    public void update() {
        for (int i = 0; i < this.jointsFromRootToSole.length; ++i) {
            OneDoFJointBasics oneDoFJoint = this.jointsFromRootToSole[i];
            this.jointTorques.set(i, 0, oneDoFJoint.getTau());
        }
        this.jacobian.compute();
        this.solver.setA((Matrix)this.jacobian.getJacobianMatrix());
        this.solver.invert((Matrix)this.jacobianInverse);
        CommonOps_DDRM.multTransA((DMatrix1Row)this.jacobianInverse, (DMatrix1Row)this.jointTorques, (DMatrix1Row)this.footWrench);
        this.wrench.setIncludingFrame(this.jacobian.getJacobianFrame(), (DMatrix)this.footWrench);
        this.footForce.setToZero(this.jacobian.getJacobianFrame());
        this.footForce.set((FrameTuple3DReadOnly)this.wrench.getLinearPart());
        this.footForce.changeFrame(ReferenceFrame.getWorldFrame());
        this.measuredZForce.set(this.footForce.getZ() * -1.0);
        this.pastThreshold.set(this.measuredZForce.getDoubleValue() > this.contactThresholdForce.getValue());
        this.isInContact.update();
    }

    public boolean hasFootHitGround() {
        this.update();
        return this.isInContact.getBooleanValue();
    }

    public double computeFootLoadPercentage() {
        return Math.min(1.0, this.measuredZForce.getDoubleValue() / this.standingZForce);
    }

    public void computeAndPackCoP(FramePoint2D copToPack) {
        copToPack.setToZero((ReferenceFrame)this.soleFrame);
    }

    public void updateCoP() {
    }

    public void computeAndPackFootWrench(Wrench footWrenchToPack) {
        footWrenchToPack.setIncludingFrame((WrenchReadOnly)this.wrench);
    }

    public ReferenceFrame getMeasurementFrame() {
        return this.jacobian.getJacobianFrame();
    }

    public void reset() {
        this.isInContact.set(false);
    }

    public boolean getForceMagnitudePastThreshhold() {
        return this.isInContact.getBooleanValue();
    }

    public void setFootContactState(boolean hasFootHitGround) {
        this.isInContact.set(hasFootHitGround);
    }

    public void trustFootSwitchInSwing(boolean trustFootSwitch) {
    }

    public void trustFootSwitchInSupport(boolean trustFootSwitch) {
    }
}

