/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.sensors.footSwitch;

import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.robotics.sensors.FootSwitchInterface;

public class AlwaysInContactFootSwitch
implements FootSwitchInterface {
    private final ReferenceFrame measurementFrame;
    private final double weightOnFoot;

    public AlwaysInContactFootSwitch(double weightOnFoot, ReferenceFrame measurementFrame) {
        this.measurementFrame = measurementFrame;
        this.weightOnFoot = weightOnFoot;
    }

    public boolean hasFootHitGround() {
        return true;
    }

    public double computeFootLoadPercentage() {
        return Double.NaN;
    }

    public void computeAndPackCoP(FramePoint2D copToPack) {
        copToPack.setToNaN(this.measurementFrame);
    }

    public void updateCoP() {
    }

    public void computeAndPackFootWrench(Wrench footWrenchToPack) {
        footWrenchToPack.setToZero();
        if (this.hasFootHitGround()) {
            footWrenchToPack.setLinearPartZ(this.weightOnFoot / 4.0);
        }
    }

    public ReferenceFrame getMeasurementFrame() {
        return this.measurementFrame;
    }

    public void reset() {
    }

    public boolean getForceMagnitudePastThreshhold() {
        return false;
    }

    public void setFootContactState(boolean hasFootHitGround) {
    }

    public void trustFootSwitchInSwing(boolean trustFootSwitch) {
    }

    public void trustFootSwitchInSupport(boolean trustFootSwitch) {
    }
}

