/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.sensors;

import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPosition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicVector;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsList;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.mecano.multiBodySystem.RigidBody;
import us.ihmc.mecano.multiBodySystem.SixDoFJoint;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.SpatialAcceleration;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.spatial.interfaces.SpatialAccelerationReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialMotionReadOnly;
import us.ihmc.mecano.spatial.interfaces.WrenchBasics;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class ProvidedMassMatrixToolRigidBody {
    private final YoRegistry registry;
    private final RigidBodyBasics toolBody;
    private final ReferenceFrame handFixedFrame;
    private final ReferenceFrame handControlFrame;
    private final YoFramePoint3D objectCenterOfMass;
    private final YoFramePoint3D objectCenterOfMassInWorld;
    private final YoFrameVector3D objectForceInWorld;
    private final YoDouble objectMass;
    private final double gravity;
    private final SixDoFJoint toolJoint;
    private final ReferenceFrame elevatorFrame;
    private final FramePoint3D temporaryPoint = new FramePoint3D();
    private final FrameVector3D temporaryVector = new FrameVector3D();
    private final SpatialAcceleration toolAcceleration = new SpatialAcceleration();
    private boolean hasBeenInitialized = false;
    private final FramePoint3D toolFramePoint = new FramePoint3D();

    public ProvidedMassMatrixToolRigidBody(RobotSide robotSide, FullHumanoidRobotModel fullRobotModel, double gravity, YoRegistry parentRegistry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        String name = robotSide.getCamelCaseNameForStartOfExpression() + "Tool";
        this.registry = new YoRegistry(name);
        this.gravity = gravity;
        this.handFixedFrame = fullRobotModel.getHand(robotSide).getBodyFixedFrame();
        this.handControlFrame = fullRobotModel.getHandControlFrame(robotSide);
        this.elevatorFrame = fullRobotModel.getElevatorFrame();
        this.toolJoint = new SixDoFJoint(name + "Joint", fullRobotModel.getElevator());
        this.toolBody = new RigidBody(name + "Body", (JointBasics)this.toolJoint, (Matrix3DReadOnly)new Matrix3D(), 0.0, (RigidBodyTransformReadOnly)new RigidBodyTransform());
        this.objectCenterOfMass = new YoFramePoint3D(name + "CoMOffset", this.handControlFrame, this.registry);
        this.objectMass = new YoDouble(name + "ObjectMass", this.registry);
        this.objectForceInWorld = new YoFrameVector3D(name + "Force", ReferenceFrame.getWorldFrame(), this.registry);
        this.objectCenterOfMassInWorld = new YoFramePoint3D(name + "CoMInWorld", ReferenceFrame.getWorldFrame(), this.registry);
        if (yoGraphicsListRegistry != null) {
            YoGraphicsList yoGraphicsList = new YoGraphicsList(name);
            YoGraphicPosition comViz = new YoGraphicPosition(name + "CenterOfMassViz", this.objectCenterOfMassInWorld, 0.05, YoAppearance.Red());
            yoGraphicsList.add((YoGraphic)comViz);
            YoGraphicVector vectorViz = new YoGraphicVector(name + "ForceViz", this.objectCenterOfMassInWorld, this.objectForceInWorld, YoAppearance.Yellow());
            yoGraphicsList.add((YoGraphic)vectorViz);
            yoGraphicsListRegistry.registerYoGraphicsList(yoGraphicsList);
        }
        parentRegistry.addChild(this.registry);
    }

    private void initialize() {
        this.hasBeenInitialized = true;
    }

    public void update() {
        this.toolBody.getInertia().setMass(this.objectMass.getDoubleValue());
        this.temporaryPoint.setIncludingFrame((FrameTuple3DReadOnly)this.objectCenterOfMass);
        this.temporaryPoint.changeFrame((ReferenceFrame)this.toolBody.getBodyFixedFrame());
        this.toolBody.setCenterOfMass((FramePoint3DReadOnly)this.temporaryPoint);
        this.toolFramePoint.changeFrame(ReferenceFrame.getWorldFrame());
        this.objectCenterOfMassInWorld.set((FrameTuple3DReadOnly)this.toolFramePoint);
    }

    public void control(SpatialAccelerationReadOnly handSpatialAccelerationVector, Wrench toolWrench) {
        if (!this.hasBeenInitialized) {
            this.update();
            this.initialize();
        }
        this.update();
        this.temporaryVector.setIncludingFrame(this.elevatorFrame, 0.0, 0.0, this.gravity);
        this.temporaryVector.changeFrame(handSpatialAccelerationVector.getReferenceFrame());
        this.toolAcceleration.setIncludingFrame((SpatialMotionReadOnly)handSpatialAccelerationVector);
        this.toolAcceleration.getLinearPart().add((FrameTuple3DReadOnly)this.temporaryVector);
        this.toolAcceleration.changeFrame((ReferenceFrame)this.toolBody.getBodyFixedFrame());
        this.toolAcceleration.setBaseFrame(this.elevatorFrame);
        this.toolAcceleration.setBodyFrame((ReferenceFrame)this.toolBody.getBodyFixedFrame());
        toolWrench.setToZero(this.handFixedFrame, this.handFixedFrame);
        this.toolBody.getInertia().computeDynamicWrench((SpatialAccelerationReadOnly)this.toolAcceleration, this.toolBody.getBodyFixedFrame().getTwistOfFrame(), (WrenchBasics)toolWrench);
        toolWrench.negate();
        toolWrench.changeFrame(this.handFixedFrame);
        toolWrench.setBodyFrame(this.handFixedFrame);
        this.temporaryVector.setIncludingFrame(this.handFixedFrame, toolWrench.getLinearPartX(), toolWrench.getLinearPartY(), toolWrench.getLinearPartZ());
        this.temporaryVector.changeFrame(ReferenceFrame.getWorldFrame());
        this.temporaryVector.scale(0.01);
        this.objectForceInWorld.set((FrameTuple3DReadOnly)this.temporaryVector);
    }

    public void setMass(double mass) {
        this.objectMass.set(mass);
    }
}

