/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.referenceFrames;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicReferenceFrame;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.yoVariables.registry.YoRegistry;

public class ReferenceFramesVisualizer {
    private static final double DEFAULT_SIZE = 0.2;
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final String groupName;
    private final YoGraphicsListRegistry yoGraphicsListRegistry;
    private final List<YoGraphicReferenceFrame> referenceFramesVisualizers = new ArrayList<YoGraphicReferenceFrame>();

    public ReferenceFramesVisualizer(String groupName, YoGraphicsListRegistry yoGraphicsListRegistry, YoRegistry parentRegistry) {
        this.groupName = groupName;
        this.yoGraphicsListRegistry = yoGraphicsListRegistry;
        parentRegistry.addChild(this.registry);
    }

    public void addReferenceFrame(ReferenceFrame referenceFrame) {
        this.addReferenceFrame(referenceFrame, 0.2);
    }

    public void addReferenceFrame(ReferenceFrame referenceFrame, double size) {
        this.addReferenceFrame(referenceFrame, false, size);
    }

    public void addReferenceFrame(ReferenceFrame referenceFrame, boolean useYawPitchRoll) {
        this.addReferenceFrame(referenceFrame, useYawPitchRoll, 0.2);
    }

    public void addReferenceFrame(ReferenceFrame referenceFrame, boolean useYawPitchRoll, double size) {
        YoGraphicReferenceFrame yoGraphic = new YoGraphicReferenceFrame(referenceFrame, this.registry, useYawPitchRoll, size);
        this.yoGraphicsListRegistry.registerYoGraphic(this.groupName, (YoGraphic)yoGraphic);
        this.referenceFramesVisualizers.add(yoGraphic);
    }

    public void update() {
        for (int i = 0; i < this.referenceFramesVisualizers.size(); ++i) {
            this.referenceFramesVisualizers.get(i).update();
        }
    }
}

