/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.polygonWiggling;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.commonWalkingControlModules.polygonWiggling.WiggleParameters;
import us.ihmc.convexOptimization.quadraticProgram.QuadProgSolver;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DBasics;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.log.LogTools;
import us.ihmc.robotics.geometry.ConvexPolygonTools;
import us.ihmc.robotics.geometry.PlanarRegion;

public class PolygonWiggler {
    private static final boolean DEBUG = false;
    private static final boolean coldStart = true;
    private static final double polygonWeight = 1000000.0;
    private static final double regularization = 1.0E-10;
    private static final double moveWeight = 1.0;
    private static int[] emptyArray = new int[0];

    public static RigidBodyTransform wigglePolygonIntoConvexHullOfRegion(ConvexPolygon2D polygonToWiggleInRegionFrame, PlanarRegion regionToWiggleInto, WiggleParameters parameters) {
        return PolygonWiggler.findWiggleTransform((ConvexPolygon2DReadOnly)polygonToWiggleInRegionFrame, (ConvexPolygon2DReadOnly)regionToWiggleInto.getConvexHull(), parameters);
    }

    public static RigidBodyTransform wigglePolygonIntoRegion(ConvexPolygon2D polygonToWiggleInRegionFrame, PlanarRegion regionToWiggleInto, WiggleParameters parameters) {
        ConvexPolygon2D bestMatch = null;
        double overlap = Double.NEGATIVE_INFINITY;
        ConvexPolygonTools convexPolygonTools = new ConvexPolygonTools();
        for (int i = 0; i < regionToWiggleInto.getNumberOfConvexPolygons(); ++i) {
            ConvexPolygon2D intersection = new ConvexPolygon2D();
            convexPolygonTools.computeIntersectionOfPolygons((ConvexPolygon2DReadOnly)regionToWiggleInto.getConvexPolygon(i), (ConvexPolygon2DReadOnly)polygonToWiggleInRegionFrame, (ConvexPolygon2DBasics)intersection);
            if (!(intersection.getArea() > overlap)) continue;
            overlap = intersection.getArea();
            bestMatch = regionToWiggleInto.getConvexPolygon(i);
        }
        if (bestMatch == null) {
            return null;
        }
        return PolygonWiggler.findWiggleTransform((ConvexPolygon2DReadOnly)polygonToWiggleInRegionFrame, bestMatch, parameters);
    }

    public static ConvexPolygon2D wigglePolygon(ConvexPolygon2D polygonToWiggle, ConvexPolygon2DReadOnly planeToWiggleInto, WiggleParameters parameters) {
        return PolygonWiggler.wigglePolygon(polygonToWiggle, planeToWiggleInto, parameters, emptyArray);
    }

    public static ConvexPolygon2D wigglePolygon(ConvexPolygon2D polygonToWiggle, ConvexPolygon2DReadOnly planeToWiggleInto, WiggleParameters parameters, int[] indicesToExclude) {
        ConvexPolygon2D wiggledPolygon = new ConvexPolygon2D((Vertex2DSupplier)polygonToWiggle);
        RigidBodyTransform wiggleTransform = PolygonWiggler.findWiggleTransform((ConvexPolygon2DReadOnly)polygonToWiggle, planeToWiggleInto, parameters, indicesToExclude);
        if (wiggleTransform == null) {
            return null;
        }
        wiggledPolygon.applyTransform((Transform)wiggleTransform, false);
        return wiggledPolygon;
    }

    public static RigidBodyTransform findWiggleTransform(ConvexPolygon2DReadOnly polygonToWiggle, ConvexPolygon2DReadOnly planeToWiggleInto, WiggleParameters parameters) {
        return PolygonWiggler.findWiggleTransform(polygonToWiggle, planeToWiggleInto, parameters, emptyArray);
    }

    public static RigidBodyTransform findWiggleTransform(ConvexPolygon2DReadOnly polygonToWiggle, ConvexPolygon2DReadOnly planeToWiggleInto, WiggleParameters parameters, int[] startingVerticesToIgnore) {
        int numberOfPoints = polygonToWiggle.getNumberOfVertices();
        Point2DReadOnly pointToRotateAbout = polygonToWiggle.getCentroid();
        DMatrixRMaj A = new DMatrixRMaj(0);
        DMatrixRMaj b = new DMatrixRMaj(0);
        PolygonWiggler.convertToInequalityConstraints(planeToWiggleInto, A, b, parameters.deltaInside, startingVerticesToIgnore);
        int constraintsPerPoint = A.getNumRows();
        int boundConstraints = 6;
        DMatrixRMaj A_full = new DMatrixRMaj(constraintsPerPoint * numberOfPoints + boundConstraints, 3 + constraintsPerPoint * numberOfPoints);
        DMatrixRMaj b_full = new DMatrixRMaj(constraintsPerPoint * numberOfPoints + boundConstraints, 1);
        PolygonWiggler.addRotationAndTranslationConstraint(A_full, b_full, constraintsPerPoint * numberOfPoints, parameters);
        DMatrixRMaj Aeq = new DMatrixRMaj(constraintsPerPoint * numberOfPoints, 3 + constraintsPerPoint * numberOfPoints);
        DMatrixRMaj beq = new DMatrixRMaj(constraintsPerPoint * numberOfPoints, 1);
        DMatrixRMaj indentity = new DMatrixRMaj(constraintsPerPoint * numberOfPoints, constraintsPerPoint * numberOfPoints);
        CommonOps_DDRM.setIdentity((DMatrix1Row)indentity);
        CommonOps_DDRM.insert((DMatrix)indentity, (DMatrix)A_full, (int)0, (int)3);
        CommonOps_DDRM.scale((double)-1.0, (DMatrixD1)indentity);
        CommonOps_DDRM.insert((DMatrix)indentity, (DMatrix)Aeq, (int)0, (int)3);
        for (int i = 0; i < numberOfPoints; ++i) {
            DMatrixRMaj p = new DMatrixRMaj(2, 1);
            p.set(0, polygonToWiggle.getVertex(i).getX());
            p.set(1, polygonToWiggle.getVertex(i).getY());
            Point2D point = new Point2D((Tuple2DReadOnly)polygonToWiggle.getVertex(i));
            point.sub((Tuple2DReadOnly)pointToRotateAbout);
            DMatrixRMaj V = new DMatrixRMaj((double[][])new double[][]{{1.0, 0.0, -point.getY()}, {0.0, 1.0, point.getX()}});
            DMatrixRMaj A_new = new DMatrixRMaj(constraintsPerPoint, 3);
            DMatrixRMaj b_new = new DMatrixRMaj(constraintsPerPoint, 1);
            CommonOps_DDRM.mult((DMatrix1Row)A, (DMatrix1Row)V, (DMatrix1Row)A_new);
            CommonOps_DDRM.mult((DMatrix1Row)A, (DMatrix1Row)p, (DMatrix1Row)b_new);
            CommonOps_DDRM.changeSign((DMatrixD1)b_new);
            CommonOps_DDRM.add((DMatrixD1)b, (DMatrixD1)b_new, (DMatrixD1)b_new);
            CommonOps_DDRM.insert((DMatrix)A_new, (DMatrix)Aeq, (int)(constraintsPerPoint * i), (int)0);
            CommonOps_DDRM.insert((DMatrix)b_new, (DMatrix)beq, (int)(constraintsPerPoint * i), (int)0);
        }
        DMatrixRMaj costMatrix = new DMatrixRMaj(3 + constraintsPerPoint * numberOfPoints, 3 + constraintsPerPoint * numberOfPoints);
        CommonOps_DDRM.multInner((DMatrix1Row)Aeq, (DMatrix1Row)costMatrix);
        DMatrixRMaj costVector = new DMatrixRMaj(3 + constraintsPerPoint * numberOfPoints, 1);
        CommonOps_DDRM.multTransA((DMatrix1Row)Aeq, (DMatrix1Row)beq, (DMatrix1Row)costVector);
        CommonOps_DDRM.changeSign((DMatrixD1)costVector);
        CommonOps_DDRM.scale((double)1000000.0, (DMatrixD1)costMatrix);
        CommonOps_DDRM.scale((double)1000000.0, (DMatrixD1)costVector);
        indentity.reshape(3 + constraintsPerPoint * numberOfPoints, 3 + constraintsPerPoint * numberOfPoints);
        CommonOps_DDRM.setIdentity((DMatrix1Row)indentity);
        CommonOps_DDRM.scale((double)1.0E-10, (DMatrixD1)indentity);
        CommonOps_DDRM.add((DMatrixD1)costMatrix, (DMatrixD1)indentity, (DMatrixD1)costMatrix);
        costMatrix.add(0, 0, 1.0);
        costMatrix.add(1, 1, 1.0);
        costMatrix.add(2, 2, 1.0 * parameters.rotationWeight);
        QuadProgSolver solver = new QuadProgSolver();
        DMatrixRMaj result = new DMatrixRMaj(3 + constraintsPerPoint * numberOfPoints, 1);
        Aeq = new DMatrixRMaj(0, 3 + constraintsPerPoint * numberOfPoints);
        beq = new DMatrixRMaj(0, 3 + constraintsPerPoint * numberOfPoints);
        try {
            int A_new = solver.solve(costMatrix, costVector, Aeq, beq, A_full, b_full, result, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        if (Double.isInfinite(solver.getCost())) {
            LogTools.info((String)"Could not wiggle!");
            return null;
        }
        double theta = result.get(2);
        Vector3D translation = new Vector3D(result.get(0), result.get(1), 0.0);
        Vector3D offset = new Vector3D(pointToRotateAbout.getX(), pointToRotateAbout.getY(), 0.0);
        RigidBodyTransform toOriginTransform = new RigidBodyTransform();
        toOriginTransform.setTranslationAndIdentityRotation((Tuple3DReadOnly)offset);
        RigidBodyTransform rotationTransform = new RigidBodyTransform();
        rotationTransform.appendYawRotation(theta);
        RigidBodyTransform fullTransform = new RigidBodyTransform((RigidBodyTransformReadOnly)toOriginTransform);
        fullTransform.multiply((RigidBodyTransformReadOnly)rotationTransform);
        toOriginTransform.invert();
        fullTransform.multiply((RigidBodyTransformReadOnly)toOriginTransform);
        RotationMatrix rotationMatrix = new RotationMatrix();
        rotationMatrix.set((RotationMatrixReadOnly)rotationTransform.getRotation());
        rotationMatrix.transpose();
        rotationMatrix.transform((Tuple3DBasics)translation);
        RigidBodyTransform translationTransform = new RigidBodyTransform();
        translationTransform.setTranslationAndIdentityRotation((Tuple3DReadOnly)translation);
        fullTransform.multiply((RigidBodyTransformReadOnly)translationTransform);
        return fullTransform;
    }

    public static void addRotationAndTranslationConstraint(DMatrixRMaj A, DMatrixRMaj b, int constraintRowStart, WiggleParameters parameters) {
        PolygonWiggler.addTranslationConstraint(A, b, constraintRowStart, parameters);
        PolygonWiggler.addRotationConstraint(A, b, constraintRowStart + 4, parameters);
    }

    public static void addTranslationConstraint(DMatrixRMaj A, DMatrixRMaj b, int constraintRowStart, WiggleParameters parameters) {
        PolygonWiggler.addTranslationConstraint(A, b, constraintRowStart, parameters.maxX, parameters.minX, parameters.maxY, parameters.minY);
    }

    public static void addTranslationConstraint(DMatrixRMaj A, DMatrixRMaj b, int constraintRowStart, double maxX, double minX, double maxY, double minY) {
        A.set(constraintRowStart, 0, 1.0);
        b.set(constraintRowStart, maxX);
        A.set(constraintRowStart + 1, 0, -1.0);
        b.set(constraintRowStart + 1, -minX);
        A.set(constraintRowStart + 2, 1, 1.0);
        b.set(constraintRowStart + 2, maxY);
        A.set(constraintRowStart + 3, 1, -1.0);
        b.set(constraintRowStart + 3, -minY);
    }

    public static void addRotationConstraint(DMatrixRMaj A, DMatrixRMaj b, int constraintRowStart, WiggleParameters parameters) {
        A.set(constraintRowStart, 2, 1.0);
        b.set(constraintRowStart, parameters.maxYaw);
        A.set(constraintRowStart + 1, 2, -1.0);
        b.set(constraintRowStart + 1, -parameters.minYaw);
    }

    public static void convertToInequalityConstraints(ConvexPolygon2DReadOnly polygon, DMatrixRMaj A, DMatrixRMaj b, double deltaInside) {
        PolygonWiggler.convertToInequalityConstraints(polygon, A, b, deltaInside, emptyArray);
    }

    public static void convertToInequalityConstraints(ConvexPolygon2DReadOnly polygon, DMatrixRMaj A, DMatrixRMaj b, double deltaInside, int[] startingVerticesToIgnore) {
        int constraints = polygon.getNumberOfVertices();
        if (constraints > 2) {
            PolygonWiggler.convertToInequalityConstraintsPolygon(polygon, A, b, deltaInside, startingVerticesToIgnore);
        } else if (constraints > 1) {
            PolygonWiggler.convertToInequalityConstraintsLine(polygon, A, b, deltaInside);
        } else {
            PolygonWiggler.convertToInequalityConstraintsPoint(polygon, A, b);
        }
    }

    public static void convertToInequalityConstraintsPoint(ConvexPolygon2DReadOnly polygon, DMatrixRMaj A, DMatrixRMaj b) {
        PolygonWiggler.convertToInequalityConstraintsPoint(polygon.getVertex(0), A, b);
    }

    public static void convertToInequalityConstraintsPoint(Point2DReadOnly point, DMatrixRMaj A, DMatrixRMaj b) {
        PolygonWiggler.convertToInequalityConstraintsPoint(point.getX(), point.getY(), A, b);
    }

    public static void convertToInequalityConstraintsPoint(double x, double y, DMatrixRMaj A, DMatrixRMaj b) {
        A.reshape(4, 2);
        b.reshape(4, 1);
        A.set(0, 0, 1.0);
        A.set(0, 1, 0.0);
        A.set(1, 0, 0.0);
        A.set(1, 1, 1.0);
        A.set(2, 0, -1.0);
        A.set(2, 1, 0.0);
        A.set(3, 0, 0.0);
        A.set(3, 1, -1.0);
        b.set(0, 0, x);
        b.set(1, 0, y);
        b.set(2, 0, -x);
        b.set(3, 0, -y);
    }

    public static void convertToInequalityConstraintsLine(ConvexPolygon2DReadOnly polygon, DMatrixRMaj A, DMatrixRMaj b, double deltaInside) {
        Point2DReadOnly secondPoint;
        Point2DReadOnly firstPoint = polygon.getVertex(0);
        if (firstPoint.distance(secondPoint = polygon.getNextVertex(0)) <= 2.0 * deltaInside) {
            double x = 0.5 * (firstPoint.getX() + secondPoint.getX());
            double y = 0.5 * (firstPoint.getY() + secondPoint.getY());
            PolygonWiggler.convertToInequalityConstraintsPoint(x, y, A, b);
        } else {
            A.reshape(4, 2);
            b.reshape(4, 1);
            double vectorX = secondPoint.getX() - firstPoint.getX();
            double vectorY = secondPoint.getY() - firstPoint.getY();
            A.set(0, 0, -vectorY);
            A.set(0, 1, vectorX);
            b.set(0, firstPoint.getY() * vectorX - firstPoint.getX() * vectorY);
            A.set(1, 0, vectorY);
            A.set(1, 1, -vectorX);
            b.set(1, -b.get(0));
            A.set(2, 0, -vectorX);
            A.set(2, 1, -vectorY);
            b.set(2, -deltaInside - firstPoint.getX() * vectorX - firstPoint.getY() * vectorY);
            A.set(3, 0, vectorX);
            A.set(3, 1, vectorY);
            b.set(3, -deltaInside + secondPoint.getX() * vectorX + secondPoint.getY() * vectorY);
        }
    }

    public static void convertToInequalityConstraintsPolygon(ConvexPolygon2DReadOnly polygon, DMatrixRMaj A, DMatrixRMaj b, double deltaInside) {
        PolygonWiggler.convertToInequalityConstraintsPolygon(polygon, A, b, deltaInside, emptyArray);
    }

    public static void convertToInequalityConstraintsPolygon(ConvexPolygon2DReadOnly polygon, DMatrixRMaj A, DMatrixRMaj b, double deltaInside, int[] startingVerticesToIgnore) {
        int constraints = polygon.getNumberOfVertices();
        A.reshape(constraints, 2);
        b.reshape(constraints, 1);
        for (int i = 0; i < constraints; ++i) {
            Point2DReadOnly firstPoint = polygon.getVertex(i);
            Point2DReadOnly secondPoint = polygon.getNextVertex(i);
            double x = secondPoint.getX() - firstPoint.getX();
            double y = secondPoint.getY() - firstPoint.getY();
            double norm = Math.sqrt(x * x + y * y);
            double desiredDistanceInside = PolygonWiggler.isAllowed(i, startingVerticesToIgnore) ? deltaInside : 0.0;
            A.set(i, 0, -(y /= norm));
            A.set(i, 1, x /= norm);
            b.set(i, -desiredDistanceInside + firstPoint.getY() * x - firstPoint.getX() * y);
        }
    }

    private static boolean isAllowed(int index, int[] indicesToIgnore) {
        for (int i = 0; i < indicesToIgnore.length; ++i) {
            if (index != indicesToIgnore[i]) continue;
            return false;
        }
        return true;
    }

    public static void constrainPolygonInsideOtherPolygon(ConvexPolygon2DReadOnly polygonExteriorInWorld, ConvexPolygon2DReadOnly polygonInteriorRelative, DMatrixRMaj A, DMatrixRMaj b, double deltaInside) {
        int constraints = polygonExteriorInWorld.getNumberOfVertices();
        A.reshape(constraints, 2);
        b.reshape(constraints, 1);
        Vector2D tempVector = new Vector2D();
        for (int exteriorVertexIndex = 0; exteriorVertexIndex < constraints; ++exteriorVertexIndex) {
            Point2DReadOnly firstPoint = polygonExteriorInWorld.getVertex(exteriorVertexIndex);
            Point2DReadOnly secondPoint = polygonExteriorInWorld.getNextVertex(exteriorVertexIndex);
            tempVector.set((Tuple2DReadOnly)secondPoint);
            tempVector.sub((Tuple2DReadOnly)firstPoint);
            tempVector.normalize();
            A.set(exteriorVertexIndex, 0, -tempVector.getY());
            A.set(exteriorVertexIndex, 1, tempVector.getX());
            double additionalDistanceInside = 0.0;
            for (int interiorVertexIndex = 0; interiorVertexIndex < polygonInteriorRelative.getNumberOfVertices(); ++interiorVertexIndex) {
                Point2DReadOnly interiorVertex = polygonInteriorRelative.getVertex(interiorVertexIndex);
                additionalDistanceInside = Math.max(additionalDistanceInside, tempVector.getY() * interiorVertex.getX() - tempVector.getX() * interiorVertex.getY());
            }
            A.set(exteriorVertexIndex, 0, -tempVector.getY());
            A.set(exteriorVertexIndex, 1, tempVector.getX());
            b.set(exteriorVertexIndex, -(deltaInside + additionalDistanceInside) + firstPoint.getY() * tempVector.getX() - firstPoint.getX() * tempVector.getY());
        }
    }
}

