/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.polygonWiggling;

import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.geometry.interfaces.BoundingBox3DBasics;
import us.ihmc.euclid.geometry.interfaces.BoundingBox3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.shape.collision.EuclidShape3DCollisionResult;
import us.ihmc.euclid.shape.collision.epa.ExpandingPolytopeAlgorithm;
import us.ihmc.euclid.shape.collision.interfaces.EuclidShape3DCollisionResultBasics;
import us.ihmc.euclid.shape.collision.interfaces.SupportingVertexHolder;
import us.ihmc.euclid.shape.primitives.Cylinder3D;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPosition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicVector;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.robotics.geometry.PlanarRegion;
import us.ihmc.robotics.geometry.PlanarRegionsList;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;

public class LegCollisionConstraintCalculator {
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private static final double defaultShinRadiusWhenOneMeterLong = 0.3167;
    private Cylinder3D legCollisionShape = null;
    private final RigidBodyTransform legShapeTransformToSoleFrame = new RigidBodyTransform();
    private final RigidBodyTransform legShapeToWorld = new RigidBodyTransform();
    private final Vector3D collisionDirection = new Vector3D();
    private final BoundingBox3D legBoundingBox = new BoundingBox3D();
    private final ExpandingPolytopeAlgorithm collisionDetector = new ExpandingPolytopeAlgorithm();
    private final EuclidShape3DCollisionResult collisionResult = new EuclidShape3DCollisionResult();
    private final YoFramePoint3D legShapeBase = new YoFramePoint3D("legShapeBase", ReferenceFrame.getWorldFrame(), this.registry);
    private final YoFrameVector3D legShapeDirection = new YoFrameVector3D("legShapeDirection", ReferenceFrame.getWorldFrame(), this.registry);
    private final YoGraphicVector legCollisionShapeGraphic;
    private final YoFramePoint3D legIntersectionPosition = new YoFramePoint3D("legIntersectionPosition", ReferenceFrame.getWorldFrame(), this.registry);
    private final YoFramePoint3D regionIntersectionPosition = new YoFramePoint3D("regionIntersectionPosition", ReferenceFrame.getWorldFrame(), this.registry);
    private final YoFrameVector3D gradientDirection = new YoFrameVector3D("intersectionNormal", ReferenceFrame.getWorldFrame(), this.registry);
    private final YoGraphicPosition legIntersectionPositionGraphic;
    private final YoGraphicPosition regionIntersectionPositionGraphic;
    private final YoGraphicVector gradientDirectionGraphic;

    public LegCollisionConstraintCalculator() {
        this.legCollisionShapeGraphic = null;
        this.legIntersectionPositionGraphic = null;
        this.regionIntersectionPositionGraphic = null;
        this.gradientDirectionGraphic = null;
    }

    public LegCollisionConstraintCalculator(YoGraphicsListRegistry graphicsListRegistry, YoRegistry parentRegistry) {
        AppearanceDefinition appearance = YoAppearance.LightGoldenRodYellow();
        appearance.setTransparency(0.15);
        this.legCollisionShapeGraphic = new YoGraphicVector("legCollisionGraphic", this.legShapeBase, this.legShapeDirection, appearance);
        this.legIntersectionPositionGraphic = new YoGraphicPosition("intersectionPositionGraphic", this.legIntersectionPosition, 0.02, YoAppearance.Orange());
        this.regionIntersectionPositionGraphic = new YoGraphicPosition("regionIntersectionPositionGraphic", this.regionIntersectionPosition, 0.02, YoAppearance.Black());
        this.gradientDirectionGraphic = new YoGraphicVector("intersectionDirectionGraphic", this.legIntersectionPosition, this.gradientDirection, 1.0, YoAppearance.Orange(), true, 0.01);
        this.legCollisionShapeGraphic.setDrawArrowhead(false);
        this.legCollisionShapeGraphic.setLineRadiusWhenOneMeterLong(0.3167);
        this.legShapeBase.setToZero();
        this.legShapeDirection.set(0.0, 0.0, 1.0);
        String graphicListName = this.getClass().getSimpleName();
        graphicsListRegistry.registerYoGraphic(graphicListName, (YoGraphic)this.legCollisionShapeGraphic);
        graphicsListRegistry.registerYoGraphic(graphicListName, (YoGraphic)this.legIntersectionPositionGraphic);
        graphicsListRegistry.registerYoGraphic(graphicListName, (YoGraphic)this.gradientDirectionGraphic);
        this.legIntersectionPosition.setToNaN();
        this.regionIntersectionPosition.setToNaN();
        parentRegistry.addChild(this.registry);
    }

    public void calculateLegCollisionGradient(RigidBodyTransformReadOnly soleFrameToRegionFrame, RigidBodyTransformReadOnly regionToWorld, PlanarRegionsList planarRegionsList, Tuple3DBasics gradientToPack) {
        gradientToPack.setToZero();
        if (this.legCollisionShape == null) {
            return;
        }
        this.legShapeToWorld.set(this.legShapeTransformToSoleFrame);
        this.legShapeToWorld.preMultiply(soleFrameToRegionFrame);
        this.legShapeToWorld.preMultiply(regionToWorld);
        this.legCollisionShape.getPosition().set((Tuple3DReadOnly)this.legShapeToWorld.getTranslation());
        this.legCollisionShape.getAxis().set(this.legShapeToWorld.getM02(), this.legShapeToWorld.getM12(), this.legShapeToWorld.getM22());
        this.legCollisionShape.getBoundingBox((BoundingBox3DBasics)this.legBoundingBox);
        this.updateGraphics();
        for (int i = 0; i < planarRegionsList.getNumberOfPlanarRegions(); ++i) {
            PlanarRegion region = planarRegionsList.getPlanarRegion(i);
            if (!region.getBoundingBox3dInWorld().intersectsInclusive((BoundingBox3DReadOnly)this.legBoundingBox) || !this.collisionDetector.evaluateCollision((SupportingVertexHolder)this.legCollisionShape, (SupportingVertexHolder)region, (EuclidShape3DCollisionResultBasics)this.collisionResult)) continue;
            this.collisionDirection.sub((Tuple3DReadOnly)this.collisionResult.getPointOnB(), (Tuple3DReadOnly)this.collisionResult.getPointOnA());
            this.collisionDirection.applyInverseTransform((Transform)regionToWorld);
            this.collisionDirection.setZ(0.0);
            gradientToPack.set(this.collisionDirection.getX(), this.collisionDirection.getY(), 0.0);
            this.updateGraphics(this.collisionResult.getPointOnA(), this.collisionResult.getPointOnB());
            break;
        }
    }

    private void updateGraphics() {
        if (this.legCollisionShapeGraphic == null) {
            return;
        }
        this.legShapeDirection.set((Tuple3DReadOnly)this.legCollisionShape.getAxis());
        this.legShapeDirection.scale(this.legCollisionShape.getLength());
        this.legShapeBase.set((FrameTuple3DReadOnly)this.legShapeDirection);
        this.legShapeBase.scale(-0.5);
        this.legShapeBase.add((Tuple3DReadOnly)this.legCollisionShape.getPosition());
        this.legCollisionShapeGraphic.update();
    }

    private void updateGraphics(Point3D legIntersectionPoint, Point3D regionIntersectionPoint) {
        if (this.legCollisionShapeGraphic == null) {
            return;
        }
        this.legIntersectionPosition.set((Tuple3DReadOnly)legIntersectionPoint);
        this.regionIntersectionPosition.set((Tuple3DReadOnly)regionIntersectionPoint);
        this.gradientDirection.set((Tuple3DReadOnly)this.collisionDirection);
        this.legIntersectionPositionGraphic.update();
        this.regionIntersectionPositionGraphic.update();
        this.gradientDirectionGraphic.update();
    }

    public void setLegCollisionShape(Cylinder3D legCollisionShape, RigidBodyTransform legShapeTransformToSoleFrame) {
        this.legCollisionShape = legCollisionShape;
        this.legShapeTransformToSoleFrame.set(legShapeTransformToSoleFrame);
        double lineRadiusWhenOneMeterLong = legCollisionShape.getRadius() / legCollisionShape.getLength();
        this.legCollisionShapeGraphic.setLineRadiusWhenOneMeterLong(lineRadiusWhenOneMeterLong);
    }
}

