/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.polygonWiggling;

import java.awt.Color;
import java.util.List;
import us.ihmc.commonWalkingControlModules.polygonWiggling.FootPlacementConstraintCalculator;
import us.ihmc.commonWalkingControlModules.polygonWiggling.GradientDescentStepConstraintInput;
import us.ihmc.commonWalkingControlModules.polygonWiggling.LegCollisionConstraintCalculator;
import us.ihmc.commonWalkingControlModules.polygonWiggling.StepConstraintPolygonTools;
import us.ihmc.commonWalkingControlModules.polygonWiggling.WiggleParameters;
import us.ihmc.commons.MathTools;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLineSegment2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.shape.primitives.Cylinder3D;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicCoordinateSystem;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.graphicsDescription.yoGraphics.plotting.YoArtifactLineSegment2d;
import us.ihmc.log.LogTools;
import us.ihmc.robotics.graphics.YoGraphicPlanarRegionsList;
import us.ihmc.simulationconstructionset.util.TickAndUpdatable;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameLineSegment2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;

public class GradientDescentStepConstraintSolver {
    private static final boolean verbose = false;
    private final String name = this.getClass().getSimpleName();
    private final YoRegistry registry = new YoRegistry(this.name);
    private int maximumIterations = 1000;
    private double alpha = 0.125;
    private double alphaForSmallGradient = 0.35;
    private double gradientMagnitudeToTerminate = 1.0E-5;
    private double gradientMagnitudeToApplyStandardAlpha = 0.001;
    private final YoDouble gradientMagnitude = new YoDouble("gradientMagnitude", this.registry);
    private final YoDouble stanceFootProximity = new YoDouble("stanceFootProximity", this.registry);
    private double stanceFootClearance;
    private final FootPlacementConstraintCalculator footPlacementConstraintCalculator = new FootPlacementConstraintCalculator();
    private final LegCollisionConstraintCalculator legCollisionConstraintCalculator;
    private final Vector3D previousGradient = new Vector3D();
    private final YoFrameVector3D gradient = new YoFrameVector3D("gradient", ReferenceFrame.getWorldFrame(), this.registry);
    private final YoFrameVector3D footPlacementGradient = new YoFrameVector3D("footPlacementGradient", ReferenceFrame.getWorldFrame(), this.registry);
    private final YoFrameVector3D legCollisionGradient = new YoFrameVector3D("legCollisionGradient", ReferenceFrame.getWorldFrame(), this.registry);
    private final YoFrameVector3D accumulatedTransform = new YoFrameVector3D("accumulatedTransform", ReferenceFrame.getWorldFrame(), this.registry);
    private final YoEnum<Constraint> activeConstraint = new YoEnum("activeConstraint", "Active constraint", this.registry, Constraint.class, true);
    private final RecyclingArrayList<Point2D> transformedVertices = new RecyclingArrayList(5, Point2D::new);
    private final RecyclingArrayList<Vector2D> rotationVectors = new RecyclingArrayList(5, Vector2D::new);
    private final RigidBodyTransform transformedSoleToRegionFrame = new RigidBodyTransform();
    private final ConvexPolygon2D transformedFootPolygon = new ConvexPolygon2D();
    private final TickAndUpdatable tickAndUpdatable;
    private final YoFrameLineSegment2D[] initialPolygonToWiggle = new YoFrameLineSegment2D[5];
    private final YoFrameLineSegment2D[] linearizedTransformedPolygonToWiggle = new YoFrameLineSegment2D[5];
    private final YoFrameLineSegment2D[] transformedPolygonToWiggle = new YoFrameLineSegment2D[5];
    private final YoFrameLineSegment2D[] constraintPolygon = new YoFrameLineSegment2D[500];
    private final YoFrameLineSegment2D[] yoRotationVectors = new YoFrameLineSegment2D[5];
    private final YoFrameLineSegment2D[] stanceFootPolygon = new YoFrameLineSegment2D[5];
    private final YoGraphicPlanarRegionsList yoGraphicPlanarRegionsList;
    private final YoGraphicCoordinateSystem soleFrameGraphic;

    public GradientDescentStepConstraintSolver() {
        this.tickAndUpdatable = null;
        this.legCollisionConstraintCalculator = new LegCollisionConstraintCalculator();
        this.yoGraphicPlanarRegionsList = null;
        this.soleFrameGraphic = null;
    }

    public GradientDescentStepConstraintSolver(TickAndUpdatable tickAndUpdatable, YoGraphicsListRegistry graphicsListRegistry, YoRegistry registry) {
        int i;
        registry.addChild(this.registry);
        this.tickAndUpdatable = tickAndUpdatable;
        this.legCollisionConstraintCalculator = new LegCollisionConstraintCalculator(graphicsListRegistry, registry);
        for (i = 0; i < 5; ++i) {
            this.initialPolygonToWiggle[i] = new YoFrameLineSegment2D("initialFootV" + i, ReferenceFrame.getWorldFrame(), registry);
            graphicsListRegistry.registerArtifact(this.name, (Artifact)new YoArtifactLineSegment2d("graphicInitialFootV" + i, this.initialPolygonToWiggle[i], Color.RED, 0.0, 0.0));
            this.stanceFootPolygon[i] = new YoFrameLineSegment2D("stanceFootV" + i, ReferenceFrame.getWorldFrame(), registry);
            graphicsListRegistry.registerArtifact(this.name, (Artifact)new YoArtifactLineSegment2d("graphicStanceFootV" + i, this.stanceFootPolygon[i], Color.YELLOW.darker(), 0.0, 0.0));
            this.transformedPolygonToWiggle[i] = new YoFrameLineSegment2D("transformedFootV" + i, ReferenceFrame.getWorldFrame(), registry);
            graphicsListRegistry.registerArtifact(this.name, (Artifact)new YoArtifactLineSegment2d("graphicFootV" + i, this.transformedPolygonToWiggle[i], Color.GREEN.darker(), 0.0, 0.0));
            this.linearizedTransformedPolygonToWiggle[i] = new YoFrameLineSegment2D("linearizedTransformedFootV" + i, ReferenceFrame.getWorldFrame(), registry);
            graphicsListRegistry.registerArtifact(this.name, (Artifact)new YoArtifactLineSegment2d("linearizedGraphicFootV" + i, this.linearizedTransformedPolygonToWiggle[i], Color.BLUE.darker(), 0.0, 0.0));
            this.yoRotationVectors[i] = new YoFrameLineSegment2D("rotationVector" + i, ReferenceFrame.getWorldFrame(), registry);
            graphicsListRegistry.registerArtifact(this.name, (Artifact)new YoArtifactLineSegment2d("rotationVectorGraphic" + i, this.yoRotationVectors[i], Color.ORANGE.darker(), 0.01, 0.01));
        }
        for (i = 0; i < this.constraintPolygon.length; ++i) {
            this.constraintPolygon[i] = new YoFrameLineSegment2D("polygonEdge" + i, ReferenceFrame.getWorldFrame(), registry);
            graphicsListRegistry.registerArtifact(this.name, (Artifact)new YoArtifactLineSegment2d("graphicPolygonEdge" + i, this.constraintPolygon[i], Color.BLACK, 0.0, 0.0));
        }
        this.yoGraphicPlanarRegionsList = new YoGraphicPlanarRegionsList("planarRegions", 150, 100, registry);
        graphicsListRegistry.registerYoGraphic(this.getClass().getSimpleName(), (YoGraphic)this.yoGraphicPlanarRegionsList);
        this.soleFrameGraphic = new YoGraphicCoordinateSystem("soleFrame", "", registry, false, 0.3);
        graphicsListRegistry.registerYoGraphic(this.getClass().getSimpleName(), (YoGraphic)this.soleFrameGraphic);
    }

    public RigidBodyTransform wigglePolygon(GradientDescentStepConstraintInput input) {
        input.checkInputs();
        int iterations = 0;
        this.accumulatedTransform.setToZero();
        this.rotationVectors.clear();
        this.transformedVertices.clear();
        this.footPlacementGradient.setToZero();
        this.legCollisionGradient.setToZero();
        ConvexPolygon2D polygonToWiggle = input.getInitialStepPolygon();
        for (int i = 0; i < polygonToWiggle.getNumberOfVertices(); ++i) {
            Point2DReadOnly vertex = polygonToWiggle.getVertex(i);
            Vector2D rotationVector = (Vector2D)this.rotationVectors.add();
            rotationVector.sub((Tuple2DReadOnly)vertex, (Tuple2DReadOnly)polygonToWiggle.getCentroid());
            rotationVector.set(-rotationVector.getY(), rotationVector.getX());
            ((Point2D)this.transformedVertices.add()).set((Tuple2DReadOnly)vertex);
        }
        if (this.tickAndUpdatable != null) {
            this.initializeConstraintGraphics((ConvexPolygon2DReadOnly)polygonToWiggle, input);
            this.tickAndUpdatable.tickAndUpdate();
        }
        if (input.containsInputForLegCollisionCheck()) {
            this.transformedSoleToRegionFrame.set(input.getFootstepInRegionFrame());
        }
        this.activeConstraint.set((Enum)this.computeActiveConstraint(input));
        if (this.activeConstraint.getValue() == null) {
            return new RigidBodyTransform();
        }
        WiggleParameters wiggleParameters = input.getWiggleParameters();
        while (iterations <= this.maximumIterations) {
            this.updateGraphics((ConvexPolygon2DReadOnly)polygonToWiggle);
            if (input.containsInputForLegCollisionCheck()) {
                this.legCollisionConstraintCalculator.calculateLegCollisionGradient((RigidBodyTransformReadOnly)this.transformedSoleToRegionFrame, (RigidBodyTransformReadOnly)input.getLocalToWorld(), input.getPlanarRegionsList(), (Tuple3DBasics)this.legCollisionGradient);
            }
            if (this.activeConstraint.getValue() == Constraint.FOOT_AREA) {
                this.footPlacementConstraintCalculator.calculateFootAreaGradient((List<? extends Point2DReadOnly>)this.transformedVertices, (List<? extends Vector2DReadOnly>)this.rotationVectors, input.getPolygonToWiggleInto(), wiggleParameters, (Tuple3DBasics)this.footPlacementGradient);
            }
            if (this.activeConstraint.getValue() == Constraint.FOOT_AREA) {
                if (this.legCollisionGradient.lengthSquared() > 0.0) break;
                this.gradient.set((FrameTuple3DReadOnly)this.footPlacementGradient);
            } else {
                this.gradient.set((FrameTuple3DReadOnly)this.legCollisionGradient);
            }
            boolean xTranslationAllowed = MathTools.intervalContains((double)this.accumulatedTransform.getX(), (double)wiggleParameters.minX, (double)wiggleParameters.maxX);
            boolean yTranslationAllowed = MathTools.intervalContains((double)this.accumulatedTransform.getY(), (double)wiggleParameters.minY, (double)wiggleParameters.maxY);
            boolean rotationAllowed = MathTools.intervalContains((double)this.accumulatedTransform.getZ(), (double)wiggleParameters.minYaw, (double)wiggleParameters.maxYaw);
            if (!xTranslationAllowed && !yTranslationAllowed && !rotationAllowed) break;
            if (!xTranslationAllowed) {
                this.gradient.setX(0.0);
            }
            if (!yTranslationAllowed) {
                this.gradient.setY(0.0);
            }
            if (!rotationAllowed) {
                this.gradient.setZ(0.0);
            }
            if (this.tickAndUpdatable != null) {
                this.gradientMagnitude.set(this.gradient.length());
                this.tickAndUpdatable.tickAndUpdate();
            }
            if (this.gradient.lengthSquared() > MathTools.square((double)this.gradientMagnitudeToApplyStandardAlpha)) {
                this.gradient.scale(this.alpha);
            } else {
                this.gradient.scale(this.alphaForSmallGradient);
            }
            this.accumulatedTransform.add((FrameTuple3DReadOnly)this.gradient);
            this.transformedFootPolygon.clear();
            for (int i = 0; i < polygonToWiggle.getNumberOfVertices(); ++i) {
                ((Point2D)this.transformedVertices.get(i)).add(this.gradient.getX(), this.gradient.getY());
                ((Point2D)this.transformedVertices.get(i)).addX(this.gradient.getZ() * ((Vector2D)this.rotationVectors.get(i)).getX());
                ((Point2D)this.transformedVertices.get(i)).addY(this.gradient.getZ() * ((Vector2D)this.rotationVectors.get(i)).getY());
                this.transformedFootPolygon.addVertex(((Point2D)this.transformedVertices.get(i)).getX(), ((Point2D)this.transformedVertices.get(i)).getY());
            }
            this.transformedSoleToRegionFrame.getTranslation().add(this.gradient.getX(), this.gradient.getY(), 0.0);
            this.transformedSoleToRegionFrame.getRotation().appendYawRotation(this.gradient.getZ());
            this.transformedFootPolygon.update();
            if (input.containsInputForStanceFootCheck()) {
                this.stanceFootProximity.set(StepConstraintPolygonTools.distanceBetweenPolygons(this.transformedFootPolygon, input.getStanceFootPolygon()));
                if (this.stanceFootProximity.getValue() < this.stanceFootClearance) break;
            }
            if (iterations > 0 && this.gradient.lengthSquared() < MathTools.square((double)this.gradientMagnitudeToTerminate)) break;
            this.previousGradient.set((Tuple3DReadOnly)this.gradient);
            ++iterations;
        }
        RigidBodyTransform transform = new RigidBodyTransform();
        if (this.accumulatedTransform.containsNaN()) {
            LogTools.warn((String)(this.name + ": NaN found in solution for concave hull constraint. returning identity transform"));
        } else {
            this.packWorldFrameTransform((ConvexPolygon2DReadOnly)polygonToWiggle, transform);
        }
        return transform;
    }

    private Constraint computeActiveConstraint(GradientDescentStepConstraintInput input) {
        double gradientEpsilonToActivateConstraint = 1.0E-10;
        if (input.containsInputForLegCollisionCheck()) {
            this.legCollisionConstraintCalculator.calculateLegCollisionGradient((RigidBodyTransformReadOnly)this.transformedSoleToRegionFrame, (RigidBodyTransformReadOnly)input.getLocalToWorld(), input.getPlanarRegionsList(), (Tuple3DBasics)this.gradient);
            if (this.gradient.length() > gradientEpsilonToActivateConstraint) {
                return Constraint.LEG_COLLISION;
            }
        }
        this.footPlacementConstraintCalculator.calculateFootAreaGradient((List<? extends Point2DReadOnly>)this.transformedVertices, (List<? extends Vector2DReadOnly>)this.rotationVectors, input.getPolygonToWiggleInto(), input.getWiggleParameters(), (Tuple3DBasics)this.gradient);
        if (this.gradient.length() > gradientEpsilonToActivateConstraint) {
            return Constraint.FOOT_AREA;
        }
        if (this.tickAndUpdatable != null) {
            this.tickAndUpdatable.tickAndUpdate();
        }
        return null;
    }

    private void packWorldFrameTransform(ConvexPolygon2DReadOnly polygonToWiggle, RigidBodyTransform transform) {
        transform.getTranslation().set(this.accumulatedTransform.getX(), this.accumulatedTransform.getY(), 0.0);
        transform.getRotation().setToYawOrientation(this.accumulatedTransform.getZ());
        transform.prependTranslation(polygonToWiggle.getCentroid().getX(), polygonToWiggle.getCentroid().getY(), 0.0);
        transform.appendTranslation(-polygonToWiggle.getCentroid().getX(), -polygonToWiggle.getCentroid().getY(), 0.0);
    }

    private void initializeConstraintGraphics(ConvexPolygon2DReadOnly polygonToWiggle, GradientDescentStepConstraintInput input) {
        int i;
        if (this.tickAndUpdatable == null) {
            return;
        }
        Vertex2DSupplier concavePolygonToWiggleInto = input.getPolygonToWiggleInto();
        RigidBodyTransform footstepInRegionFrame = input.getFootstepInRegionFrame();
        for (i = 0; i < this.constraintPolygon.length; ++i) {
            this.constraintPolygon[i].setToNaN();
        }
        for (i = 0; i < polygonToWiggle.getNumberOfVertices(); ++i) {
            this.initialPolygonToWiggle[i].getFirstEndpoint().set((Tuple2DReadOnly)polygonToWiggle.getVertex(i));
            this.initialPolygonToWiggle[i].getSecondEndpoint().set((Tuple2DReadOnly)polygonToWiggle.getVertex((i + 1) % polygonToWiggle.getNumberOfVertices()));
            this.linearizedTransformedPolygonToWiggle[i].set((FrameLineSegment2DReadOnly)this.initialPolygonToWiggle[i]);
            this.yoRotationVectors[i].getFirstEndpoint().set((Tuple2DReadOnly)polygonToWiggle.getVertex(i));
            this.yoRotationVectors[i].getSecondEndpoint().set((Tuple2DReadOnly)this.rotationVectors.get(i));
            this.yoRotationVectors[i].getSecondEndpoint().add((Tuple2DReadOnly)polygonToWiggle.getVertex(i));
        }
        for (i = 0; i < input.getStanceFootPolygon().getNumberOfVertices(); ++i) {
            this.stanceFootPolygon[i].getFirstEndpoint().set((Tuple2DReadOnly)input.getStanceFootPolygon().getVertex(i));
            this.stanceFootPolygon[i].getSecondEndpoint().set((Tuple2DReadOnly)input.getStanceFootPolygon().getVertex((i + 1) % input.getStanceFootPolygon().getNumberOfVertices()));
        }
        for (i = 0; i < concavePolygonToWiggleInto.getNumberOfVertices(); ++i) {
            this.constraintPolygon[i].getFirstEndpoint().set((Tuple2DReadOnly)concavePolygonToWiggleInto.getVertex(i));
            this.constraintPolygon[i].getSecondEndpoint().set((Tuple2DReadOnly)concavePolygonToWiggleInto.getVertex((i + 1) % concavePolygonToWiggleInto.getNumberOfVertices()));
        }
        if (input.containsInputForLegCollisionCheck()) {
            RigidBodyTransform soleFrame = new RigidBodyTransform((RigidBodyTransformReadOnly)footstepInRegionFrame);
            soleFrame.preMultiply((RigidBodyTransformReadOnly)input.getLocalToWorld());
            this.soleFrameGraphic.setPosition((Tuple3DReadOnly)soleFrame.getTranslation());
            this.soleFrameGraphic.setOrientation((QuaternionReadOnly)new Quaternion((Orientation3DReadOnly)soleFrame.getRotation()));
        }
    }

    private void updateGraphics(ConvexPolygon2DReadOnly polygonToWiggle) {
        if (this.tickAndUpdatable == null) {
            return;
        }
        for (int i = 0; i < this.transformedVertices.size(); ++i) {
            this.linearizedTransformedPolygonToWiggle[i].getFirstEndpoint().set((Tuple2DReadOnly)this.transformedVertices.get(i));
            this.linearizedTransformedPolygonToWiggle[i].getSecondEndpoint().set((Tuple2DReadOnly)this.transformedVertices.get((i + 1) % this.transformedVertices.size()));
        }
        RigidBodyTransform transform = new RigidBodyTransform();
        this.packWorldFrameTransform(polygonToWiggle, transform);
        for (int i = 0; i < this.initialPolygonToWiggle.length; ++i) {
            this.transformedPolygonToWiggle[i].set((FrameLineSegment2DReadOnly)this.initialPolygonToWiggle[i]);
            this.transformedPolygonToWiggle[i].applyTransform((Transform)transform);
        }
    }

    public RecyclingArrayList<Point2D> getTransformedVertices() {
        return this.transformedVertices;
    }

    public void setMaximumIterations(int maximumIterations) {
        this.maximumIterations = maximumIterations;
    }

    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }

    public void setGradientMagnitudeToTerminate(double gradientMagnitudeToTerminate) {
        this.gradientMagnitudeToTerminate = gradientMagnitudeToTerminate;
    }

    public void setLegCollisionShape(Cylinder3D legCollisionShape, RigidBodyTransform legShapeTransformToSoleFrame) {
        this.legCollisionConstraintCalculator.setLegCollisionShape(legCollisionShape, legShapeTransformToSoleFrame);
    }

    public void setStanceFootClearance(double stanceFootClearance) {
        this.stanceFootClearance = stanceFootClearance;
    }

    public double getGradientMagnitudeToTerminate() {
        return this.gradientMagnitudeToTerminate;
    }

    public double getAlpha() {
        return this.alpha;
    }

    private static enum Constraint {
        FOOT_AREA,
        LEG_COLLISION;

    }
}

