/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.polygonWiggling;

import java.util.List;
import us.ihmc.commonWalkingControlModules.polygonWiggling.WiggleParameters;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.robotics.geometry.PlanarRegion;
import us.ihmc.robotics.geometry.PlanarRegionsList;

public class GradientDescentStepConstraintInput {
    private final ConvexPolygon2D initialStepPolygon = new ConvexPolygon2D();
    private Vertex2DSupplier polygonToWiggleInto = null;
    private final WiggleParameters wiggleParameters = new WiggleParameters();
    private final ConvexPolygon2D stanceFootPolygon = new ConvexPolygon2D();
    private final RigidBodyTransform footstepInRegionFrame = new RigidBodyTransform();
    private final RigidBodyTransform localToWorld = new RigidBodyTransform();
    private PlanarRegionsList planarRegionsList = null;

    public GradientDescentStepConstraintInput() {
        this.clear();
    }

    public void setInitialStepPolygon(ConvexPolygon2DReadOnly initialStepPolygon) {
        this.initialStepPolygon.set((Vertex2DSupplier)initialStepPolygon);
    }

    public void setPolygonToWiggleInto(Vertex2DSupplier polygonToWiggleInto) {
        this.polygonToWiggleInto = polygonToWiggleInto;
    }

    public void setWiggleParameters(WiggleParameters wiggleParameters) {
        this.wiggleParameters.set(wiggleParameters);
    }

    public void setStanceFootPolygon(ConvexPolygon2D stanceFootPolygonInRegionFrame) {
        this.stanceFootPolygon.set(stanceFootPolygonInRegionFrame);
    }

    public void setFootstepInRegionFrame(RigidBodyTransformReadOnly footstepInRegionFrame) {
        this.footstepInRegionFrame.set(footstepInRegionFrame);
    }

    public void setLocalToWorld(RigidBodyTransformReadOnly localToWorld) {
        this.localToWorld.set(localToWorld);
    }

    public void setPlanarRegion(PlanarRegion planarRegion) {
        this.localToWorld.set(planarRegion.getTransformToWorld());
        this.polygonToWiggleInto = Vertex2DSupplier.asVertex2DSupplier((List)planarRegion.getConcaveHull());
    }

    public void setPlanarRegionsList(PlanarRegionsList planarRegionsList) {
        this.planarRegionsList = planarRegionsList;
    }

    public ConvexPolygon2D getInitialStepPolygon() {
        return this.initialStepPolygon;
    }

    public Vertex2DSupplier getPolygonToWiggleInto() {
        return this.polygonToWiggleInto;
    }

    public WiggleParameters getWiggleParameters() {
        return this.wiggleParameters;
    }

    public ConvexPolygon2D getStanceFootPolygon() {
        return this.stanceFootPolygon;
    }

    public RigidBodyTransform getFootstepInRegionFrame() {
        return this.footstepInRegionFrame;
    }

    public RigidBodyTransform getLocalToWorld() {
        return this.localToWorld;
    }

    public PlanarRegionsList getPlanarRegionsList() {
        return this.planarRegionsList;
    }

    public void clear() {
        this.initialStepPolygon.clear();
        this.polygonToWiggleInto = null;
        this.stanceFootPolygon.clear();
        this.footstepInRegionFrame.setToNaN();
        this.localToWorld.setToNaN();
        this.planarRegionsList = null;
    }

    void checkInputs() {
        if (this.initialStepPolygon.isEmpty()) {
            throw new RuntimeException("Initial step polygon not set");
        }
        if (this.polygonToWiggleInto == null) {
            throw new RuntimeException("Polygon to wiggle into is not set");
        }
    }

    boolean containsInputForLegCollisionCheck() {
        if (this.footstepInRegionFrame.containsNaN()) {
            return false;
        }
        if (this.localToWorld.containsNaN()) {
            return false;
        }
        return this.planarRegionsList != null;
    }

    boolean containsInputForStanceFootCheck() {
        return !this.stanceFootPolygon.isEmpty();
    }
}

