/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.orientationControl;

import java.util.ArrayList;
import java.util.List;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.ContactStateProvider;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.SettableContactStateProvider;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.tools.MPCAngleTools;
import us.ihmc.commonWalkingControlModules.orientationControl.AlgebraicVariationalFunction;
import us.ihmc.commonWalkingControlModules.orientationControl.DifferentialVariationalSegment;
import us.ihmc.commonWalkingControlModules.orientationControl.VariationalCommonValues;
import us.ihmc.commonWalkingControlModules.orientationControl.VariationalFunction;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.matrixlib.MatrixTools;
import us.ihmc.mecano.spatial.interfaces.SpatialInertiaReadOnly;
import us.ihmc.robotics.math.trajectories.generators.MultipleWaypointsOrientationTrajectoryGenerator;
import us.ihmc.robotics.math.trajectories.generators.MultipleWaypointsPositionTrajectoryGenerator;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.EuclideanTrajectoryPointBasics;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.SO3TrajectoryPointBasics;
import us.ihmc.yoVariables.registry.YoRegistry;

public class TrackingVariationalLQRController {
    private static final double discreteDt = 0.005;
    private static final double defaultQR = 1100.0;
    private static final double defaultQw = 5.0;
    private static final double defaultR = 1.25;
    private final MPCAngleTools angleTools = new MPCAngleTools();
    private final VariationalCommonValues commonValues = new VariationalCommonValues();
    private final Vector3DBasics axisAngleError = new Vector3D();
    private final DMatrixRMaj intermediateP = new DMatrixRMaj(6, 6);
    private final DMatrixRMaj intermediateK = new DMatrixRMaj(3, 6);
    private final DMatrixRMaj activeP = new DMatrixRMaj(6, 6);
    private final DMatrixRMaj activeK = new DMatrixRMaj(3, 6);
    private final DMatrixRMaj wBd = new DMatrixRMaj(3, 1);
    private final DMatrixRMaj wB = new DMatrixRMaj(3, 1);
    private final DMatrixRMaj RBerrorVector = new DMatrixRMaj(3, 1);
    private final DMatrixRMaj wBerror = new DMatrixRMaj(3, 1);
    private final DMatrixRMaj state = new DMatrixRMaj(6, 1);
    private final DMatrixRMaj desiredTorque = new DMatrixRMaj(3, 1);
    private final DMatrixRMaj feedbackTorque = new DMatrixRMaj(3, 1);
    private final DMatrixRMaj deltaTau = new DMatrixRMaj(3, 1);
    private final DMatrixRMaj inertia = new DMatrixRMaj(3, 3);
    private final Vector3D desiredBodyVelocityInBodyFrame = new Vector3D();
    private final AlgebraicVariationalFunction finalPFunction = new AlgebraicVariationalFunction();
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final MultipleWaypointsOrientationTrajectoryGenerator orientationTrajectory = new MultipleWaypointsOrientationTrajectoryGenerator("lqrOrientationTrajectory", ReferenceFrame.getWorldFrame(), this.registry);
    private final MultipleWaypointsPositionTrajectoryGenerator angularMomentumTrajectory = new MultipleWaypointsPositionTrajectoryGenerator("lqrAngularMomentumTrajectory", ReferenceFrame.getWorldFrame(), this.registry);
    private final RecyclingArrayList<SettableContactStateProvider> contactStateProviders = new RecyclingArrayList(SettableContactStateProvider::new);
    private final List<VariationalFunction> reversedPFunctionList = new ArrayList<VariationalFunction>();
    private final List<VariationalFunction> pFunctionList = new ArrayList<VariationalFunction>();

    public TrackingVariationalLQRController() {
        CommonOps_DDRM.setIdentity((DMatrix1Row)this.inertia);
        this.commonValues.setInertia(this.inertia);
        this.commonValues.computeCostMatrices(1100.0, 5.0, 1.25);
    }

    public void setInertia(SpatialInertiaReadOnly inertia) {
        inertia.getMomentOfInertia().get((DMatrix)this.inertia);
        this.commonValues.setInertia(this.inertia);
    }

    public void setTrajectories(MultipleWaypointsOrientationTrajectoryGenerator orientationTrajectory, MultipleWaypointsPositionTrajectoryGenerator angularMomentumTrajectory, List<? extends ContactStateProvider<?>> contactStateProviders) {
        int i;
        this.orientationTrajectory.clear();
        this.angularMomentumTrajectory.clear();
        this.contactStateProviders.clear();
        for (i = 0; i < orientationTrajectory.getCurrentNumberOfWaypoints(); ++i) {
            this.orientationTrajectory.appendWaypoint((SO3TrajectoryPointBasics)orientationTrajectory.getWaypoint(i));
        }
        for (i = 0; i < angularMomentumTrajectory.getCurrentNumberOfWaypoints(); ++i) {
            this.angularMomentumTrajectory.appendWaypoint((EuclideanTrajectoryPointBasics)angularMomentumTrajectory.getWaypoint(i));
        }
        for (i = 0; i < contactStateProviders.size(); ++i) {
            ((SettableContactStateProvider)this.contactStateProviders.add()).set(contactStateProviders.get(i));
        }
        double finalTime = ((SettableContactStateProvider)this.contactStateProviders.getLast()).getTimeInterval().getEndTime();
        orientationTrajectory.compute(finalTime);
        angularMomentumTrajectory.compute(finalTime);
        this.desiredBodyVelocityInBodyFrame.set((Tuple3DReadOnly)orientationTrajectory.getAngularVelocity());
        orientationTrajectory.getOrientation().transform((Tuple3DBasics)this.desiredBodyVelocityInBodyFrame);
        this.finalPFunction.setDesired((QuaternionReadOnly)orientationTrajectory.getOrientation(), (Vector3DReadOnly)this.desiredBodyVelocityInBodyFrame, (Vector3DReadOnly)angularMomentumTrajectory.getVelocity(), this.commonValues);
        this.computePSegments();
    }

    public void compute(double currentTime, QuaternionReadOnly currentRotation, Vector3DReadOnly currentAngularVelocityInBodyFrame) {
        currentAngularVelocityInBodyFrame.get((DMatrix)this.wB);
        int activeSegment = this.getActiveSegment(currentTime);
        double timeInSegment = currentTime - ((SettableContactStateProvider)this.contactStateProviders.get(activeSegment)).getTimeInterval().getStartTime();
        this.pFunctionList.get(activeSegment).compute(timeInSegment, this.activeP, this.activeK);
        this.orientationTrajectory.compute(currentTime);
        this.desiredBodyVelocityInBodyFrame.set((Tuple3DReadOnly)this.orientationTrajectory.getAngularVelocity());
        this.orientationTrajectory.getOrientation().transform((Tuple3DBasics)this.desiredBodyVelocityInBodyFrame);
        this.desiredBodyVelocityInBodyFrame.get((DMatrix)this.wBd);
        this.angleTools.computeRotationError((Orientation3DReadOnly)this.orientationTrajectory.getOrientation(), (Orientation3DReadOnly)currentRotation, this.axisAngleError);
        this.axisAngleError.get((DMatrix)this.RBerrorVector);
        CommonOps_DDRM.subtract((DMatrixD1)this.wB, (DMatrixD1)this.wBd, (DMatrixD1)this.wBerror);
        MatrixTools.setMatrixBlock((DMatrix)this.state, (int)0, (int)0, (DMatrix)this.RBerrorVector, (int)0, (int)0, (int)3, (int)1, (double)1.0);
        MatrixTools.setMatrixBlock((DMatrix)this.state, (int)3, (int)0, (DMatrix)this.wBerror, (int)0, (int)0, (int)3, (int)1, (double)1.0);
        CommonOps_DDRM.mult((double)-1.0, (DMatrix1Row)this.activeK, (DMatrix1Row)this.state, (DMatrix1Row)this.deltaTau);
        CommonOps_DDRM.add((DMatrixD1)this.deltaTau, (DMatrixD1)this.desiredTorque, (DMatrixD1)this.feedbackTorque);
    }

    public void getDesiredTorque(Vector3DBasics tau) {
        tau.set((DMatrix)this.feedbackTorque);
    }

    private int getActiveSegment(double currentTime) {
        for (int i = 0; i < this.contactStateProviders.size(); ++i) {
            if (!((SettableContactStateProvider)this.contactStateProviders.get(i)).getTimeInterval().intervalContains(currentTime)) continue;
            return i;
        }
        return this.contactStateProviders.size() - 1;
    }

    private void computePSegments() {
        this.reversedPFunctionList.clear();
        this.pFunctionList.clear();
        int numberOfSegments = this.contactStateProviders.size() - 1;
        if (numberOfSegments < 0) {
            this.reversedPFunctionList.add(this.finalPFunction);
        } else {
            this.finalPFunction.compute(0.0, this.intermediateP, this.intermediateK);
            this.reversedPFunctionList.add(this.finalPFunction);
            for (int j = numberOfSegments - 1; j >= 0; --j) {
                ContactStateProvider thisContactProvider = (ContactStateProvider)this.contactStateProviders.get(j);
                DifferentialVariationalSegment pSegment = new DifferentialVariationalSegment(0.005);
                pSegment.set(this.commonValues, this.orientationTrajectory, this.angularMomentumTrajectory, this.intermediateP, thisContactProvider.getTimeInterval().getStartTime(), thisContactProvider.getTimeInterval().getEndTime());
                pSegment.compute(0.0, this.intermediateP, this.intermediateK);
                this.reversedPFunctionList.add(pSegment);
            }
        }
        for (int i = this.reversedPFunctionList.size() - 1; i >= 0; --i) {
            this.pFunctionList.add(this.reversedPFunctionList.get(i));
        }
    }
}

