/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.momentumControlCore;

import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.CenterOfMassFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.momentumControlCore.HeightController;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.mecano.algorithms.CenterOfMassJacobian;
import us.ihmc.robotics.controllers.PDController;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class CoMHeightController
implements HeightController<CenterOfMassFeedbackControlCommand> {
    private final CenterOfMassJacobian centerOfMassJacobian;
    private final PDController comHeightController;
    private final YoDouble currentCoMHeightInWorld;
    private final YoDouble desiredCoMHeightInWorld;
    private final YoDouble desiredCoMVelocityInWorld;
    private final YoDouble currentCoMVelocityInWorld;
    private final YoDouble feedbackCoMAcceleration;
    private final YoDouble feedForwardCoMAcceleration;
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final FramePoint3D controlPosition = new FramePoint3D();
    private final FrameVector3D feedForwardLinearAcceleration = new FrameVector3D();
    private final FrameVector3D currentLinearVelocity = new FrameVector3D();

    public CoMHeightController(CenterOfMassJacobian centerOfMassJacobian, YoRegistry parentRegistry) {
        this.centerOfMassJacobian = centerOfMassJacobian;
        this.comHeightController = new PDController("CoMHeight", this.registry);
        this.currentCoMHeightInWorld = new YoDouble("currentCoMHeightInWorld", this.registry);
        this.desiredCoMHeightInWorld = new YoDouble("desiredCoMHeightInWorld", this.registry);
        this.desiredCoMVelocityInWorld = new YoDouble("desiredCoMVelocityInWorld", this.registry);
        this.currentCoMVelocityInWorld = new YoDouble("currentCoMVelocityInWorld", this.registry);
        this.feedbackCoMAcceleration = new YoDouble("feedbackCoMAcceleration", this.registry);
        this.feedForwardCoMAcceleration = new YoDouble("feedForwardCoMAcceleration", this.registry);
        parentRegistry.addChild(this.registry);
    }

    @Override
    public void compute(CenterOfMassFeedbackControlCommand feedbackCommand) {
        this.controlPosition.setIncludingFrame((FrameTuple3DReadOnly)this.centerOfMassJacobian.getCenterOfMass());
        this.currentLinearVelocity.setIncludingFrame((FrameTuple3DReadOnly)this.centerOfMassJacobian.getCenterOfMassVelocity());
        this.controlPosition.changeFrame(ReferenceFrame.getWorldFrame());
        this.currentLinearVelocity.changeFrame(ReferenceFrame.getWorldFrame());
        this.feedForwardLinearAcceleration.changeFrame(ReferenceFrame.getWorldFrame());
        this.currentCoMHeightInWorld.set(this.controlPosition.getZ());
        this.desiredCoMHeightInWorld.set(feedbackCommand.getReferencePosition().getZ());
        this.currentCoMVelocityInWorld.set(this.currentLinearVelocity.getZ());
        this.desiredCoMVelocityInWorld.set(feedbackCommand.getReferenceLinearVelocity().getZ());
        this.feedForwardLinearAcceleration.setIncludingFrame((FrameTuple3DReadOnly)feedbackCommand.getReferenceLinearAcceleration());
        this.comHeightController.setProportionalGain(feedbackCommand.getGains().getProportionalGains()[3]);
        this.comHeightController.setDerivativeGain(feedbackCommand.getGains().getDerivativeGains()[3]);
        this.comHeightController.setPositionDeadband(0.0);
        this.feedForwardCoMAcceleration.set(this.feedForwardLinearAcceleration.getZ());
        this.feedbackCoMAcceleration.set(this.comHeightController.compute(this.currentCoMHeightInWorld.getValue(), this.desiredCoMHeightInWorld.getValue(), this.currentCoMVelocityInWorld.getValue(), this.desiredCoMVelocityInWorld.getValue()));
        this.feedbackCoMAcceleration.add(this.feedForwardLinearAcceleration.getZ());
    }

    @Override
    public double getHeightAcceleration() {
        return this.feedbackCoMAcceleration.getDoubleValue();
    }
}

