/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.virtualModelControl;

import java.util.List;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.commonWalkingControlModules.controllerCore.command.virtualModelControl.JointTorqueCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.virtualModelControl.VirtualEffortCommand;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.JointIndexHandler;
import us.ihmc.commonWalkingControlModules.virtualModelControl.VirtualModelControlSolution;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.mecano.algorithms.GeometricJacobianCalculator;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;
import us.ihmc.robotics.screwTheory.SelectionMatrix6D;

public class VirtualModelMomentumController {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final PoseReferenceFrame controlFrame = new PoseReferenceFrame("controlFrame", worldFrame);
    private final GeometricJacobianCalculator jacobianCalculator = new GeometricJacobianCalculator();
    private final JointIndexHandler jointIndexHandler;
    private final DMatrixRMaj tempFullJacobian;
    private final DMatrixRMaj tempTaskJacobian = new DMatrixRMaj(6, 12);
    private final DMatrixRMaj tempSelectionMatrix = new DMatrixRMaj(6, 6);
    private final DMatrixRMaj tempTaskObjective = new DMatrixRMaj(6, 1);
    private final DMatrixRMaj tempFullObjective = new DMatrixRMaj(6, 1);
    private final DMatrixRMaj fullEffortMatrix;
    private final SelectionMatrix6D defaultSelectionMatrix = new SelectionMatrix6D();

    public VirtualModelMomentumController(JointIndexHandler jointIndexHandler) {
        this.jointIndexHandler = jointIndexHandler;
        this.fullEffortMatrix = new DMatrixRMaj(jointIndexHandler.getNumberOfDoFs(), 1);
        this.tempFullJacobian = new DMatrixRMaj(6, jointIndexHandler.getNumberOfDoFs());
    }

    public void reset() {
        this.fullEffortMatrix.zero();
    }

    public boolean addVirtualEffortCommand(VirtualEffortCommand<?> commandToAdd) {
        commandToAdd.getControlFrame(this.controlFrame);
        commandToAdd.getSelectionMatrix((ReferenceFrame)this.controlFrame, this.tempSelectionMatrix);
        int taskSize = this.tempSelectionMatrix.getNumRows();
        if (taskSize == 0) {
            return false;
        }
        this.jacobianCalculator.clear();
        this.jacobianCalculator.setKinematicChain((RigidBodyReadOnly)commandToAdd.getBase(), (RigidBodyReadOnly)commandToAdd.getEndEffector());
        this.jacobianCalculator.setJacobianFrame((ReferenceFrame)this.controlFrame);
        this.jacobianCalculator.reset();
        this.tempTaskJacobian.reshape(taskSize, this.jacobianCalculator.getNumberOfDegreesOfFreedom());
        CommonOps_DDRM.mult((DMatrix1Row)this.tempSelectionMatrix, (DMatrix1Row)this.jacobianCalculator.getJacobianMatrix(), (DMatrix1Row)this.tempTaskJacobian);
        List jointsUsedInTask = this.jacobianCalculator.getJointsFromBaseToEndEffector();
        this.jointIndexHandler.compactBlockToFullBlockIgnoreUnindexedJoints(jointsUsedInTask, this.tempTaskJacobian, this.tempFullJacobian);
        this.tempTaskObjective.reshape(taskSize, 1);
        commandToAdd.getDesiredEffort(this.tempFullObjective);
        CommonOps_DDRM.mult((DMatrix1Row)this.tempSelectionMatrix, (DMatrix1Row)this.tempFullObjective, (DMatrix1Row)this.tempTaskObjective);
        CommonOps_DDRM.multAddTransA((DMatrix1Row)this.tempFullJacobian, (DMatrix1Row)this.tempTaskObjective, (DMatrix1Row)this.fullEffortMatrix);
        return true;
    }

    public boolean addJointTorqueCommand(JointTorqueCommand commandToAdd) {
        int taskSize = MultiBodySystemTools.computeDegreesOfFreedom(commandToAdd.getJoints());
        if (taskSize == 0) {
            return false;
        }
        for (int jointNumber = 0; jointNumber < commandToAdd.getNumberOfJoints(); ++jointNumber) {
            JointBasics joint = commandToAdd.getJoint(jointNumber);
            int[] jointIndices = this.jointIndexHandler.getJointIndices((JointReadOnly)joint);
            if (jointIndices == null) {
                return false;
            }
            for (int i = 0; i < jointIndices.length; ++i) {
                int jointIndex = jointIndices[i];
                this.fullEffortMatrix.add(jointIndex, 0, commandToAdd.getDesiredTorque(jointNumber).get(i, 0));
            }
        }
        return true;
    }

    public boolean addExternalWrench(RigidBodyBasics base, RigidBodyBasics endEffector, WrenchReadOnly wrench, SelectionMatrix6D selectionMatrix) {
        if (wrench.getLinearPart().length() < 1.0E-5 && wrench.getAngularPart().length() < 1.0E-5) {
            return false;
        }
        selectionMatrix.getCompactSelectionMatrixInFrame(wrench.getReferenceFrame(), this.tempSelectionMatrix);
        int taskSize = this.tempSelectionMatrix.getNumRows();
        if (taskSize == 0) {
            return false;
        }
        this.jacobianCalculator.clear();
        this.jacobianCalculator.setKinematicChain((RigidBodyReadOnly)base, (RigidBodyReadOnly)endEffector);
        this.jacobianCalculator.setJacobianFrame(wrench.getReferenceFrame());
        this.jacobianCalculator.reset();
        this.tempTaskJacobian.reshape(taskSize, this.jacobianCalculator.getNumberOfDegreesOfFreedom());
        CommonOps_DDRM.mult((DMatrix1Row)this.tempSelectionMatrix, (DMatrix1Row)this.jacobianCalculator.getJacobianMatrix(), (DMatrix1Row)this.tempTaskJacobian);
        List jointsUsedInTask = this.jacobianCalculator.getJointsFromBaseToEndEffector();
        this.jointIndexHandler.compactBlockToFullBlockIgnoreUnindexedJoints(jointsUsedInTask, this.tempTaskJacobian, this.tempFullJacobian);
        this.tempTaskObjective.reshape(taskSize, 1);
        wrench.get((DMatrix)this.tempFullObjective);
        CommonOps_DDRM.mult((DMatrix1Row)this.tempSelectionMatrix, (DMatrix1Row)this.tempFullObjective, (DMatrix1Row)this.tempTaskObjective);
        CommonOps_DDRM.multAddTransA((DMatrix1Row)this.tempFullJacobian, (DMatrix1Row)this.tempTaskObjective, (DMatrix1Row)this.fullEffortMatrix);
        return true;
    }

    public boolean addExternalWrench(RigidBodyBasics base, RigidBodyBasics endEffector, Wrench wrench) {
        return this.addExternalWrench(base, endEffector, (WrenchReadOnly)wrench, this.defaultSelectionMatrix);
    }

    public void populateTorqueSolution(VirtualModelControlSolution solutionToPack) {
        solutionToPack.setJointTorques(this.fullEffortMatrix);
    }
}

