/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.virtualModelControl;

import java.util.List;
import java.util.Map;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.commonWalkingControlModules.controllerCore.WholeBodyControlCoreToolbox;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ConstraintType;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.CenterOfPressureCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.ContactWrenchCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.MomentumRateCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.PlaneContactStateCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.virtualModelControl.VirtualModelControlOptimizationSettingsCommand;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.ControllerCoreOptimizationSettings;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.ExternalWrenchHandler;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.QPInputTypeA;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.groundContactForce.GroundContactForceMomentumQPSolver;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.virtualModelControl.VirtualModelControlModuleException;
import us.ihmc.commonWalkingControlModules.virtualModelControl.VirtualModelControlSolution;
import us.ihmc.commonWalkingControlModules.visualizer.BasisVectorVisualizer;
import us.ihmc.commonWalkingControlModules.wrenchDistribution.WrenchMatrixCalculator;
import us.ihmc.convexOptimization.exceptions.NoConvergenceException;
import us.ihmc.convexOptimization.quadraticProgram.ActiveSetQPSolverWithInactiveVariablesInterface;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.log.LogTools;
import us.ihmc.matrixlib.DiagonalMatrixTools;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.SpatialForce;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.spatial.interfaces.SpatialForceReadOnly;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class VirtualModelControlOptimizationControlModule {
    private static final boolean VISUALIZE_RHO_BASIS_VECTORS = false;
    private static final boolean SETUP_RHO_TASKS = true;
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final ExternalWrenchHandler externalWrenchHandler;
    private final SpatialForce centroidalMomentumRateSolution = new SpatialForce();
    private final YoBoolean hasNotConvergedInPast = new YoBoolean("hasNotConvergedInPast", this.registry);
    private final YoInteger hasNotConvergedCounts = new YoInteger("hasNotConvergedCounts", this.registry);
    private final YoBoolean useWarmStart = new YoBoolean("useWarmStartInSolver", this.registry);
    private final YoInteger maximumNumberOfIterations = new YoInteger("maximumNumberOfIterationsInSolver", this.registry);
    private final VirtualModelControlSolution virtualModelControlSolution = new VirtualModelControlSolution();
    private final WrenchMatrixCalculator wrenchMatrixCalculator;
    private final YoDouble rhoMin = new YoDouble("rhoMinGCF", this.registry);
    private final BasisVectorVisualizer basisVectorVisualizer;
    private final GroundContactForceMomentumQPSolver qpSolver;
    private final QPInputTypeA momentumQPInput;
    private final DMatrixRMaj identityMatrix = CommonOps_DDRM.identity((int)6, (int)6);
    private final DMatrixRMaj tempSelectionMatrix = new DMatrixRMaj(6, 6);
    private final DMatrixRMaj tempTaskWeight = new DMatrixRMaj(6, 6);
    private final DMatrixRMaj tempTaskWeightSubspace = new DMatrixRMaj(6, 6);
    private final DMatrixRMaj fullMomentumObjective = new DMatrixRMaj(6, 1);
    private final DMatrixRMaj totalWrench = new DMatrixRMaj(6, 1);
    private final FrameVector3D angularMomentum = new FrameVector3D();
    private final FrameVector3D linearMomentum = new FrameVector3D();
    private final ReferenceFrame centerOfMassFrame;
    private final DMatrixRMaj zeroObjective = new DMatrixRMaj(0, 0);

    public VirtualModelControlOptimizationControlModule(WholeBodyControlCoreToolbox toolbox, YoRegistry parentRegistry) {
        this.wrenchMatrixCalculator = toolbox.getWrenchMatrixCalculator();
        this.centerOfMassFrame = toolbox.getCenterOfMassFrame();
        ControllerCoreOptimizationSettings optimizationSettings = toolbox.getOptimizationSettings();
        int rhoSize = optimizationSettings.getRhoSize();
        this.momentumQPInput = new QPInputTypeA(6);
        this.basisVectorVisualizer = null;
        boolean hasFloatingBase = toolbox.getRootJoint() != null;
        this.rhoMin.set(optimizationSettings.getRhoMin());
        ActiveSetQPSolverWithInactiveVariablesInterface activeSetQPSolver = optimizationSettings.getActiveSetQPSolver();
        this.qpSolver = new GroundContactForceMomentumQPSolver(activeSetQPSolver, rhoSize, hasFloatingBase, this.registry);
        this.qpSolver.setMinRho(optimizationSettings.getRhoMin());
        this.qpSolver.setUseWarmStart(optimizationSettings.useWarmStartInSolver());
        this.qpSolver.setMaxNumberOfIterations(optimizationSettings.getMaxNumberOfSolverIterations());
        this.externalWrenchHandler = new ExternalWrenchHandler(toolbox.getGravityZ(), this.centerOfMassFrame, toolbox.getTotalRobotMass(), toolbox.getContactablePlaneBodies());
        this.useWarmStart.set(optimizationSettings.useWarmStartInSolver());
        this.maximumNumberOfIterations.set(optimizationSettings.getMaxNumberOfSolverIterations());
        this.zeroObjective.reshape(this.wrenchMatrixCalculator.getCopTaskSize(), 1);
        this.zeroObjective.zero();
        parentRegistry.addChild(this.registry);
    }

    public void initialize() {
        this.qpSolver.reset();
        this.externalWrenchHandler.reset();
    }

    public VirtualModelControlSolution compute() throws VirtualModelControlModuleException {
        this.wrenchMatrixCalculator.computeMatrices();
        this.qpSolver.setRhoRegularizationWeight(this.wrenchMatrixCalculator.getRhoWeightMatrix());
        this.setupRhoTasks();
        this.qpSolver.setMinRho(this.rhoMin.getDoubleValue());
        this.qpSolver.setMaxRho(this.wrenchMatrixCalculator.getRhoMaxMatrix());
        this.qpSolver.setActiveRhos(this.wrenchMatrixCalculator.getActiveRhoMatrix());
        this.setupWrenchesEquilibriumConstraint();
        this.qpSolver.setMaxNumberOfIterations(this.maximumNumberOfIterations.getIntegerValue());
        if (this.useWarmStart.getBooleanValue() && this.wrenchMatrixCalculator.hasContactStateChanged()) {
            this.qpSolver.setUseWarmStart(this.useWarmStart.getBooleanValue());
            this.qpSolver.notifyResetActiveSet();
        }
        NoConvergenceException noConvergenceException = null;
        try {
            this.qpSolver.solve();
        }
        catch (NoConvergenceException e) {
            if (!this.hasNotConvergedInPast.getBooleanValue()) {
                e.printStackTrace();
                LogTools.warn((String)("Only showing the stack trace of the first " + ((Object)((Object)e)).getClass().getSimpleName() + ". This may be happening more than once."));
            }
            this.hasNotConvergedInPast.set(true);
            this.hasNotConvergedCounts.increment();
            noConvergenceException = e;
        }
        DMatrixRMaj rhoSolution = this.qpSolver.getRhos();
        Map<RigidBodyBasics, Wrench> groundReactionWrenches = this.wrenchMatrixCalculator.computeWrenchesFromRho(rhoSolution);
        this.externalWrenchHandler.computeExternalWrenches(groundReactionWrenches);
        SpatialForceReadOnly centroidalMomentumRateSolution = this.computeCentroidalMomentumRateSolution(rhoSolution);
        Map<RigidBodyBasics, Wrench> externalWrenchSolution = this.externalWrenchHandler.getExternalWrenchMap();
        List<RigidBodyBasics> rigidBodiesWithExternalWrench = this.externalWrenchHandler.getRigidBodiesWithExternalWrench();
        this.virtualModelControlSolution.setExternalWrenchSolution(rigidBodiesWithExternalWrench, externalWrenchSolution);
        this.virtualModelControlSolution.setCentroidalMomentumRateSolution(centroidalMomentumRateSolution);
        if (noConvergenceException != null) {
            throw new VirtualModelControlModuleException(this.virtualModelControlSolution);
        }
        return this.virtualModelControlSolution;
    }

    public void submitMomentumRateCommand(MomentumRateCommand command) {
        boolean success = this.convertMomentumRateCommand(command, this.momentumQPInput);
        if (success) {
            this.qpSolver.addMomentumInput(this.momentumQPInput);
        }
    }

    public void submitPlaneContactStateCommand(PlaneContactStateCommand command) {
        this.wrenchMatrixCalculator.submitPlaneContactStateCommand(command);
    }

    public void submitCenterOfPressureCommand(CenterOfPressureCommand command) {
        this.wrenchMatrixCalculator.submitCenterOfPressureCommand(command);
    }

    public void submitContactWrenchCommand(ContactWrenchCommand command) {
        this.wrenchMatrixCalculator.submitContactWrenchCommand(command);
    }

    public void submitExternalWrench(RigidBodyBasics rigidBody, WrenchReadOnly wrench) {
        this.externalWrenchHandler.setExternalWrenchToCompensateFor(rigidBody, wrench);
    }

    public void submitOptimizationSettingsCommand(VirtualModelControlOptimizationSettingsCommand command) {
        if (command.hasRhoMin()) {
            this.rhoMin.set(command.getRhoMin());
        }
        if (command.hasRhoWeight()) {
            this.wrenchMatrixCalculator.setRhoWeight(command.getRhoWeight());
        }
        if (command.hasRhoRateWeight()) {
            this.wrenchMatrixCalculator.setRhoRateWeight(command.getRhoRateWeight());
        }
        if (command.hasCenterOfPressureWeight()) {
            this.wrenchMatrixCalculator.setDesiredCoPWeight((Tuple2DReadOnly)command.getCenterOfPressureWeight());
        }
        if (command.hasCenterOfPressureRateWeight()) {
            this.wrenchMatrixCalculator.setCoPRateWeight((Tuple2DReadOnly)command.getCenterOfPressureRateWeight());
        }
        if (command.hasMomentumRateWeight()) {
            this.qpSolver.setMomentumRateRegularization(command.getMomentumRateWeight());
        }
        if (command.hasMomentumAccelerationWeight()) {
            this.qpSolver.setMomentumAccelerationRegularization(command.getMomentumAccelerationWeight());
        }
    }

    private boolean convertMomentumRateCommand(MomentumRateCommand commandToConvert, QPInputTypeA motionQPInputToPack) {
        commandToConvert.getSelectionMatrix(this.centerOfMassFrame, this.tempSelectionMatrix);
        int taskSize = this.tempSelectionMatrix.getNumRows();
        if (taskSize == 0) {
            return false;
        }
        motionQPInputToPack.reshape(taskSize);
        motionQPInputToPack.setUseWeightScalar(false);
        motionQPInputToPack.setConstraintType(ConstraintType.OBJECTIVE);
        this.tempTaskWeight.reshape(6, 6);
        commandToConvert.getWeightMatrix(this.tempTaskWeight);
        this.tempTaskWeightSubspace.reshape(taskSize, 6);
        DiagonalMatrixTools.postMult((DMatrix1Row)this.tempSelectionMatrix, (DMatrix1Row)this.tempTaskWeight, (DMatrix1Row)this.tempTaskWeightSubspace);
        CommonOps_DDRM.multTransB((DMatrix1Row)this.tempTaskWeightSubspace, (DMatrix1Row)this.tempSelectionMatrix, (DMatrix1Row)motionQPInputToPack.taskWeightMatrix);
        CommonOps_DDRM.mult((DMatrix1Row)this.tempSelectionMatrix, (DMatrix1Row)this.identityMatrix, (DMatrix1Row)motionQPInputToPack.taskJacobian);
        commandToConvert.getMomentumRate(this.angularMomentum, this.linearMomentum);
        this.angularMomentum.changeFrame(this.centerOfMassFrame);
        this.linearMomentum.changeFrame(this.centerOfMassFrame);
        this.angularMomentum.get(0, (DMatrix)this.fullMomentumObjective);
        this.linearMomentum.get(3, (DMatrix)this.fullMomentumObjective);
        CommonOps_DDRM.mult((DMatrix1Row)this.tempSelectionMatrix, (DMatrix1Row)this.fullMomentumObjective, (DMatrix1Row)motionQPInputToPack.taskObjective);
        return true;
    }

    private void setupWrenchesEquilibriumConstraint() {
        DMatrixRMaj additionalExternalWrench = this.externalWrenchHandler.getSumOfExternalWrenches();
        DMatrixRMaj gravityWrench = this.externalWrenchHandler.getGravitationalWrench();
        DMatrixRMaj rhoJacobian = this.wrenchMatrixCalculator.getRhoJacobianMatrix();
        this.qpSolver.setupWrenchesEquilibriumConstraint(this.identityMatrix, rhoJacobian, additionalExternalWrench, gravityWrench);
    }

    private SpatialForceReadOnly computeCentroidalMomentumRateSolution(DMatrixRMaj rhoSolution) {
        DMatrixRMaj additionalExternalWrench = this.externalWrenchHandler.getSumOfExternalWrenches();
        DMatrixRMaj gravityWrench = this.externalWrenchHandler.getGravitationalWrench();
        DMatrixRMaj rhoJacobian = this.wrenchMatrixCalculator.getRhoJacobianMatrix();
        CommonOps_DDRM.mult((DMatrix1Row)rhoJacobian, (DMatrix1Row)rhoSolution, (DMatrix1Row)this.totalWrench);
        CommonOps_DDRM.addEquals((DMatrixD1)this.totalWrench, (DMatrixD1)additionalExternalWrench);
        CommonOps_DDRM.addEquals((DMatrixD1)this.totalWrench, (DMatrixD1)gravityWrench);
        this.centroidalMomentumRateSolution.setIncludingFrame(this.centerOfMassFrame, (DMatrix)this.totalWrench);
        return this.centroidalMomentumRateSolution;
    }

    private void setupRhoTasks() {
        DMatrixRMaj rhoPrevious = this.wrenchMatrixCalculator.getRhoPreviousMatrix();
        DMatrixRMaj rhoRateWeight = this.wrenchMatrixCalculator.getRhoRateWeightMatrix();
        this.qpSolver.addRhoTask(rhoPrevious, rhoRateWeight);
        DMatrixRMaj copRegularizationWeight = this.wrenchMatrixCalculator.getCoPRegularizationWeight();
        DMatrixRMaj copRegularizationJacobian = this.wrenchMatrixCalculator.getCoPRegularizationJacobian();
        this.qpSolver.addRhoTask(copRegularizationJacobian, this.zeroObjective, copRegularizationWeight);
        DMatrixRMaj copRateRegularizationWeight = this.wrenchMatrixCalculator.getCoPRateRegularizationWeight();
        DMatrixRMaj copRateRegularizationJacobian = this.wrenchMatrixCalculator.getCoPRateRegularizationJacobian();
        this.qpSolver.addRhoTask(copRateRegularizationJacobian, this.zeroObjective, copRateRegularizationWeight);
    }
}

