/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.groundContactForce;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.QPInputTypeA;
import us.ihmc.convexOptimization.exceptions.NoConvergenceException;
import us.ihmc.convexOptimization.quadraticProgram.ActiveSetQPSolver;
import us.ihmc.matrixlib.DiagonalMatrixTools;
import us.ihmc.matrixlib.MatrixTools;
import us.ihmc.robotics.time.ExecutionTimer;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoInteger;

public class GroundContactForceQPSolver {
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final ExecutionTimer qpSolverTimer = new ExecutionTimer("qpSolverTimer", 0.5, this.registry);
    private final YoBoolean firstCall = new YoBoolean("firstCall", this.registry);
    private final ActiveSetQPSolver qpSolver;
    private final DMatrixRMaj solverInput_H;
    private final DMatrixRMaj solverInput_f;
    private final DMatrixRMaj solverInput_Aeq;
    private final DMatrixRMaj solverInput_beq;
    private final DMatrixRMaj solverInput_Ain;
    private final DMatrixRMaj solverInput_bin;
    private final DMatrixRMaj solverInput_lb;
    private final DMatrixRMaj solverInput_ub;
    private final DMatrixRMaj solverOutput_rhos;
    private final YoInteger numberOfIterations = new YoInteger("numberOfIterations", this.registry);
    private final YoInteger numberOfEqualityConstraints = new YoInteger("numberOfEqualityConstraints", this.registry);
    private final YoInteger numberOfInequalityConstraints = new YoInteger("numberOfInequalityConstraints", this.registry);
    private final YoInteger numberOfConstraints = new YoInteger("numberOfConstraints", this.registry);
    private final DMatrixRMaj regularizationMatrix;
    private final DMatrixRMaj tempJtW;
    private final DMatrixRMaj tempRhoTask_H;
    private final DMatrixRMaj tempRhoTask_f;
    private final int rhoSize;

    public GroundContactForceQPSolver(ActiveSetQPSolver qpSolver, int rhoSize, YoRegistry parentRegistry) {
        this.qpSolver = qpSolver;
        this.rhoSize = rhoSize;
        this.solverInput_H = new DMatrixRMaj(rhoSize, rhoSize);
        this.solverInput_f = new DMatrixRMaj(rhoSize, 1);
        this.solverInput_Aeq = new DMatrixRMaj(0, rhoSize);
        this.solverInput_beq = new DMatrixRMaj(0, 1);
        this.solverInput_Ain = new DMatrixRMaj(0, rhoSize);
        this.solverInput_bin = new DMatrixRMaj(0, 1);
        this.solverInput_lb = new DMatrixRMaj(rhoSize, 1);
        this.solverInput_ub = new DMatrixRMaj(rhoSize, 1);
        CommonOps_DDRM.fill((DMatrixD1)this.solverInput_lb, (double)Double.NEGATIVE_INFINITY);
        CommonOps_DDRM.fill((DMatrixD1)this.solverInput_ub, (double)Double.POSITIVE_INFINITY);
        this.solverOutput_rhos = new DMatrixRMaj(rhoSize, 1);
        this.tempJtW = new DMatrixRMaj(rhoSize, rhoSize);
        this.tempRhoTask_H = new DMatrixRMaj(rhoSize, rhoSize);
        this.tempRhoTask_f = new DMatrixRMaj(rhoSize, 1);
        this.regularizationMatrix = new DMatrixRMaj(rhoSize, rhoSize);
        double defaultRhoRegularization = 1.0E-5;
        for (int i = 0; i < rhoSize; ++i) {
            this.regularizationMatrix.set(i, i, defaultRhoRegularization);
        }
        parentRegistry.addChild(this.registry);
    }

    public void setRhoRegularizationWeight(DMatrixRMaj weight) {
        CommonOps_DDRM.insert((DMatrix)weight, (DMatrix)this.regularizationMatrix, (int)0, (int)0);
    }

    public void reset() {
        this.solverInput_H.zero();
        this.solverInput_f.zero();
        this.solverInput_Aeq.reshape(0, this.rhoSize);
        this.solverInput_beq.reshape(0, 1);
    }

    public void addRegularization() {
        CommonOps_DDRM.addEquals((DMatrixD1)this.solverInput_H, (DMatrixD1)this.regularizationMatrix);
    }

    public void addMotionInput(QPInputTypeA input) {
        switch (input.getConstraintType()) {
            case OBJECTIVE: {
                if (input.useWeightScalar()) {
                    this.addMotionTask(input.taskJacobian, input.taskObjective, input.getWeightScalar());
                    break;
                }
                this.addMotionTask(input.taskJacobian, input.taskObjective, input.taskWeightMatrix);
                break;
            }
            case EQUALITY: {
                this.addMotionEqualityConstraint(input.taskJacobian, input.taskObjective);
                break;
            }
            case LEQ_INEQUALITY: {
                this.addMotionLesserOrEqualInequalityConstraint(input.taskJacobian, input.taskObjective);
                break;
            }
            case GEQ_INEQUALITY: {
                this.addMotionGreaterOrEqualInequalityConstraint(input.taskJacobian, input.taskObjective);
                break;
            }
            default: {
                throw new RuntimeException("Unexpected constraint type: " + (Object)((Object)input.getConstraintType()));
            }
        }
    }

    public void addMomentumTask(DMatrixRMaj taskJacobian, DMatrixRMaj taskObjective, DMatrixRMaj taskWeight) {
        int taskSize = taskJacobian.getNumRows();
        this.tempJtW.reshape(this.rhoSize, taskSize);
        CommonOps_DDRM.multTransA((DMatrix1Row)taskJacobian, (DMatrix1Row)taskWeight, (DMatrix1Row)this.tempJtW);
        this.addMomentumTaskInternal(this.tempJtW, taskJacobian, taskObjective);
    }

    public void addMotionTask(DMatrixRMaj taskJ, DMatrixRMaj taskObjective, double taskWeight) {
        int taskSize = taskJ.getNumRows();
        this.tempJtW.reshape(this.rhoSize, taskSize);
        CommonOps_DDRM.transpose((DMatrixRMaj)taskJ, (DMatrixRMaj)this.tempJtW);
        this.addMotionTaskInternal(taskWeight, this.tempJtW, taskJ, taskObjective);
    }

    public void addMotionTask(DMatrixRMaj taskJacobian, DMatrixRMaj taskObjective, DMatrixRMaj taskWeight) {
        int taskSize = taskJacobian.getNumRows();
        this.tempJtW.reshape(this.rhoSize, taskSize);
        DiagonalMatrixTools.postMultTransA((DMatrix1Row)taskJacobian, (DMatrix1Row)taskWeight, (DMatrix1Row)this.tempJtW);
        this.addMotionTaskInternal(this.tempJtW, taskJacobian, taskObjective);
    }

    private void addMotionTaskInternal(double weight, DMatrixRMaj taskJt, DMatrixRMaj taskJacobian, DMatrixRMaj taskObjective) {
        CommonOps_DDRM.multInner((DMatrix1Row)taskJacobian, (DMatrix1Row)this.tempRhoTask_H);
        MatrixTools.addMatrixBlock((DMatrix)this.solverInput_H, (int)0, (int)0, (DMatrix1Row)this.tempRhoTask_H, (int)0, (int)0, (int)this.rhoSize, (int)this.rhoSize, (double)weight);
        CommonOps_DDRM.mult((DMatrix1Row)taskJt, (DMatrix1Row)taskObjective, (DMatrix1Row)this.tempRhoTask_f);
        MatrixTools.addMatrixBlock((DMatrix)this.solverInput_f, (int)0, (int)0, (DMatrix1Row)this.tempRhoTask_f, (int)0, (int)0, (int)this.rhoSize, (int)1, (double)(-weight));
    }

    private void addMotionTaskInternal(DMatrixRMaj taskJtW, DMatrixRMaj taskJacobian, DMatrixRMaj taskObjective) {
        CommonOps_DDRM.mult((DMatrix1Row)taskJtW, (DMatrix1Row)taskJacobian, (DMatrix1Row)this.tempRhoTask_H);
        MatrixTools.addMatrixBlock((DMatrix)this.solverInput_H, (int)0, (int)0, (DMatrix1Row)this.tempRhoTask_H, (int)0, (int)0, (int)this.rhoSize, (int)this.rhoSize, (double)1.0);
        CommonOps_DDRM.mult((DMatrix1Row)taskJtW, (DMatrix1Row)taskObjective, (DMatrix1Row)this.tempRhoTask_f);
        MatrixTools.addMatrixBlock((DMatrix)this.solverInput_f, (int)0, (int)0, (DMatrix1Row)this.tempRhoTask_f, (int)0, (int)0, (int)this.rhoSize, (int)1, (double)-1.0);
    }

    public void addMomentumTaskInternal(DMatrixRMaj taskJtW, DMatrixRMaj taskJacobian, DMatrixRMaj taskObjective) {
        CommonOps_DDRM.mult((DMatrix1Row)taskJtW, (DMatrix1Row)taskJacobian, (DMatrix1Row)this.tempRhoTask_H);
        MatrixTools.addMatrixBlock((DMatrix)this.solverInput_H, (int)0, (int)0, (DMatrix1Row)this.tempRhoTask_H, (int)0, (int)0, (int)this.rhoSize, (int)this.rhoSize, (double)1.0);
        CommonOps_DDRM.mult((DMatrix1Row)taskJtW, (DMatrix1Row)taskObjective, (DMatrix1Row)this.tempRhoTask_f);
        MatrixTools.addMatrixBlock((DMatrix)this.solverInput_f, (int)0, (int)0, (DMatrix1Row)this.tempRhoTask_f, (int)0, (int)0, (int)this.rhoSize, (int)1, (double)-1.0);
    }

    public void addMotionEqualityConstraint(DMatrixRMaj taskJacobian, DMatrixRMaj taskObjective) {
        int taskSize = taskJacobian.getNumRows();
        int previousSize = this.solverInput_beq.getNumRows();
        this.solverInput_Aeq.reshape(previousSize + taskSize, this.rhoSize, true);
        this.solverInput_beq.reshape(previousSize + taskSize, 1, true);
        CommonOps_DDRM.insert((DMatrix)taskJacobian, (DMatrix)this.solverInput_Aeq, (int)previousSize, (int)0);
        CommonOps_DDRM.insert((DMatrix)taskObjective, (DMatrix)this.solverInput_beq, (int)previousSize, (int)0);
    }

    public void addMotionLesserOrEqualInequalityConstraint(DMatrixRMaj taskJacobian, DMatrixRMaj taskObjective) {
        this.addMotionInequalityConstraintInternal(taskJacobian, taskObjective, 1.0);
    }

    public void addMotionGreaterOrEqualInequalityConstraint(DMatrixRMaj taskJacobian, DMatrixRMaj taskObjective) {
        this.addMotionInequalityConstraintInternal(taskJacobian, taskObjective, -1.0);
    }

    private void addMotionInequalityConstraintInternal(DMatrixRMaj taskJacobian, DMatrixRMaj taskObjective, double sign) {
        int taskSize = taskJacobian.getNumRows();
        int previousSize = this.solverInput_bin.getNumRows();
        this.solverInput_Ain.reshape(previousSize + taskSize, this.rhoSize, true);
        this.solverInput_bin.reshape(previousSize + taskSize, 1, true);
        MatrixTools.setMatrixBlock((DMatrix)this.solverInput_Ain, (int)previousSize, (int)0, (DMatrix)taskJacobian, (int)0, (int)0, (int)taskSize, (int)this.rhoSize, (double)sign);
        MatrixTools.setMatrixBlock((DMatrix)this.solverInput_bin, (int)previousSize, (int)0, (DMatrix)taskObjective, (int)0, (int)0, (int)taskSize, (int)1, (double)sign);
    }

    public void addRhoTask(DMatrixRMaj taskObjective, DMatrixRMaj taskWeight) {
        MatrixTools.addMatrixBlock((DMatrix)this.solverInput_H, (int)0, (int)0, (DMatrix1Row)taskWeight, (int)0, (int)0, (int)this.rhoSize, (int)this.rhoSize, (double)1.0);
        CommonOps_DDRM.mult((DMatrix1Row)taskWeight, (DMatrix1Row)taskObjective, (DMatrix1Row)this.tempRhoTask_f);
        MatrixTools.addMatrixBlock((DMatrix)this.solverInput_f, (int)0, (int)0, (DMatrix1Row)this.tempRhoTask_f, (int)0, (int)0, (int)this.rhoSize, (int)1, (double)-1.0);
    }

    public void addRhoTask(DMatrixRMaj taskJacobian, DMatrixRMaj taskObjective, DMatrixRMaj taskWeight) {
        int taskSize = taskJacobian.getNumRows();
        this.tempJtW.reshape(this.rhoSize, taskSize);
        CommonOps_DDRM.multTransA((DMatrix1Row)taskJacobian, (DMatrix1Row)taskWeight, (DMatrix1Row)this.tempJtW);
        CommonOps_DDRM.mult((DMatrix1Row)this.tempJtW, (DMatrix1Row)taskJacobian, (DMatrix1Row)this.tempRhoTask_H);
        MatrixTools.addMatrixBlock((DMatrix)this.solverInput_H, (int)0, (int)0, (DMatrix1Row)this.tempRhoTask_H, (int)0, (int)0, (int)this.rhoSize, (int)this.rhoSize, (double)1.0);
        CommonOps_DDRM.mult((DMatrix1Row)this.tempJtW, (DMatrix1Row)taskObjective, (DMatrix1Row)this.tempRhoTask_f);
        MatrixTools.addMatrixBlock((DMatrix)this.solverInput_f, (int)0, (int)0, (DMatrix1Row)this.tempRhoTask_f, (int)0, (int)0, (int)this.rhoSize, (int)1, (double)-1.0);
    }

    public void solve() throws NoConvergenceException {
        this.numberOfEqualityConstraints.set(this.solverInput_Aeq.getNumRows());
        this.numberOfInequalityConstraints.set(this.solverInput_Ain.getNumRows());
        this.numberOfConstraints.set(this.solverInput_Aeq.getNumRows() + this.solverInput_Ain.getNumRows());
        this.qpSolverTimer.startMeasurement();
        this.qpSolver.clear();
        this.qpSolver.setQuadraticCostFunction((DMatrix)this.solverInput_H, (DMatrix)this.solverInput_f, 0.0);
        this.qpSolver.setVariableBounds((DMatrix)this.solverInput_lb, (DMatrix)this.solverInput_ub);
        this.qpSolver.setLinearInequalityConstraints((DMatrix)this.solverInput_Ain, (DMatrix)this.solverInput_bin);
        this.qpSolver.setLinearEqualityConstraints((DMatrix)this.solverInput_Aeq, (DMatrix)this.solverInput_beq);
        this.numberOfIterations.set(this.qpSolver.solve((DMatrix)this.solverOutput_rhos));
        this.qpSolverTimer.stopMeasurement();
        if (MatrixTools.containsNaN((DMatrix1Row)this.solverOutput_rhos)) {
            throw new NoConvergenceException(this.numberOfIterations.getIntegerValue());
        }
        this.firstCall.set(false);
    }

    public DMatrixRMaj getRhos() {
        return this.solverOutput_rhos;
    }

    public void setMinRho(double rhoMin) {
        for (int i = 0; i < this.rhoSize; ++i) {
            this.solverInput_lb.set(i, 0, rhoMin);
        }
    }

    public void setMinRho(DMatrixRMaj rhoMin) {
        CommonOps_DDRM.insert((DMatrix)rhoMin, (DMatrix)this.solverInput_lb, (int)0, (int)0);
    }

    public void setMaxRho(double rhoMax) {
        for (int i = 0; i < this.rhoSize; ++i) {
            this.solverInput_ub.set(i, 0, rhoMax);
        }
    }

    public void setMaxRho(DMatrixRMaj rhoMax) {
        CommonOps_DDRM.insert((DMatrix)rhoMax, (DMatrix)this.solverInput_ub, (int)0, (int)0);
    }
}

