/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.groundContactForce;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.QPInputTypeA;
import us.ihmc.convexOptimization.exceptions.NoConvergenceException;
import us.ihmc.convexOptimization.quadraticProgram.ActiveSetQPSolverWithInactiveVariablesInterface;
import us.ihmc.matrixlib.DiagonalMatrixTools;
import us.ihmc.matrixlib.MatrixTools;
import us.ihmc.robotics.time.ExecutionTimer;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class GroundContactForceMomentumQPSolver {
    private static final boolean SETUP_WRENCHES_CONSTRAINT_AS_OBJECTIVE = true;
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final ExecutionTimer qpSolverTimer = new ExecutionTimer("qpSolverTimer", 0.5, this.registry);
    private final YoFrameVector3D wrenchEquilibriumForceError;
    private final YoFrameVector3D wrenchEquilibriumTorqueError;
    private final YoBoolean firstCall = new YoBoolean("firstCall", this.registry);
    private final ActiveSetQPSolverWithInactiveVariablesInterface qpSolver;
    private final DMatrixRMaj solverInput_H;
    private final DMatrixRMaj solverInput_f;
    private final DMatrixRMaj solverInput_H_previous;
    private final DMatrixRMaj solverInput_f_previous;
    private final DMatrixRMaj solverInput_Aeq;
    private final DMatrixRMaj solverInput_beq;
    private final DMatrixRMaj solverInput_Ain;
    private final DMatrixRMaj solverInput_bin;
    private final DMatrixRMaj solverInput_lb;
    private final DMatrixRMaj solverInput_ub;
    private final DMatrixRMaj solverInput_lb_previous;
    private final DMatrixRMaj solverInput_ub_previous;
    private final DMatrixRMaj solverInput_activeIndices;
    private final DMatrixRMaj solverOutput;
    private final DMatrixRMaj solverOutput_momentumRate;
    private final DMatrixRMaj solverOutput_rhos;
    private final YoInteger numberOfActiveVariables = new YoInteger("numberOfActiveVariables", this.registry);
    private final YoInteger numberOfIterations = new YoInteger("numberOfIterations", this.registry);
    private final YoInteger numberOfEqualityConstraints = new YoInteger("numberOfEqualityConstraints", this.registry);
    private final YoInteger numberOfInequalityConstraints = new YoInteger("numberOfInequalityConstraints", this.registry);
    private final YoInteger numberOfConstraints = new YoInteger("numberOfConstraints", this.registry);
    private final YoDouble momentumRateRegularization = new YoDouble("momentumRateRegularization", this.registry);
    private final YoDouble momentumAccelerationRegularization = new YoDouble("momentumAccelerationRegularization", this.registry);
    private final DMatrixRMaj regularizationMatrix;
    private final DMatrixRMaj tempJtW;
    private final DMatrixRMaj tempMomentumTask_H;
    private final DMatrixRMaj tempMomentumTask_f;
    private final DMatrixRMaj tempRhoTask_H;
    private final DMatrixRMaj tempRhoTask_f;
    private final int momentumSize = 6;
    private final int rhoSize;
    private final int problemSize;
    private final boolean hasFloatingBase;
    private boolean hasWrenchesEquilibriumConstraintBeenSetup = false;
    private boolean resetActiveSet = false;
    private boolean useWarmStart = false;
    private int maxNumberOfIterations = 100;
    private final DMatrixRMaj tempWrenchConstraint_H = new DMatrixRMaj(200, 200);
    private final DMatrixRMaj tempWrenchConstraint_J = new DMatrixRMaj(6, 200);
    private final DMatrixRMaj tempWrenchConstraint_f = new DMatrixRMaj(6, 200);
    private final DMatrixRMaj tempWrenchConstraint_LHS = new DMatrixRMaj(6, 1);
    private final DMatrixRMaj tempWrenchConstraint_RHS = new DMatrixRMaj(6, 1);

    public GroundContactForceMomentumQPSolver(ActiveSetQPSolverWithInactiveVariablesInterface qpSolver, int rhoSize, boolean hasFloatingBase, YoRegistry parentRegistry) {
        int i;
        this.qpSolver = qpSolver;
        this.rhoSize = rhoSize;
        this.problemSize = 6 + rhoSize;
        this.hasFloatingBase = hasFloatingBase;
        this.solverInput_H = new DMatrixRMaj(this.problemSize, this.problemSize);
        this.solverInput_f = new DMatrixRMaj(this.problemSize, 1);
        this.solverInput_H_previous = new DMatrixRMaj(this.problemSize, this.problemSize);
        this.solverInput_f_previous = new DMatrixRMaj(this.problemSize, 1);
        this.solverInput_Aeq = new DMatrixRMaj(0, this.problemSize);
        this.solverInput_beq = new DMatrixRMaj(0, 1);
        this.solverInput_Ain = new DMatrixRMaj(0, this.problemSize);
        this.solverInput_bin = new DMatrixRMaj(0, 1);
        this.solverInput_lb = new DMatrixRMaj(this.problemSize, 1);
        this.solverInput_ub = new DMatrixRMaj(this.problemSize, 1);
        this.solverInput_lb_previous = new DMatrixRMaj(this.problemSize, 1);
        this.solverInput_ub_previous = new DMatrixRMaj(this.problemSize, 1);
        CommonOps_DDRM.fill((DMatrixD1)this.solverInput_lb, (double)Double.NEGATIVE_INFINITY);
        CommonOps_DDRM.fill((DMatrixD1)this.solverInput_ub, (double)Double.POSITIVE_INFINITY);
        this.solverInput_activeIndices = new DMatrixRMaj(this.problemSize, 1);
        CommonOps_DDRM.fill((DMatrixD1)this.solverInput_activeIndices, (double)1.0);
        this.solverOutput = new DMatrixRMaj(this.problemSize, 1);
        this.solverOutput_momentumRate = new DMatrixRMaj(6, 1);
        this.solverOutput_rhos = new DMatrixRMaj(rhoSize, 1);
        this.tempJtW = new DMatrixRMaj(this.problemSize, this.problemSize);
        this.tempMomentumTask_H = new DMatrixRMaj(6, 6);
        this.tempMomentumTask_f = new DMatrixRMaj(6, 1);
        this.tempRhoTask_H = new DMatrixRMaj(rhoSize, rhoSize);
        this.tempRhoTask_f = new DMatrixRMaj(rhoSize, 1);
        this.regularizationMatrix = new DMatrixRMaj(this.problemSize, this.problemSize);
        this.momentumRateRegularization.set(1.0E-5);
        this.momentumAccelerationRegularization.set(1.0E-6);
        double defaultRhoRegularization = 1.0E-5;
        for (i = 0; i < 6; ++i) {
            this.regularizationMatrix.set(i, i, this.momentumRateRegularization.getDoubleValue());
        }
        for (i = rhoSize; i < this.problemSize; ++i) {
            this.regularizationMatrix.set(i, i, defaultRhoRegularization);
        }
        this.wrenchEquilibriumForceError = new YoFrameVector3D("wrenchEquilibriumForceError", null, this.registry);
        this.wrenchEquilibriumTorqueError = new YoFrameVector3D("wrenchEquilibriumTorqueError", null, this.registry);
        parentRegistry.addChild(this.registry);
    }

    public void setMomentumRateRegularization(double weight) {
        this.momentumRateRegularization.set(weight);
    }

    public void setMomentumAccelerationRegularization(double weight) {
        this.momentumAccelerationRegularization.set(weight);
    }

    public void setRhoRegularizationWeight(DMatrixRMaj weight) {
        CommonOps_DDRM.insert((DMatrix)weight, (DMatrix)this.regularizationMatrix, (int)6, (int)6);
    }

    public void setUseWarmStart(boolean useWarmStart) {
        this.useWarmStart = useWarmStart;
    }

    public void setMaxNumberOfIterations(int maxNumberOfIterations) {
        this.maxNumberOfIterations = maxNumberOfIterations;
    }

    public void notifyResetActiveSet() {
        this.resetActiveSet = true;
    }

    private boolean pollResetActiveSet() {
        boolean ret = this.resetActiveSet;
        this.resetActiveSet = false;
        return ret;
    }

    public void reset() {
        for (int i = 0; i < 6; ++i) {
            this.regularizationMatrix.set(i, i, this.momentumRateRegularization.getDoubleValue());
        }
        this.solverInput_H.zero();
        this.solverInput_f.zero();
        this.solverInput_Aeq.reshape(0, this.problemSize);
        this.solverInput_beq.reshape(0, 1);
        this.solverInput_Ain.reshape(0, this.problemSize);
        this.solverInput_bin.reshape(0, 1);
        if (!this.firstCall.getBooleanValue()) {
            this.addMomentumAccelerationRegularization();
        }
    }

    public void addRegularization() {
        CommonOps_DDRM.addEquals((DMatrixD1)this.solverInput_H, (DMatrixD1)this.regularizationMatrix);
    }

    public void addMomentumAccelerationRegularization() {
        for (int i = 0; i < 6; ++i) {
            this.solverInput_H.add(i, i, this.momentumAccelerationRegularization.getDoubleValue());
            this.solverInput_f.add(i, 0, -this.momentumAccelerationRegularization.getDoubleValue() * this.solverOutput_momentumRate.get(i, 0));
        }
    }

    public void addMomentumInput(QPInputTypeA input) {
        switch (input.getConstraintType()) {
            case OBJECTIVE: {
                if (input.useWeightScalar()) {
                    this.addMomentumTask(input.taskJacobian, input.taskObjective, input.getWeightScalar());
                    break;
                }
                this.addMomentumTask(input.taskJacobian, input.taskObjective, input.taskWeightMatrix);
                break;
            }
            case EQUALITY: {
                this.addMomentumEqualityConstraint(input.taskJacobian, input.taskObjective);
                break;
            }
            case LEQ_INEQUALITY: {
                this.addMomentumLesserOrEqualInequalityConstraint(input.taskJacobian, input.taskObjective);
                break;
            }
            case GEQ_INEQUALITY: {
                this.addMomentumGreaterOrEqualInequalityConstraint(input.taskJacobian, input.taskObjective);
                break;
            }
            default: {
                throw new RuntimeException("Unexpected constraint type: " + (Object)((Object)input.getConstraintType()));
            }
        }
    }

    public void addMomentumTask(DMatrixRMaj taskJ, DMatrixRMaj taskObjective, double taskWeight) {
        int taskSize = taskJ.getNumRows();
        this.tempJtW.reshape(6, taskSize);
        CommonOps_DDRM.transpose((DMatrixRMaj)taskJ, (DMatrixRMaj)this.tempJtW);
        this.addMomentumTaskInternal(taskWeight, this.tempJtW, taskJ, taskObjective);
    }

    public void addMomentumTask(DMatrixRMaj taskJacobian, DMatrixRMaj taskObjective, DMatrixRMaj taskWeight) {
        int taskSize = taskJacobian.getNumRows();
        this.tempJtW.reshape(6, taskSize);
        DiagonalMatrixTools.postMultTransA((DMatrix1Row)taskJacobian, (DMatrix1Row)taskWeight, (DMatrix1Row)this.tempJtW);
        this.addMomentumTaskInternal(this.tempJtW, taskJacobian, taskObjective);
    }

    private void addMomentumTaskInternal(double weight, DMatrixRMaj taskJt, DMatrixRMaj taskJacobian, DMatrixRMaj taskObjective) {
        CommonOps_DDRM.multInner((DMatrix1Row)taskJacobian, (DMatrix1Row)this.tempMomentumTask_H);
        MatrixTools.addMatrixBlock((DMatrix)this.solverInput_H, (int)0, (int)0, (DMatrix1Row)this.tempMomentumTask_H, (int)0, (int)0, (int)6, (int)6, (double)weight);
        CommonOps_DDRM.mult((DMatrix1Row)taskJt, (DMatrix1Row)taskObjective, (DMatrix1Row)this.tempMomentumTask_f);
        MatrixTools.addMatrixBlock((DMatrix)this.solverInput_f, (int)0, (int)0, (DMatrix1Row)this.tempMomentumTask_f, (int)0, (int)0, (int)6, (int)1, (double)(-weight));
    }

    private void addMomentumTaskInternal(DMatrixRMaj taskJtW, DMatrixRMaj taskJacobian, DMatrixRMaj taskObjective) {
        CommonOps_DDRM.mult((DMatrix1Row)taskJtW, (DMatrix1Row)taskJacobian, (DMatrix1Row)this.tempMomentumTask_H);
        MatrixTools.addMatrixBlock((DMatrix)this.solverInput_H, (int)0, (int)0, (DMatrix1Row)this.tempMomentumTask_H, (int)0, (int)0, (int)6, (int)6, (double)1.0);
        CommonOps_DDRM.mult((DMatrix1Row)taskJtW, (DMatrix1Row)taskObjective, (DMatrix1Row)this.tempMomentumTask_f);
        MatrixTools.addMatrixBlock((DMatrix)this.solverInput_f, (int)0, (int)0, (DMatrix1Row)this.tempMomentumTask_f, (int)0, (int)0, (int)6, (int)1, (double)-1.0);
    }

    public void addMomentumEqualityConstraint(DMatrixRMaj taskJacobian, DMatrixRMaj taskObjective) {
        int taskSize = taskJacobian.getNumRows();
        int previousSize = this.solverInput_beq.getNumRows();
        this.solverInput_Aeq.reshape(previousSize + taskSize, this.problemSize, true);
        this.solverInput_beq.reshape(previousSize + taskSize, 1, true);
        CommonOps_DDRM.insert((DMatrix)taskJacobian, (DMatrix)this.solverInput_Aeq, (int)previousSize, (int)0);
        CommonOps_DDRM.insert((DMatrix)taskObjective, (DMatrix)this.solverInput_beq, (int)previousSize, (int)0);
    }

    public void addMomentumLesserOrEqualInequalityConstraint(DMatrixRMaj taskJacobian, DMatrixRMaj taskObjective) {
        this.addMomentumInequalityConstraintInternal(taskJacobian, taskObjective, 1.0);
    }

    public void addMomentumGreaterOrEqualInequalityConstraint(DMatrixRMaj taskJacobian, DMatrixRMaj taskObjective) {
        this.addMomentumInequalityConstraintInternal(taskJacobian, taskObjective, -1.0);
    }

    private void addMomentumInequalityConstraintInternal(DMatrixRMaj taskJacobian, DMatrixRMaj taskObjective, double sign) {
        int taskSize = taskJacobian.getNumRows();
        int previousSize = this.solverInput_bin.getNumRows();
        this.solverInput_Ain.reshape(previousSize + taskSize, this.problemSize, true);
        this.solverInput_bin.reshape(previousSize + taskSize, 1, true);
        MatrixTools.setMatrixBlock((DMatrix)this.solverInput_Ain, (int)previousSize, (int)0, (DMatrix)taskJacobian, (int)0, (int)0, (int)taskSize, (int)this.problemSize, (double)sign);
        MatrixTools.setMatrixBlock((DMatrix)this.solverInput_bin, (int)previousSize, (int)0, (DMatrix)taskObjective, (int)0, (int)0, (int)taskSize, (int)1, (double)sign);
    }

    public void addRhoTask(DMatrixRMaj taskObjective, DMatrixRMaj taskWeight) {
        MatrixTools.addMatrixBlock((DMatrix)this.solverInput_H, (int)6, (int)6, (DMatrix1Row)taskWeight, (int)0, (int)0, (int)this.rhoSize, (int)this.rhoSize, (double)1.0);
        DiagonalMatrixTools.preMult((DMatrix1Row)taskWeight, (DMatrix1Row)taskObjective, (DMatrix1Row)this.tempRhoTask_f);
        MatrixTools.addMatrixBlock((DMatrix)this.solverInput_f, (int)6, (int)0, (DMatrix1Row)this.tempRhoTask_f, (int)0, (int)0, (int)this.rhoSize, (int)1, (double)-1.0);
    }

    public void addRhoTask(DMatrixRMaj taskJacobian, DMatrixRMaj taskObjective, DMatrixRMaj taskWeight) {
        int taskSize = taskJacobian.getNumRows();
        this.tempJtW.reshape(this.rhoSize, taskSize);
        DiagonalMatrixTools.postMultTransA((DMatrix1Row)taskJacobian, (DMatrix1Row)taskWeight, (DMatrix1Row)this.tempJtW);
        CommonOps_DDRM.mult((DMatrix1Row)this.tempJtW, (DMatrix1Row)taskJacobian, (DMatrix1Row)this.tempRhoTask_H);
        MatrixTools.addMatrixBlock((DMatrix)this.solverInput_H, (int)6, (int)6, (DMatrix1Row)this.tempRhoTask_H, (int)0, (int)0, (int)this.rhoSize, (int)this.rhoSize, (double)1.0);
        CommonOps_DDRM.mult((DMatrix1Row)this.tempJtW, (DMatrix1Row)taskObjective, (DMatrix1Row)this.tempRhoTask_f);
        MatrixTools.addMatrixBlock((DMatrix)this.solverInput_f, (int)6, (int)0, (DMatrix1Row)this.tempRhoTask_f, (int)0, (int)0, (int)this.rhoSize, (int)1, (double)-1.0);
    }

    public void solve() throws NoConvergenceException {
        if (!this.hasWrenchesEquilibriumConstraintBeenSetup) {
            throw new RuntimeException("The wrench equilibrium constraint has to be setup before calling solve().");
        }
        this.addRegularization();
        this.numberOfEqualityConstraints.set(this.solverInput_Aeq.getNumRows());
        this.numberOfInequalityConstraints.set(this.solverInput_Ain.getNumRows());
        this.numberOfConstraints.set(this.solverInput_Aeq.getNumRows() + this.solverInput_Ain.getNumRows());
        this.qpSolverTimer.startMeasurement();
        this.qpSolver.clear();
        this.qpSolver.setUseWarmStart(this.useWarmStart);
        this.qpSolver.setMaxNumberOfIterations(this.maxNumberOfIterations);
        if (this.useWarmStart && this.pollResetActiveSet()) {
            this.qpSolver.resetActiveSet();
        }
        this.numberOfActiveVariables.set((int)CommonOps_DDRM.elementSum((DMatrixD1)this.solverInput_activeIndices));
        this.qpSolver.setQuadraticCostFunction((DMatrix)this.solverInput_H, (DMatrix)this.solverInput_f, 0.0);
        this.qpSolver.setVariableBounds((DMatrix)this.solverInput_lb, (DMatrix)this.solverInput_ub);
        this.qpSolver.setActiveVariables(this.solverInput_activeIndices);
        this.qpSolver.setLinearInequalityConstraints((DMatrix)this.solverInput_Ain, (DMatrix)this.solverInput_bin);
        this.qpSolver.setLinearEqualityConstraints((DMatrix)this.solverInput_Aeq, (DMatrix)this.solverInput_beq);
        this.numberOfIterations.set(this.qpSolver.solve((DMatrix)this.solverOutput));
        this.qpSolverTimer.stopMeasurement();
        this.hasWrenchesEquilibriumConstraintBeenSetup = false;
        if (MatrixTools.containsNaN((DMatrix1Row)this.solverOutput)) {
            throw new NoConvergenceException(this.numberOfIterations.getIntegerValue());
        }
        CommonOps_DDRM.extract((DMatrix)this.solverOutput, (int)0, (int)6, (int)0, (int)1, (DMatrix)this.solverOutput_momentumRate, (int)0, (int)0);
        CommonOps_DDRM.extract((DMatrix)this.solverOutput, (int)6, (int)this.problemSize, (int)0, (int)1, (DMatrix)this.solverOutput_rhos, (int)0, (int)0);
        this.firstCall.set(false);
        if (this.hasFloatingBase) {
            CommonOps_DDRM.mult((DMatrix1Row)this.tempWrenchConstraint_J, (DMatrix1Row)this.solverOutput, (DMatrix1Row)this.tempWrenchConstraint_LHS);
            int index = 0;
            this.wrenchEquilibriumTorqueError.setX(this.tempWrenchConstraint_LHS.get(index, 0) - this.tempWrenchConstraint_RHS.get(index++, 0));
            this.wrenchEquilibriumTorqueError.setY(this.tempWrenchConstraint_LHS.get(index, 0) - this.tempWrenchConstraint_RHS.get(index++, 0));
            this.wrenchEquilibriumTorqueError.setZ(this.tempWrenchConstraint_LHS.get(index, 0) - this.tempWrenchConstraint_RHS.get(index++, 0));
            this.wrenchEquilibriumForceError.setX(this.tempWrenchConstraint_LHS.get(index, 0) - this.tempWrenchConstraint_RHS.get(index++, 0));
            this.wrenchEquilibriumForceError.setY(this.tempWrenchConstraint_LHS.get(index, 0) - this.tempWrenchConstraint_RHS.get(index++, 0));
            this.wrenchEquilibriumForceError.setZ(this.tempWrenchConstraint_LHS.get(index, 0) - this.tempWrenchConstraint_RHS.get(index++, 0));
        }
        this.solverInput_H_previous.set((DMatrixD1)this.solverInput_H);
        this.solverInput_f_previous.set((DMatrixD1)this.solverInput_f);
        this.solverInput_lb_previous.set((DMatrixD1)this.solverInput_lb);
        this.solverInput_ub_previous.set((DMatrixD1)this.solverInput_ub);
    }

    public void setupWrenchesEquilibriumConstraint(DMatrixRMaj momentumJacobian, DMatrixRMaj rhoJacobian, DMatrixRMaj additionalExternalWrench, DMatrixRMaj gravityWrench) {
        if (!this.hasFloatingBase) {
            this.hasWrenchesEquilibriumConstraintBeenSetup = true;
            return;
        }
        this.tempWrenchConstraint_RHS.zero();
        CommonOps_DDRM.subtractEquals((DMatrixD1)this.tempWrenchConstraint_RHS, (DMatrixD1)additionalExternalWrench);
        CommonOps_DDRM.subtractEquals((DMatrixD1)this.tempWrenchConstraint_RHS, (DMatrixD1)gravityWrench);
        this.tempWrenchConstraint_J.reshape(6, this.problemSize);
        MatrixTools.setMatrixBlock((DMatrix)this.tempWrenchConstraint_J, (int)0, (int)0, (DMatrix)momentumJacobian, (int)0, (int)0, (int)6, (int)6, (double)-1.0);
        CommonOps_DDRM.insert((DMatrix)rhoJacobian, (DMatrix)this.tempWrenchConstraint_J, (int)0, (int)6);
        double weight = 1500.0;
        this.tempWrenchConstraint_H.reshape(this.problemSize, this.problemSize);
        CommonOps_DDRM.multInner((DMatrix1Row)this.tempWrenchConstraint_J, (DMatrix1Row)this.tempWrenchConstraint_H);
        CommonOps_DDRM.scale((double)weight, (DMatrixD1)this.tempWrenchConstraint_H);
        CommonOps_DDRM.addEquals((DMatrixD1)this.solverInput_H, (DMatrixD1)this.tempWrenchConstraint_H);
        this.tempWrenchConstraint_f.reshape(this.problemSize, 1);
        CommonOps_DDRM.multTransA((double)weight, (DMatrix1Row)this.tempWrenchConstraint_J, (DMatrix1Row)this.tempWrenchConstraint_RHS, (DMatrix1Row)this.tempWrenchConstraint_f);
        CommonOps_DDRM.subtractEquals((DMatrixD1)this.solverInput_f, (DMatrixD1)this.tempWrenchConstraint_f);
        this.hasWrenchesEquilibriumConstraintBeenSetup = true;
    }

    public DMatrixRMaj getMomentumRate() {
        return this.solverOutput_momentumRate;
    }

    public DMatrixRMaj getRhos() {
        return this.solverOutput_rhos;
    }

    public void setMinRho(double rhoMin) {
        for (int i = 6; i < this.problemSize; ++i) {
            this.solverInput_lb.set(i, 0, rhoMin);
        }
    }

    public void setMinRho(DMatrixRMaj rhoMin) {
        CommonOps_DDRM.insert((DMatrix)rhoMin, (DMatrix)this.solverInput_lb, (int)6, (int)0);
    }

    public void setMaxRho(double rhoMax) {
        for (int i = 6; i < this.problemSize; ++i) {
            this.solverInput_ub.set(i, 0, rhoMax);
        }
    }

    public void setMaxRho(DMatrixRMaj rhoMax) {
        CommonOps_DDRM.insert((DMatrix)rhoMax, (DMatrix)this.solverInput_ub, (int)6, (int)0);
    }

    public void setActiveRhos(DMatrixRMaj activeRhoMatrix) {
        CommonOps_DDRM.insert((DMatrix)activeRhoMatrix, (DMatrix)this.solverInput_activeIndices, (int)6, (int)0);
    }
}

