/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.momentumBasedController.optimization;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.matrixlib.MatrixTools;
import us.ihmc.robotics.screwTheory.SelectionMatrix3D;
import us.ihmc.robotics.screwTheory.SelectionMatrix6D;
import us.ihmc.robotics.weightMatrices.WeightMatrix3D;
import us.ihmc.robotics.weightMatrices.WeightMatrix6D;

public class SelectionCalculator {
    private final RigidBodyTransform tempTransform = new RigidBodyTransform();
    private final DMatrixRMaj tempRotationMatrix = new DMatrixRMaj(3, 3);
    private final DMatrixRMaj tempRotationMatrixWithSelection = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj tempTaskWeight = new DMatrixRMaj(3, 3);
    private final DMatrixRMaj denseSelectionMatrix = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj taskJacobian3D = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj taskObjective3D = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj taskJacobianSelected3D = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj taskObjectiveSelected3D = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj taskWeightSelected3D = new DMatrixRMaj(1, 1);

    public int applySelectionToTask(SelectionMatrix3D selectionMatrix, WeightMatrix3D weightMatrix, ReferenceFrame taskFrame, DMatrixRMaj taskJacobian, DMatrixRMaj taskObjective, DMatrixRMaj taskJacobianToPack, DMatrixRMaj taskObjectiveToPack, DMatrixRMaj taskWeightToPack) {
        boolean selectedAll;
        boolean selectedNone;
        int problemSize = taskJacobian.getNumCols();
        int taskSize = 3;
        SelectionCalculator.checkMatrixSizes(taskJacobian, taskObjective, taskSize);
        int reducedTaskSize = selectionMatrix.getNumberOfSelectedAxes();
        boolean bl = selectedNone = reducedTaskSize == 0;
        if (selectedNone) {
            taskJacobianToPack.reshape(0, problemSize);
            taskObjectiveToPack.reshape(0, 1);
            taskWeightToPack.reshape(0, 0);
            return 0;
        }
        this.denseSelectionMatrix.reshape(3, 3);
        CommonOps_DDRM.setIdentity((DMatrix1Row)this.denseSelectionMatrix);
        for (int axis = taskSize - 1; axis >= 0; --axis) {
            if (selectionMatrix.isAxisSelected(axis)) continue;
            MatrixTools.removeRow((DMatrix1Row)this.denseSelectionMatrix, (int)axis);
        }
        ReferenceFrame selectionFrame = selectionMatrix.getSelectionFrame();
        boolean bl2 = selectedAll = reducedTaskSize == 3;
        if (selectedAll || selectionFrame == null) {
            selectionFrame = taskFrame;
        }
        if (selectionFrame != taskFrame) {
            taskFrame.getTransformToDesiredFrame(this.tempTransform, selectionFrame);
            this.tempTransform.getRotation().get((DMatrix)this.tempRotationMatrix);
            this.tempRotationMatrixWithSelection.reshape(reducedTaskSize, 3);
            CommonOps_DDRM.mult((DMatrix1Row)this.denseSelectionMatrix, (DMatrix1Row)this.tempRotationMatrix, (DMatrix1Row)this.tempRotationMatrixWithSelection);
            taskJacobianToPack.reshape(reducedTaskSize, problemSize);
            taskObjectiveToPack.reshape(reducedTaskSize, 1);
            CommonOps_DDRM.mult((DMatrix1Row)this.tempRotationMatrixWithSelection, (DMatrix1Row)taskJacobian, (DMatrix1Row)taskJacobianToPack);
            CommonOps_DDRM.mult((DMatrix1Row)this.tempRotationMatrixWithSelection, (DMatrix1Row)taskObjective, (DMatrix1Row)taskObjectiveToPack);
        } else {
            taskJacobianToPack.set((DMatrixD1)taskJacobian);
            taskObjectiveToPack.set((DMatrixD1)taskObjective);
        }
        ReferenceFrame weightFrame = weightMatrix.getWeightFrame();
        if (weightFrame == null) {
            weightFrame = taskFrame;
        }
        taskWeightToPack.reshape(taskSize, taskSize);
        CommonOps_DDRM.fill((DMatrixD1)taskWeightToPack, (double)0.0);
        taskWeightToPack.set(0, 0, weightMatrix.getXAxisWeight());
        taskWeightToPack.set(1, 1, weightMatrix.getYAxisWeight());
        taskWeightToPack.set(2, 2, weightMatrix.getZAxisWeight());
        if (weightFrame != selectionFrame) {
            weightFrame.getTransformToDesiredFrame(this.tempTransform, selectionFrame);
            this.tempTransform.getRotation().get((DMatrix)this.tempRotationMatrix);
            this.tempRotationMatrixWithSelection.reshape(reducedTaskSize, 3);
            CommonOps_DDRM.mult((DMatrix1Row)this.denseSelectionMatrix, (DMatrix1Row)this.tempRotationMatrix, (DMatrix1Row)this.tempRotationMatrixWithSelection);
            this.tempTaskWeight.reshape(reducedTaskSize, 3);
            CommonOps_DDRM.mult((DMatrix1Row)this.tempRotationMatrixWithSelection, (DMatrix1Row)taskWeightToPack, (DMatrix1Row)this.tempTaskWeight);
            taskWeightToPack.reshape(reducedTaskSize, reducedTaskSize);
            CommonOps_DDRM.multTransB((DMatrix1Row)this.tempTaskWeight, (DMatrix1Row)this.tempRotationMatrixWithSelection, (DMatrix1Row)taskWeightToPack);
        } else {
            for (int axis = taskSize - 1; axis >= 0; --axis) {
                if (selectionMatrix.isAxisSelected(axis)) continue;
                MatrixTools.removeRow((DMatrix1Row)taskWeightToPack, (int)axis);
                MatrixTools.removeColumn((DMatrix1Row)taskWeightToPack, (int)axis);
            }
        }
        SelectionCalculator.checkResult(taskJacobianToPack, taskObjectiveToPack, taskWeightToPack);
        return reducedTaskSize;
    }

    public int applySelectionToTask(SelectionMatrix6D selectionMatrix, WeightMatrix6D weightMatrix, ReferenceFrame taskFrame, DMatrixRMaj taskJacobian, DMatrixRMaj taskObjective, DMatrixRMaj taskJacobianToPack, DMatrixRMaj taskObjectiveToPack, DMatrixRMaj taskWeightToPack) {
        int problemSize = taskJacobian.getNumCols();
        int taskSize = 6;
        SelectionCalculator.checkMatrixSizes(taskJacobian, taskObjective, taskSize);
        int reducedTaskSize = selectionMatrix.getNumberOfSelectedAxes();
        this.taskJacobian3D.reshape(3, problemSize);
        this.taskObjective3D.reshape(3, 1);
        taskJacobianToPack.reshape(reducedTaskSize, problemSize);
        taskObjectiveToPack.reshape(reducedTaskSize, 1);
        taskWeightToPack.reshape(reducedTaskSize, reducedTaskSize);
        CommonOps_DDRM.extract((DMatrix)taskJacobian, (int)0, (int)3, (int)0, (int)problemSize, (DMatrix)this.taskJacobian3D, (int)0, (int)0);
        CommonOps_DDRM.extract((DMatrix)taskObjective, (int)0, (int)3, (int)0, (int)1, (DMatrix)this.taskObjective3D, (int)0, (int)0);
        int offset = this.applySelectionToTask(selectionMatrix.getAngularPart(), weightMatrix.getAngularPart(), taskFrame, this.taskJacobian3D, this.taskObjective3D, this.taskJacobianSelected3D, this.taskObjectiveSelected3D, this.taskWeightSelected3D);
        CommonOps_DDRM.insert((DMatrix)this.taskJacobianSelected3D, (DMatrix)taskJacobianToPack, (int)0, (int)0);
        CommonOps_DDRM.insert((DMatrix)this.taskObjectiveSelected3D, (DMatrix)taskObjectiveToPack, (int)0, (int)0);
        CommonOps_DDRM.insert((DMatrix)this.taskWeightSelected3D, (DMatrix)taskWeightToPack, (int)0, (int)0);
        CommonOps_DDRM.extract((DMatrix)taskJacobian, (int)3, (int)6, (int)0, (int)problemSize, (DMatrix)this.taskJacobian3D, (int)0, (int)0);
        CommonOps_DDRM.extract((DMatrix)taskObjective, (int)3, (int)6, (int)0, (int)1, (DMatrix)this.taskObjective3D, (int)0, (int)0);
        this.applySelectionToTask(selectionMatrix.getLinearPart(), weightMatrix.getLinearPart(), taskFrame, this.taskJacobian3D, this.taskObjective3D, this.taskJacobianSelected3D, this.taskObjectiveSelected3D, this.taskWeightSelected3D);
        CommonOps_DDRM.insert((DMatrix)this.taskJacobianSelected3D, (DMatrix)taskJacobianToPack, (int)offset, (int)0);
        CommonOps_DDRM.insert((DMatrix)this.taskObjectiveSelected3D, (DMatrix)taskObjectiveToPack, (int)offset, (int)0);
        CommonOps_DDRM.insert((DMatrix)this.taskWeightSelected3D, (DMatrix)taskWeightToPack, (int)offset, (int)offset);
        return reducedTaskSize;
    }

    private static void checkResult(DMatrixRMaj taskJacobian, DMatrixRMaj taskObjective, DMatrixRMaj taskWeight) {
        if (MatrixTools.containsNaN((DMatrix1Row)taskJacobian)) {
            throw new RuntimeException("The task jacobian contained NaN.");
        }
        if (MatrixTools.containsNaN((DMatrix1Row)taskObjective)) {
            throw new RuntimeException("The task objective contained NaN.");
        }
        if (MatrixTools.containsNaN((DMatrix1Row)taskWeight)) {
            throw new RuntimeException("The task weight contained NaN.");
        }
    }

    private static void checkMatrixSizes(DMatrixRMaj taskJacobian, DMatrixRMaj taskObjective, int taskSize) {
        if (taskJacobian.getNumRows() != taskSize || taskObjective.getNumRows() != taskSize || taskObjective.getNumCols() != 1) {
            throw new RuntimeException("Unexpected size of task matrices.");
        }
    }
}

