/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.momentumBasedController.optimization;

import gnu.trove.list.array.TIntArrayList;
import java.util.Arrays;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.matrixlib.MatrixTools;

public class QPVariableSubstitution {
    public int numberOfVariablesToSubstitute;
    public int[] variableIndices = new int[4];
    public TIntArrayList activeIndices = new TIntArrayList(4, -1);
    private TIntArrayList inactiveIndices = new TIntArrayList(4, -1);
    public final DMatrixRMaj transformation = new DMatrixRMaj(4, 1);
    public final DMatrixRMaj bias = new DMatrixRMaj(4, 1);
    private boolean ignoreBias = false;
    private final DMatrixRMaj tempA = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj tempB = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj tempC = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj tempD = new DMatrixRMaj(1, 1);
    private final DMatrixRMaj tempE = new DMatrixRMaj(1, 1);

    public QPVariableSubstitution() {
        this.reset();
    }

    public void reset() {
        this.numberOfVariablesToSubstitute = 0;
        this.activeIndices.reset();
        this.inactiveIndices.reset();
        this.transformation.reshape(0, 0);
        this.bias.reshape(0, 0);
    }

    public void reshape(int numberOfVariablesToSubstitute, int numberOfVariablesPostSubstitution) {
        this.numberOfVariablesToSubstitute = numberOfVariablesToSubstitute;
        if (this.variableIndices.length < numberOfVariablesToSubstitute) {
            this.variableIndices = new int[numberOfVariablesToSubstitute];
        }
        this.activeIndices.reset();
        this.transformation.reshape(numberOfVariablesToSubstitute, numberOfVariablesPostSubstitution);
        this.bias.reshape(numberOfVariablesPostSubstitution, 1);
    }

    public void setIgnoreBias(boolean ignoreBias) {
        this.ignoreBias = ignoreBias;
    }

    public void concatenate(QPVariableSubstitution other) {
        int i;
        int oldSizeX = this.numberOfVariablesToSubstitute;
        int oldSizeY = this.transformation.getNumCols();
        int newSizeX = oldSizeX + other.numberOfVariablesToSubstitute;
        int newSizeY = oldSizeY + other.transformation.getNumCols();
        if (this.variableIndices.length < newSizeX) {
            this.variableIndices = Arrays.copyOf(this.variableIndices, newSizeX);
        }
        for (i = 0; i < other.numberOfVariablesToSubstitute; ++i) {
            this.variableIndices[i + oldSizeX] = other.variableIndices[i];
        }
        for (i = 0; i < other.activeIndices.size(); ++i) {
            this.activeIndices.add(other.activeIndices.get(i) + oldSizeX);
        }
        this.tempA.set((DMatrixD1)this.transformation);
        this.transformation.reshape(newSizeX, newSizeY);
        this.transformation.zero();
        CommonOps_DDRM.insert((DMatrix)this.tempA, (DMatrix)this.transformation, (int)0, (int)0);
        CommonOps_DDRM.insert((DMatrix)other.transformation, (DMatrix)this.transformation, (int)oldSizeX, (int)oldSizeY);
        if (!this.ignoreBias) {
            this.bias.reshape(newSizeX, 1);
            CommonOps_DDRM.insert((DMatrix)other.bias, (DMatrix)this.bias, (int)oldSizeX, (int)0);
        }
        this.numberOfVariablesToSubstitute = newSizeX;
    }

    public boolean isEmpty() {
        return this.numberOfVariablesToSubstitute == 0;
    }

    public TIntArrayList getInactiveIndices() {
        int numberOfInactiveIndices = this.transformation.getNumRows() - this.transformation.getNumCols();
        this.inactiveIndices.reset();
        for (int i = 0; i < numberOfInactiveIndices; ++i) {
            this.inactiveIndices.add(this.variableIndices[this.transformation.getNumCols() + i]);
        }
        return this.inactiveIndices;
    }

    public void applySubstitutionToObjectiveFunction(DMatrixRMaj H, DMatrixRMaj f) {
        DMatrixRMaj G = this.transformation;
        DMatrixRMaj g = this.bias;
        DMatrixRMaj sub_H = this.tempA;
        DMatrixRMaj sub_f = this.tempB;
        DMatrixRMaj GTH = this.tempC;
        sub_H.reshape(this.variableIndices.length, H.getNumCols());
        MatrixTools.extractRows((DMatrix1Row)H, (int[])this.variableIndices, (DMatrix1Row)sub_H, (int)0);
        GTH.reshape(G.getNumCols(), H.getNumCols());
        CommonOps_DDRM.multTransA((DMatrix1Row)G, (DMatrix1Row)sub_H, (DMatrix1Row)GTH);
        for (int i = 0; i < this.variableIndices.length; ++i) {
            int rowH = this.variableIndices[i];
            if (i < GTH.getNumRows()) {
                CommonOps_DDRM.extract((DMatrix)GTH, (int)i, (int)(i + 1), (int)0, (int)H.getNumCols(), (DMatrix)H, (int)rowH, (int)0);
                continue;
            }
            MatrixTools.zeroRow((int)rowH, (DMatrix1Row)H);
        }
        DMatrixRMaj GTf = this.tempD;
        sub_f.reshape(G.getNumRows(), 1);
        CommonOps_DDRM.extract((DMatrixRMaj)f, (int[])this.variableIndices, (int)this.variableIndices.length, (DMatrixRMaj)sub_f);
        GTf.reshape(G.getNumCols(), 1);
        CommonOps_DDRM.multTransA((DMatrix1Row)G, (DMatrix1Row)sub_f, (DMatrix1Row)GTf);
        if (this.ignoreBias) {
            sub_f.set((DMatrixD1)GTf);
        } else {
            DMatrixRMaj sub_GTH = this.tempE;
            sub_GTH.reshape(G.getNumCols(), this.variableIndices.length);
            MatrixTools.extractColumns((DMatrix1Row)GTH, (int[])this.variableIndices, (DMatrix1Row)sub_GTH, (int)0);
            sub_f.reshape(G.getNumCols(), 1);
            CommonOps_DDRM.mult((DMatrix1Row)sub_GTH, (DMatrix1Row)g, (DMatrix1Row)sub_f);
            CommonOps_DDRM.addEquals((DMatrixD1)sub_f, (DMatrixD1)GTf);
        }
        for (int i = 0; i < this.variableIndices.length; ++i) {
            int row_f = this.variableIndices[i];
            if (i < sub_f.getNumRows()) {
                f.set(row_f, sub_f.get(i));
                continue;
            }
            f.set(row_f, 0.0);
        }
        DMatrixRMaj HG = this.tempC;
        sub_H.reshape(H.getNumRows(), this.variableIndices.length);
        MatrixTools.extractColumns((DMatrix1Row)H, (int[])this.variableIndices, (DMatrix1Row)sub_H, (int)0);
        HG.reshape(H.getNumRows(), G.getNumCols());
        CommonOps_DDRM.mult((DMatrix1Row)sub_H, (DMatrix1Row)G, (DMatrix1Row)HG);
        for (int i = 0; i < this.variableIndices.length; ++i) {
            int colH = this.variableIndices[i];
            if (i < HG.getNumCols()) {
                CommonOps_DDRM.extract((DMatrix)HG, (int)0, (int)H.getNumRows(), (int)i, (int)(i + 1), (DMatrix)H, (int)0, (int)colH);
                continue;
            }
            MatrixTools.zeroRow((int)colH, (DMatrix1Row)H);
        }
    }

    public void applySubstitutionToLinearConstraint(DMatrixRMaj A, DMatrixRMaj b) {
        if (A.getNumRows() == 0) {
            return;
        }
        DMatrixRMaj G = this.transformation;
        DMatrixRMaj g = this.bias;
        DMatrixRMaj sub_A = this.tempA;
        DMatrixRMaj AG = this.tempC;
        sub_A.reshape(A.getNumRows(), this.variableIndices.length);
        MatrixTools.extractColumns((DMatrix1Row)A, (int[])this.variableIndices, (DMatrix1Row)sub_A, (int)0);
        AG.reshape(A.getNumRows(), G.getNumCols());
        CommonOps_DDRM.mult((DMatrix1Row)sub_A, (DMatrix1Row)G, (DMatrix1Row)AG);
        for (int i = 0; i < this.variableIndices.length; ++i) {
            int colA = this.variableIndices[i];
            if (i < AG.getNumCols()) {
                CommonOps_DDRM.extract((DMatrix)AG, (int)0, (int)A.getNumRows(), (int)i, (int)(i + 1), (DMatrix)A, (int)0, (int)colA);
                continue;
            }
            MatrixTools.zeroRow((int)colA, (DMatrix1Row)A);
        }
        if (!this.ignoreBias) {
            DMatrixRMaj Ag = this.tempB;
            Ag.reshape(g.getNumRows(), 1);
            CommonOps_DDRM.mult((DMatrix1Row)sub_A, (DMatrix1Row)g, (DMatrix1Row)Ag);
            for (int i = 0; i < this.variableIndices.length; ++i) {
                int row_b = this.variableIndices[i];
                b.set(row_b, b.get(row_b) - Ag.get(i));
            }
        }
    }

    public void applySubstitutionToBounds(DMatrixRMaj xMin, DMatrixRMaj xMax, DMatrixRMaj Ain, DMatrixRMaj bin) {
        int i;
        boolean areBoundsSet = false;
        for (int i2 = 0; i2 < this.activeIndices.size(); ++i2) {
            int variableIndex = this.variableIndices[this.activeIndices.get(i2)];
            if (!Double.isFinite(xMin.get(variableIndex)) && !Double.isFinite(xMax.get(variableIndex))) continue;
            areBoundsSet = true;
            break;
        }
        if (!areBoundsSet) {
            return;
        }
        DMatrixRMaj G = this.transformation;
        DMatrixRMaj g = this.bias;
        int offset_min = Ain.getNumRows();
        int offset_max = offset_min + this.activeIndices.size();
        Ain.reshape(Ain.getNumRows() + 2 * this.activeIndices.size(), Ain.getNumCols(), true);
        bin.reshape(bin.getNumRows() + 2 * this.activeIndices.size(), 1, true);
        for (i = 0; i < this.activeIndices.size(); ++i) {
            int rowAmin = i + offset_min;
            int rowAmax = i + offset_max;
            MatrixTools.zeroRow((int)rowAmin, (DMatrix1Row)Ain);
            MatrixTools.zeroRow((int)rowAmax, (DMatrix1Row)Ain);
            int rowG = this.activeIndices.get(i);
            for (int colG = 0; colG < G.getNumCols(); ++colG) {
                int colA = this.variableIndices[colG];
                Ain.unsafe_set(rowAmin, colA, -G.unsafe_get(rowG, colG));
                Ain.unsafe_set(rowAmax, colA, G.unsafe_get(rowG, colG));
            }
        }
        for (i = 0; i < this.activeIndices.size(); ++i) {
            int row_g = this.activeIndices.get(i);
            int row_x = this.variableIndices[row_g];
            int row_b_min = i + offset_min;
            int row_b_max = i + offset_max;
            if (this.ignoreBias) {
                bin.set(row_b_min, -xMin.get(row_x));
                bin.set(row_b_max, xMax.get(row_x));
                continue;
            }
            bin.set(row_b_min, -(xMin.get(row_x) - g.get(row_g)));
            bin.set(row_b_max, xMax.get(row_x) - g.get(row_g));
        }
        for (int variableIndex : this.variableIndices) {
            xMin.set(variableIndex, Double.NEGATIVE_INFINITY);
            xMax.set(variableIndex, Double.POSITIVE_INFINITY);
        }
    }

    public void removeSubstitutionToSolution(DMatrixRMaj x) {
        int i;
        DMatrixRMaj G = this.transformation;
        DMatrixRMaj g = this.bias;
        DMatrixRMaj sub_y = this.tempA;
        DMatrixRMaj sub_x = this.tempB;
        sub_y.reshape(G.getNumCols(), 1);
        sub_x.reshape(G.getNumRows(), 1);
        for (i = 0; i < G.getNumCols(); ++i) {
            sub_y.set(i, x.get(this.variableIndices[i]));
        }
        CommonOps_DDRM.mult((DMatrix1Row)G, (DMatrix1Row)sub_y, (DMatrix1Row)sub_x);
        if (!this.ignoreBias) {
            CommonOps_DDRM.addEquals((DMatrixD1)sub_x, (DMatrixD1)g);
        }
        for (i = 0; i < sub_x.getNumRows(); ++i) {
            x.set(this.variableIndices[i], sub_x.get(i));
        }
    }
}

