/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.momentumBasedController.optimization;

import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.PrivilegedConfigurationCommand;
import us.ihmc.euclid.interfaces.Settable;

public class OneDoFJointPrivilegedConfigurationParameters
implements Settable<OneDoFJointPrivilegedConfigurationParameters> {
    private double privilegedConfiguration;
    private PrivilegedConfigurationCommand.PrivilegedConfigurationOption privilegedConfigurationOption;
    private double weight;
    private double configurationGain;
    private double velocityGain;
    private double maxVelocity;
    private double maxAcceleration;

    public OneDoFJointPrivilegedConfigurationParameters() {
        this.clear();
    }

    public void clear() {
        this.privilegedConfiguration = Double.NaN;
        this.privilegedConfigurationOption = null;
        this.weight = Double.NaN;
        this.configurationGain = Double.NaN;
        this.velocityGain = Double.NaN;
        this.maxVelocity = Double.NaN;
        this.maxAcceleration = Double.NaN;
    }

    public void set(OneDoFJointPrivilegedConfigurationParameters other) {
        this.privilegedConfiguration = other.privilegedConfiguration;
        this.privilegedConfigurationOption = other.privilegedConfigurationOption;
        this.weight = other.weight;
        this.configurationGain = other.configurationGain;
        this.velocityGain = other.velocityGain;
        this.maxVelocity = other.maxVelocity;
        this.maxAcceleration = other.maxAcceleration;
    }

    public void setPrivilegedConfiguration(double privilegedConfiguration) {
        this.privilegedConfiguration = privilegedConfiguration;
    }

    public void setPrivilegedConfigurationOption(PrivilegedConfigurationCommand.PrivilegedConfigurationOption privilegedConfigurationOption) {
        this.privilegedConfigurationOption = privilegedConfigurationOption;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public void setConfigurationGain(double configurationGain) {
        this.configurationGain = configurationGain;
    }

    public void setVelocityGain(double velocityGain) {
        this.velocityGain = velocityGain;
    }

    public void setMaxVelocity(double maxVelocity) {
        this.maxVelocity = maxVelocity;
    }

    public void setMaxAcceleration(double maxAcceleration) {
        this.maxAcceleration = maxAcceleration;
    }

    public boolean hasPrivilegedConfiguration() {
        return !Double.isNaN(this.privilegedConfiguration);
    }

    public boolean hasPrivilegedConfigurationOption() {
        return this.privilegedConfigurationOption != null;
    }

    public boolean hasWeight() {
        return !Double.isNaN(this.weight);
    }

    public boolean hasConfigurationGain() {
        return !Double.isNaN(this.configurationGain);
    }

    public boolean hasVelocityGain() {
        return !Double.isNaN(this.velocityGain);
    }

    public boolean hasMaxVelocity() {
        return !Double.isNaN(this.maxVelocity);
    }

    public boolean hasMaxAcceleration() {
        return !Double.isNaN(this.maxAcceleration);
    }

    public double getPrivilegedConfiguration() {
        return this.privilegedConfiguration;
    }

    public PrivilegedConfigurationCommand.PrivilegedConfigurationOption getPrivilegedConfigurationOption() {
        return this.privilegedConfigurationOption;
    }

    public double getWeight() {
        return this.weight;
    }

    public double getConfigurationGain() {
        return this.configurationGain;
    }

    public double getVelocityGain() {
        return this.velocityGain;
    }

    public double getMaxVelocity() {
        return this.maxVelocity;
    }

    public double getMaxAcceleration() {
        return this.maxAcceleration;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof OneDoFJointPrivilegedConfigurationParameters) {
            OneDoFJointPrivilegedConfigurationParameters other = (OneDoFJointPrivilegedConfigurationParameters)object;
            if (Double.compare(this.privilegedConfiguration, other.privilegedConfiguration) != 0) {
                return false;
            }
            if (this.privilegedConfigurationOption != other.privilegedConfigurationOption) {
                return false;
            }
            if (Double.compare(this.weight, other.weight) != 0) {
                return false;
            }
            if (Double.compare(this.configurationGain, other.configurationGain) != 0) {
                return false;
            }
            if (Double.compare(this.velocityGain, other.velocityGain) != 0) {
                return false;
            }
            if (Double.compare(this.maxVelocity, other.maxVelocity) != 0) {
                return false;
            }
            return Double.compare(this.maxAcceleration, other.maxAcceleration) == 0;
        }
        return false;
    }

    public String toString() {
        String ret = this.getClass().getSimpleName() + ":";
        if (this.hasPrivilegedConfiguration()) {
            ret = ret + " q_priv: " + this.privilegedConfiguration;
        }
        if (this.hasPrivilegedConfigurationOption()) {
            ret = ret + " q_priv option: " + (Object)((Object)this.privilegedConfigurationOption);
        }
        if (this.hasWeight()) {
            ret = ret + " weight: " + this.weight;
        }
        if (this.hasConfigurationGain()) {
            ret = ret + " configuration gain: " + this.configurationGain;
        }
        if (this.hasVelocityGain()) {
            ret = ret + " velocity gain: " + this.velocityGain;
        }
        if (this.hasMaxVelocity()) {
            ret = ret + " max velocity: " + this.maxVelocity;
        }
        if (this.hasMaxAcceleration()) {
            ret = ret + " max acceleration: " + this.maxAcceleration;
        }
        return ret;
    }
}

