/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.momentumBasedController.optimization;

import gnu.trove.list.array.TIntArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.matrixlib.NativeMatrix;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.robotics.screwTheory.ScrewTools;

public class JointIndexHandler {
    private final TIntArrayList indicesIntoCompactBlock = new TIntArrayList();
    private final LinkedHashMap<JointReadOnly, int[]> columnsForJoints = new LinkedHashMap();
    private final int numberOfDoFs;
    private final JointBasics[] indexedJoints;
    private final OneDoFJointBasics[] indexedOneDoFJoints;

    public JointIndexHandler(JointBasics[] jointsToIndex) {
        this.indexedJoints = jointsToIndex;
        this.indexedOneDoFJoints = (OneDoFJointBasics[])MultiBodySystemTools.filterJoints((JointReadOnly[])this.indexedJoints, OneDoFJointBasics.class);
        this.numberOfDoFs = MultiBodySystemTools.computeDegreesOfFreedom((JointReadOnly[])jointsToIndex);
        this.populateColumnIndices();
    }

    public JointIndexHandler(List<? extends JointBasics> jointsToIndex) {
        this.indexedJoints = new JointBasics[jointsToIndex.size()];
        jointsToIndex.toArray(this.indexedJoints);
        this.indexedOneDoFJoints = (OneDoFJointBasics[])MultiBodySystemTools.filterJoints((JointReadOnly[])this.indexedJoints, OneDoFJointBasics.class);
        this.numberOfDoFs = MultiBodySystemTools.computeDegreesOfFreedom(jointsToIndex);
        this.populateColumnIndices();
    }

    private void populateColumnIndices() {
        for (JointBasics joint : this.indexedJoints) {
            TIntArrayList listToPackIndices = new TIntArrayList();
            ScrewTools.computeIndexForJoint((JointReadOnly[])this.indexedJoints, (TIntArrayList)listToPackIndices, (JointReadOnly)joint);
            int[] indices = listToPackIndices.toArray();
            this.columnsForJoints.put((JointReadOnly)joint, indices);
        }
    }

    public boolean compactBlockToFullBlock(JointReadOnly[] joints, DMatrixRMaj compactMatrix, DMatrixRMaj fullMatrix) {
        fullMatrix.zero();
        for (JointReadOnly joint : joints) {
            this.indicesIntoCompactBlock.reset();
            ScrewTools.computeIndexForJoint((JointReadOnly[])joints, (TIntArrayList)this.indicesIntoCompactBlock, (JointReadOnly)joint);
            int[] indicesIntoFullBlock = this.columnsForJoints.get(joint);
            if (indicesIntoFullBlock == null) {
                return false;
            }
            for (int i = 0; i < this.indicesIntoCompactBlock.size(); ++i) {
                int compactBlockIndex = this.indicesIntoCompactBlock.get(i);
                int fullBlockIndex = indicesIntoFullBlock[i];
                CommonOps_DDRM.extract((DMatrix)compactMatrix, (int)0, (int)compactMatrix.getNumRows(), (int)compactBlockIndex, (int)(compactBlockIndex + 1), (DMatrix)fullMatrix, (int)0, (int)fullBlockIndex);
            }
        }
        return true;
    }

    public boolean compactBlockToFullBlock(JointReadOnly[] joints, DMatrixRMaj compactMatrix, NativeMatrix fullMatrix) {
        fullMatrix.zero();
        for (JointReadOnly joint : joints) {
            this.indicesIntoCompactBlock.reset();
            ScrewTools.computeIndexForJoint((JointReadOnly[])joints, (TIntArrayList)this.indicesIntoCompactBlock, (JointReadOnly)joint);
            int[] indicesIntoFullBlock = this.columnsForJoints.get(joint);
            if (indicesIntoFullBlock == null) {
                return false;
            }
            for (int i = 0; i < this.indicesIntoCompactBlock.size(); ++i) {
                int compactBlockIndex = this.indicesIntoCompactBlock.get(i);
                int fullBlockIndex = indicesIntoFullBlock[i];
                fullMatrix.insert(compactMatrix, 0, compactMatrix.getNumRows(), compactBlockIndex, compactBlockIndex + 1, 0, fullBlockIndex);
            }
        }
        return true;
    }

    public boolean compactBlockToFullBlock(List<? extends JointReadOnly> joints, DMatrixRMaj compactMatrix, DMatrixRMaj fullMatrix) {
        fullMatrix.zero();
        for (int index = 0; index < joints.size(); ++index) {
            JointReadOnly joint = joints.get(index);
            this.indicesIntoCompactBlock.reset();
            ScrewTools.computeIndexForJoint(joints, (TIntArrayList)this.indicesIntoCompactBlock, (JointReadOnly)joint);
            int[] indicesIntoFullBlock = this.columnsForJoints.get(joint);
            if (indicesIntoFullBlock == null) {
                return false;
            }
            for (int i = 0; i < this.indicesIntoCompactBlock.size(); ++i) {
                int compactBlockIndex = this.indicesIntoCompactBlock.get(i);
                int fullBlockIndex = indicesIntoFullBlock[i];
                CommonOps_DDRM.extract((DMatrix)compactMatrix, (int)0, (int)compactMatrix.getNumRows(), (int)compactBlockIndex, (int)(compactBlockIndex + 1), (DMatrix)fullMatrix, (int)0, (int)fullBlockIndex);
            }
        }
        return true;
    }

    public void compactBlockToFullBlockIgnoreUnindexedJoints(List<? extends JointReadOnly> joints, DMatrixRMaj compactMatrix, DMatrixRMaj fullMatrix) {
        fullMatrix.reshape(compactMatrix.getNumRows(), fullMatrix.getNumCols());
        fullMatrix.zero();
        for (int index = 0; index < joints.size(); ++index) {
            JointReadOnly joint = joints.get(index);
            this.indicesIntoCompactBlock.reset();
            ScrewTools.computeIndexForJoint(joints, (TIntArrayList)this.indicesIntoCompactBlock, (JointReadOnly)joint);
            int[] indicesIntoFullBlock = this.columnsForJoints.get(joint);
            if (indicesIntoFullBlock == null) continue;
            for (int i = 0; i < this.indicesIntoCompactBlock.size(); ++i) {
                int compactBlockIndex = this.indicesIntoCompactBlock.get(i);
                int fullBlockIndex = indicesIntoFullBlock[i];
                CommonOps_DDRM.extract((DMatrix)compactMatrix, (int)0, (int)compactMatrix.getNumRows(), (int)compactBlockIndex, (int)(compactBlockIndex + 1), (DMatrix)fullMatrix, (int)0, (int)fullBlockIndex);
            }
        }
    }

    public void compactBlockToFullBlockIgnoreUnindexedJoints(JointBasics[] joints, DMatrixRMaj compactMatrix, DMatrixRMaj fullMatrix) {
        fullMatrix.reshape(compactMatrix.getNumRows(), fullMatrix.getNumCols());
        fullMatrix.zero();
        for (int index = 0; index < joints.length; ++index) {
            JointBasics joint = joints[index];
            this.indicesIntoCompactBlock.reset();
            ScrewTools.computeIndexForJoint((JointReadOnly[])joints, (TIntArrayList)this.indicesIntoCompactBlock, (JointReadOnly)joint);
            int[] indicesIntoFullBlock = this.columnsForJoints.get(joint);
            if (indicesIntoFullBlock == null) continue;
            for (int i = 0; i < this.indicesIntoCompactBlock.size(); ++i) {
                int compactBlockIndex = this.indicesIntoCompactBlock.get(i);
                int fullBlockIndex = indicesIntoFullBlock[i];
                CommonOps_DDRM.extract((DMatrix)compactMatrix, (int)0, (int)compactMatrix.getNumRows(), (int)compactBlockIndex, (int)(compactBlockIndex + 1), (DMatrix)fullMatrix, (int)0, (int)fullBlockIndex);
            }
        }
    }

    public JointBasics[] getIndexedJoints() {
        return this.indexedJoints;
    }

    public OneDoFJointBasics[] getIndexedOneDoFJoints() {
        return this.indexedOneDoFJoints;
    }

    public boolean isJointIndexed(JointBasics joint) {
        return this.columnsForJoints.containsKey(joint);
    }

    public boolean areJointsIndexed(JointBasics[] joints) {
        for (int i = 0; i < joints.length; ++i) {
            if (this.isJointIndexed(joints[i])) continue;
            return false;
        }
        return true;
    }

    public int getOneDoFJointIndex(OneDoFJointReadOnly joint) {
        int[] jointIndices = this.columnsForJoints.get(joint);
        if (jointIndices == null) {
            return -1;
        }
        return jointIndices[0];
    }

    public int[] getJointIndices(JointReadOnly joint) {
        return this.columnsForJoints.get(joint);
    }

    public int getNumberOfDoFs() {
        return this.numberOfDoFs;
    }
}

