/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.momentumBasedController.optimization;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.SpatialForce;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.robotics.contactable.ContactablePlaneBody;

public class ExternalWrenchHandler {
    private final SpatialForce gravitationalWrench;
    private final DMatrixRMaj gravitationalWrenchMatrix = new DMatrixRMaj(6, 1);
    private final DMatrixRMaj wrenchEquationRightHandSide = new DMatrixRMaj(6, 1);
    private final Map<RigidBodyBasics, Wrench> externalWrenchesToCompensateFor = new LinkedHashMap<RigidBodyBasics, Wrench>();
    private final List<Wrench> externalWrenchesToCompensateForList = new ArrayList<Wrench>();
    private final SpatialForce totalWrenchAlreadyApplied;
    private final DMatrixRMaj totalWrenchAlreadyAppliedMatrix = new DMatrixRMaj(6, 1);
    private final List<? extends ContactablePlaneBody> contactablePlaneBodies;
    private final List<RigidBodyBasics> rigidBodiesWithWrenchToCompensateFor = new ArrayList<RigidBodyBasics>();
    private final List<RigidBodyBasics> rigidBodiesWithExternalWrench = new ArrayList<RigidBodyBasics>();
    private final Map<RigidBodyBasics, Wrench> externalWrenches = new LinkedHashMap<RigidBodyBasics, Wrench>();
    private final SpatialForce tempWrench = new SpatialForce();
    private final ReferenceFrame centerOfMassFrame;

    public ExternalWrenchHandler(double gravityZ, ReferenceFrame centerOfMassFrame, double robotTotalMass, List<? extends ContactablePlaneBody> contactablePlaneBodies) {
        this.centerOfMassFrame = centerOfMassFrame;
        MathTools.checkIntervalContains((double)gravityZ, (double)0.0, (double)Double.POSITIVE_INFINITY);
        this.contactablePlaneBodies = new ArrayList<ContactablePlaneBody>(contactablePlaneBodies);
        this.gravitationalWrench = new SpatialForce(centerOfMassFrame);
        this.gravitationalWrench.setLinearPartZ(-gravityZ * robotTotalMass);
        this.totalWrenchAlreadyApplied = new SpatialForce(centerOfMassFrame);
        for (int i = 0; i < contactablePlaneBodies.size(); ++i) {
            RigidBodyBasics rigidBody = this.contactablePlaneBodies.get(i).getRigidBody();
            this.externalWrenches.put(rigidBody, new Wrench((ReferenceFrame)rigidBody.getBodyFixedFrame(), (ReferenceFrame)rigidBody.getBodyFixedFrame()));
        }
    }

    public void reset() {
        RigidBodyBasics rigidBody;
        int i;
        for (i = 0; i < this.contactablePlaneBodies.size(); ++i) {
            rigidBody = this.contactablePlaneBodies.get(i).getRigidBody();
            this.externalWrenches.get(rigidBody).setToZero((ReferenceFrame)rigidBody.getBodyFixedFrame(), (ReferenceFrame)rigidBody.getBodyFixedFrame());
        }
        for (i = 0; i < this.rigidBodiesWithWrenchToCompensateFor.size(); ++i) {
            rigidBody = this.rigidBodiesWithWrenchToCompensateFor.get(i);
            this.externalWrenches.get(rigidBody).setToZero((ReferenceFrame)rigidBody.getBodyFixedFrame(), (ReferenceFrame)rigidBody.getBodyFixedFrame());
        }
    }

    public final DMatrixRMaj computeWrenchEquationRightHandSide(DMatrixRMaj momentumConvectiveTerm, DMatrixRMaj b, DMatrixRMaj bHat) {
        this.totalWrenchAlreadyApplied.setIncludingFrame((SpatialVectorReadOnly)this.gravitationalWrench);
        for (int i = 0; i < this.externalWrenchesToCompensateForList.size(); ++i) {
            this.tempWrench.setIncludingFrame((SpatialVectorReadOnly)this.externalWrenchesToCompensateForList.get(i));
            this.tempWrench.changeFrame(this.gravitationalWrench.getReferenceFrame());
            this.totalWrenchAlreadyApplied.add((SpatialVectorReadOnly)this.tempWrench);
        }
        this.totalWrenchAlreadyApplied.get((DMatrix)this.wrenchEquationRightHandSide);
        CommonOps_DDRM.changeSign((DMatrixD1)this.wrenchEquationRightHandSide);
        CommonOps_DDRM.addEquals((DMatrixD1)this.wrenchEquationRightHandSide, (DMatrixD1)momentumConvectiveTerm);
        CommonOps_DDRM.addEquals((DMatrixD1)this.wrenchEquationRightHandSide, (DMatrixD1)b);
        CommonOps_DDRM.subtractEquals((DMatrixD1)this.wrenchEquationRightHandSide, (DMatrixD1)bHat);
        return this.wrenchEquationRightHandSide;
    }

    public DMatrixRMaj getSumOfExternalWrenches() {
        this.totalWrenchAlreadyApplied.setToZero(this.centerOfMassFrame);
        for (int i = 0; i < this.externalWrenchesToCompensateForList.size(); ++i) {
            this.tempWrench.setIncludingFrame((SpatialVectorReadOnly)this.externalWrenchesToCompensateForList.get(i));
            this.tempWrench.changeFrame(this.centerOfMassFrame);
            this.totalWrenchAlreadyApplied.add((SpatialVectorReadOnly)this.tempWrench);
        }
        this.totalWrenchAlreadyApplied.get((DMatrix)this.totalWrenchAlreadyAppliedMatrix);
        return this.totalWrenchAlreadyAppliedMatrix;
    }

    public void setExternalWrenchToCompensateFor(RigidBodyBasics rigidBody, WrenchReadOnly wrench) {
        boolean containsRigidBody;
        boolean bl = containsRigidBody = this.externalWrenchesToCompensateFor.get(rigidBody) != null;
        if (!containsRigidBody) {
            this.externalWrenches.put(rigidBody, new Wrench((ReferenceFrame)rigidBody.getBodyFixedFrame(), (ReferenceFrame)rigidBody.getBodyFixedFrame()));
            this.externalWrenchesToCompensateFor.put(rigidBody, new Wrench((ReferenceFrame)rigidBody.getBodyFixedFrame(), (ReferenceFrame)rigidBody.getBodyFixedFrame()));
            this.externalWrenchesToCompensateForList.add(this.externalWrenchesToCompensateFor.get(rigidBody));
            this.rigidBodiesWithWrenchToCompensateFor.add(rigidBody);
        }
        MovingReferenceFrame bodyFixedFrame = rigidBody.getBodyFixedFrame();
        wrench.getBodyFrame().checkReferenceFrameMatch((ReferenceFrame)bodyFixedFrame);
        wrench.getReferenceFrame().checkReferenceFrameMatch((ReferenceFrame)bodyFixedFrame);
        this.externalWrenchesToCompensateFor.get(rigidBody).setIncludingFrame(wrench);
    }

    public void computeExternalWrenches(Map<RigidBodyBasics, Wrench> groundReactionWrenches) {
        Wrench externalWrench;
        RigidBodyBasics rigidBody;
        int i;
        for (i = 0; i < this.contactablePlaneBodies.size(); ++i) {
            rigidBody = this.contactablePlaneBodies.get(i).getRigidBody();
            externalWrench = this.externalWrenches.get(rigidBody);
            if (groundReactionWrenches.containsKey(rigidBody)) {
                externalWrench.add((WrenchReadOnly)groundReactionWrenches.get(rigidBody));
            }
            if (this.rigidBodiesWithExternalWrench.contains(rigidBody)) continue;
            this.rigidBodiesWithExternalWrench.add(rigidBody);
        }
        for (i = 0; i < this.rigidBodiesWithWrenchToCompensateFor.size(); ++i) {
            rigidBody = this.rigidBodiesWithWrenchToCompensateFor.get(i);
            externalWrench = this.externalWrenches.get(rigidBody);
            externalWrench.add((WrenchReadOnly)this.externalWrenchesToCompensateFor.get(rigidBody));
            if (this.rigidBodiesWithExternalWrench.contains(rigidBody)) continue;
            this.rigidBodiesWithExternalWrench.add(rigidBody);
        }
    }

    public Map<RigidBodyBasics, Wrench> getExternalWrenchMap() {
        return this.externalWrenches;
    }

    public List<RigidBodyBasics> getRigidBodiesWithExternalWrench() {
        return this.rigidBodiesWithExternalWrench;
    }

    public DMatrixRMaj getGravitationalWrench() {
        this.gravitationalWrench.get((DMatrix)this.gravitationalWrenchMatrix);
        return this.gravitationalWrenchMatrix;
    }
}

