/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.momentumBasedController.optimization;

import gnu.trove.list.array.TIntArrayList;
import java.util.LinkedHashMap;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.JointIndexHandler;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.robotics.screwTheory.GravityCoriolisExternalWrenchMatrixCalculator;
import us.ihmc.robotics.screwTheory.ScrewTools;

public class DynamicsMatrixCalculatorHelper {
    private final GravityCoriolisExternalWrenchMatrixCalculator coriolisMatrixCalculator;
    private final LinkedHashMap<JointBasics, int[]> bodyOnlyIndices = new LinkedHashMap();
    private final int degreesOfFreedom;
    private final int bodyDoFs;
    private final int floatingBaseDoFs;
    private int rhoSize;

    public DynamicsMatrixCalculatorHelper(GravityCoriolisExternalWrenchMatrixCalculator coriolisMatrixCalculator, JointIndexHandler jointIndexHandler) {
        this.coriolisMatrixCalculator = coriolisMatrixCalculator;
        this.degreesOfFreedom = MultiBodySystemTools.computeDegreesOfFreedom((JointReadOnly[])jointIndexHandler.getIndexedJoints());
        OneDoFJointBasics[] bodyJoints = jointIndexHandler.getIndexedOneDoFJoints();
        this.bodyDoFs = MultiBodySystemTools.computeDegreesOfFreedom((JointReadOnly[])bodyJoints);
        this.floatingBaseDoFs = this.degreesOfFreedom - this.bodyDoFs;
        for (OneDoFJointBasics joint : bodyJoints) {
            TIntArrayList listToPackIndices = new TIntArrayList();
            ScrewTools.computeIndexForJoint((JointReadOnly[])bodyJoints, (TIntArrayList)listToPackIndices, (JointReadOnly)joint);
            int[] indices = listToPackIndices.toArray();
            this.bodyOnlyIndices.put((JointBasics)joint, indices);
        }
    }

    public void setRhoSize(int rhoSize) {
        this.rhoSize = rhoSize;
    }

    public void computeCoriolisMatrix(DMatrixRMaj coriolisMatrix) {
        coriolisMatrix.set((DMatrixD1)this.coriolisMatrixCalculator.getJointTauMatrix());
    }

    public void extractFloatingBaseCoriolisMatrix(DMatrixRMaj coriolisMatrixSrc, DMatrixRMaj coriolisMatrixDest) {
        CommonOps_DDRM.extract((DMatrix)coriolisMatrixSrc, (int)0, (int)this.floatingBaseDoFs, (int)0, (int)1, (DMatrix)coriolisMatrixDest, (int)0, (int)0);
    }

    public void extractBodyCoriolisMatrix(DMatrixRMaj coriolisMatrixSrc, DMatrixRMaj coriolisMatrixDest) {
        CommonOps_DDRM.extract((DMatrix)coriolisMatrixSrc, (int)this.floatingBaseDoFs, (int)this.degreesOfFreedom, (int)0, (int)1, (DMatrix)coriolisMatrixDest, (int)0, (int)0);
    }

    public void extractFloatingBaseContactForceJacobianMatrix(DMatrixRMaj jacobainMatrixSrc, DMatrixRMaj jacobianMatrixDest) {
        CommonOps_DDRM.extract((DMatrix)jacobainMatrixSrc, (int)0, (int)this.rhoSize, (int)0, (int)this.floatingBaseDoFs, (DMatrix)jacobianMatrixDest, (int)0, (int)0);
    }

    public void extractBodyContactForceJacobianMatrix(DMatrixRMaj jacobainMatrixSrc, DMatrixRMaj jacobianMatrixDest) {
        CommonOps_DDRM.extract((DMatrix)jacobainMatrixSrc, (int)0, (int)this.rhoSize, (int)this.floatingBaseDoFs, (int)this.degreesOfFreedom, (DMatrix)jacobianMatrixDest, (int)0, (int)0);
    }

    public void extractFloatingBaseMassMatrix(DMatrixRMaj massMatrixSrc, DMatrixRMaj massMatrixDest) {
        CommonOps_DDRM.extract((DMatrix)massMatrixSrc, (int)0, (int)this.floatingBaseDoFs, (int)0, (int)this.degreesOfFreedom, (DMatrix)massMatrixDest, (int)0, (int)0);
    }

    public void extractBodyMassMatrix(DMatrixRMaj massMatrixSrc, DMatrixRMaj massMatrixDest) {
        CommonOps_DDRM.extract((DMatrix)massMatrixSrc, (int)this.floatingBaseDoFs, (int)this.degreesOfFreedom, (int)0, (int)this.degreesOfFreedom, (DMatrix)massMatrixDest, (int)0, (int)0);
    }
}

