/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.momentumBasedController.optimization;

import java.util.List;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.commonWalkingControlModules.controllerCore.WholeBodyControlCoreToolbox;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.JointIndexHandler;
import us.ihmc.commonWalkingControlModules.wrenchDistribution.WrenchMatrixCalculator;
import us.ihmc.mecano.algorithms.GeometricJacobianCalculator;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;

public class ContactWrenchMatrixCalculator {
    private final WrenchMatrixCalculator wrenchMatrixCalculator;
    private final List<RigidBodyBasics> contactableBodies;
    private final JointIndexHandler jointIndexHandler;
    private final GeometricJacobianCalculator jacobianCalculator = new GeometricJacobianCalculator();
    private final RigidBodyBasics rootBody;
    private final int numberOfDoFs;
    private final DMatrixRMaj tmpCompactContactForceJacobianMatrix;
    private final DMatrixRMaj tmpFullContactForceJacobianMatrix;

    public ContactWrenchMatrixCalculator(WholeBodyControlCoreToolbox toolbox) {
        this.rootBody = toolbox.getRootBody();
        this.wrenchMatrixCalculator = toolbox.getWrenchMatrixCalculator();
        this.contactableBodies = this.wrenchMatrixCalculator.getRigidBodies();
        this.jointIndexHandler = toolbox.getJointIndexHandler();
        this.numberOfDoFs = this.jointIndexHandler.getNumberOfDoFs();
        int rhoSize = this.wrenchMatrixCalculator.getRhoSize();
        this.tmpFullContactForceJacobianMatrix = new DMatrixRMaj(rhoSize, this.numberOfDoFs);
        this.tmpCompactContactForceJacobianMatrix = new DMatrixRMaj(rhoSize, this.numberOfDoFs);
    }

    public void computeContactForceJacobian(DMatrixRMaj contactForceJacobianToPack) {
        int contactForceStartIndex = 0;
        for (int bodyIndex = 0; bodyIndex < this.contactableBodies.size(); ++bodyIndex) {
            RigidBodyBasics rigidBody = this.contactableBodies.get(bodyIndex);
            this.jacobianCalculator.setKinematicChain((RigidBodyReadOnly)this.rootBody, (RigidBodyReadOnly)rigidBody);
            this.jacobianCalculator.setJacobianFrame(this.wrenchMatrixCalculator.getJacobianFrame());
            DMatrixRMaj contactableBodyJacobianMatrix = this.jacobianCalculator.getJacobianMatrix();
            DMatrixRMaj rhoJacobianMatrix = this.wrenchMatrixCalculator.getRhoJacobianMatrix(rigidBody);
            int rhoSize = rhoJacobianMatrix.getNumCols();
            this.tmpCompactContactForceJacobianMatrix.reshape(rhoSize, contactableBodyJacobianMatrix.getNumCols());
            CommonOps_DDRM.multTransA((DMatrix1Row)rhoJacobianMatrix, (DMatrix1Row)contactableBodyJacobianMatrix, (DMatrix1Row)this.tmpCompactContactForceJacobianMatrix);
            CommonOps_DDRM.changeSign((DMatrixD1)this.tmpCompactContactForceJacobianMatrix);
            this.jointIndexHandler.compactBlockToFullBlock(this.jacobianCalculator.getJointsFromBaseToEndEffector(), this.tmpCompactContactForceJacobianMatrix, this.tmpFullContactForceJacobianMatrix);
            CommonOps_DDRM.extract((DMatrix)this.tmpFullContactForceJacobianMatrix, (int)0, (int)rhoSize, (int)0, (int)this.numberOfDoFs, (DMatrix)contactForceJacobianToPack, (int)contactForceStartIndex, (int)0);
            contactForceStartIndex += rhoSize;
        }
    }
}

