/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.momentumBasedController.feedbackController.taskspace;

import us.ihmc.commonWalkingControlModules.controlModules.YoSE3OffsetFrame;
import us.ihmc.commonWalkingControlModules.controllerCore.FeedbackControllerException;
import us.ihmc.commonWalkingControlModules.controllerCore.FeedbackControllerToolbox;
import us.ihmc.commonWalkingControlModules.controllerCore.WholeBodyControlCoreToolbox;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.SpatialFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.MomentumRateCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.SpatialAccelerationCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.SpatialVelocityCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.virtualModelControl.VirtualModelControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.virtualModelControl.VirtualWrenchCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.data.FBAlphaFilteredVector6D;
import us.ihmc.commonWalkingControlModules.controllerCore.data.FBPose3D;
import us.ihmc.commonWalkingControlModules.controllerCore.data.FBQuaternion3D;
import us.ihmc.commonWalkingControlModules.controllerCore.data.FBRateLimitedVector6D;
import us.ihmc.commonWalkingControlModules.controllerCore.data.FBVector3D;
import us.ihmc.commonWalkingControlModules.controllerCore.data.FBVector6D;
import us.ihmc.commonWalkingControlModules.controllerCore.data.SpaceData3D;
import us.ihmc.commonWalkingControlModules.controllerCore.data.SpaceData6D;
import us.ihmc.commonWalkingControlModules.controllerCore.data.Type;
import us.ihmc.commonWalkingControlModules.momentumBasedController.feedbackController.FeedbackControllerInterface;
import us.ihmc.commonWalkingControlModules.momentumBasedController.feedbackController.FeedbackControllerSettings;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.mecano.algorithms.interfaces.RigidBodyAccelerationProvider;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.SpatialAcceleration;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.SpatialMotionReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistBasics;
import us.ihmc.robotics.controllers.pidGains.PIDSE3GainsReadOnly;
import us.ihmc.robotics.controllers.pidGains.YoPID3DGains;
import us.ihmc.robotics.controllers.pidGains.YoPIDSE3Gains;
import us.ihmc.robotics.screwTheory.SelectionMatrix6D;
import us.ihmc.yoVariables.providers.BooleanProvider;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class SpatialFeedbackController
implements FeedbackControllerInterface {
    protected static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    protected final YoRegistry registry;
    protected final YoBoolean isEnabled;
    protected final FBPose3D yoDesiredPose;
    protected final FBPose3D yoCurrentPose;
    protected final FBVector6D yoErrorVector;
    protected final FBQuaternion3D yoErrorOrientation;
    protected final FBVector3D yoErrorPositionIntegrated;
    protected final FBQuaternion3D yoErrorOrientationCumulated;
    protected final FBVector3D yoErrorRotationVectorIntegrated;
    protected final FBVector6D yoDesiredVelocity;
    protected final FBVector6D yoCurrentVelocity;
    protected final FBVector6D yoErrorVelocity;
    protected final FBAlphaFilteredVector6D yoFilteredErrorVelocity;
    protected final FBVector6D yoFeedForwardVelocity;
    protected final FBVector6D yoFeedbackVelocity;
    protected final FBRateLimitedVector6D rateLimitedFeedbackVelocity;
    protected final FBVector6D yoDesiredAcceleration;
    protected final FBVector6D yoFeedForwardAcceleration;
    protected final FBVector6D yoFeedbackAcceleration;
    protected final FBRateLimitedVector6D rateLimitedFeedbackAcceleration;
    protected final FBVector6D yoAchievedAcceleration;
    protected final FBVector6D yoDesiredWrench;
    protected final FBVector6D yoFeedForwardWrench;
    protected final FBVector6D yoFeedbackWrench;
    protected final FBRateLimitedVector6D rateLimitedFeedbackWrench;
    protected final FBVector3D yoDesiredRotationVector;
    protected final FBVector3D yoCurrentRotationVector;
    protected final FramePoint3D desiredPosition = new FramePoint3D();
    protected final FrameQuaternion desiredOrientation = new FrameQuaternion();
    protected final FramePose3D desiredPose = new FramePose3D();
    protected final FrameQuaternion errorOrientationCumulated = new FrameQuaternion();
    protected final FrameVector3D desiredLinearVelocity = new FrameVector3D();
    protected final FrameVector3D desiredAngularVelocity = new FrameVector3D();
    protected final FrameVector3D currentLinearVelocity = new FrameVector3D();
    protected final FrameVector3D currentAngularVelocity = new FrameVector3D();
    protected final FrameVector3D feedForwardLinearVelocity = new FrameVector3D();
    protected final FrameVector3D feedForwardAngularVelocity = new FrameVector3D();
    protected final FrameVector3D desiredLinearAcceleration = new FrameVector3D();
    protected final FrameVector3D desiredAngularAcceleration = new FrameVector3D();
    protected final FrameVector3D feedForwardLinearAction = new FrameVector3D();
    protected final FrameVector3D feedForwardAngularAction = new FrameVector3D();
    protected final FrameVector3D biasLinearAcceleration = new FrameVector3D();
    protected final FrameVector3D achievedAngularAcceleration = new FrameVector3D();
    protected final FrameVector3D achievedLinearAcceleration = new FrameVector3D();
    protected final FrameVector3D desiredLinearForce = new FrameVector3D();
    protected final FrameVector3D desiredAngularTorque = new FrameVector3D();
    protected final Twist currentTwist = new Twist();
    protected final SpatialAcceleration endEffectorAchievedAcceleration = new SpatialAcceleration();
    protected final SpatialAccelerationCommand inverseDynamicsOutput = new SpatialAccelerationCommand();
    protected final SpatialVelocityCommand inverseKinematicsOutput = new SpatialVelocityCommand();
    protected final VirtualWrenchCommand virtualModelControlOutput = new VirtualWrenchCommand();
    protected final MomentumRateCommand virtualModelControlRootOutput = new MomentumRateCommand();
    protected final SelectionMatrix6D selectionMatrix = new SelectionMatrix6D();
    protected final YoPIDSE3Gains gains;
    protected final YoPID3DGains positionGains;
    protected final YoPID3DGains orientationGains;
    protected final Matrix3D tempGainMatrix = new Matrix3D();
    protected final RigidBodyAccelerationProvider rigidBodyAccelerationProvider;
    protected final RigidBodyBasics rootBody;
    protected RigidBodyBasics base;
    protected ReferenceFrame controlBaseFrame;
    protected ReferenceFrame angularGainsFrame;
    protected ReferenceFrame linearGainsFrame;
    protected final RigidBodyBasics endEffector;
    protected final YoSE3OffsetFrame controlFrame;
    protected final double dt;
    protected final boolean isRootBody;
    protected final boolean computeIntegralTerm;
    protected final int controllerIndex;
    protected int currentCommandId;
    protected final FrameVector3D linearProportionalFeedback = new FrameVector3D();
    protected final FrameVector3D linearDerivativeFeedback = new FrameVector3D();
    protected final FrameVector3D linearIntegralFeedback = new FrameVector3D();
    protected final FrameVector3D angularProportionalFeedback = new FrameVector3D();
    protected final FrameVector3D angularDerivativeFeedback = new FrameVector3D();
    protected final FrameVector3D angularIntegralFeedback = new FrameVector3D();

    public SpatialFeedbackController(RigidBodyBasics endEffector, WholeBodyControlCoreToolbox ccToolbox, FeedbackControllerToolbox fbToolbox, YoRegistry parentRegistry) {
        this(endEffector, 0, ccToolbox, fbToolbox, parentRegistry);
    }

    public SpatialFeedbackController(RigidBodyBasics endEffector, int controllerIndex, WholeBodyControlCoreToolbox ccToolbox, FeedbackControllerToolbox fbToolbox, YoRegistry parentRegistry) {
        this.endEffector = endEffector;
        this.controllerIndex = controllerIndex;
        FeedbackControllerSettings settings = ccToolbox.getFeedbackControllerSettings();
        this.computeIntegralTerm = settings != null ? settings.enableIntegralTerm() : true;
        if (ccToolbox.getRootJoint() != null) {
            this.rootBody = ccToolbox.getRootJoint().getSuccessor();
            this.isRootBody = this.endEffector.getName().equals(this.rootBody.getName());
        } else {
            this.isRootBody = false;
            this.rootBody = null;
        }
        this.rigidBodyAccelerationProvider = ccToolbox.getRigidBodyAccelerationProvider();
        String endEffectorName = endEffector.getName();
        this.registry = new YoRegistry(FeedbackControllerToolbox.appendIndex(endEffectorName, controllerIndex) + "SpatialFBController");
        this.dt = ccToolbox.getControlDT();
        this.gains = fbToolbox.getOrCreateSE3PIDGains(endEffector, controllerIndex, this.computeIntegralTerm);
        this.positionGains = this.gains.getPositionGains();
        this.orientationGains = this.gains.getOrientationGains();
        YoDouble maximumLinearRate = this.positionGains.getYoMaximumFeedbackRate();
        YoDouble maximumAngularRate = this.orientationGains.getYoMaximumFeedbackRate();
        this.controlFrame = fbToolbox.getOrCreateControlFrame(endEffector, controllerIndex);
        this.isEnabled = new YoBoolean(FeedbackControllerToolbox.appendIndex(endEffectorName, controllerIndex) + "isSpatialFBControllerEnabled", this.registry);
        this.isEnabled.set(false);
        this.yoDesiredPose = fbToolbox.getOrCreatePoseData(endEffector, controllerIndex, Type.DESIRED, (BooleanProvider)this.isEnabled);
        this.yoCurrentPose = fbToolbox.getOrCreatePoseData(endEffector, controllerIndex, Type.CURRENT, (BooleanProvider)this.isEnabled);
        this.yoErrorVector = fbToolbox.getOrCreateVectorData6D(endEffector, controllerIndex, Type.ERROR, SpaceData6D.POSE, (BooleanProvider)this.isEnabled);
        this.yoErrorOrientation = fbToolbox.getOrCreateOrientationData(endEffector, controllerIndex, Type.ERROR, (BooleanProvider)this.isEnabled);
        if (this.computeIntegralTerm) {
            this.yoErrorPositionIntegrated = fbToolbox.getOrCreateVectorData3D(endEffector, controllerIndex, Type.ERROR_INTEGRATED, SpaceData3D.POSITION, (BooleanProvider)this.isEnabled);
            this.yoErrorOrientationCumulated = fbToolbox.getOrCreateOrientationData(endEffector, controllerIndex, Type.ERROR_CUMULATED, (BooleanProvider)this.isEnabled);
            this.yoErrorRotationVectorIntegrated = fbToolbox.getOrCreateVectorData3D(endEffector, controllerIndex, Type.ERROR_INTEGRATED, SpaceData3D.ROTATION_VECTOR, (BooleanProvider)this.isEnabled);
        } else {
            this.yoErrorPositionIntegrated = null;
            this.yoErrorOrientationCumulated = null;
            this.yoErrorRotationVectorIntegrated = null;
        }
        this.yoDesiredRotationVector = fbToolbox.getOrCreateVectorData3D(endEffector, controllerIndex, Type.DESIRED, SpaceData3D.ROTATION_VECTOR, (BooleanProvider)this.isEnabled);
        this.yoCurrentRotationVector = fbToolbox.getOrCreateVectorData3D(endEffector, controllerIndex, Type.CURRENT, SpaceData3D.ROTATION_VECTOR, (BooleanProvider)this.isEnabled);
        this.yoDesiredVelocity = fbToolbox.getOrCreateVectorData6D(endEffector, controllerIndex, Type.DESIRED, SpaceData6D.VELOCITY, (BooleanProvider)this.isEnabled);
        if (ccToolbox.isEnableInverseDynamicsModule() || ccToolbox.isEnableVirtualModelControlModule()) {
            this.yoCurrentVelocity = fbToolbox.getOrCreateVectorData6D(endEffector, controllerIndex, Type.CURRENT, SpaceData6D.VELOCITY, (BooleanProvider)this.isEnabled);
            this.yoErrorVelocity = fbToolbox.getOrCreateVectorData6D(endEffector, controllerIndex, Type.ERROR, SpaceData6D.VELOCITY, (BooleanProvider)this.isEnabled);
            DoubleProvider breakFrequency = fbToolbox.getErrorVelocityFilterBreakFrequency(endEffectorName);
            this.yoFilteredErrorVelocity = breakFrequency != null ? fbToolbox.getOrCreateAlphaFilteredVectorData6D(endEffector, controllerIndex, Type.ERROR, SpaceData6D.VELOCITY, this.dt, breakFrequency, breakFrequency, (BooleanProvider)this.isEnabled) : null;
            if (ccToolbox.isEnableInverseDynamicsModule()) {
                this.yoDesiredAcceleration = fbToolbox.getOrCreateVectorData6D(endEffector, controllerIndex, Type.DESIRED, SpaceData6D.ACCELERATION, (BooleanProvider)this.isEnabled);
                this.yoFeedForwardAcceleration = fbToolbox.getOrCreateVectorData6D(endEffector, controllerIndex, Type.FEEDFORWARD, SpaceData6D.ACCELERATION, (BooleanProvider)this.isEnabled);
                this.yoFeedbackAcceleration = fbToolbox.getOrCreateVectorData6D(endEffector, controllerIndex, Type.FEEDBACK, SpaceData6D.ACCELERATION, (BooleanProvider)this.isEnabled);
                this.rateLimitedFeedbackAcceleration = fbToolbox.getOrCreateRateLimitedVectorData6D(endEffector, controllerIndex, Type.FEEDBACK, SpaceData6D.ACCELERATION, this.dt, maximumAngularRate, maximumLinearRate, (BooleanProvider)this.isEnabled);
                this.yoAchievedAcceleration = fbToolbox.getOrCreateVectorData6D(endEffector, controllerIndex, Type.ACHIEVED, SpaceData6D.ACCELERATION, (BooleanProvider)this.isEnabled);
            } else {
                this.yoDesiredAcceleration = null;
                this.yoFeedForwardAcceleration = null;
                this.yoFeedbackAcceleration = null;
                this.rateLimitedFeedbackAcceleration = null;
                this.yoAchievedAcceleration = null;
            }
            if (ccToolbox.isEnableVirtualModelControlModule()) {
                this.yoDesiredWrench = fbToolbox.getOrCreateVectorData6D(endEffector, controllerIndex, Type.DESIRED, SpaceData6D.FORCE, (BooleanProvider)this.isEnabled);
                this.yoFeedForwardWrench = fbToolbox.getOrCreateVectorData6D(endEffector, controllerIndex, Type.FEEDFORWARD, SpaceData6D.FORCE, (BooleanProvider)this.isEnabled);
                this.yoFeedbackWrench = fbToolbox.getOrCreateVectorData6D(endEffector, controllerIndex, Type.FEEDBACK, SpaceData6D.FORCE, (BooleanProvider)this.isEnabled);
                this.rateLimitedFeedbackWrench = fbToolbox.getOrCreateRateLimitedVectorData6D(endEffector, controllerIndex, Type.FEEDBACK, SpaceData6D.FORCE, this.dt, maximumAngularRate, maximumLinearRate, (BooleanProvider)this.isEnabled);
            } else {
                this.yoDesiredWrench = null;
                this.yoFeedForwardWrench = null;
                this.yoFeedbackWrench = null;
                this.rateLimitedFeedbackWrench = null;
            }
        } else {
            this.yoCurrentVelocity = null;
            this.yoErrorVelocity = null;
            this.yoFilteredErrorVelocity = null;
            this.yoDesiredAcceleration = null;
            this.yoFeedForwardAcceleration = null;
            this.yoFeedbackAcceleration = null;
            this.rateLimitedFeedbackAcceleration = null;
            this.yoAchievedAcceleration = null;
            this.yoDesiredWrench = null;
            this.yoFeedForwardWrench = null;
            this.yoFeedbackWrench = null;
            this.rateLimitedFeedbackWrench = null;
        }
        if (ccToolbox.isEnableInverseKinematicsModule()) {
            this.yoFeedbackVelocity = fbToolbox.getOrCreateVectorData6D(endEffector, controllerIndex, Type.FEEDBACK, SpaceData6D.VELOCITY, (BooleanProvider)this.isEnabled);
            this.yoFeedForwardVelocity = fbToolbox.getOrCreateVectorData6D(endEffector, controllerIndex, Type.FEEDFORWARD, SpaceData6D.VELOCITY, (BooleanProvider)this.isEnabled);
            this.rateLimitedFeedbackVelocity = fbToolbox.getOrCreateRateLimitedVectorData6D(endEffector, controllerIndex, Type.FEEDBACK, SpaceData6D.VELOCITY, this.dt, maximumAngularRate, maximumLinearRate, (BooleanProvider)this.isEnabled);
        } else {
            this.yoFeedbackVelocity = null;
            this.yoFeedForwardVelocity = null;
            this.rateLimitedFeedbackVelocity = null;
        }
        parentRegistry.addChild(this.registry);
    }

    public void submitFeedbackControlCommand(SpatialFeedbackControlCommand command) {
        if (command.getEndEffector() != this.endEffector) {
            throw new FeedbackControllerException("Wrong end effector - received: " + command.getEndEffector() + ", expected: " + this.endEffector);
        }
        this.currentCommandId = command.getCommandId();
        this.base = command.getBase();
        this.controlBaseFrame = command.getControlBaseFrame();
        this.inverseDynamicsOutput.set(command.getSpatialAccelerationCommand());
        this.inverseKinematicsOutput.setProperties(command.getSpatialAccelerationCommand());
        this.virtualModelControlOutput.setProperties(command.getSpatialAccelerationCommand());
        this.gains.set((PIDSE3GainsReadOnly)command.getGains());
        command.getSpatialAccelerationCommand().getSelectionMatrix(this.selectionMatrix);
        this.angularGainsFrame = command.getAngularGainsFrame();
        this.linearGainsFrame = command.getLinearGainsFrame();
        command.getControlFramePoseIncludingFrame((FramePoint3DBasics)this.desiredPosition, (FrameQuaternionBasics)this.desiredOrientation);
        this.controlFrame.setOffsetToParent((FrameTuple3DReadOnly)this.desiredPosition, (FrameQuaternionReadOnly)this.desiredOrientation);
        this.yoDesiredPose.setIncludingFrame((FrameTuple3DReadOnly)command.getReferencePosition(), (FrameOrientation3DReadOnly)command.getReferenceOrientation());
        this.yoDesiredPose.getOrientation().getRotationVector((FrameVector3DBasics)this.yoDesiredRotationVector);
        this.yoDesiredPose.setCommandId(this.currentCommandId);
        this.yoDesiredVelocity.setIncludingFrame((FrameVector3DReadOnly)command.getReferenceAngularVelocity(), (FrameVector3DReadOnly)command.getReferenceLinearVelocity());
        this.yoDesiredVelocity.checkReferenceFrameMatch((ReferenceFrameHolder)this.yoDesiredPose);
        this.yoDesiredVelocity.setCommandId(this.currentCommandId);
        if (this.yoFeedForwardVelocity != null) {
            this.yoFeedForwardVelocity.setIncludingFrame((FrameVector3DReadOnly)command.getReferenceAngularVelocity(), (FrameVector3DReadOnly)command.getReferenceLinearVelocity());
            this.yoFeedForwardVelocity.checkReferenceFrameMatch((ReferenceFrameHolder)this.yoDesiredPose);
            this.yoFeedForwardVelocity.setCommandId(this.currentCommandId);
        }
        if (this.yoFeedForwardAcceleration != null) {
            this.yoFeedForwardAcceleration.setIncludingFrame((FrameVector3DReadOnly)command.getReferenceAngularAcceleration(), (FrameVector3DReadOnly)command.getReferenceLinearAcceleration());
            this.yoFeedForwardAcceleration.checkReferenceFrameMatch((ReferenceFrameHolder)this.yoDesiredPose);
            this.yoFeedForwardAcceleration.setCommandId(this.currentCommandId);
        }
        if (this.yoFeedForwardWrench != null) {
            this.yoFeedForwardWrench.setIncludingFrame((FrameVector3DReadOnly)command.getReferenceTorque(), (FrameVector3DReadOnly)command.getReferenceForce());
            this.yoFeedForwardWrench.checkReferenceFrameMatch((ReferenceFrameHolder)this.yoDesiredPose);
            this.yoFeedForwardWrench.setCommandId(this.currentCommandId);
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.isEnabled.set(isEnabled);
    }

    @Override
    public void initialize() {
        if (this.rateLimitedFeedbackAcceleration != null) {
            this.rateLimitedFeedbackAcceleration.reset();
        }
        if (this.rateLimitedFeedbackVelocity != null) {
            this.rateLimitedFeedbackVelocity.reset();
        }
        if (this.yoFilteredErrorVelocity != null) {
            this.yoFilteredErrorVelocity.reset();
        }
        if (this.yoErrorPositionIntegrated != null) {
            this.yoErrorPositionIntegrated.setToZero(worldFrame);
        }
        if (this.yoErrorOrientationCumulated != null) {
            this.yoErrorOrientationCumulated.setToZero(worldFrame);
        }
        if (this.yoErrorRotationVectorIntegrated != null) {
            this.yoErrorRotationVectorIntegrated.setToZero(worldFrame);
        }
    }

    @Override
    public void computeInverseDynamics() {
        if (!this.isEnabled()) {
            return;
        }
        ReferenceFrame trajectoryFrame = this.yoDesiredPose.getReferenceFrame();
        this.computeProportionalTerm(this.linearProportionalFeedback, this.angularProportionalFeedback);
        this.computeDerivativeTerm(this.linearDerivativeFeedback, this.angularDerivativeFeedback);
        this.computeIntegralTerm(this.linearIntegralFeedback, this.angularIntegralFeedback);
        this.feedForwardLinearAction.setIncludingFrame((FrameTuple3DReadOnly)this.yoFeedForwardAcceleration.getLinearPart());
        this.feedForwardAngularAction.setIncludingFrame((FrameTuple3DReadOnly)this.yoFeedForwardAcceleration.getAngularPart());
        this.feedForwardLinearAction.changeFrame((ReferenceFrame)this.controlFrame);
        this.feedForwardAngularAction.changeFrame((ReferenceFrame)this.controlFrame);
        this.desiredLinearAcceleration.setIncludingFrame((FrameTuple3DReadOnly)this.linearProportionalFeedback);
        this.desiredLinearAcceleration.add((FrameTuple3DReadOnly)this.linearDerivativeFeedback);
        this.desiredLinearAcceleration.add((FrameTuple3DReadOnly)this.linearIntegralFeedback);
        this.desiredLinearAcceleration.clipToMaxLength(this.positionGains.getMaximumFeedback());
        this.desiredAngularAcceleration.setIncludingFrame((FrameTuple3DReadOnly)this.angularProportionalFeedback);
        this.desiredAngularAcceleration.add((FrameTuple3DReadOnly)this.angularDerivativeFeedback);
        this.desiredAngularAcceleration.add((FrameTuple3DReadOnly)this.angularIntegralFeedback);
        this.desiredAngularAcceleration.clipToMaxLength(this.orientationGains.getMaximumFeedback());
        this.yoFeedbackAcceleration.setIncludingFrame((FrameVector3DReadOnly)this.desiredAngularAcceleration, (FrameVector3DReadOnly)this.desiredLinearAcceleration);
        this.yoFeedbackAcceleration.changeFrame(trajectoryFrame);
        this.yoFeedbackAcceleration.setCommandId(this.currentCommandId);
        this.rateLimitedFeedbackAcceleration.changeFrame(trajectoryFrame);
        this.rateLimitedFeedbackAcceleration.update();
        this.rateLimitedFeedbackAcceleration.setCommandId(this.currentCommandId);
        this.desiredLinearAcceleration.setIncludingFrame((FrameTuple3DReadOnly)this.rateLimitedFeedbackAcceleration.getLinearPart());
        this.desiredAngularAcceleration.setIncludingFrame((FrameTuple3DReadOnly)this.rateLimitedFeedbackAcceleration.getAngularPart());
        this.desiredLinearAcceleration.changeFrame((ReferenceFrame)this.controlFrame);
        this.desiredLinearAcceleration.add((FrameTuple3DReadOnly)this.feedForwardLinearAction);
        this.desiredAngularAcceleration.changeFrame((ReferenceFrame)this.controlFrame);
        this.desiredAngularAcceleration.add((FrameTuple3DReadOnly)this.feedForwardAngularAction);
        this.proccessInverseDynamicsDesiredAcceleration(this.controlFrame, this.desiredAngularAcceleration, this.desiredLinearAcceleration);
        this.yoDesiredAcceleration.setIncludingFrame((FrameVector3DReadOnly)this.desiredAngularAcceleration, (FrameVector3DReadOnly)this.desiredLinearAcceleration);
        this.yoDesiredAcceleration.changeFrame(trajectoryFrame);
        this.yoDesiredAcceleration.setCommandId(this.currentCommandId);
        this.addCoriolisAcceleration(this.desiredLinearAcceleration);
        this.inverseDynamicsOutput.setSpatialAcceleration((ReferenceFrame)this.controlFrame, (FrameVector3DReadOnly)this.desiredAngularAcceleration, (FrameVector3DReadOnly)this.desiredLinearAcceleration);
    }

    @Override
    public void computeInverseKinematics() {
        if (!this.isEnabled()) {
            return;
        }
        this.inverseKinematicsOutput.setProperties(this.inverseDynamicsOutput);
        ReferenceFrame trajectoryFrame = this.yoDesiredPose.getReferenceFrame();
        this.feedForwardLinearVelocity.setIncludingFrame((FrameTuple3DReadOnly)this.yoFeedForwardVelocity.getLinearPart());
        this.feedForwardAngularVelocity.setIncludingFrame((FrameTuple3DReadOnly)this.yoFeedForwardVelocity.getAngularPart());
        this.computeProportionalTerm(this.linearProportionalFeedback, this.angularProportionalFeedback);
        this.computeIntegralTerm(this.linearIntegralFeedback, this.angularIntegralFeedback);
        this.desiredLinearVelocity.setIncludingFrame((FrameTuple3DReadOnly)this.linearProportionalFeedback);
        this.desiredLinearVelocity.add((FrameTuple3DReadOnly)this.linearIntegralFeedback);
        this.desiredLinearVelocity.clipToMaxLength(this.positionGains.getMaximumFeedback());
        this.desiredAngularVelocity.setIncludingFrame((FrameTuple3DReadOnly)this.angularProportionalFeedback);
        this.desiredAngularVelocity.add((FrameTuple3DReadOnly)this.angularIntegralFeedback);
        this.desiredAngularVelocity.clipToMaxLength(this.orientationGains.getMaximumFeedback());
        this.yoFeedbackVelocity.setIncludingFrame((FrameVector3DReadOnly)this.desiredAngularVelocity, (FrameVector3DReadOnly)this.desiredLinearVelocity);
        this.yoFeedbackVelocity.changeFrame(trajectoryFrame);
        this.yoFeedbackVelocity.setCommandId(this.currentCommandId);
        this.rateLimitedFeedbackVelocity.changeFrame(trajectoryFrame);
        this.rateLimitedFeedbackVelocity.update();
        this.rateLimitedFeedbackVelocity.setCommandId(this.currentCommandId);
        this.desiredLinearVelocity.setIncludingFrame((FrameTuple3DReadOnly)this.rateLimitedFeedbackVelocity.getLinearPart());
        this.desiredAngularVelocity.setIncludingFrame((FrameTuple3DReadOnly)this.rateLimitedFeedbackVelocity.getAngularPart());
        this.desiredLinearVelocity.add((FrameTuple3DReadOnly)this.feedForwardLinearVelocity);
        this.desiredAngularVelocity.add((FrameTuple3DReadOnly)this.feedForwardAngularVelocity);
        this.yoDesiredVelocity.setIncludingFrame((FrameVector3DReadOnly)this.desiredAngularVelocity, (FrameVector3DReadOnly)this.desiredLinearVelocity);
        this.yoDesiredVelocity.changeFrame(trajectoryFrame);
        this.yoDesiredVelocity.setCommandId(this.currentCommandId);
        this.desiredLinearVelocity.changeFrame((ReferenceFrame)this.controlFrame);
        this.desiredAngularVelocity.changeFrame((ReferenceFrame)this.controlFrame);
        this.inverseKinematicsOutput.setSpatialVelocity((ReferenceFrame)this.controlFrame, this.desiredAngularVelocity, this.desiredLinearVelocity);
    }

    @Override
    public void computeVirtualModelControl() {
        if (!this.isEnabled()) {
            return;
        }
        this.computeFeedbackWrench();
        if (this.isRootBody) {
            this.desiredLinearForce.changeFrame(worldFrame);
            this.desiredAngularTorque.changeFrame(worldFrame);
            this.virtualModelControlRootOutput.setProperties(this.inverseDynamicsOutput);
            this.virtualModelControlRootOutput.setMomentumRate(this.desiredAngularTorque, this.desiredLinearForce);
        } else {
            this.virtualModelControlOutput.setProperties(this.inverseDynamicsOutput);
            this.virtualModelControlOutput.setWrench((ReferenceFrame)this.controlFrame, this.desiredAngularTorque, this.desiredLinearForce);
        }
    }

    protected void computeFeedbackWrench() {
        ReferenceFrame trajectoryFrame = this.yoDesiredPose.getReferenceFrame();
        this.feedForwardLinearAction.setIncludingFrame((FrameTuple3DReadOnly)this.yoFeedForwardWrench.getLinearPart());
        this.feedForwardAngularAction.setIncludingFrame((FrameTuple3DReadOnly)this.yoFeedForwardWrench.getAngularPart());
        this.feedForwardLinearAction.changeFrame((ReferenceFrame)this.controlFrame);
        this.feedForwardAngularAction.changeFrame((ReferenceFrame)this.controlFrame);
        this.computeProportionalTerm(this.linearProportionalFeedback, this.angularProportionalFeedback);
        this.computeDerivativeTerm(this.linearDerivativeFeedback, this.angularDerivativeFeedback);
        this.computeIntegralTerm(this.linearIntegralFeedback, this.angularIntegralFeedback);
        this.desiredLinearForce.setIncludingFrame((FrameTuple3DReadOnly)this.linearProportionalFeedback);
        this.desiredLinearForce.add((FrameTuple3DReadOnly)this.linearDerivativeFeedback);
        this.desiredLinearForce.add((FrameTuple3DReadOnly)this.linearIntegralFeedback);
        this.desiredLinearForce.clipToMaxLength(this.positionGains.getMaximumFeedback());
        this.desiredAngularTorque.setIncludingFrame((FrameTuple3DReadOnly)this.angularProportionalFeedback);
        this.desiredAngularTorque.add((FrameTuple3DReadOnly)this.angularDerivativeFeedback);
        this.desiredAngularTorque.add((FrameTuple3DReadOnly)this.angularIntegralFeedback);
        this.desiredAngularTorque.clipToMaxLength(this.orientationGains.getMaximumFeedback());
        this.yoFeedbackWrench.setIncludingFrame((FrameVector3DReadOnly)this.desiredAngularTorque, (FrameVector3DReadOnly)this.desiredLinearForce);
        this.yoFeedbackWrench.changeFrame(trajectoryFrame);
        this.yoFeedbackWrench.setCommandId(this.currentCommandId);
        this.rateLimitedFeedbackWrench.changeFrame(trajectoryFrame);
        this.rateLimitedFeedbackWrench.update();
        this.rateLimitedFeedbackWrench.setCommandId(this.currentCommandId);
        this.desiredLinearForce.setIncludingFrame((FrameTuple3DReadOnly)this.rateLimitedFeedbackWrench.getLinearPart());
        this.desiredAngularTorque.setIncludingFrame((FrameTuple3DReadOnly)this.rateLimitedFeedbackWrench.getAngularPart());
        this.desiredLinearForce.changeFrame((ReferenceFrame)this.controlFrame);
        this.desiredLinearForce.add((FrameTuple3DReadOnly)this.feedForwardLinearAction);
        this.desiredAngularTorque.changeFrame((ReferenceFrame)this.controlFrame);
        this.desiredAngularTorque.add((FrameTuple3DReadOnly)this.feedForwardAngularAction);
        this.yoDesiredWrench.setIncludingFrame((FrameVector3DReadOnly)this.desiredAngularTorque, (FrameVector3DReadOnly)this.desiredLinearForce);
        this.yoDesiredWrench.changeFrame(trajectoryFrame);
        this.yoDesiredWrench.setCommandId(this.currentCommandId);
    }

    @Override
    public void computeAchievedAcceleration() {
        this.endEffectorAchievedAcceleration.setIncludingFrame((SpatialMotionReadOnly)this.rigidBodyAccelerationProvider.getRelativeAcceleration((RigidBodyReadOnly)this.base, (RigidBodyReadOnly)this.endEffector));
        this.endEffectorAchievedAcceleration.changeFrame((ReferenceFrame)this.controlFrame);
        this.achievedAngularAcceleration.setIncludingFrame((FrameTuple3DReadOnly)this.endEffectorAchievedAcceleration.getAngularPart());
        this.achievedLinearAcceleration.setIncludingFrame((FrameTuple3DReadOnly)this.endEffectorAchievedAcceleration.getLinearPart());
        this.subtractCoriolisAcceleration(this.achievedLinearAcceleration);
        this.yoAchievedAcceleration.setReferenceFrame(this.yoDesiredPose.getReferenceFrame());
        this.yoAchievedAcceleration.getAngularPart().setMatchingFrame((FrameTuple3DReadOnly)this.achievedAngularAcceleration);
        this.yoAchievedAcceleration.getLinearPart().setMatchingFrame((FrameTuple3DReadOnly)this.achievedLinearAcceleration);
        this.yoAchievedAcceleration.setCommandId(this.currentCommandId);
    }

    protected void computeProportionalTerm(FrameVector3D linearFeedbackTermToPack, FrameVector3D angularFeedbackTermToPack) {
        ReferenceFrame trajectoryFrame = this.yoDesiredPose.getReferenceFrame();
        this.yoCurrentPose.setToZero((ReferenceFrame)this.controlFrame);
        this.yoCurrentPose.changeFrame(trajectoryFrame);
        this.yoCurrentPose.setCommandId(this.currentCommandId);
        this.yoCurrentPose.getOrientation().getRotationVector((FrameVector3DBasics)this.yoCurrentRotationVector);
        this.yoCurrentRotationVector.setCommandId(this.currentCommandId);
        this.desiredPose.setIncludingFrame((FramePose3DReadOnly)this.yoDesiredPose);
        this.desiredPose.changeFrame((ReferenceFrame)this.controlFrame);
        this.desiredPose.getOrientation().normalizeAndLimitToPi();
        linearFeedbackTermToPack.setIncludingFrame((FrameTuple3DReadOnly)this.desiredPose.getPosition());
        this.desiredPose.getRotationVector((FrameVector3DBasics)angularFeedbackTermToPack);
        this.selectionMatrix.applyLinearSelection(linearFeedbackTermToPack);
        this.selectionMatrix.applyAngularSelection(angularFeedbackTermToPack);
        linearFeedbackTermToPack.clipToMaxLength(this.positionGains.getMaximumProportionalError());
        angularFeedbackTermToPack.clipToMaxLength(this.orientationGains.getMaximumProportionalError());
        this.yoErrorVector.setIncludingFrame((FrameVector3DReadOnly)angularFeedbackTermToPack, (FrameVector3DReadOnly)linearFeedbackTermToPack);
        this.yoErrorVector.changeFrame(trajectoryFrame);
        this.yoErrorVector.setCommandId(this.currentCommandId);
        this.yoErrorOrientation.setRotationVectorIncludingFrame((FrameVector3DReadOnly)this.yoErrorVector.getAngularPart());
        this.yoErrorOrientation.setCommandId(this.currentCommandId);
        if (this.linearGainsFrame != null) {
            linearFeedbackTermToPack.changeFrame(this.linearGainsFrame);
        } else {
            linearFeedbackTermToPack.changeFrame((ReferenceFrame)this.controlFrame);
        }
        if (this.angularGainsFrame != null) {
            angularFeedbackTermToPack.changeFrame(this.angularGainsFrame);
        } else {
            angularFeedbackTermToPack.changeFrame((ReferenceFrame)this.controlFrame);
        }
        this.positionGains.getProportionalGainMatrix(this.tempGainMatrix);
        this.tempGainMatrix.transform((Tuple3DBasics)linearFeedbackTermToPack);
        this.orientationGains.getProportionalGainMatrix(this.tempGainMatrix);
        this.tempGainMatrix.transform((Tuple3DBasics)angularFeedbackTermToPack);
        linearFeedbackTermToPack.changeFrame((ReferenceFrame)this.controlFrame);
        angularFeedbackTermToPack.changeFrame((ReferenceFrame)this.controlFrame);
    }

    protected void computeDerivativeTerm(FrameVector3D linearFeedbackTermToPack, FrameVector3D angularFeedbackTermToPack) {
        ReferenceFrame trajectoryFrame = this.yoDesiredPose.getReferenceFrame();
        this.controlFrame.getTwistRelativeToOther(this.controlBaseFrame, (TwistBasics)this.currentTwist);
        this.yoCurrentVelocity.setIncludingFrame((FrameVector3DReadOnly)this.currentTwist.getAngularPart(), (FrameVector3DReadOnly)this.currentTwist.getLinearPart());
        this.yoCurrentVelocity.changeFrame(trajectoryFrame);
        this.yoCurrentVelocity.setCommandId(this.currentCommandId);
        linearFeedbackTermToPack.setToZero(trajectoryFrame);
        angularFeedbackTermToPack.setToZero(trajectoryFrame);
        linearFeedbackTermToPack.sub((FrameTuple3DReadOnly)this.yoDesiredVelocity.getLinearPart(), (FrameTuple3DReadOnly)this.yoCurrentVelocity.getLinearPart());
        angularFeedbackTermToPack.sub((FrameTuple3DReadOnly)this.yoDesiredVelocity.getAngularPart(), (FrameTuple3DReadOnly)this.yoCurrentVelocity.getAngularPart());
        linearFeedbackTermToPack.changeFrame((ReferenceFrame)this.controlFrame);
        angularFeedbackTermToPack.changeFrame((ReferenceFrame)this.controlFrame);
        this.selectionMatrix.applyLinearSelection(linearFeedbackTermToPack);
        this.selectionMatrix.applyAngularSelection(angularFeedbackTermToPack);
        linearFeedbackTermToPack.clipToMaxLength(this.positionGains.getMaximumDerivativeError());
        angularFeedbackTermToPack.clipToMaxLength(this.orientationGains.getMaximumDerivativeError());
        if (this.yoFilteredErrorVelocity != null) {
            if (this.yoFilteredErrorVelocity.getReferenceFrame() != trajectoryFrame) {
                this.yoFilteredErrorVelocity.setReferenceFrame(trajectoryFrame);
                this.yoFilteredErrorVelocity.reset();
            }
            linearFeedbackTermToPack.changeFrame(trajectoryFrame);
            angularFeedbackTermToPack.changeFrame(trajectoryFrame);
            this.yoErrorVelocity.setIncludingFrame((FrameVector3DReadOnly)angularFeedbackTermToPack, (FrameVector3DReadOnly)linearFeedbackTermToPack);
            this.yoFilteredErrorVelocity.update();
            this.yoFilteredErrorVelocity.setCommandId(this.currentCommandId);
            linearFeedbackTermToPack.set((FrameTuple3DReadOnly)this.yoFilteredErrorVelocity.getLinearPart());
            angularFeedbackTermToPack.set((FrameTuple3DReadOnly)this.yoFilteredErrorVelocity.getAngularPart());
        } else {
            this.yoErrorVelocity.setIncludingFrame((FrameVector3DReadOnly)angularFeedbackTermToPack, (FrameVector3DReadOnly)linearFeedbackTermToPack);
        }
        this.yoErrorVelocity.changeFrame(trajectoryFrame);
        this.yoErrorVelocity.setCommandId(this.currentCommandId);
        if (this.linearGainsFrame != null) {
            linearFeedbackTermToPack.changeFrame(this.linearGainsFrame);
        } else {
            linearFeedbackTermToPack.changeFrame((ReferenceFrame)this.controlFrame);
        }
        if (this.angularGainsFrame != null) {
            angularFeedbackTermToPack.changeFrame(this.angularGainsFrame);
        } else {
            angularFeedbackTermToPack.changeFrame((ReferenceFrame)this.controlFrame);
        }
        this.positionGains.getDerivativeGainMatrix(this.tempGainMatrix);
        this.tempGainMatrix.transform((Tuple3DBasics)linearFeedbackTermToPack);
        this.orientationGains.getDerivativeGainMatrix(this.tempGainMatrix);
        this.tempGainMatrix.transform((Tuple3DBasics)angularFeedbackTermToPack);
        linearFeedbackTermToPack.changeFrame((ReferenceFrame)this.controlFrame);
        angularFeedbackTermToPack.changeFrame((ReferenceFrame)this.controlFrame);
    }

    protected void computeIntegralTerm(FrameVector3D linearFeedbackTermToPack, FrameVector3D angularFeedbackTermToPack) {
        if (!this.computeIntegralTerm) {
            linearFeedbackTermToPack.setToZero((ReferenceFrame)this.controlFrame);
            angularFeedbackTermToPack.setToZero((ReferenceFrame)this.controlFrame);
            return;
        }
        ReferenceFrame trajectoryFrame = this.yoDesiredPose.getReferenceFrame();
        double maximumLinearIntegralError = this.positionGains.getMaximumIntegralError();
        if (maximumLinearIntegralError < 1.0E-5) {
            linearFeedbackTermToPack.setToZero((ReferenceFrame)this.controlFrame);
            this.yoErrorPositionIntegrated.setToZero(trajectoryFrame);
            this.yoErrorPositionIntegrated.setCommandId(this.currentCommandId);
        } else {
            if (this.yoErrorPositionIntegrated.getReferenceFrame() != trajectoryFrame) {
                this.yoErrorPositionIntegrated.setToZero(trajectoryFrame);
            }
            linearFeedbackTermToPack.setIncludingFrame((FrameTuple3DReadOnly)this.yoErrorVector.getLinearPart());
            linearFeedbackTermToPack.scale(this.dt);
            linearFeedbackTermToPack.add((FrameTuple3DReadOnly)this.yoErrorPositionIntegrated);
            linearFeedbackTermToPack.changeFrame((ReferenceFrame)this.controlFrame);
            this.selectionMatrix.applyLinearSelection(linearFeedbackTermToPack);
            linearFeedbackTermToPack.clipToMaxLength(maximumLinearIntegralError);
            this.yoErrorPositionIntegrated.setIncludingFrame((FrameTuple3DReadOnly)linearFeedbackTermToPack);
            this.yoErrorPositionIntegrated.changeFrame(trajectoryFrame);
            this.yoErrorPositionIntegrated.setCommandId(this.currentCommandId);
            if (this.linearGainsFrame != null) {
                linearFeedbackTermToPack.changeFrame(this.linearGainsFrame);
            } else {
                linearFeedbackTermToPack.changeFrame((ReferenceFrame)this.controlFrame);
            }
            this.positionGains.getIntegralGainMatrix(this.tempGainMatrix);
            this.tempGainMatrix.transform((Tuple3DBasics)linearFeedbackTermToPack);
            linearFeedbackTermToPack.changeFrame((ReferenceFrame)this.controlFrame);
        }
        double maximumAngularIntegralError = this.orientationGains.getMaximumIntegralError();
        if (maximumAngularIntegralError < 1.0E-5) {
            angularFeedbackTermToPack.setToZero((ReferenceFrame)this.controlFrame);
            this.yoErrorOrientationCumulated.setToZero(trajectoryFrame);
            this.yoErrorOrientationCumulated.setCommandId(this.currentCommandId);
            this.yoErrorRotationVectorIntegrated.setToZero(trajectoryFrame);
            this.yoErrorRotationVectorIntegrated.setCommandId(this.currentCommandId);
        } else {
            if (this.yoErrorOrientationCumulated.getReferenceFrame() != trajectoryFrame) {
                this.yoErrorOrientationCumulated.setToZero(trajectoryFrame);
                this.yoErrorRotationVectorIntegrated.setToZero(trajectoryFrame);
            }
            this.errorOrientationCumulated.setIncludingFrame((FrameQuaternionReadOnly)this.yoErrorOrientationCumulated);
            this.errorOrientationCumulated.multiply((FrameQuaternionReadOnly)this.yoErrorOrientation);
            this.yoErrorOrientationCumulated.set((FrameQuaternionReadOnly)this.errorOrientationCumulated);
            this.yoErrorOrientationCumulated.setCommandId(this.currentCommandId);
            this.errorOrientationCumulated.normalizeAndLimitToPi();
            this.errorOrientationCumulated.getRotationVector((FrameVector3DBasics)angularFeedbackTermToPack);
            angularFeedbackTermToPack.scale(this.dt);
            angularFeedbackTermToPack.changeFrame((ReferenceFrame)this.controlFrame);
            this.selectionMatrix.applyAngularSelection(angularFeedbackTermToPack);
            angularFeedbackTermToPack.clipToMaxLength(maximumAngularIntegralError);
            this.yoErrorRotationVectorIntegrated.setIncludingFrame((FrameTuple3DReadOnly)angularFeedbackTermToPack);
            this.yoErrorRotationVectorIntegrated.changeFrame(trajectoryFrame);
            this.yoErrorRotationVectorIntegrated.setCommandId(this.currentCommandId);
            if (this.angularGainsFrame != null) {
                angularFeedbackTermToPack.changeFrame(this.angularGainsFrame);
            } else {
                angularFeedbackTermToPack.changeFrame((ReferenceFrame)this.controlFrame);
            }
            this.orientationGains.getIntegralGainMatrix(this.tempGainMatrix);
            this.tempGainMatrix.transform((Tuple3DBasics)angularFeedbackTermToPack);
            angularFeedbackTermToPack.changeFrame((ReferenceFrame)this.controlFrame);
        }
    }

    protected void addCoriolisAcceleration(FrameVector3D linearAccelerationToModify) {
        this.controlFrame.getTwistRelativeToOther(this.controlBaseFrame, (TwistBasics)this.currentTwist);
        this.currentAngularVelocity.setIncludingFrame((FrameTuple3DReadOnly)this.currentTwist.getAngularPart());
        this.currentLinearVelocity.setIncludingFrame((FrameTuple3DReadOnly)this.currentTwist.getLinearPart());
        this.biasLinearAcceleration.setToZero((ReferenceFrame)this.controlFrame);
        this.biasLinearAcceleration.cross((FrameVector3DReadOnly)this.currentLinearVelocity, (FrameVector3DReadOnly)this.currentAngularVelocity);
        linearAccelerationToModify.changeFrame((ReferenceFrame)this.controlFrame);
        linearAccelerationToModify.add((FrameTuple3DReadOnly)this.biasLinearAcceleration);
    }

    protected void subtractCoriolisAcceleration(FrameVector3D linearAccelerationToModify) {
        ReferenceFrame originalFrame = linearAccelerationToModify.getReferenceFrame();
        this.controlFrame.getTwistRelativeToOther(this.controlBaseFrame, (TwistBasics)this.currentTwist);
        this.currentAngularVelocity.setIncludingFrame((FrameTuple3DReadOnly)this.currentTwist.getAngularPart());
        this.currentLinearVelocity.setIncludingFrame((FrameTuple3DReadOnly)this.currentTwist.getLinearPart());
        this.biasLinearAcceleration.setToZero((ReferenceFrame)this.controlFrame);
        this.biasLinearAcceleration.cross((FrameVector3DReadOnly)this.currentLinearVelocity, (FrameVector3DReadOnly)this.currentAngularVelocity);
        linearAccelerationToModify.changeFrame((ReferenceFrame)this.controlFrame);
        linearAccelerationToModify.sub((FrameTuple3DReadOnly)this.biasLinearAcceleration);
        linearAccelerationToModify.changeFrame(originalFrame);
    }

    protected void proccessInverseDynamicsDesiredAcceleration(MovingReferenceFrame controlFrame, FrameVector3D desiredAngularAcceleration, FrameVector3D desiredLinearAcceleration) {
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled.getBooleanValue();
    }

    public SpatialAccelerationCommand getInverseDynamicsOutput() {
        if (!this.isEnabled()) {
            throw new FeedbackControllerException("This controller is disabled.");
        }
        return this.inverseDynamicsOutput;
    }

    public SpatialVelocityCommand getInverseKinematicsOutput() {
        if (!this.isEnabled()) {
            throw new FeedbackControllerException("This controller is disabled.");
        }
        return this.inverseKinematicsOutput;
    }

    @Override
    public VirtualModelControlCommand<?> getVirtualModelControlOutput() {
        if (!this.isEnabled()) {
            throw new FeedbackControllerException("This controller is disabled.");
        }
        return this.isRootBody ? this.virtualModelControlRootOutput : this.virtualModelControlOutput;
    }

    public int getControllerIndex() {
        return this.controllerIndex;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": endEffector = " + this.endEffector;
    }
}

