/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.momentumBasedController.feedbackController.taskspace;

import us.ihmc.commonWalkingControlModules.controllerCore.FeedbackControllerException;
import us.ihmc.commonWalkingControlModules.controllerCore.FeedbackControllerToolbox;
import us.ihmc.commonWalkingControlModules.controllerCore.WholeBodyControlCoreToolbox;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.CenterOfMassFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.MomentumRateCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.MomentumCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.data.SpaceData3D;
import us.ihmc.commonWalkingControlModules.controllerCore.data.Type;
import us.ihmc.commonWalkingControlModules.momentumBasedController.feedbackController.FeedbackControllerInterface;
import us.ihmc.commonWalkingControlModules.momentumBasedController.feedbackController.FeedbackControllerSettings;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.mecano.algorithms.CentroidalMomentumRateCalculator;
import us.ihmc.mecano.spatial.interfaces.SpatialForceReadOnly;
import us.ihmc.robotics.controllers.pidGains.PID3DGainsReadOnly;
import us.ihmc.robotics.controllers.pidGains.YoPID3DGains;
import us.ihmc.robotics.math.filters.AlphaFilteredYoMutableFrameVector3D;
import us.ihmc.robotics.math.filters.RateLimitedYoMutableFrameVector3D;
import us.ihmc.robotics.screwTheory.SelectionMatrix6D;
import us.ihmc.yoVariables.providers.BooleanProvider;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class CenterOfMassFeedbackController
implements FeedbackControllerInterface {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final String shortName = "CenterOfMassFBController";
    private final YoRegistry registry = new YoRegistry("CenterOfMassFBController");
    private final YoBoolean isEnabled = new YoBoolean("isCenterOfMassFBControllerEnabled", this.registry);
    private final FramePoint3DBasics yoDesiredPosition;
    private final FramePoint3DBasics yoCurrentPosition;
    private final FrameVector3DBasics yoErrorPosition;
    private final FrameVector3DBasics yoErrorPositionIntegrated;
    private final FrameVector3DBasics yoDesiredLinearVelocity;
    private final FrameVector3DBasics yoCurrentLinearVelocity;
    private final FrameVector3DBasics yoErrorLinearVelocity;
    private final AlphaFilteredYoMutableFrameVector3D yoFilteredErrorLinearVelocity;
    private final FrameVector3DBasics yoFeedForwardLinearVelocity;
    private final FrameVector3DBasics yoFeedbackLinearVelocity;
    private final RateLimitedYoMutableFrameVector3D rateLimitedFeedbackLinearVelocity;
    private final FrameVector3DBasics yoDesiredLinearAcceleration;
    private final FrameVector3DBasics yoFeedForwardLinearAcceleration;
    private final FrameVector3DBasics yoFeedbackLinearAcceleration;
    private final RateLimitedYoMutableFrameVector3D rateLimitedFeedbackLinearAcceleration;
    private final FrameVector3DBasics yoAchievedLinearAcceleration;
    private final FrameVector3D desiredLinearVelocity = new FrameVector3D();
    private final FrameVector3D feedForwardLinearVelocity = new FrameVector3D();
    private final FrameVector3D desiredLinearAcceleration = new FrameVector3D();
    private final FrameVector3D feedForwardLinearAcceleration = new FrameVector3D();
    private final MomentumRateCommand inverseDynamicsOutput = new MomentumRateCommand();
    private final MomentumCommand inverseKinematicsOutput = new MomentumCommand();
    private final MomentumRateCommand virtualModelControlOutput = new MomentumRateCommand();
    private final SelectionMatrix6D selectionMatrix = new SelectionMatrix6D();
    private final YoPID3DGains gains;
    private final Matrix3D tempGainMatrix = new Matrix3D();
    private ReferenceFrame centerOfMassFrame;
    private CentroidalMomentumRateCalculator centroidalMomentumHandler;
    private final double dt;
    private final double totalRobotMass;
    private final boolean computeIntegralTerm;
    private final FrameVector3D proportionalFeedback = new FrameVector3D();
    private final FrameVector3D derivativeFeedback = new FrameVector3D();
    private final FrameVector3D integralFeedback = new FrameVector3D();

    public CenterOfMassFeedbackController(WholeBodyControlCoreToolbox toolbox, FeedbackControllerToolbox feedbackControllerToolbox, YoRegistry parentRegistry) {
        this.centerOfMassFrame = toolbox.getCenterOfMassFrame();
        this.centroidalMomentumHandler = toolbox.getCentroidalMomentumRateCalculator();
        this.totalRobotMass = toolbox.getTotalRobotMass();
        FeedbackControllerSettings settings = toolbox.getFeedbackControllerSettings();
        this.computeIntegralTerm = settings != null ? settings.enableIntegralTerm() : true;
        this.dt = toolbox.getControlDT();
        this.gains = feedbackControllerToolbox.getOrCreateCenterOfMassGains(this.computeIntegralTerm);
        YoDouble maximumRate = this.gains.getYoMaximumFeedbackRate();
        this.isEnabled.set(false);
        this.yoDesiredPosition = feedbackControllerToolbox.getOrCreateCenterOfMassPositionData(Type.DESIRED, (BooleanProvider)this.isEnabled);
        this.yoCurrentPosition = feedbackControllerToolbox.getOrCreateCenterOfMassPositionData(Type.CURRENT, (BooleanProvider)this.isEnabled);
        this.yoErrorPosition = feedbackControllerToolbox.getOrCreateCenterOfMassVectorData(Type.ERROR, SpaceData3D.POSITION, (BooleanProvider)this.isEnabled);
        this.yoErrorPositionIntegrated = this.computeIntegralTerm ? feedbackControllerToolbox.getOrCreateCenterOfMassVectorData(Type.ERROR_INTEGRATED, SpaceData3D.POSITION, (BooleanProvider)this.isEnabled) : null;
        this.yoDesiredLinearVelocity = feedbackControllerToolbox.getOrCreateCenterOfMassVectorData(Type.DESIRED, SpaceData3D.LINEAR_VELOCITY, (BooleanProvider)this.isEnabled);
        if (toolbox.isEnableInverseDynamicsModule() || toolbox.isEnableVirtualModelControlModule()) {
            this.yoCurrentLinearVelocity = feedbackControllerToolbox.getOrCreateCenterOfMassVectorData(Type.CURRENT, SpaceData3D.LINEAR_VELOCITY, (BooleanProvider)this.isEnabled);
            this.yoErrorLinearVelocity = feedbackControllerToolbox.getOrCreateCenterOfMassVectorData(Type.ERROR, SpaceData3D.LINEAR_VELOCITY, (BooleanProvider)this.isEnabled);
            DoubleProvider breakFrequency = feedbackControllerToolbox.getErrorVelocityFilterBreakFrequency("centerOfMass");
            this.yoFilteredErrorLinearVelocity = breakFrequency != null ? feedbackControllerToolbox.getOrCreateCenterOfMassAlphaFilteredVectorData(Type.ERROR, SpaceData3D.LINEAR_VELOCITY, this.dt, breakFrequency, (BooleanProvider)this.isEnabled) : null;
            this.yoDesiredLinearAcceleration = feedbackControllerToolbox.getOrCreateCenterOfMassVectorData(Type.DESIRED, SpaceData3D.LINEAR_ACCELERATION, (BooleanProvider)this.isEnabled);
            this.yoFeedForwardLinearAcceleration = feedbackControllerToolbox.getOrCreateCenterOfMassVectorData(Type.FEEDFORWARD, SpaceData3D.LINEAR_ACCELERATION, (BooleanProvider)this.isEnabled);
            this.yoFeedbackLinearAcceleration = feedbackControllerToolbox.getOrCreateCenterOfMassVectorData(Type.FEEDBACK, SpaceData3D.LINEAR_ACCELERATION, (BooleanProvider)this.isEnabled);
            this.rateLimitedFeedbackLinearAcceleration = feedbackControllerToolbox.getOrCreateCenterOfMassRateLimitedVectorData(Type.FEEDBACK, SpaceData3D.LINEAR_ACCELERATION, this.dt, maximumRate, (BooleanProvider)this.isEnabled);
            this.yoAchievedLinearAcceleration = feedbackControllerToolbox.getOrCreateCenterOfMassVectorData(Type.ACHIEVED, SpaceData3D.LINEAR_ACCELERATION, (BooleanProvider)this.isEnabled);
        } else {
            this.yoCurrentLinearVelocity = null;
            this.yoErrorLinearVelocity = null;
            this.yoFilteredErrorLinearVelocity = null;
            this.yoDesiredLinearAcceleration = null;
            this.yoFeedForwardLinearAcceleration = null;
            this.yoFeedbackLinearAcceleration = null;
            this.rateLimitedFeedbackLinearAcceleration = null;
            this.yoAchievedLinearAcceleration = null;
        }
        if (toolbox.isEnableInverseKinematicsModule()) {
            this.yoFeedbackLinearVelocity = feedbackControllerToolbox.getOrCreateCenterOfMassVectorData(Type.FEEDBACK, SpaceData3D.LINEAR_VELOCITY, (BooleanProvider)this.isEnabled);
            this.yoFeedForwardLinearVelocity = feedbackControllerToolbox.getOrCreateCenterOfMassVectorData(Type.FEEDFORWARD, SpaceData3D.LINEAR_VELOCITY, (BooleanProvider)this.isEnabled);
            this.rateLimitedFeedbackLinearVelocity = feedbackControllerToolbox.getOrCreateCenterOfMassRateLimitedVectorData(Type.FEEDBACK, SpaceData3D.LINEAR_VELOCITY, this.dt, maximumRate, (BooleanProvider)this.isEnabled);
        } else {
            this.yoFeedbackLinearVelocity = null;
            this.yoFeedForwardLinearVelocity = null;
            this.rateLimitedFeedbackLinearVelocity = null;
        }
        parentRegistry.addChild(this.registry);
    }

    public void submitFeedbackControlCommand(CenterOfMassFeedbackControlCommand command) {
        this.inverseDynamicsOutput.set(command.getMomentumRateCommand());
        this.gains.set((PID3DGainsReadOnly)command.getGains());
        command.getMomentumRateCommand().getSelectionMatrix(this.selectionMatrix);
        this.yoDesiredPosition.setIncludingFrame((FrameTuple3DReadOnly)command.getReferencePosition());
        this.yoDesiredLinearVelocity.setIncludingFrame((FrameTuple3DReadOnly)command.getReferenceLinearVelocity());
        this.yoDesiredLinearVelocity.checkReferenceFrameMatch((ReferenceFrameHolder)this.yoDesiredPosition);
        if (this.yoFeedForwardLinearVelocity != null) {
            this.yoFeedForwardLinearVelocity.setIncludingFrame((FrameTuple3DReadOnly)command.getReferenceLinearVelocity());
            this.yoFeedForwardLinearVelocity.checkReferenceFrameMatch((ReferenceFrameHolder)this.yoDesiredPosition);
        }
        if (this.yoFeedForwardLinearAcceleration != null) {
            this.yoFeedForwardLinearAcceleration.setIncludingFrame((FrameTuple3DReadOnly)command.getReferenceLinearAcceleration());
            this.yoFeedForwardLinearAcceleration.checkReferenceFrameMatch((ReferenceFrameHolder)this.yoDesiredPosition);
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.isEnabled.set(isEnabled);
    }

    @Override
    public void initialize() {
        if (this.rateLimitedFeedbackLinearAcceleration != null) {
            this.rateLimitedFeedbackLinearAcceleration.reset();
        }
        if (this.rateLimitedFeedbackLinearVelocity != null) {
            this.rateLimitedFeedbackLinearVelocity.reset();
        }
        if (this.yoFilteredErrorLinearVelocity != null) {
            this.yoFilteredErrorLinearVelocity.reset();
        }
        if (this.yoErrorPositionIntegrated != null) {
            this.yoErrorPositionIntegrated.setToZero(worldFrame);
        }
    }

    @Override
    public void computeInverseDynamics() {
        if (!this.isEnabled()) {
            return;
        }
        ReferenceFrame trajectoryFrame = this.yoDesiredPosition.getReferenceFrame();
        this.computeProportionalTerm(this.proportionalFeedback);
        this.computeDerivativeTerm(this.derivativeFeedback);
        this.computeIntegralTerm(this.integralFeedback);
        this.feedForwardLinearAcceleration.setIncludingFrame((FrameTuple3DReadOnly)this.yoFeedForwardLinearAcceleration);
        this.feedForwardLinearAcceleration.changeFrame(this.centerOfMassFrame);
        this.desiredLinearAcceleration.setIncludingFrame((FrameTuple3DReadOnly)this.proportionalFeedback);
        this.desiredLinearAcceleration.add((FrameTuple3DReadOnly)this.derivativeFeedback);
        this.desiredLinearAcceleration.add((FrameTuple3DReadOnly)this.integralFeedback);
        this.desiredLinearAcceleration.clipToMaxLength(this.gains.getMaximumFeedback());
        this.yoFeedbackLinearAcceleration.setIncludingFrame((FrameTuple3DReadOnly)this.desiredLinearAcceleration);
        this.yoFeedbackLinearAcceleration.changeFrame(trajectoryFrame);
        this.rateLimitedFeedbackLinearAcceleration.changeFrame(trajectoryFrame);
        this.rateLimitedFeedbackLinearAcceleration.update();
        this.desiredLinearAcceleration.setIncludingFrame((FrameTuple3DReadOnly)this.rateLimitedFeedbackLinearAcceleration);
        this.desiredLinearAcceleration.changeFrame(this.centerOfMassFrame);
        this.desiredLinearAcceleration.add((FrameTuple3DReadOnly)this.feedForwardLinearAcceleration);
        this.yoDesiredLinearAcceleration.setIncludingFrame((FrameTuple3DReadOnly)this.desiredLinearAcceleration);
        this.yoDesiredLinearAcceleration.changeFrame(trajectoryFrame);
        this.desiredLinearAcceleration.scale(this.totalRobotMass);
        this.desiredLinearAcceleration.changeFrame(worldFrame);
        this.inverseDynamicsOutput.setLinearMomentumRate(this.desiredLinearAcceleration);
    }

    @Override
    public void computeInverseKinematics() {
        if (!this.isEnabled()) {
            return;
        }
        this.inverseKinematicsOutput.setProperties(this.inverseDynamicsOutput);
        ReferenceFrame trajectoryFrame = this.yoDesiredPosition.getReferenceFrame();
        this.feedForwardLinearVelocity.setIncludingFrame((FrameTuple3DReadOnly)this.yoFeedForwardLinearVelocity);
        this.computeProportionalTerm(this.proportionalFeedback);
        this.computeIntegralTerm(this.integralFeedback);
        this.desiredLinearVelocity.setIncludingFrame((FrameTuple3DReadOnly)this.proportionalFeedback);
        this.desiredLinearVelocity.add((FrameTuple3DReadOnly)this.integralFeedback);
        this.desiredLinearVelocity.clipToMaxLength(this.gains.getMaximumFeedback());
        this.yoFeedbackLinearVelocity.setIncludingFrame((FrameTuple3DReadOnly)this.desiredLinearVelocity);
        this.yoFeedbackLinearVelocity.changeFrame(trajectoryFrame);
        this.rateLimitedFeedbackLinearVelocity.changeFrame(trajectoryFrame);
        this.rateLimitedFeedbackLinearVelocity.update();
        this.desiredLinearVelocity.setIncludingFrame((FrameTuple3DReadOnly)this.rateLimitedFeedbackLinearVelocity);
        this.desiredLinearVelocity.add((FrameTuple3DReadOnly)this.feedForwardLinearVelocity);
        this.yoDesiredLinearVelocity.setIncludingFrame((FrameTuple3DReadOnly)this.desiredLinearVelocity);
        this.yoDesiredLinearVelocity.changeFrame(trajectoryFrame);
        this.desiredLinearVelocity.scale(this.totalRobotMass);
        this.desiredLinearVelocity.changeFrame(worldFrame);
        this.inverseKinematicsOutput.setLinearMomentum((FrameVector3DReadOnly)this.desiredLinearVelocity);
    }

    @Override
    public void computeVirtualModelControl() {
        if (!this.isEnabled()) {
            return;
        }
        this.virtualModelControlOutput.set(this.inverseDynamicsOutput);
        ReferenceFrame trajectoryFrame = this.yoDesiredPosition.getReferenceFrame();
        this.computeProportionalTerm(this.proportionalFeedback);
        this.computeDerivativeTerm(this.derivativeFeedback);
        this.computeIntegralTerm(this.integralFeedback);
        this.feedForwardLinearAcceleration.setIncludingFrame((FrameTuple3DReadOnly)this.yoFeedForwardLinearAcceleration);
        this.feedForwardLinearAcceleration.changeFrame(this.centerOfMassFrame);
        this.desiredLinearAcceleration.setIncludingFrame((FrameTuple3DReadOnly)this.proportionalFeedback);
        this.desiredLinearAcceleration.add((FrameTuple3DReadOnly)this.derivativeFeedback);
        this.desiredLinearAcceleration.add((FrameTuple3DReadOnly)this.integralFeedback);
        this.desiredLinearAcceleration.clipToMaxLength(this.gains.getMaximumFeedback());
        this.yoFeedbackLinearAcceleration.setIncludingFrame((FrameTuple3DReadOnly)this.desiredLinearAcceleration);
        this.yoFeedbackLinearAcceleration.changeFrame(trajectoryFrame);
        this.rateLimitedFeedbackLinearAcceleration.changeFrame(trajectoryFrame);
        this.rateLimitedFeedbackLinearAcceleration.update();
        this.desiredLinearAcceleration.setIncludingFrame((FrameTuple3DReadOnly)this.rateLimitedFeedbackLinearAcceleration);
        this.desiredLinearAcceleration.changeFrame(this.centerOfMassFrame);
        this.desiredLinearAcceleration.add((FrameTuple3DReadOnly)this.feedForwardLinearAcceleration);
        this.yoDesiredLinearAcceleration.setIncludingFrame((FrameTuple3DReadOnly)this.desiredLinearAcceleration);
        this.yoDesiredLinearAcceleration.changeFrame(trajectoryFrame);
        this.desiredLinearAcceleration.scale(this.totalRobotMass);
        this.desiredLinearAcceleration.changeFrame(worldFrame);
        this.virtualModelControlOutput.setLinearMomentumRate(this.desiredLinearAcceleration);
    }

    @Override
    public void computeAchievedAcceleration() {
        SpatialForceReadOnly achievedMomentumRate = this.centroidalMomentumHandler.getMomentumRate();
        this.yoAchievedLinearAcceleration.setIncludingFrame((FrameTuple3DReadOnly)achievedMomentumRate.getLinearPart());
        this.yoAchievedLinearAcceleration.scale(1.0 / this.totalRobotMass);
        this.yoAchievedLinearAcceleration.changeFrame(this.yoDesiredPosition.getReferenceFrame());
    }

    private void computeProportionalTerm(FrameVector3D feedbackTermToPack) {
        ReferenceFrame trajectoryFrame = this.yoDesiredPosition.getReferenceFrame();
        this.yoCurrentPosition.setToZero(this.centerOfMassFrame);
        this.yoCurrentPosition.changeFrame(trajectoryFrame);
        feedbackTermToPack.setToZero(trajectoryFrame);
        feedbackTermToPack.sub((FrameTuple3DReadOnly)this.yoDesiredPosition, (FrameTuple3DReadOnly)this.yoCurrentPosition);
        this.selectionMatrix.applyLinearSelection(feedbackTermToPack);
        feedbackTermToPack.clipToMaxLength(this.gains.getMaximumProportionalError());
        this.yoErrorPosition.setIncludingFrame((FrameTuple3DReadOnly)feedbackTermToPack);
        this.yoErrorPosition.changeFrame(trajectoryFrame);
        feedbackTermToPack.changeFrame(this.centerOfMassFrame);
        this.gains.getProportionalGainMatrix(this.tempGainMatrix);
        this.tempGainMatrix.transform((Tuple3DBasics)feedbackTermToPack);
    }

    private void computeDerivativeTerm(FrameVector3D feedbackTermToPack) {
        ReferenceFrame trajectoryFrame = this.yoDesiredPosition.getReferenceFrame();
        this.yoCurrentLinearVelocity.setIncludingFrame((FrameTuple3DReadOnly)this.centroidalMomentumHandler.getCenterOfMassVelocity());
        this.yoCurrentLinearVelocity.changeFrame(trajectoryFrame);
        feedbackTermToPack.setToZero(trajectoryFrame);
        feedbackTermToPack.sub((FrameTuple3DReadOnly)this.yoDesiredLinearVelocity, (FrameTuple3DReadOnly)this.yoCurrentLinearVelocity);
        this.selectionMatrix.applyLinearSelection(feedbackTermToPack);
        feedbackTermToPack.clipToMaxLength(this.gains.getMaximumDerivativeError());
        this.yoErrorLinearVelocity.setIncludingFrame((FrameTuple3DReadOnly)feedbackTermToPack);
        this.yoErrorLinearVelocity.changeFrame(trajectoryFrame);
        if (this.yoFilteredErrorLinearVelocity != null) {
            if (this.yoFilteredErrorLinearVelocity.getReferenceFrame() != trajectoryFrame) {
                this.yoFilteredErrorLinearVelocity.setReferenceFrame(trajectoryFrame);
                this.yoFilteredErrorLinearVelocity.reset();
            }
            feedbackTermToPack.changeFrame(trajectoryFrame);
            this.yoFilteredErrorLinearVelocity.update();
            feedbackTermToPack.set((FrameTuple3DReadOnly)this.yoFilteredErrorLinearVelocity);
        }
        feedbackTermToPack.changeFrame(this.centerOfMassFrame);
        this.gains.getDerivativeGainMatrix(this.tempGainMatrix);
        this.tempGainMatrix.transform((Tuple3DBasics)feedbackTermToPack);
    }

    private void computeIntegralTerm(FrameVector3D feedbackTermToPack) {
        if (!this.computeIntegralTerm) {
            feedbackTermToPack.setToZero(this.centerOfMassFrame);
            return;
        }
        double maximumIntegralError = this.gains.getMaximumIntegralError();
        ReferenceFrame trajectoryFrame = this.yoDesiredPosition.getReferenceFrame();
        if (maximumIntegralError < 1.0E-5) {
            feedbackTermToPack.setToZero(this.centerOfMassFrame);
            this.yoErrorPositionIntegrated.setToZero(trajectoryFrame);
            return;
        }
        if (this.yoErrorPositionIntegrated.getReferenceFrame() != trajectoryFrame) {
            this.yoErrorPositionIntegrated.setToZero(trajectoryFrame);
        }
        feedbackTermToPack.setIncludingFrame((FrameTuple3DReadOnly)this.yoErrorPosition);
        feedbackTermToPack.scale(this.dt);
        feedbackTermToPack.add((FrameTuple3DReadOnly)this.yoErrorPositionIntegrated);
        this.selectionMatrix.applyLinearSelection(feedbackTermToPack);
        feedbackTermToPack.clipToMaxLength(maximumIntegralError);
        this.yoErrorPositionIntegrated.setIncludingFrame((FrameTuple3DReadOnly)feedbackTermToPack);
        this.yoErrorPositionIntegrated.changeFrame(trajectoryFrame);
        feedbackTermToPack.changeFrame(this.centerOfMassFrame);
        this.gains.getIntegralGainMatrix(this.tempGainMatrix);
        this.tempGainMatrix.transform((Tuple3DBasics)feedbackTermToPack);
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled.getBooleanValue();
    }

    public MomentumRateCommand getInverseDynamicsOutput() {
        if (!this.isEnabled()) {
            throw new FeedbackControllerException("This controller is disabled.");
        }
        return this.inverseDynamicsOutput;
    }

    public MomentumCommand getInverseKinematicsOutput() {
        if (!this.isEnabled()) {
            throw new FeedbackControllerException("This controller is disabled.");
        }
        return this.inverseKinematicsOutput;
    }

    public MomentumRateCommand getVirtualModelControlOutput() {
        if (!this.isEnabled()) {
            throw new FeedbackControllerException("This controller is disabled.");
        }
        return this.virtualModelControlOutput;
    }
}

