/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.momentumBasedController.feedbackController.jointspace;

import us.ihmc.commonWalkingControlModules.controllerCore.FeedbackControllerToolbox;
import us.ihmc.commonWalkingControlModules.controllerCore.WholeBodyControlCoreToolbox;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.OneDoFJointFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.JointspaceAccelerationCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.JointspaceVelocityCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.virtualModelControl.JointTorqueCommand;
import us.ihmc.commonWalkingControlModules.momentumBasedController.feedbackController.FeedbackControllerInterface;
import us.ihmc.commons.MathTools;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.robotics.controllers.pidGains.implementations.PDGains;
import us.ihmc.robotics.math.filters.AlphaFilteredYoVariable;
import us.ihmc.robotics.math.filters.RateLimitedYoVariable;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class OneDoFJointFeedbackController
implements FeedbackControllerInterface {
    public static final String shortName = "PDController";
    private final JointspaceAccelerationCommand inverseDynamicsOutput = new JointspaceAccelerationCommand();
    private final JointspaceVelocityCommand inverseKinematicsOutput = new JointspaceVelocityCommand();
    private final JointTorqueCommand virtualModelControlOutput = new JointTorqueCommand();
    private final OneDoFJointBasics joint;
    private final YoBoolean isEnabled;
    private final YoDouble qCurrent;
    private final YoDouble qDCurrent;
    private final YoDouble qDesired;
    private final YoDouble qDDesired;
    private final YoDouble qDFeedforward;
    private final YoDouble qDDFeedforward;
    private final YoDouble tauFeedforward;
    private final YoDouble qError;
    private final YoDouble qDError;
    private final AlphaFilteredYoVariable qDFilteredError;
    private final YoDouble maxFeedback;
    private final YoDouble maxFeedbackRate;
    private final YoDouble qDDFeedback;
    private final RateLimitedYoVariable qDDFeedbackRateLimited;
    private final YoDouble qDDDesired;
    private final YoDouble qDDAchieved;
    private final YoDouble tauFeedback;
    private final RateLimitedYoVariable tauFeedbackRateLimited;
    private final YoDouble tauDesired;
    private final YoDouble qDFeedback;
    private final RateLimitedYoVariable qDFeedbackRateLimited;
    private final YoDouble kp;
    private final YoDouble kd;
    private final YoDouble weightForSolver;

    public OneDoFJointFeedbackController(OneDoFJointBasics joint, WholeBodyControlCoreToolbox toolbox, FeedbackControllerToolbox feedbackControllerToolbox, YoRegistry parentRegistry) {
        String jointName = joint.getName();
        YoRegistry registry = new YoRegistry(jointName + shortName);
        this.joint = joint;
        this.isEnabled = new YoBoolean("control_enabled_" + jointName, registry);
        this.isEnabled.set(false);
        double dt = toolbox.getControlDT();
        this.qCurrent = new YoDouble("q_" + jointName, registry);
        this.qDesired = new YoDouble("q_d_" + jointName, registry);
        this.qError = new YoDouble("q_err_" + jointName, registry);
        this.qDDesired = new YoDouble("qd_d_" + jointName, registry);
        this.maxFeedback = new YoDouble("max_fb_" + jointName, registry);
        this.maxFeedbackRate = new YoDouble("max_fb_rate_" + jointName, registry);
        this.kp = new YoDouble("kp_" + jointName, registry);
        if (toolbox.isEnableInverseDynamicsModule() || toolbox.isEnableVirtualModelControlModule()) {
            this.qDCurrent = new YoDouble("qd_" + jointName, registry);
            this.qDError = new YoDouble("qd_err_" + jointName, registry);
            DoubleProvider breakFrequency = feedbackControllerToolbox.getErrorVelocityFilterBreakFrequency(jointName);
            if (breakFrequency != null) {
                DoubleProvider alpha = () -> AlphaFilteredYoVariable.computeAlphaGivenBreakFrequencyProperly((double)breakFrequency.getValue(), (double)dt);
                this.qDFilteredError = new AlphaFilteredYoVariable(jointName, registry, alpha, this.qDError);
            } else {
                this.qDFilteredError = null;
            }
            this.kd = new YoDouble("kd_" + jointName, registry);
            this.qDDFeedforward = new YoDouble("qdd_ff_" + jointName, registry);
            this.qDDFeedback = new YoDouble("qdd_fb_" + jointName, registry);
            this.qDDFeedbackRateLimited = new RateLimitedYoVariable("qdd_fb_rl_" + jointName, registry, (DoubleProvider)this.maxFeedbackRate, this.qDDFeedback, dt);
            this.qDDDesired = new YoDouble("qdd_d_" + jointName, registry);
            this.qDDAchieved = new YoDouble("qdd_achieved_" + jointName, registry);
        } else {
            this.qDCurrent = null;
            this.qDError = null;
            this.qDFilteredError = null;
            this.kd = null;
            this.qDDFeedforward = null;
            this.qDDFeedback = null;
            this.qDDFeedbackRateLimited = null;
            this.qDDDesired = null;
            this.qDDAchieved = null;
        }
        if (toolbox.isEnableInverseKinematicsModule()) {
            this.qDFeedforward = new YoDouble("qd_ff_" + jointName, registry);
            this.qDFeedback = new YoDouble("qd_fb_" + jointName, registry);
            this.qDFeedbackRateLimited = new RateLimitedYoVariable("qd_fb_rl_" + jointName, registry, (DoubleProvider)this.maxFeedbackRate, this.qDFeedback, dt);
        } else {
            this.qDFeedforward = null;
            this.qDFeedback = null;
            this.qDFeedbackRateLimited = null;
        }
        if (toolbox.isEnableVirtualModelControlModule()) {
            this.tauFeedback = new YoDouble("tau_fb_" + jointName, registry);
            this.tauFeedforward = new YoDouble("tau_ff_" + jointName, registry);
            this.tauFeedbackRateLimited = new RateLimitedYoVariable("tau_fb_rl_" + jointName, registry, (DoubleProvider)this.maxFeedbackRate, this.tauFeedback, dt);
            this.tauDesired = new YoDouble("tau_d_" + jointName, registry);
        } else {
            this.tauFeedback = null;
            this.tauFeedforward = null;
            this.tauFeedbackRateLimited = null;
            this.tauDesired = null;
        }
        this.weightForSolver = new YoDouble("weight_" + jointName, registry);
        this.weightForSolver.set(Double.POSITIVE_INFINITY);
        this.inverseDynamicsOutput.addJoint(joint, Double.NaN);
        this.inverseKinematicsOutput.addJoint(joint, Double.NaN);
        this.virtualModelControlOutput.addJoint(joint, Double.NaN);
        parentRegistry.addChild(registry);
    }

    @Override
    public void initialize() {
        if (this.qDDFeedbackRateLimited != null) {
            this.qDDFeedbackRateLimited.reset();
        }
        if (this.qDFilteredError != null) {
            this.qDFilteredError.reset();
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.isEnabled.set(isEnabled);
    }

    public void submitFeedbackControlCommand(OneDoFJointFeedbackControlCommand command) {
        this.weightForSolver.set(command.getWeightForSolver());
        PDGains gains = command.getGains();
        this.kp.set(gains.getKp());
        if (this.kd != null) {
            this.kd.set(gains.getKd());
        }
        this.maxFeedback.set(gains.getMaximumFeedback());
        this.maxFeedbackRate.set(gains.getMaximumFeedbackRate());
        this.qDesired.set(command.getReferencePosition());
        this.qDDesired.set(command.getReferenceVelocity());
        if (this.qDFeedforward != null) {
            this.qDFeedforward.set(command.getReferenceVelocity());
        }
        if (this.qDDFeedforward != null) {
            this.qDDFeedforward.set(command.getReferenceAcceleration());
        }
        if (this.tauFeedforward != null) {
            this.tauFeedforward.set(command.getReferenceEffort());
        }
    }

    @Override
    public void computeInverseDynamics() {
        if (!this.isEnabled.getBooleanValue()) {
            return;
        }
        this.qCurrent.set(this.joint.getQ());
        this.qDCurrent.set(this.joint.getQd());
        this.qError.set(this.qDesired.getDoubleValue() - this.qCurrent.getDoubleValue());
        this.qDError.set(this.qDDesired.getDoubleValue() - this.qDCurrent.getDoubleValue());
        double qDErrorToUse = this.qDError.getDoubleValue();
        if (this.qDFilteredError != null) {
            this.qDFilteredError.update();
            qDErrorToUse = this.qDFilteredError.getValue();
        }
        double qdd_fb = this.kp.getDoubleValue() * this.qError.getDoubleValue() + this.kd.getDoubleValue() * qDErrorToUse;
        qdd_fb = MathTools.clamp((double)qdd_fb, (double)this.maxFeedback.getDoubleValue());
        this.qDDFeedback.set(qdd_fb);
        this.qDDFeedbackRateLimited.update();
        this.qDDDesired.set(this.qDDFeedforward.getDoubleValue() + this.qDDFeedbackRateLimited.getDoubleValue());
        this.inverseDynamicsOutput.setOneDoFJointDesiredAcceleration(0, this.qDDDesired.getDoubleValue());
        this.inverseDynamicsOutput.setWeight(0, this.weightForSolver.getDoubleValue());
    }

    @Override
    public void computeInverseKinematics() {
        if (!this.isEnabled.getBooleanValue()) {
            return;
        }
        this.qCurrent.set(this.joint.getQ());
        this.qError.set(this.qDesired.getDoubleValue() - this.qCurrent.getDoubleValue());
        double qd_fb = this.kp.getDoubleValue() * this.qError.getDoubleValue();
        qd_fb = MathTools.clamp((double)qd_fb, (double)this.maxFeedback.getDoubleValue());
        this.qDFeedback.set(qd_fb);
        this.qDFeedbackRateLimited.update();
        this.qDDesired.set(this.qDFeedforward.getDoubleValue() + this.qDFeedbackRateLimited.getDoubleValue());
        this.inverseKinematicsOutput.setOneDoFJointDesiredVelocity(0, this.qDDesired.getDoubleValue());
        this.inverseKinematicsOutput.setWeight(0, this.weightForSolver.getDoubleValue());
    }

    @Override
    public void computeVirtualModelControl() {
        if (!this.isEnabled.getBooleanValue()) {
            return;
        }
        this.qCurrent.set(this.joint.getQ());
        this.qDCurrent.set(this.joint.getQd());
        this.qError.set(this.qDesired.getDoubleValue() - this.qCurrent.getDoubleValue());
        this.qDError.set(this.qDDesired.getDoubleValue() - this.qDCurrent.getDoubleValue());
        double qDErrorToUse = this.qDError.getDoubleValue();
        if (this.qDFilteredError != null) {
            this.qDFilteredError.update();
            qDErrorToUse = this.qDFilteredError.getValue();
        }
        double tau_fb = this.kp.getDoubleValue() * this.qError.getDoubleValue() + this.kd.getDoubleValue() * qDErrorToUse;
        tau_fb = MathTools.clamp((double)tau_fb, (double)this.maxFeedback.getDoubleValue());
        this.tauFeedback.set(tau_fb);
        this.tauFeedbackRateLimited.update();
        this.tauDesired.set(this.tauFeedforward.getValue() + this.tauFeedbackRateLimited.getDoubleValue());
        this.virtualModelControlOutput.setOneDoFJointDesiredTorque(0, this.tauDesired.getDoubleValue());
    }

    @Override
    public void computeAchievedAcceleration() {
        this.qDDAchieved.set(this.joint.getQdd());
    }

    public OneDoFJointBasics getJoint() {
        return this.joint;
    }

    public double getJointDesiredAcceleration() {
        return this.qDDDesired.getDoubleValue();
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled.getBooleanValue();
    }

    public JointspaceAccelerationCommand getInverseDynamicsOutput() {
        if (!this.isEnabled()) {
            throw new RuntimeException("This controller is disabled.");
        }
        return this.inverseDynamicsOutput;
    }

    public JointspaceVelocityCommand getInverseKinematicsOutput() {
        if (!this.isEnabled()) {
            throw new RuntimeException("This controller is disabled.");
        }
        return this.inverseKinematicsOutput;
    }

    public JointTorqueCommand getVirtualModelControlOutput() {
        if (!this.isEnabled()) {
            throw new RuntimeException("This controller is disabled.");
        }
        return this.virtualModelControlOutput;
    }
}

