/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.momentumBasedController;

import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.JointLimitEnforcementMethodCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.JointLimitReductionCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.lowLevel.LowLevelOneDoFJointDesiredDataHolder;
import us.ihmc.commonWalkingControlModules.controllerCore.command.virtualModelControl.JointLimitEnforcementCommand;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.JointIndexHandler;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.JointLimitEnforcement;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.JointLimitParameters;
import us.ihmc.commons.MathTools;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.robotics.kinematics.JointLimitData;
import us.ihmc.robotics.math.DeadbandTools;
import us.ihmc.robotics.math.filters.AlphaFilteredYoVariable;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputBasics;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class WholeBodyControllerBoundCalculator {
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final DMatrixRMaj jointsRangeOfMotion;
    private final DMatrixRMaj jointLowerLimits;
    private final DMatrixRMaj jointUpperLimits;
    private final JointLimitEnforcement[] jointLimitTypes;
    private final JointLimitParameters[] jointLimitParameters;
    private final JointLimitData[] jointLimitData;
    private final YoDouble[] filterAlphas;
    private final YoDouble[] velocityDeadbandSizes;
    private final YoDouble[] romMarginFractions;
    private final YoDouble[] velocityGains;
    private final AlphaFilteredYoVariable[] filteredLowerLimits;
    private final AlphaFilteredYoVariable[] filteredUpperLimits;
    private final YoDouble[] lowerHardLimits;
    private final YoDouble[] upperHardLimits;
    private final YoBoolean areJointVelocityLimitsConsidered = new YoBoolean("areJointVelocityLimitsConsidered", this.registry);
    private final JointIndexHandler jointIndexHandler;
    private final OneDoFJointBasics[] oneDoFJoints;
    private final double controlDT;

    public WholeBodyControllerBoundCalculator(JointIndexHandler jointIndexHandler, double controlDT, boolean considerJointVelocityLimits, YoRegistry parentRegistry) {
        this.controlDT = controlDT;
        this.jointIndexHandler = jointIndexHandler;
        this.oneDoFJoints = jointIndexHandler.getIndexedOneDoFJoints();
        int numberOfDoFs = jointIndexHandler.getNumberOfDoFs();
        this.jointsRangeOfMotion = new DMatrixRMaj(numberOfDoFs, 1);
        this.jointLowerLimits = new DMatrixRMaj(numberOfDoFs, 1);
        this.jointUpperLimits = new DMatrixRMaj(numberOfDoFs, 1);
        this.jointLimitTypes = new JointLimitEnforcement[numberOfDoFs];
        this.jointLimitParameters = new JointLimitParameters[numberOfDoFs];
        this.jointLimitData = new JointLimitData[numberOfDoFs];
        this.filterAlphas = new YoDouble[numberOfDoFs];
        this.velocityDeadbandSizes = new YoDouble[numberOfDoFs];
        this.romMarginFractions = new YoDouble[numberOfDoFs];
        this.velocityGains = new YoDouble[numberOfDoFs];
        this.filteredLowerLimits = new AlphaFilteredYoVariable[numberOfDoFs];
        this.filteredUpperLimits = new AlphaFilteredYoVariable[numberOfDoFs];
        this.lowerHardLimits = new YoDouble[numberOfDoFs];
        this.upperHardLimits = new YoDouble[numberOfDoFs];
        this.areJointVelocityLimitsConsidered.set(considerJointVelocityLimits);
        for (OneDoFJointBasics joint : jointIndexHandler.getIndexedOneDoFJoints()) {
            YoDouble velocityGain;
            int jointIndex = jointIndexHandler.getOneDoFJointIndex((OneDoFJointReadOnly)joint);
            double jointLimitLower = joint.getJointLimitLower();
            double jointLimitUpper = joint.getJointLimitUpper();
            this.jointsRangeOfMotion.set(jointIndex, 0, jointLimitUpper - jointLimitLower);
            this.jointLowerLimits.set(jointIndex, 0, jointLimitLower);
            this.jointUpperLimits.set(jointIndex, 0, jointLimitUpper);
            this.jointLimitTypes[jointIndex] = JointLimitEnforcement.DEFAULT;
            this.jointLimitParameters[jointIndex] = new JointLimitParameters();
            this.jointLimitData[jointIndex] = new JointLimitData();
            YoDouble filterAlpha = new YoDouble("joint_limit_filter_alpha_" + joint.getName(), parentRegistry);
            YoDouble velocityDeadband = new YoDouble("joint_limit_velocity_deadband" + joint.getName(), parentRegistry);
            YoDouble romMarginFraction = new YoDouble("joint_limit_rom_margin_fraction" + joint.getName(), parentRegistry);
            filterAlpha.set(AlphaFilteredYoVariable.computeAlphaGivenBreakFrequencyProperly((double)Double.POSITIVE_INFINITY, (double)controlDT));
            AlphaFilteredYoVariable filteredLowerLimit = new AlphaFilteredYoVariable("qdd_min_filter_" + joint.getName(), this.registry, (DoubleProvider)filterAlpha);
            AlphaFilteredYoVariable filteredUpperLimit = new AlphaFilteredYoVariable("qdd_max_filter_" + joint.getName(), this.registry, (DoubleProvider)filterAlpha);
            YoDouble hardLowerLimit = new YoDouble("qdd_min_hard_" + joint.getName(), this.registry);
            YoDouble hardUpperLimit = new YoDouble("qdd_max_hard_" + joint.getName(), this.registry);
            this.filterAlphas[jointIndex] = filterAlpha;
            this.velocityDeadbandSizes[jointIndex] = velocityDeadband;
            this.romMarginFractions[jointIndex] = romMarginFraction;
            this.filteredLowerLimits[jointIndex] = filteredLowerLimit;
            this.filteredUpperLimits[jointIndex] = filteredUpperLimit;
            this.lowerHardLimits[jointIndex] = hardLowerLimit;
            this.upperHardLimits[jointIndex] = hardUpperLimit;
            this.velocityGains[jointIndex] = velocityGain = new YoDouble("joint_limit_velocity_gain_" + joint.getName(), this.registry);
        }
        parentRegistry.addChild(this.registry);
    }

    public void considerJointVelocityLimits(boolean value) {
        this.areJointVelocityLimitsConsidered.set(value);
    }

    public void submitJointLimitReductionCommand(JointLimitReductionCommand command) {
        for (int commandJointIndex = 0; commandJointIndex < command.getNumberOfJoints(); ++commandJointIndex) {
            int jointIndex = this.jointIndexHandler.getOneDoFJointIndex((OneDoFJointReadOnly)command.getJoint(commandJointIndex));
            this.romMarginFractions[jointIndex].set(command.getJointLimitReductionFactor(commandJointIndex));
        }
    }

    public void submitJointLimitEnforcementMethodCommand(JointLimitEnforcementMethodCommand command) {
        for (int idx = 0; idx < command.getNumberOfJoints(); ++idx) {
            int jointIndex = this.jointIndexHandler.getOneDoFJointIndex((OneDoFJointReadOnly)command.getJoint(idx));
            this.jointLimitTypes[jointIndex] = command.getJointLimitReductionFactor(idx);
            JointLimitParameters params = command.getJointLimitParameters(idx);
            if (params == null) continue;
            this.jointLimitParameters[jointIndex].set(params);
            this.filterAlphas[jointIndex].set(AlphaFilteredYoVariable.computeAlphaGivenBreakFrequencyProperly((double)params.getJointLimitFilterBreakFrequency(), (double)this.controlDT));
            this.velocityGains[jointIndex].set(params.getVelocityControlGain());
            this.romMarginFractions[jointIndex].set(params.getRangeOfMotionMarginFraction());
            this.velocityDeadbandSizes[jointIndex].set(params.getVelocityDeadbandSize());
        }
    }

    public void submitJointLimitEnforcementCommand(JointLimitEnforcementCommand command) {
        for (int idx = 0; idx < command.getNumberOfJoints(); ++idx) {
            int jointIndex = this.jointIndexHandler.getOneDoFJointIndex((OneDoFJointReadOnly)command.getJoint(idx));
            JointLimitData data = command.getJointLimitData(idx);
            if (data == null) continue;
            this.jointLimitData[jointIndex].set(data);
        }
    }

    public void computeJointVelocityLimits(DMatrixRMaj qDotMinToPack, DMatrixRMaj qDotMaxToPack) {
        CommonOps_DDRM.fill((DMatrixD1)qDotMinToPack, (double)Double.NEGATIVE_INFINITY);
        CommonOps_DDRM.fill((DMatrixD1)qDotMaxToPack, (double)Double.POSITIVE_INFINITY);
        block4: for (OneDoFJointBasics joint : this.oneDoFJoints) {
            int jointIndex = this.jointIndexHandler.getOneDoFJointIndex((OneDoFJointReadOnly)joint);
            switch (this.jointLimitTypes[jointIndex]) {
                case DEFAULT: {
                    this.computeVelocityLimitDefault(joint, qDotMinToPack, qDotMaxToPack);
                    continue block4;
                }
                case NONE: {
                    continue block4;
                }
                default: {
                    throw new RuntimeException("Implement case!");
                }
            }
        }
    }

    private void computeVelocityLimitDefault(OneDoFJointBasics joint, DMatrixRMaj qDotMinToPack, DMatrixRMaj qDotMaxToPack) {
        double velocityLimitUpper;
        double velocityLimitLower;
        int index = this.jointIndexHandler.getOneDoFJointIndex((OneDoFJointReadOnly)joint);
        double jointLimitLower = this.jointLowerLimits.get(index, 0);
        double jointLimitUpper = this.jointUpperLimits.get(index, 0);
        double limitMargin = this.romMarginFractions[index].getDoubleValue() * (jointLimitUpper - jointLimitLower);
        jointLimitUpper -= limitMargin;
        jointLimitLower += limitMargin;
        if (this.areJointVelocityLimitsConsidered.getBooleanValue()) {
            velocityLimitLower = joint.getVelocityLimitLower();
            velocityLimitUpper = joint.getVelocityLimitUpper();
        } else {
            velocityLimitLower = Double.NEGATIVE_INFINITY;
            velocityLimitUpper = Double.POSITIVE_INFINITY;
        }
        if (!Double.isInfinite(jointLimitLower) || !Double.isInfinite(velocityLimitLower)) {
            double qDotMinFromFD = (jointLimitLower - joint.getQ()) / this.controlDT;
            double qDotMin = MathTools.clamp((double)qDotMinFromFD, (double)velocityLimitLower, (double)velocityLimitUpper);
            qDotMinToPack.set(index, 0, qDotMin);
        }
        if (!Double.isInfinite(jointLimitUpper) || !Double.isInfinite(velocityLimitUpper)) {
            double qDotMaxFromFD = (jointLimitUpper - joint.getQ()) / this.controlDT;
            double qDotMax = MathTools.clamp((double)qDotMaxFromFD, (double)velocityLimitLower, (double)velocityLimitUpper);
            qDotMaxToPack.set(index, 0, qDotMax);
        }
    }

    public void computeJointAccelerationLimits(double absoluteMaximumJointAcceleration, DMatrixRMaj qDDotMinToPack, DMatrixRMaj qDDotMaxToPack) {
        CommonOps_DDRM.fill((DMatrixD1)qDDotMinToPack, (double)Double.NEGATIVE_INFINITY);
        CommonOps_DDRM.fill((DMatrixD1)qDDotMaxToPack, (double)Double.POSITIVE_INFINITY);
        block5: for (OneDoFJointBasics joint : this.oneDoFJoints) {
            int jointIndex = this.jointIndexHandler.getOneDoFJointIndex((OneDoFJointReadOnly)joint);
            switch (this.jointLimitTypes[jointIndex]) {
                case DEFAULT: {
                    this.computeAccelerationLimitDefault(joint, absoluteMaximumJointAcceleration, qDDotMinToPack, qDDotMaxToPack);
                    continue block5;
                }
                case RESTRICTIVE: {
                    this.computeAccelerationLimitRestrictive(joint, absoluteMaximumJointAcceleration, qDDotMinToPack, qDDotMaxToPack);
                    continue block5;
                }
                case NONE: {
                    continue block5;
                }
                default: {
                    throw new RuntimeException("Implement case!");
                }
            }
        }
    }

    private void computeAccelerationLimitDefault(OneDoFJointBasics joint, double absoluteMaximumJointAcceleration, DMatrixRMaj qDDotMinToPack, DMatrixRMaj qDDotMaxToPack) {
        double velocityLimitUpper;
        double velocityLimitLower;
        int index = this.jointIndexHandler.getOneDoFJointIndex((OneDoFJointReadOnly)joint);
        double jointLimitLower = this.jointLowerLimits.get(index, 0);
        double jointLimitUpper = this.jointUpperLimits.get(index, 0);
        double limitMargin = this.romMarginFractions[index].getDoubleValue() * (jointLimitUpper - jointLimitLower);
        jointLimitUpper -= limitMargin;
        jointLimitLower += limitMargin;
        double qDDotMin = Double.NEGATIVE_INFINITY;
        double qDDotMax = Double.POSITIVE_INFINITY;
        if (this.areJointVelocityLimitsConsidered.getBooleanValue()) {
            velocityLimitLower = joint.getVelocityLimitLower();
            velocityLimitUpper = joint.getVelocityLimitUpper();
        } else {
            velocityLimitLower = Double.NEGATIVE_INFINITY;
            velocityLimitUpper = Double.POSITIVE_INFINITY;
        }
        double brakeVelocity = DeadbandTools.applyDeadband((double)this.velocityDeadbandSizes[index].getDoubleValue(), (double)joint.getQd());
        if (!Double.isInfinite(jointLimitLower) || !Double.isInfinite(velocityLimitLower)) {
            double qDotMinFromFD = (jointLimitLower - joint.getQ()) / this.controlDT;
            double qDotMin = MathTools.clamp((double)qDotMinFromFD, (double)velocityLimitLower, (double)velocityLimitUpper);
            qDDotMin = 2.0 * (qDotMin - brakeVelocity) / this.controlDT;
            qDDotMin = MathTools.clamp((double)qDDotMin, (double)(-absoluteMaximumJointAcceleration), (double)0.0);
            qDDotMinToPack.set(index, 0, qDDotMin);
            this.lowerHardLimits[index].set(qDDotMin);
        }
        if (!Double.isInfinite(jointLimitUpper) || !Double.isInfinite(velocityLimitUpper)) {
            double qDotMaxFromFD = (jointLimitUpper - joint.getQ()) / this.controlDT;
            double qDotMax = MathTools.clamp((double)qDotMaxFromFD, (double)velocityLimitLower, (double)velocityLimitUpper);
            qDDotMax = 2.0 * (qDotMax - brakeVelocity) / this.controlDT;
            qDDotMax = MathTools.clamp((double)qDDotMax, (double)-0.0, (double)absoluteMaximumJointAcceleration);
            qDDotMaxToPack.set(index, 0, qDDotMax);
            this.upperHardLimits[index].set(qDDotMax);
        }
    }

    private void computeAccelerationLimitRestrictive(OneDoFJointBasics joint, double absoluteMaximumJointAcceleration, DMatrixRMaj qDDotMinToPack, DMatrixRMaj qDDotMaxToPack) {
        double distance;
        double velocityLimitUpper;
        double velocityLimitLower;
        int index = this.jointIndexHandler.getOneDoFJointIndex((OneDoFJointReadOnly)joint);
        double jointLimitLower = this.jointLowerLimits.get(index, 0);
        double jointLimitUpper = this.jointUpperLimits.get(index, 0);
        double limitMargin = this.romMarginFractions[index].getDoubleValue() * (jointLimitUpper - jointLimitLower);
        jointLimitUpper -= limitMargin;
        jointLimitLower += limitMargin;
        if (this.areJointVelocityLimitsConsidered.getBooleanValue()) {
            velocityLimitLower = joint.getVelocityLimitLower();
            velocityLimitUpper = joint.getVelocityLimitUpper();
        } else {
            velocityLimitLower = Double.NEGATIVE_INFINITY;
            velocityLimitUpper = Double.POSITIVE_INFINITY;
        }
        double qDDotMin = -absoluteMaximumJointAcceleration;
        double qDDotMax = absoluteMaximumJointAcceleration;
        JointLimitParameters params = this.jointLimitParameters[index];
        double brakeVelocity = DeadbandTools.applyDeadband((double)this.velocityDeadbandSizes[index].getDoubleValue(), (double)joint.getQd());
        double slope = params.getMaxAbsJointVelocity() / Math.pow(params.getJointLimitDistanceForMaxVelocity(), 2.0);
        double maxBrakeAcceleration = 0.99 * absoluteMaximumJointAcceleration;
        if (!Double.isInfinite(jointLimitLower) || !Double.isInfinite(velocityLimitLower)) {
            distance = joint.getQ() - jointLimitLower;
            distance = Math.max(0.0, distance);
            double qDotMinFromFD = -Math.pow(distance, 2.0) * slope;
            double qDotMin = MathTools.clamp((double)qDotMinFromFD, (double)velocityLimitLower, (double)velocityLimitUpper);
            qDDotMin = (qDotMin - brakeVelocity) * this.velocityGains[index].getDoubleValue();
            qDDotMin = MathTools.clamp((double)qDDotMin, (double)(-absoluteMaximumJointAcceleration), (double)maxBrakeAcceleration);
        }
        if (!Double.isInfinite(jointLimitUpper) || !Double.isInfinite(velocityLimitUpper)) {
            distance = jointLimitUpper - joint.getQ();
            distance = Math.max(0.0, distance);
            double qDotMaxFromFD = Math.pow(distance, 2.0) * slope;
            double qDotMax = MathTools.clamp((double)qDotMaxFromFD, (double)velocityLimitLower, (double)velocityLimitUpper);
            qDDotMax = (qDotMax - brakeVelocity) * this.velocityGains[index].getDoubleValue();
            qDDotMax = MathTools.clamp((double)qDDotMax, (double)(-maxBrakeAcceleration), (double)absoluteMaximumJointAcceleration);
        }
        this.filteredLowerLimits[index].update(qDDotMin);
        this.filteredUpperLimits[index].update(qDDotMax);
        qDDotMinToPack.set(index, 0, this.filteredLowerLimits[index].getDoubleValue());
        qDDotMaxToPack.set(index, 0, this.filteredUpperLimits[index].getDoubleValue());
    }

    public void enforceJointTorqueLimits(LowLevelOneDoFJointDesiredDataHolder jointDesiredOutputList) {
        for (OneDoFJointBasics joint : this.oneDoFJoints) {
            JointDesiredOutputBasics jointDesiredOutput = jointDesiredOutputList.getJointDesiredOutput((OneDoFJointReadOnly)joint);
            int jointIndex = this.jointIndexHandler.getOneDoFJointIndex((OneDoFJointReadOnly)joint);
            if (jointIndex >= this.jointLimitData.length || this.jointLimitData[jointIndex] == null) continue;
            JointLimitData jointLimitData = this.jointLimitData[jointIndex];
            this.enforceJointTorqueLimit(joint, jointDesiredOutput, jointLimitData);
        }
    }

    private void enforceJointTorqueLimit(OneDoFJointBasics joint, JointDesiredOutputBasics jointDesiredOutput, JointLimitData jointLimitData) {
        double dampingTorque;
        double stiffnessTorque;
        double torque = !jointDesiredOutput.hasDesiredTorque() ? 0.0 : jointDesiredOutput.getDesiredTorque();
        if (!jointLimitData.hasPositionSoftLowerLimit() && joint.getQ() < jointLimitData.getPositionSoftLowerLimit()) {
            stiffnessTorque = 0.0;
            if (jointLimitData.hasPositionLimitStiffness()) {
                stiffnessTorque = jointLimitData.getJointLimitStiffness() * (jointLimitData.getPositionSoftLowerLimit() - joint.getQ());
            }
            dampingTorque = 0.0;
            if (jointLimitData.hasPositionLimitDamping()) {
                dampingTorque = jointLimitData.getJointLimitDamping() * joint.getQd();
            }
            torque = Math.max(torque, stiffnessTorque - dampingTorque);
        }
        if (!jointLimitData.hasPositionSoftUpperLimit() && joint.getQ() > jointLimitData.getPositionSoftUpperLimit()) {
            stiffnessTorque = 0.0;
            if (jointLimitData.hasPositionLimitStiffness()) {
                stiffnessTorque = jointLimitData.getJointLimitStiffness() * (jointLimitData.getPositionSoftUpperLimit() - joint.getQ());
            }
            dampingTorque = 0.0;
            if (jointLimitData.hasPositionLimitDamping()) {
                dampingTorque = jointLimitData.getJointLimitDamping() * joint.getQd();
            }
            torque = Math.min(torque, stiffnessTorque - dampingTorque);
        }
        if (jointLimitData.hasTorqueUpperLimit()) {
            torque = Math.min(torque, jointLimitData.getTorqueUpperLimit());
        }
        if (jointLimitData.hasTorqueLowerLimit()) {
            torque = Math.max(torque, jointLimitData.getTorqueLowerLimit());
        }
        jointDesiredOutput.setDesiredTorque(torque);
    }
}

