/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.modelPredictiveController.visualization;

import us.ihmc.commonWalkingControlModules.modelPredictiveController.SE3ModelPredictiveController;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.visualization.BagOfEllipses;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.visualization.LinearMPCTrajectoryViewer;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.yoVariables.registry.YoRegistry;

public class SE3MPCTrajectoryViewer
extends LinearMPCTrajectoryViewer {
    private static final int numberOfVectors = 100;
    private static final double dt = 0.1;
    private static final double tallAxis = 0.1;
    private static final double wideAxis = 0.075;
    private static final double forwardAxis = 0.05;
    private static final Vector3D radii = new Vector3D(0.05, 0.075, 0.1);
    private final BagOfEllipses orientationTrajectoryVectors;
    private final FramePoint3D comPositionToThrowAway = new FramePoint3D();
    private final FrameVector3D comVelocityToThrowAway = new FrameVector3D();
    private final FrameVector3D comAccelerationToThrowAway = new FrameVector3D();
    private final FramePoint3D dcmPositionToThrowAway = new FramePoint3D();
    private final FrameVector3D dcmVelocityToThrowAway = new FrameVector3D();
    private final FramePoint3D vrpPositionToThrowAway = new FramePoint3D();
    private final FrameVector3D vrpVelocityToThrowAway = new FrameVector3D();
    private final FramePoint3D ecmpPositionToThrowAway = new FramePoint3D();
    private final FrameQuaternion orientation = new FrameQuaternion();

    public SE3MPCTrajectoryViewer(YoRegistry registry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        super(registry, yoGraphicsListRegistry);
        AppearanceDefinition orientationAppearance = YoAppearance.Green();
        orientationAppearance.setTransparency(0.8);
        this.orientationTrajectoryVectors = new BagOfEllipses(100, "Orientation", orientationAppearance, registry, yoGraphicsListRegistry);
    }

    public void compute(SE3ModelPredictiveController mpc, double currentTimeInState) {
        super.compute(mpc, currentTimeInState);
        this.orientationTrajectoryVectors.reset();
        int max = Math.min(100, 7);
        for (int i = 0; i < max; ++i) {
            double time = 0.1 * (double)i + currentTimeInState;
            mpc.compute(time, (FixedFramePoint3DBasics)this.comPositionToThrowAway, (FixedFrameVector3DBasics)this.comVelocityToThrowAway, (FixedFrameVector3DBasics)this.comAccelerationToThrowAway, (FixedFramePoint3DBasics)this.dcmPositionToThrowAway, (FixedFrameVector3DBasics)this.dcmVelocityToThrowAway, (FixedFramePoint3DBasics)this.vrpPositionToThrowAway, (FixedFrameVector3DBasics)this.vrpVelocityToThrowAway, (FixedFramePoint3DBasics)this.ecmpPositionToThrowAway);
            this.orientation.set(mpc.getDesiredBodyOrientationSolution());
            this.orientationTrajectoryVectors.setEllipseLoop((FramePoint3DReadOnly)this.comPositionToThrowAway, (FrameQuaternionReadOnly)this.orientation, radii);
        }
    }
}

