/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.modelPredictiveController.visualization;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.ContactStateProvider;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.ioHandling.LinearMPCTrajectoryHandler;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPosition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.registry.YoRegistry;

public class MPCCornerPointViewer {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private static final double size = 0.0075;
    private static final int maxPoints = 20;
    private final List<YoFramePoint3D> dcmStartPoints = new ArrayList<YoFramePoint3D>();
    private final List<YoFramePoint3D> dcmEndPoints = new ArrayList<YoFramePoint3D>();
    private final List<YoFramePoint3D> comStartPoints = new ArrayList<YoFramePoint3D>();
    private final List<YoFramePoint3D> comEndPoints = new ArrayList<YoFramePoint3D>();
    private final List<YoFramePoint3D> vrpStartPoints = new ArrayList<YoFramePoint3D>();
    private final List<YoFramePoint3D> vrpEndPoints = new ArrayList<YoFramePoint3D>();
    private static final String name = "Corner Points";

    public MPCCornerPointViewer(YoRegistry registry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this(false, true, registry, yoGraphicsListRegistry);
    }

    public MPCCornerPointViewer(boolean artifactsOnly, boolean viewCoM, YoRegistry registry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        for (int i = 0; i < 20; ++i) {
            YoFramePoint3D dcmStartPoint = new YoFramePoint3D("dcmStartPoint" + i, worldFrame, registry);
            YoFramePoint3D dcmEndPoint = new YoFramePoint3D("dcmEndPoint" + i, worldFrame, registry);
            YoFramePoint3D vrpStartPoint = new YoFramePoint3D("vrpStartPoint" + i, worldFrame, registry);
            YoFramePoint3D vrpEndPoint = new YoFramePoint3D("vrpEndPoint" + i, worldFrame, registry);
            dcmStartPoint.setToNaN();
            dcmEndPoint.setToNaN();
            vrpStartPoint.setToNaN();
            vrpEndPoint.setToNaN();
            this.dcmStartPoints.add(dcmStartPoint);
            this.dcmEndPoints.add(dcmEndPoint);
            this.vrpStartPoints.add(vrpStartPoint);
            this.vrpEndPoints.add(vrpEndPoint);
            YoGraphicPosition dcmStartPointGraphic = new YoGraphicPosition("dcmStartPoint" + i, dcmEndPoint, 0.0075, YoAppearance.Blue(), YoGraphicPosition.GraphicType.BALL_WITH_CROSS);
            YoGraphicPosition dcmEndPointGraphic = new YoGraphicPosition("dcmEndPoint" + i, dcmEndPoint, 0.0075, YoAppearance.Blue(), YoGraphicPosition.GraphicType.BALL_WITH_CROSS);
            YoGraphicPosition vrpStartPointGraphic = new YoGraphicPosition("vrpStartPoint" + i, vrpStartPoint, 0.0075, YoAppearance.Green(), YoGraphicPosition.GraphicType.BALL);
            YoGraphicPosition vrpEndPointGraphic = new YoGraphicPosition("vrpEndPoint" + i, vrpEndPoint, 0.0075, YoAppearance.Green(), YoGraphicPosition.GraphicType.SOLID_BALL);
            if (!artifactsOnly) {
                yoGraphicsListRegistry.registerYoGraphic(name, (YoGraphic)dcmStartPointGraphic);
                yoGraphicsListRegistry.registerYoGraphic(name, (YoGraphic)dcmEndPointGraphic);
                yoGraphicsListRegistry.registerYoGraphic(name, (YoGraphic)vrpStartPointGraphic);
                yoGraphicsListRegistry.registerYoGraphic(name, (YoGraphic)vrpEndPointGraphic);
            }
            yoGraphicsListRegistry.registerArtifact(name, (Artifact)dcmStartPointGraphic.createArtifact());
            yoGraphicsListRegistry.registerArtifact(name, (Artifact)dcmEndPointGraphic.createArtifact());
            yoGraphicsListRegistry.registerArtifact(name, (Artifact)vrpStartPointGraphic.createArtifact());
            yoGraphicsListRegistry.registerArtifact(name, (Artifact)vrpEndPointGraphic.createArtifact());
            if (!viewCoM) continue;
            YoFramePoint3D comStartPoint = new YoFramePoint3D("comStartPoint" + i, worldFrame, registry);
            YoFramePoint3D comEndPoint = new YoFramePoint3D("comEndPoint" + i, worldFrame, registry);
            comStartPoint.setToNaN();
            comEndPoint.setToNaN();
            this.comStartPoints.add(comStartPoint);
            this.comEndPoints.add(comEndPoint);
            YoGraphicPosition comStartPointGraphic = new YoGraphicPosition("comStartPoint" + i, comStartPoint, 0.0075, YoAppearance.Black(), YoGraphicPosition.GraphicType.BALL);
            YoGraphicPosition comEndPointGraphic = new YoGraphicPosition("comEndPoint" + i, comStartPoint, 0.0075, YoAppearance.Black(), YoGraphicPosition.GraphicType.SOLID_BALL);
            yoGraphicsListRegistry.registerArtifact(name, (Artifact)comStartPointGraphic.createArtifact());
            yoGraphicsListRegistry.registerArtifact(name, (Artifact)comEndPointGraphic.createArtifact());
            if (artifactsOnly) continue;
            yoGraphicsListRegistry.registerYoGraphic(name, (YoGraphic)comStartPointGraphic);
            yoGraphicsListRegistry.registerYoGraphic(name, (YoGraphic)comEndPointGraphic);
        }
    }

    public void updateCornerPoints(LinearMPCTrajectoryHandler trajectoryHandler, List<? extends ContactStateProvider> contactSequence) {
        int segmentId;
        for (segmentId = 0; segmentId < Math.min(contactSequence.size(), this.comStartPoints.size()); ++segmentId) {
            double startTime = contactSequence.get(segmentId).getTimeInterval().getStartTime();
            double endTime = Math.min(contactSequence.get(segmentId).getTimeInterval().getEndTime(), startTime + 5.0);
            trajectoryHandler.compute(startTime += 1.0E-6);
            this.comStartPoints.get(segmentId).set((FrameTuple3DReadOnly)trajectoryHandler.getDesiredCoMPosition());
            this.dcmStartPoints.get(segmentId).set((FrameTuple3DReadOnly)trajectoryHandler.getDesiredDCMPosition());
            this.vrpStartPoints.get(segmentId).set((FrameTuple3DReadOnly)trajectoryHandler.getDesiredVRPPosition());
            trajectoryHandler.compute(endTime -= 1.0E-6);
            this.comEndPoints.get(segmentId).set((FrameTuple3DReadOnly)trajectoryHandler.getDesiredCoMPosition());
            this.dcmEndPoints.get(segmentId).set((FrameTuple3DReadOnly)trajectoryHandler.getDesiredDCMPosition());
            this.vrpEndPoints.get(segmentId).set((FrameTuple3DReadOnly)trajectoryHandler.getDesiredVRPPosition());
        }
        while (segmentId < this.dcmStartPoints.size()) {
            this.comStartPoints.get(segmentId).setToNaN();
            this.comEndPoints.get(segmentId).setToNaN();
            this.dcmStartPoints.get(segmentId).setToNaN();
            this.dcmEndPoints.get(segmentId).setToNaN();
            this.vrpStartPoints.get(segmentId).setToNaN();
            this.vrpEndPoints.get(segmentId).setToNaN();
            ++segmentId;
        }
    }
}

