/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.modelPredictiveController.visualization;

import us.ihmc.commonWalkingControlModules.modelPredictiveController.EuclideanModelPredictiveController;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.visualization.BagOfVectors;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.yoVariables.registry.YoRegistry;

public class LinearMPCTrajectoryViewer {
    private static final int numberOfVectors = 100;
    private static final double dt = 0.05;
    private static final double ballSize = 0.005;
    private final BagOfVectors comTrajectoryVectors;
    private final BagOfVectors dcmTrajectoryVectors;
    private final BagOfVectors vrpTrajectoryVectors;
    private final FramePoint3D comPositionToThrowAway = new FramePoint3D();
    private final FrameVector3D comVelocityToThrowAway = new FrameVector3D();
    private final FrameVector3D comAccelerationToThrowAway = new FrameVector3D();
    private final FramePoint3D dcmPositionToThrowAway = new FramePoint3D();
    private final FrameVector3D dcmVelocityToThrowAway = new FrameVector3D();
    private final FramePoint3D vrpPositionToThrowAway = new FramePoint3D();
    private final FrameVector3D vrpVelocityToThrowAway = new FrameVector3D();
    private final FramePoint3D ecmpPositionToThrowAway = new FramePoint3D();

    public LinearMPCTrajectoryViewer(YoRegistry registry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this.comTrajectoryVectors = new BagOfVectors(100, 0.05, 0.005, "CoM", YoAppearance.Black(), registry, yoGraphicsListRegistry);
        this.dcmTrajectoryVectors = new BagOfVectors(100, 0.05, 0.005, "DCM", YoAppearance.Yellow(), registry, yoGraphicsListRegistry);
        this.vrpTrajectoryVectors = new BagOfVectors(100, 0.05, 0.005, "VRP", YoAppearance.Green(), registry, yoGraphicsListRegistry);
        AppearanceDefinition orientationAppearance = YoAppearance.Green();
        orientationAppearance.setTransparency(0.8);
    }

    public void compute(EuclideanModelPredictiveController mpc, double currentTimeInState) {
        this.comTrajectoryVectors.reset();
        this.dcmTrajectoryVectors.reset();
        this.vrpTrajectoryVectors.reset();
        int max = Math.min(100, 15);
        for (int i = 0; i < max; ++i) {
            double time = 0.05 * (double)i + currentTimeInState;
            mpc.compute(time, (FixedFramePoint3DBasics)this.comPositionToThrowAway, (FixedFrameVector3DBasics)this.comVelocityToThrowAway, (FixedFrameVector3DBasics)this.comAccelerationToThrowAway, (FixedFramePoint3DBasics)this.dcmPositionToThrowAway, (FixedFrameVector3DBasics)this.dcmVelocityToThrowAway, (FixedFramePoint3DBasics)this.vrpPositionToThrowAway, (FixedFrameVector3DBasics)this.vrpVelocityToThrowAway, (FixedFramePoint3DBasics)this.ecmpPositionToThrowAway);
            this.dcmTrajectoryVectors.setVector((FramePoint3DReadOnly)this.dcmPositionToThrowAway, (FrameVector3DReadOnly)this.dcmVelocityToThrowAway);
            this.vrpTrajectoryVectors.setVector((FramePoint3DReadOnly)this.vrpPositionToThrowAway, (FrameVector3DReadOnly)this.vrpVelocityToThrowAway);
            this.comTrajectoryVectors.setVector((FramePoint3DReadOnly)this.comPositionToThrowAway, (FrameVector3DReadOnly)this.comVelocityToThrowAway);
        }
    }
}

