/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.modelPredictiveController.visualization;

import us.ihmc.commonWalkingControlModules.modelPredictiveController.visualization.ContactPointForceViewer;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;

public class ContactPlaneForceViewer {
    static final double scale = 0.05;
    private final int numberOfBasesPerContact;
    private final YoFramePoint3D position;
    private final YoFrameVector3D magnitude;
    private final String prefix;
    private final YoRegistry registry;
    private final YoGraphicsListRegistry graphicsListRegistry;
    int pointNumber = 0;

    public ContactPlaneForceViewer(String prefix, int numberOfBasesPerContact, YoRegistry registry, YoGraphicsListRegistry graphicsListRegistry) {
        this.prefix = prefix;
        this.numberOfBasesPerContact = numberOfBasesPerContact;
        this.registry = registry;
        this.graphicsListRegistry = graphicsListRegistry;
        this.position = new YoFramePoint3D(prefix + "TotalContactPosition", ReferenceFrame.getWorldFrame(), registry);
        this.magnitude = new YoFrameVector3D(prefix + "TotalContactAcceleration", ReferenceFrame.getWorldFrame(), registry);
    }

    public ContactPointForceViewer getNextPointForceViewer() {
        return new ContactPointForceViewer(this.prefix + this.pointNumber++, this.numberOfBasesPerContact, this.registry, this.graphicsListRegistry);
    }

    public void reset() {
        this.position.setToNaN();
        this.magnitude.setToNaN();
    }

    public void update(FramePoint3DReadOnly position, FrameVector3DReadOnly magnitude) {
        this.position.setMatchingFrame((FrameTuple3DReadOnly)position);
        this.magnitude.setMatchingFrame((FrameTuple3DReadOnly)magnitude);
    }
}

