/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.modelPredictiveController.tools;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.matrixlib.MatrixTools;
import us.ihmc.matrixlib.NativeMatrix;

public class EfficientMatrixExponentialCalculator {
    private int rows;
    private int Bcols;
    private int Ccols;
    private final NativeMatrix temp = new NativeMatrix(0, 0);
    private final NativeMatrix As = new NativeMatrix(0, 0);
    private final NativeMatrix Bs = new NativeMatrix(0, 0);
    private final NativeMatrix Cs = new NativeMatrix(0, 0);
    private final NativeMatrix As_2 = new NativeMatrix(0, 0);
    private final NativeMatrix Bs_2 = new NativeMatrix(0, 0);
    private final NativeMatrix Cs_2 = new NativeMatrix(0, 0);
    private final NativeMatrix As_4 = new NativeMatrix(0, 0);
    private final NativeMatrix Bs_4 = new NativeMatrix(0, 0);
    private final NativeMatrix Cs_4 = new NativeMatrix(0, 0);
    private final NativeMatrix As_6 = new NativeMatrix(0, 0);
    private final NativeMatrix Bs_6 = new NativeMatrix(0, 0);
    private final NativeMatrix Cs_6 = new NativeMatrix(0, 0);
    private final NativeMatrix U_A = new NativeMatrix(0, 0);
    private final NativeMatrix U_B = new NativeMatrix(0, 0);
    private final NativeMatrix U_C = new NativeMatrix(0, 0);
    private final NativeMatrix V_A = new NativeMatrix(0, 0);
    private final NativeMatrix V_B = new NativeMatrix(0, 0);
    private final NativeMatrix V_C = new NativeMatrix(0, 0);
    private final NativeMatrix N_A = new NativeMatrix(0, 0);
    private final NativeMatrix N_B = new NativeMatrix(0, 0);
    private final NativeMatrix N_C = new NativeMatrix(0, 0);
    private final NativeMatrix D_Ainverse = new NativeMatrix(0, 0);
    private final NativeMatrix D_A = new NativeMatrix(0, 0);
    private final NativeMatrix D_B = new NativeMatrix(0, 0);
    private final NativeMatrix D_C = new NativeMatrix(0, 0);
    private final NativeMatrix nativeAd = new NativeMatrix(0, 0);
    private final NativeMatrix nativeBd = new NativeMatrix(0, 0);
    private final NativeMatrix nativeCd = new NativeMatrix(0, 0);
    private static final double c0 = 1.0;
    private static final double c1 = 0.5;
    private static final double c2 = 0.12;
    private static final double c3 = 0.01833333333333333;
    private static final double c4 = 0.0019927536231884053;
    private static final double c5 = 1.630434782608695E-4;
    private static final double c6 = 1.0351966873706E-5;
    private static final double c7 = 5.175983436853E-7;
    private static final double c8 = 2.0431513566525E-8;
    private static final double c9 = 6.306022705717593E-10;
    private static final double c10 = 1.4837700484041396E-11;
    private static final double c11 = 2.5291534915979653E-13;
    private static final double c12 = 2.8101705462199615E-15;
    private static final double c13 = 1.5440497506703084E-17;
    private final DMatrixRMaj Ainternal = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj Binternal = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj Cinternal = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj Adinternal = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj Bdinternal = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj Cdinternal = new DMatrixRMaj(0, 0);

    public EfficientMatrixExponentialCalculator(int rows, int Bcols, int Ccols) {
        this.reshape(rows, Bcols, Ccols);
    }

    public void reshape(int rows, int Bcols, int Ccols) {
        this.rows = rows;
        this.Bcols = Bcols;
        this.Ccols = Ccols;
        this.Ainternal.reshape(rows, rows);
        this.Binternal.reshape(rows, Bcols);
        this.Cinternal.reshape(rows, Ccols);
        this.Adinternal.reshape(rows, rows);
        this.Bdinternal.reshape(rows, Bcols);
        this.Cdinternal.reshape(rows, Ccols);
    }

    public void compute(DMatrixRMaj result, DMatrixRMaj A) {
        CommonOps_DDRM.extract((DMatrix)A, (int)0, (int)this.rows, (int)0, (int)this.rows, (DMatrix)this.Ainternal);
        CommonOps_DDRM.extract((DMatrix)A, (int)0, (int)this.rows, (int)this.rows, (int)(this.rows + this.Bcols), (DMatrix)this.Binternal);
        CommonOps_DDRM.extract((DMatrix)A, (int)0, (int)this.rows, (int)(this.rows + this.Bcols), (int)(this.rows + this.Bcols + this.Ccols), (DMatrix)this.Cinternal);
        this.compute(this.Ainternal, this.Binternal, this.Cinternal, this.Adinternal, this.Bdinternal, this.Cdinternal);
        result.zero();
        MatrixTools.setMatrixBlock((DMatrix)result, (int)0, (int)0, (DMatrix)this.Adinternal, (int)0, (int)0, (int)this.rows, (int)this.rows, (double)1.0);
        MatrixTools.setMatrixBlock((DMatrix)result, (int)0, (int)this.rows, (DMatrix)this.Bdinternal, (int)0, (int)0, (int)this.rows, (int)this.Bcols, (double)1.0);
        MatrixTools.setMatrixBlock((DMatrix)result, (int)0, (int)(this.rows + this.Bcols), (DMatrix)this.Cdinternal, (int)0, (int)0, (int)this.rows, (int)this.Ccols, (double)1.0);
        int size = this.rows + this.Bcols + this.Ccols;
        for (int row = this.rows; row < size; ++row) {
            result.set(row, row, 1.0);
        }
    }

    public void compute(DMatrixRMaj A, DMatrixRMaj B, DMatrixRMaj C, DMatrixRMaj Ad, DMatrixRMaj Bd, DMatrixRMaj Cd) {
        MatrixTools.checkMatrixDimensions((DMatrix1Row)A, (int)this.rows, (int)this.rows);
        MatrixTools.checkMatrixDimensions((DMatrix1Row)B, (int)this.rows, (int)this.Bcols);
        MatrixTools.checkMatrixDimensions((DMatrix1Row)C, (int)this.rows, (int)this.Ccols);
        MatrixTools.checkMatrixDimensions((DMatrix1Row)Ad, (int)this.rows, (int)this.rows);
        MatrixTools.checkMatrixDimensions((DMatrix1Row)Bd, (int)this.rows, (int)this.Bcols);
        MatrixTools.checkMatrixDimensions((DMatrix1Row)Cd, (int)this.rows, (int)this.Ccols);
        int j = Math.max(0, 1 + (int)Math.floor(Math.log(EfficientMatrixExponentialCalculator.inducedPInf(A, B, C)) / Math.log(2.0)));
        double inverseJ = 1.0 / Math.pow(2.0, j);
        this.As.scale(inverseJ, A);
        this.Bs.scale(inverseJ, B);
        this.Cs.scale(inverseJ, C);
        this.As_2.mult(this.As, this.As);
        this.Bs_2.mult(this.As, this.Bs);
        this.Cs_2.mult(this.As, this.Cs);
        this.As_4.mult(this.As_2, this.As_2);
        this.Bs_4.mult(this.As_2, this.Bs_2);
        this.Cs_4.mult(this.As_2, this.Cs_2);
        this.As_6.mult(this.As_4, this.As_2);
        this.Bs_6.mult(this.As_4, this.Bs_2);
        this.Cs_6.mult(this.As_4, this.Cs_2);
        this.U_A.add(0.12, this.As_2, 0.0019927536231884053, this.As_4);
        this.U_A.addDiagonal(1.0);
        this.U_B.add(0.12, this.Bs_2, 0.0019927536231884053, this.Bs_4);
        this.U_C.add(0.12, this.Cs_2, 0.0019927536231884053, this.Cs_4);
        this.temp.add(2.0431513566525E-8, this.As_2, 1.4837700484041396E-11, this.As_4);
        this.temp.addEquals(2.8101705462199615E-15, this.As_6);
        this.temp.addDiagonal(1.0351966873706E-5);
        this.U_A.multAdd(this.temp, this.As_6);
        this.U_B.multAdd(this.temp, this.Bs_6);
        this.U_C.multAdd(this.temp, this.Cs_6);
        this.V_A.add(0.01833333333333333, this.As_2, 1.630434782608695E-4, this.As_4);
        this.V_A.addDiagonal(0.5);
        this.V_B.add(0.01833333333333333, this.Bs_2, 1.630434782608695E-4, this.Bs_4);
        this.V_C.add(0.01833333333333333, this.Cs_2, 1.630434782608695E-4, this.Cs_4);
        this.temp.add(6.306022705717593E-10, this.As_2, 2.5291534915979653E-13, this.As_4);
        this.temp.addEquals(1.5440497506703084E-17, this.As_6);
        this.temp.addDiagonal(5.175983436853E-7);
        this.V_A.multAdd(this.temp, this.As_6);
        this.V_B.multAdd(this.temp, this.Bs_6);
        this.V_C.multAdd(this.temp, this.Cs_6);
        this.N_A.set(this.U_A);
        this.N_A.multAdd(this.As, this.V_A);
        this.N_B.add(this.U_B, 0.5, this.Bs);
        this.N_B.multAdd(this.As, this.V_B);
        this.N_C.add(this.U_C, 0.5, this.Cs);
        this.N_C.multAdd(this.As, this.V_C);
        this.D_A.set(this.U_A);
        this.D_A.multAdd(-1.0, this.As, this.V_A);
        this.D_B.add(this.U_B, -0.5, this.Bs);
        this.D_B.multAdd(-1.0, this.As, this.V_B);
        this.D_C.add(this.U_C, -0.5, this.Cs);
        this.D_C.multAdd(-1.0, this.As, this.V_C);
        this.D_Ainverse.invert(this.D_A);
        this.nativeAd.mult(this.D_Ainverse, this.N_A);
        this.temp.subtract(this.N_B, this.D_B);
        this.nativeBd.mult(this.D_Ainverse, this.temp);
        this.temp.subtract(this.N_C, this.D_C);
        this.nativeCd.mult(this.D_Ainverse, this.temp);
        for (int k = 0; k < j; ++k) {
            this.nativeBd.multAdd(this.nativeAd, this.nativeBd);
            this.nativeCd.multAdd(this.nativeAd, this.nativeCd);
            this.nativeAd.mult(this.nativeAd, this.nativeAd);
        }
        this.nativeAd.get(Ad);
        this.nativeBd.get(Bd);
        this.nativeCd.get(Cd);
    }

    public static double inducedPInf(DMatrixRMaj A, DMatrixRMaj B, DMatrixRMaj C) {
        double max = 0.0;
        int m = A.numRows;
        int An = A.numCols;
        int Bn = B.numCols;
        int Cn = C.numCols;
        for (int i = 0; i < m; ++i) {
            int j;
            double total = 0.0;
            for (j = 0; j < An; ++j) {
                total += Math.abs(A.get(i, j));
            }
            for (j = 0; j < Bn; ++j) {
                total += Math.abs(B.get(i, j));
            }
            for (j = 0; j < Cn; ++j) {
                total += Math.abs(C.get(i, j));
            }
            if (!(total > max)) continue;
            max = total;
        }
        return max;
    }
}

