/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.modelPredictiveController.ioHandling;

import java.util.List;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.MultipleWrenchSegmentTrajectoryGenerator;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.ContactPlaneProvider;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.ioHandling.MPCContactPlane;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.robotics.time.TimeIntervalBasics;
import us.ihmc.robotics.time.TimeIntervalReadOnly;
import us.ihmc.yoVariables.registry.YoRegistry;

public class WrenchMPCTrajectoryHandler {
    protected final MultipleWrenchSegmentTrajectoryGenerator wrenchTrajectory;
    private boolean hasTrajectory = false;

    public WrenchMPCTrajectoryHandler(YoRegistry registry) {
        this.wrenchTrajectory = new MultipleWrenchSegmentTrajectoryGenerator("desiredWrenchTrajectory", ReferenceFrame.getWorldFrame(), registry);
    }

    public void clearTrajectory() {
        this.wrenchTrajectory.clear();
        this.hasTrajectory = false;
    }

    public boolean hasTrajectory() {
        return this.hasTrajectory;
    }

    public void extractSolutionForPreviewWindow(List<ContactPlaneProvider> planningWindow, List<? extends List<MPCContactPlane>> contactPlaneHelpers, double mass, double omega) {
        this.clearTrajectory();
        for (int i = 0; i < planningWindow.size(); ++i) {
            TimeIntervalBasics timeInterval = planningWindow.get(i).getTimeInterval();
            this.wrenchTrajectory.appendSegment((TimeIntervalReadOnly)timeInterval, mass, omega, contactPlaneHelpers.get(i));
        }
        this.wrenchTrajectory.initialize();
        this.hasTrajectory = true;
    }

    public void compute(double timeInPhase) {
        this.wrenchTrajectory.compute(timeInPhase);
    }

    public MultipleWrenchSegmentTrajectoryGenerator getWrenchTrajectory() {
        return this.wrenchTrajectory;
    }

    public WrenchReadOnly getDesiredWrench() {
        return this.wrenchTrajectory.getSegment(this.wrenchTrajectory.getCurrentSegmentIndex()).getWrench();
    }
}

