/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.modelPredictiveController.ioHandling;

import java.util.List;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.ContactPlaneProvider;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.robotics.math.trajectories.generators.MultipleWaypointsOrientationTrajectoryGenerator;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameQuaternion;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;

public class OrientationTrajectoryCalculator {
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final MultipleWaypointsOrientationTrajectoryGenerator trajectory;
    private final YoFrameQuaternion initialBodyOrientation = new YoFrameQuaternion("initialBodyOrientation", ReferenceFrame.getWorldFrame(), this.registry);
    private final YoFrameVector3D initialBodyAngularVelocity = new YoFrameVector3D("initialBodyAngularVelocity", ReferenceFrame.getWorldFrame(), this.registry);
    private final FrameQuaternion desiredOrientation = new FrameQuaternion();
    private final FrameVector3D desiredAngularVelocity = new FrameVector3D();
    private final FrameQuaternion nominalOrientation = new FrameQuaternion();
    private final FrameQuaternion orientationSetpoint = new FrameQuaternion();
    private final FrameVector3D velocitySetpoint = new FrameVector3D();

    public OrientationTrajectoryCalculator(YoRegistry parentRegistry) {
        this.trajectory = new MultipleWaypointsOrientationTrajectoryGenerator("bodyOrientation", ReferenceFrame.getWorldFrame(), this.registry);
        parentRegistry.addChild(this.registry);
    }

    public void setInitialBodyOrientation(FrameOrientation3DReadOnly initialBodyOrientation, FrameVector3DReadOnly initialBodyAngularVelocity) {
        this.initialBodyOrientation.set(initialBodyOrientation);
        this.initialBodyAngularVelocity.set((FrameTuple3DReadOnly)initialBodyAngularVelocity);
    }

    public void solveForTrajectory(List<ContactPlaneProvider> fullContactSequence) {
        this.trajectory.clear();
        this.nominalOrientation.set((FrameQuaternionReadOnly)this.initialBodyOrientation);
        this.velocitySetpoint.set((FrameTuple3DReadOnly)this.initialBodyAngularVelocity);
        this.trajectory.appendWaypoint(fullContactSequence.get(0).getTimeInterval().getStartTime(), (FrameQuaternionReadOnly)this.nominalOrientation, (FrameVector3DReadOnly)this.velocitySetpoint);
        this.velocitySetpoint.setToZero();
        for (int i = 0; i < fullContactSequence.size(); ++i) {
            ContactPlaneProvider contact = fullContactSequence.get(i);
            if (contact.getNumberOfContactPlanes() > 1) {
                this.nominalOrientation.interpolate(contact.getContactPose(0).getOrientation(), contact.getContactPose(1).getOrientation(), 0.5);
            } else if (contact.getNumberOfContactPlanes() > 0) {
                this.nominalOrientation.set(contact.getContactPose(0).getOrientation());
            }
            this.orientationSetpoint.setToYawOrientation(this.nominalOrientation.getYaw());
            this.trajectory.appendWaypoint(Math.min(5.0, contact.getTimeInterval().getEndTime()), (FrameQuaternionReadOnly)this.orientationSetpoint, (FrameVector3DReadOnly)this.velocitySetpoint);
        }
        this.trajectory.initialize();
    }

    public void compute(double time) {
        this.trajectory.compute(time);
        this.desiredOrientation.setIncludingFrame(this.trajectory.getOrientation());
        this.desiredAngularVelocity.setIncludingFrame((FrameTuple3DReadOnly)this.trajectory.getAngularVelocity());
    }

    public MultipleWaypointsOrientationTrajectoryGenerator getOrientationTrajectory() {
        return this.trajectory;
    }

    public FrameOrientation3DReadOnly getDesiredOrientation() {
        return this.desiredOrientation;
    }

    public FrameVector3DReadOnly getDesiredAngularVelocity() {
        return this.desiredAngularVelocity;
    }
}

