/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.modelPredictiveController.ioHandling;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.ActiveSetData;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.ContactPlaneProvider;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.core.LinearMPCIndexHandler;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.ioHandling.MPCContactPlane;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.visualization.ContactPlaneForceViewer;
import us.ihmc.commonWalkingControlModules.wrenchDistribution.FrictionConeRotationCalculator;
import us.ihmc.commonWalkingControlModules.wrenchDistribution.ZeroConeRotationCalculator;
import us.ihmc.commons.lists.RecyclingArrayList;

public class MPCContactHandler {
    protected static final int numberOfBasisVectorsPerContactPoint = 4;
    private static final double mu = 0.8;
    private final double mass;
    private final double gravityZ;
    private final ContactDataList contactDataList = new ContactDataList();
    private final List<ContactData> unusedContactDataList = new ArrayList<ContactData>();
    public final List<List<MPCContactPlane>> contactPlanes = new ArrayList<List<MPCContactPlane>>();
    public final List<ActiveSetData> activeSetData = new ArrayList<ActiveSetData>();
    private final LinearMPCIndexHandler indexHandler;
    private final FrictionConeRotationCalculator coneRotationCalculator = new ZeroConeRotationCalculator();
    private final Supplier<MPCContactPlane> contactPlaneProvider = () -> new MPCContactPlane(6, 4, this.coneRotationCalculator);

    public MPCContactHandler(LinearMPCIndexHandler indexHandler, double gravityZ, double mass) {
        this.indexHandler = indexHandler;
        this.gravityZ = Math.abs(gravityZ);
        this.mass = mass;
    }

    public void setContactPlaneViewers(Supplier<ContactPlaneForceViewer> viewerSupplier) {
        this.contactDataList.clear();
        for (int i = 0; i < 6; ++i) {
            ContactData contactData = this.contactDataList.addContactData();
            contactData.addContactPlane().setContactPointForceViewer(viewerSupplier.get());
            contactData.addContactPlane().setContactPointForceViewer(viewerSupplier.get());
        }
        this.contactDataList.clear();
    }

    public void computeMatrixHelpers(List<ContactPlaneProvider> currentContactSequence, List<ContactPlaneProvider> previousContactSequence, double omega) {
        this.contactPlanes.clear();
        this.activeSetData.clear();
        this.updatePreviousLists();
        for (int sequenceId = 0; sequenceId < currentContactSequence.size(); ++sequenceId) {
            ContactData contactData;
            ContactPlaneProvider contact = currentContactSequence.get(sequenceId);
            int contactIdx = this.contactDataList.indexOf(contact);
            if (contactIdx < 0) {
                contactData = this.createNewContactData(sequenceId, contact);
            } else {
                contactData = this.contactDataList.getContactData(contactIdx);
                this.registerAsUsed(contact, contactData);
            }
            List<MPCContactPlane> contactPlanes = contactData.getPlanes();
            for (int contactId = 0; contactId < contact.getNumberOfContactPlanes(); ++contactId) {
                MPCContactPlane contactPlane = contactPlanes.get(contactId);
                contactPlane.computeBasisVectors(contact.getContactsInBodyFrame(contactId), contact.getContactPose(contactId), 0.8);
            }
            this.contactPlanes.add(contactPlanes);
            this.activeSetData.add(contactData.getActiveSetData());
        }
        this.deallocateUnusedObjects();
    }

    private void updatePreviousLists() {
        this.removeCorruptedPlanes();
        this.unusedContactDataList.clear();
        for (int i = 0; i < this.contactDataList.numberOfContacts(); ++i) {
            this.unusedContactDataList.add(this.contactDataList.getContactData(i));
        }
    }

    private ContactData createNewContactData(int sequenceId, ContactPlaneProvider contact) {
        ContactData contactData = this.contactDataList.addContactData();
        contactData.clear();
        contactData.setContact(contact);
        ActiveSetData activeSetData = contactData.getActiveSetData();
        activeSetData.setSegmentNumber(sequenceId);
        activeSetData.setNumberOfVariablesInSegment(this.indexHandler.getVariablesInSegment(sequenceId));
        for (int contactId = 0; contactId < contact.getNumberOfContactPlanes(); ++contactId) {
            contactData.addContactPlane();
        }
        return contactData;
    }

    private void registerAsUsed(ContactPlaneProvider contact, ContactData contactData) {
        contactData.setContact(contact);
        if (!this.unusedContactDataList.remove(contactData)) {
            throw new RuntimeException("oops");
        }
    }

    private void deallocateUnusedObjects() {
        for (int i = 0; i < this.unusedContactDataList.size(); ++i) {
            this.contactDataList.removeContact(this.unusedContactDataList.get(i).getContact());
        }
        this.removeCorruptedPlanes();
    }

    private void removeCorruptedPlanes() {
        int i = 0;
        while (i < this.contactDataList.numberOfContacts()) {
            ContactData contactData = this.contactDataList.getContactData(i);
            if (contactData.getContact().getNumberOfContactPlanes() != contactData.getPlanes().size()) {
                this.contactDataList.removeContact(i);
                continue;
            }
            ++i;
        }
    }

    public List<? extends List<MPCContactPlane>> getContactPlanes() {
        return this.contactPlanes;
    }

    public int getNumberOfContactPlanesInSegment(int segmentId) {
        return this.getContactPlanesForSegment(segmentId).size();
    }

    public List<MPCContactPlane> getContactPlanesForSegment(int segmentId) {
        return this.contactPlanes.get(segmentId);
    }

    public MPCContactPlane getContactPlane(int segmentId, int planeId) {
        return this.contactPlanes.get(segmentId).get(planeId);
    }

    public ActiveSetData getActiveSetData(int segmentId) {
        return this.activeSetData.get(segmentId);
    }

    private class ContactDataList {
        private final RecyclingArrayList<ContactData> contactData = new RecyclingArrayList(() -> new ContactData());
        private static final double timeEpsilon = 0.01;
        private static final double positionEpsilon = 0.005;

        private ContactDataList() {
        }

        public void clear() {
            this.contactData.clear();
        }

        public int numberOfContacts() {
            return this.contactData.size();
        }

        public ContactData addContactData() {
            return (ContactData)this.contactData.add();
        }

        public ContactData getContactData(int index) {
            return (ContactData)this.contactData.get(index);
        }

        public boolean removeContact(ContactPlaneProvider contactPlaneProvider) {
            int index = this.indexOf(contactPlaneProvider);
            return this.removeContact(index);
        }

        public boolean removeContact(int index) {
            if (index < 0) {
                return false;
            }
            this.contactData.remove(index);
            return true;
        }

        public boolean containsContact(ContactPlaneProvider contactPlaneProvider) {
            for (int i = 0; i < this.contactData.size(); ++i) {
                if (!ContactPlaneProvider.epsilonEquals(((ContactData)this.contactData.get(i)).getContact(), contactPlaneProvider, 0.01, 0.005)) continue;
                return true;
            }
            return false;
        }

        public int indexOf(ContactPlaneProvider contact) {
            for (int i = 0; i < this.contactData.size(); ++i) {
                if (!ContactPlaneProvider.epsilonEquals(((ContactData)this.contactData.get(i)).getContact(), contact, 0.01, 0.005)) continue;
                return i;
            }
            return -1;
        }
    }

    private class ContactData {
        private final RecyclingArrayList<MPCContactPlane> contactPlanes;
        private final ActiveSetData activeSetData;
        private final ContactPlaneProvider contact;

        private ContactData() {
            this.contactPlanes = new RecyclingArrayList(MPCContactHandler.this.contactPlaneProvider);
            this.activeSetData = new ActiveSetData();
            this.contact = new ContactPlaneProvider();
        }

        public void setContact(ContactPlaneProvider contact) {
            this.contact.set(contact);
        }

        public ContactPlaneProvider getContact() {
            return this.contact;
        }

        public void clear() {
            this.contact.reset();
            this.activeSetData.reset();
            this.contactPlanes.clear();
        }

        public List<MPCContactPlane> getPlanes() {
            return this.contactPlanes;
        }

        public ActiveSetData getActiveSetData() {
            return this.activeSetData;
        }

        public MPCContactPlane addContactPlane() {
            return (MPCContactPlane)this.contactPlanes.add();
        }

        public String toString() {
            return this.contact.getTimeInterval().toString();
        }
    }
}

