/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.modelPredictiveController.ioHandling;

import java.util.List;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.CoMTrajectoryPlanner;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.CoMTrajectorySegment;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.MultipleCoMSegmentTrajectoryGenerator;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.ContactPlaneProvider;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.core.LinearMPCIndexHandler;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.ioHandling.ContactSegmentHelper;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.ioHandling.MPCContactPlane;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.matrixlib.MatrixTools;
import us.ihmc.robotics.math.trajectories.core.Polynomial3D;
import us.ihmc.robotics.math.trajectories.interfaces.Polynomial3DBasics;
import us.ihmc.robotics.math.trajectories.interfaces.Polynomial3DReadOnly;
import us.ihmc.robotics.time.TimeIntervalBasics;
import us.ihmc.robotics.time.TimeIntervalProvider;
import us.ihmc.robotics.time.TimeIntervalReadOnly;
import us.ihmc.robotics.time.TimeIntervalTools;
import us.ihmc.yoVariables.registry.YoRegistry;

public class LinearMPCTrajectoryHandler {
    private final CoMTrajectoryPlanner positionInitializationCalculator;
    protected final RecyclingArrayList<ContactPlaneProvider> planningWindowForSolution = new RecyclingArrayList(ContactPlaneProvider::new);
    private final RecyclingArrayList<ContactPlaneProvider> fullContactSet = new RecyclingArrayList(ContactPlaneProvider::new);
    private final LinearMPCIndexHandler indexHandler;
    private final double gravityZ;
    private final DMatrixRMaj xCoefficientVector = new DMatrixRMaj(0, 1);
    private final DMatrixRMaj yCoefficientVector = new DMatrixRMaj(0, 1);
    private final DMatrixRMaj zCoefficientVector = new DMatrixRMaj(0, 1);
    private final DMatrixRMaj coefficientArray = new DMatrixRMaj(0, 3);
    private final MultipleCoMSegmentTrajectoryGenerator comTrajectory;
    private final RecyclingArrayList<Polynomial3DBasics> vrpTrajectories = new RecyclingArrayList(() -> new Polynomial3D(4));
    private final CoMTrajectorySegment comSegmentToAppend = new CoMTrajectorySegment();
    private final ContactSegmentHelper contactSegmentHelper = new ContactSegmentHelper();
    private boolean hasTrajectory = false;
    private final FramePoint3D vrpStartPosition = new FramePoint3D();
    private final FrameVector3D vrpStartVelocity = new FrameVector3D();
    private final FramePoint3D vrpEndPosition = new FramePoint3D();
    private final FrameVector3D vrpEndVelocity = new FrameVector3D();

    public LinearMPCTrajectoryHandler(LinearMPCIndexHandler indexHandler, double gravityZ, double nominalCoMHeight, YoRegistry registry) {
        this.indexHandler = indexHandler;
        this.gravityZ = Math.abs(gravityZ);
        this.positionInitializationCalculator = new CoMTrajectoryPlanner(gravityZ, nominalCoMHeight, registry);
        this.comTrajectory = new MultipleCoMSegmentTrajectoryGenerator("desiredCoMTrajectory", registry);
    }

    public void clearTrajectory() {
        this.comTrajectory.clear();
        this.vrpTrajectories.clear();
        this.fullContactSet.clear();
        this.hasTrajectory = false;
    }

    public boolean hasTrajectory() {
        return this.hasTrajectory;
    }

    public void setNominalCoMHeight(double nominalCoMHeight) {
        this.positionInitializationCalculator.setNominalCoMHeight(nominalCoMHeight);
    }

    public void setInitialCenterOfMassState(FramePoint3DReadOnly centerOfMassPosition, FrameVector3DReadOnly centerOfMassVelocity) {
        this.positionInitializationCalculator.setInitialCenterOfMassState(centerOfMassPosition, centerOfMassVelocity);
    }

    public void solveForTrajectoryOutsidePreviewWindow(List<ContactPlaneProvider> fullContactSequence) {
        this.positionInitializationCalculator.solveForTrajectory(fullContactSequence);
        this.removeInfoOutsidePreviewWindow();
        this.overwriteTrajectoryOutsidePreviewWindow(this.positionInitializationCalculator.getOmega());
        this.overwriteContactsOutsidePreviewWindow(fullContactSequence);
    }

    public void initializeTrajectory(FramePoint3DReadOnly end, double omega, double duration) {
        this.positionInitializationCalculator.initializeTrajectory(end, duration);
        this.overwriteTrajectoryOutsidePreviewWindow(omega);
        this.hasTrajectory = true;
    }

    public void extractSolutionForPreviewWindow(DMatrixRMaj solutionCoefficients, List<ContactPlaneProvider> planningWindow, List<? extends List<MPCContactPlane>> contactPlanes, List<ContactPlaneProvider> fullContactSequence, double omega) {
        int numberOfPhases = planningWindow.size();
        this.planningWindowForSolution.clear();
        for (int i = 0; i < numberOfPhases; ++i) {
            ((ContactPlaneProvider)this.planningWindowForSolution.add()).set(planningWindow.get(i));
        }
        this.computeCoMSegmentCoefficients(solutionCoefficients, contactPlanes, this.xCoefficientVector, this.yCoefficientVector, this.zCoefficientVector);
        int numRows = this.xCoefficientVector.getNumRows();
        this.coefficientArray.reshape(numRows, 3);
        MatrixTools.setMatrixBlock((DMatrix)this.coefficientArray, (int)0, (int)0, (DMatrix)this.xCoefficientVector, (int)0, (int)0, (int)numRows, (int)1, (double)1.0);
        MatrixTools.setMatrixBlock((DMatrix)this.coefficientArray, (int)0, (int)1, (DMatrix)this.yCoefficientVector, (int)0, (int)0, (int)numRows, (int)1, (double)1.0);
        MatrixTools.setMatrixBlock((DMatrix)this.coefficientArray, (int)0, (int)2, (DMatrix)this.zCoefficientVector, (int)0, (int)0, (int)numRows, (int)1, (double)1.0);
        this.clearTrajectory();
        int startRow = 0;
        for (int i = 0; i < planningWindow.size(); ++i) {
            TimeIntervalBasics timeInterval = planningWindow.get(i).getTimeInterval();
            ((ContactPlaneProvider)this.fullContactSet.add()).set(fullContactSequence.get(i));
            this.comTrajectory.appendSegment((TimeIntervalReadOnly)timeInterval, omega, this.coefficientArray, startRow);
            double duration = Math.min(timeInterval.getDuration(), 10.0);
            LinearMPCTrajectoryHandler.computeVRPBoundaryConditionsFromCoefficients(startRow, this.coefficientArray, omega, duration, (FixedFramePoint3DBasics)this.vrpStartPosition, (FixedFrameVector3DBasics)this.vrpStartVelocity, (FixedFramePoint3DBasics)this.vrpEndPosition, (FixedFrameVector3DBasics)this.vrpEndVelocity);
            Polynomial3DBasics vrpTrajectory = (Polynomial3DBasics)this.vrpTrajectories.add();
            vrpTrajectory.setCubic(0.0, duration, (Point3DReadOnly)this.vrpStartPosition, (Vector3DReadOnly)this.vrpStartVelocity, (Point3DReadOnly)this.vrpEndPosition, (Vector3DReadOnly)this.vrpEndVelocity);
            vrpTrajectory.getTimeInterval().setInterval(0.0, timeInterval.getDuration());
            startRow += 6;
        }
        this.overwriteTrajectoryOutsidePreviewWindow(omega);
        this.overwriteContactsOutsidePreviewWindow(fullContactSequence);
        this.hasTrajectory = true;
        if (this.vrpTrajectories.size() != this.fullContactSet.size()) {
            throw new RuntimeException("Somehow these didn't match up.");
        }
    }

    private void removeInfoOutsidePreviewWindow() {
        if (this.planningWindowForSolution.size() > 0 && this.fullContactSet.size() > 0) {
            while (((ContactPlaneProvider)this.fullContactSet.getLast()).getTimeInterval().getEndTime() > ((ContactPlaneProvider)this.planningWindowForSolution.getLast()).getTimeInterval().getEndTime()) {
                int lastIndx = this.fullContactSet.size() - 1;
                this.fullContactSet.remove(lastIndx);
                this.vrpTrajectories.remove(lastIndx);
                this.comTrajectory.removeSegment(lastIndx);
            }
        }
    }

    private void overwriteTrajectoryOutsidePreviewWindow(double omega) {
        CoMTrajectorySegment lastCoMSegmentOfPreview;
        double existingEndTime;
        MultipleCoMSegmentTrajectoryGenerator comTrajectoryOutsideWindow = this.positionInitializationCalculator.getCoMTrajectory();
        List<Polynomial3DReadOnly> vrpTrajectoryOutsideWindow = this.positionInitializationCalculator.getVRPTrajectories();
        boolean hasTrajectoryAlready = this.comTrajectory.getCurrentNumberOfSegments() > 0;
        double d = existingEndTime = hasTrajectoryAlready ? this.comTrajectory.getEndTime() : 0.0;
        if (existingEndTime >= comTrajectoryOutsideWindow.getEndTime()) {
            return;
        }
        int segmentIndexToAdd = LinearMPCTrajectoryHandler.getSegmentIndexContainingTime(existingEndTime + 1.0E-5, this.positionInitializationCalculator.getCoMTrajectory().getSegments());
        if (segmentIndexToAdd == -1) {
            return;
        }
        CoMTrajectorySegment nextCoMSegment = (CoMTrajectorySegment)comTrajectoryOutsideWindow.getSegment(segmentIndexToAdd);
        CoMTrajectorySegment coMTrajectorySegment = lastCoMSegmentOfPreview = hasTrajectoryAlready ? (CoMTrajectorySegment)this.comTrajectory.getSegment(this.comTrajectory.getCurrentNumberOfSegments() - 1) : null;
        if (lastCoMSegmentOfPreview == null || TimeIntervalTools.areTimeIntervalsConsecutive(lastCoMSegmentOfPreview, (TimeIntervalProvider)nextCoMSegment)) {
            this.comTrajectory.appendSegment(nextCoMSegment);
            ((Polynomial3DBasics)this.vrpTrajectories.add()).set(vrpTrajectoryOutsideWindow.get(segmentIndexToAdd));
        } else {
            double durationToRemove = lastCoMSegmentOfPreview.getTimeInterval().getEndTime() - nextCoMSegment.getTimeInterval().getStartTime();
            this.comSegmentToAppend.set(nextCoMSegment);
            this.comSegmentToAppend.shiftStartOfSegment(durationToRemove);
            this.comTrajectory.appendSegment(this.comSegmentToAppend);
            double duration = Math.min(this.comSegmentToAppend.getTimeInterval().getDuration(), 10.0);
            LinearMPCTrajectoryHandler.computeVRPBoundaryConditionsFromCoefficients(this.comSegmentToAppend, duration, omega, (FixedFramePoint3DBasics)this.vrpStartPosition, (FixedFrameVector3DBasics)this.vrpStartVelocity, (FixedFramePoint3DBasics)this.vrpEndPosition, (FixedFrameVector3DBasics)this.vrpEndVelocity);
            Polynomial3DBasics vrpTrajectory = (Polynomial3DBasics)this.vrpTrajectories.add();
            vrpTrajectory.setCubic(0.0, duration, (Point3DReadOnly)this.vrpStartPosition, (Vector3DReadOnly)this.vrpStartVelocity, (Point3DReadOnly)this.vrpEndPosition, (Vector3DReadOnly)this.vrpEndVelocity);
            vrpTrajectory.getTimeInterval().setInterval(0.0, this.comSegmentToAppend.getTimeInterval().getDuration());
        }
        ++segmentIndexToAdd;
        while (segmentIndexToAdd < comTrajectoryOutsideWindow.getCurrentNumberOfSegments()) {
            this.comTrajectory.appendSegment((CoMTrajectorySegment)comTrajectoryOutsideWindow.getSegment(segmentIndexToAdd));
            ((Polynomial3DBasics)this.vrpTrajectories.add()).set(vrpTrajectoryOutsideWindow.get(segmentIndexToAdd));
            ++segmentIndexToAdd;
        }
        this.comTrajectory.initialize();
    }

    private void overwriteContactsOutsidePreviewWindow(List<ContactPlaneProvider> contactsToUse) {
        ContactPlaneProvider lastContactOfPreview;
        double existingEndTime;
        boolean hasContactsAlready = this.fullContactSet.size() > 0;
        double d = existingEndTime = hasContactsAlready ? ((ContactPlaneProvider)this.fullContactSet.getLast()).getTimeInterval().getEndTime() : 0.0;
        if (hasContactsAlready && existingEndTime >= contactsToUse.get(contactsToUse.size() - 1).getTimeInterval().getEndTime()) {
            return;
        }
        int segmentIndexToAdd = LinearMPCTrajectoryHandler.getSegmentIndexContainingTime(existingEndTime + 1.0E-5, contactsToUse);
        if (segmentIndexToAdd == -1) {
            return;
        }
        ContactPlaneProvider nextContact = contactsToUse.get(segmentIndexToAdd);
        ContactPlaneProvider contactPlaneProvider = lastContactOfPreview = hasContactsAlready ? (ContactPlaneProvider)this.fullContactSet.get(this.fullContactSet.size() - 1) : null;
        if (lastContactOfPreview == null || TimeIntervalTools.areTimeIntervalsConsecutive(lastContactOfPreview, (TimeIntervalProvider)nextContact)) {
            ((ContactPlaneProvider)this.fullContactSet.add()).set(nextContact);
        } else {
            ContactPlaneProvider contactPlaneToAppend = (ContactPlaneProvider)this.fullContactSet.add();
            contactPlaneToAppend.set(nextContact);
            this.contactSegmentHelper.cropInitialSegmentLength(contactPlaneToAppend, lastContactOfPreview.getTimeInterval().getEndTime());
        }
        ++segmentIndexToAdd;
        while (segmentIndexToAdd < contactsToUse.size()) {
            ((ContactPlaneProvider)this.fullContactSet.add()).set(contactsToUse.get(segmentIndexToAdd));
            ++segmentIndexToAdd;
        }
    }

    private static int getSegmentIndexContainingTime(double time, List<? extends TimeIntervalProvider> segments) {
        for (int i = 0; i < segments.size(); ++i) {
            TimeIntervalProvider segment = segments.get(i);
            if (!segment.getTimeInterval().intervalContains(time)) continue;
            return i;
        }
        return -1;
    }

    public void compute(double timeInPhase) {
        this.comTrajectory.compute(timeInPhase);
    }

    public void computeOutsidePreview(double timeInPhase) {
        this.positionInitializationCalculator.compute(timeInPhase);
    }

    public FramePoint3DReadOnly getDesiredCoMPositionOutsidePreview() {
        return this.positionInitializationCalculator.getDesiredCoMPosition();
    }

    public FrameVector3DReadOnly getDesiredCoMVelocityOutsidePreview() {
        return this.positionInitializationCalculator.getDesiredCoMVelocity();
    }

    public FramePoint3DReadOnly getDesiredDCMPositionOutsidePreview() {
        return this.positionInitializationCalculator.getDesiredDCMPosition();
    }

    public FramePoint3DReadOnly getDesiredVRPPositionOutsidePreview() {
        return this.positionInitializationCalculator.getDesiredVRPPosition();
    }

    public void removeCompletedSegments(double timeToCrop) {
        throw new NotImplementedException();
    }

    public MultipleCoMSegmentTrajectoryGenerator getComTrajectory() {
        return this.comTrajectory;
    }

    public List<? extends Polynomial3DReadOnly> getVrpTrajectories() {
        return this.vrpTrajectories;
    }

    public List<ContactPlaneProvider> getFullPlanningSequence() {
        return this.fullContactSet;
    }

    public List<ContactPlaneProvider> getPlanningWindowForSolution() {
        return this.planningWindowForSolution;
    }

    public FramePoint3DReadOnly getDesiredCoMPosition() {
        return this.comTrajectory.getPosition();
    }

    public FrameVector3DReadOnly getDesiredCoMVelocity() {
        return this.comTrajectory.getVelocity();
    }

    public FrameVector3DReadOnly getDesiredCoMAcceleration() {
        return this.comTrajectory.getAcceleration();
    }

    public FramePoint3DReadOnly getDesiredVRPPosition() {
        return ((CoMTrajectorySegment)this.comTrajectory.getSegment(this.comTrajectory.getCurrentSegmentIndex())).getVRPPosition();
    }

    public FrameVector3DReadOnly getDesiredVRPVelocity() {
        return ((CoMTrajectorySegment)this.comTrajectory.getSegment(this.comTrajectory.getCurrentSegmentIndex())).getVRPVelocity();
    }

    public FramePoint3DReadOnly getDesiredDCMPosition() {
        return ((CoMTrajectorySegment)this.comTrajectory.getSegment(this.comTrajectory.getCurrentSegmentIndex())).getDCMPosition();
    }

    public FrameVector3DReadOnly getDesiredDCMVelocity() {
        return ((CoMTrajectorySegment)this.comTrajectory.getSegment(this.comTrajectory.getCurrentSegmentIndex())).getDCMVelocity();
    }

    public DMatrixRMaj getXCoefficientVector() {
        return this.xCoefficientVector;
    }

    public DMatrixRMaj getYCoefficientVector() {
        return this.yCoefficientVector;
    }

    public DMatrixRMaj getZCoefficientVector() {
        return this.zCoefficientVector;
    }

    private void computeCoMSegmentCoefficients(DMatrixRMaj solutionCoefficients, List<? extends List<MPCContactPlane>> contactPlanes, DMatrixRMaj xCoefficientVectorToPack, DMatrixRMaj yCoefficientVectorToPack, DMatrixRMaj zCoefficientVectorToPack) {
        MPCContactPlane contactPlaneHelper;
        int numberOfPhases = contactPlanes.size();
        xCoefficientVectorToPack.reshape(6 * numberOfPhases, 1);
        yCoefficientVectorToPack.reshape(6 * numberOfPhases, 1);
        zCoefficientVectorToPack.reshape(6 * numberOfPhases, 1);
        xCoefficientVectorToPack.zero();
        yCoefficientVectorToPack.zero();
        zCoefficientVectorToPack.zero();
        for (int sequence = 0; sequence < contactPlanes.size(); ++sequence) {
            int coeffStartIdx = this.indexHandler.getRhoCoefficientStartIndex(sequence);
            for (int contact = 0; contact < contactPlanes.get(sequence).size(); ++contact) {
                contactPlaneHelper = contactPlanes.get(sequence).get(contact);
                contactPlaneHelper.computeContactForceCoefficientMatrix(solutionCoefficients, coeffStartIdx);
                coeffStartIdx += contactPlaneHelper.getCoefficientSize();
            }
        }
        for (int i = 0; i < numberOfPhases; ++i) {
            int positionVectorStart = 6 * i;
            xCoefficientVectorToPack.set(positionVectorStart + 4, 0, solutionCoefficients.get(this.indexHandler.getComCoefficientStartIndex(i, 0), 0));
            yCoefficientVectorToPack.set(positionVectorStart + 4, 0, solutionCoefficients.get(this.indexHandler.getComCoefficientStartIndex(i, 1), 0));
            zCoefficientVectorToPack.set(positionVectorStart + 4, 0, solutionCoefficients.get(this.indexHandler.getComCoefficientStartIndex(i, 2), 0));
            xCoefficientVectorToPack.set(positionVectorStart + 5, 0, solutionCoefficients.get(this.indexHandler.getComCoefficientStartIndex(i, 0) + 1, 0));
            yCoefficientVectorToPack.set(positionVectorStart + 5, 0, solutionCoefficients.get(this.indexHandler.getComCoefficientStartIndex(i, 1) + 1, 0));
            zCoefficientVectorToPack.set(positionVectorStart + 5, 0, solutionCoefficients.get(this.indexHandler.getComCoefficientStartIndex(i, 2) + 1, 0));
            for (int contactIdx = 0; contactIdx < contactPlanes.get(i).size(); ++contactIdx) {
                contactPlaneHelper = contactPlanes.get(i).get(contactIdx);
                DMatrixRMaj contactCoefficientMatrix = contactPlaneHelper.getContactWrenchCoefficientMatrix();
                xCoefficientVectorToPack.add(positionVectorStart, 0, contactCoefficientMatrix.get(0, 0));
                yCoefficientVectorToPack.add(positionVectorStart, 0, contactCoefficientMatrix.get(1, 0));
                zCoefficientVectorToPack.add(positionVectorStart, 0, contactCoefficientMatrix.get(2, 0));
                xCoefficientVectorToPack.add(positionVectorStart + 1, 0, contactCoefficientMatrix.get(0, 1));
                yCoefficientVectorToPack.add(positionVectorStart + 1, 0, contactCoefficientMatrix.get(1, 1));
                zCoefficientVectorToPack.add(positionVectorStart + 1, 0, contactCoefficientMatrix.get(2, 1));
                xCoefficientVectorToPack.add(positionVectorStart + 2, 0, contactCoefficientMatrix.get(0, 2));
                yCoefficientVectorToPack.add(positionVectorStart + 2, 0, contactCoefficientMatrix.get(1, 2));
                zCoefficientVectorToPack.add(positionVectorStart + 2, 0, contactCoefficientMatrix.get(2, 2));
                xCoefficientVectorToPack.add(positionVectorStart + 3, 0, contactCoefficientMatrix.get(0, 3));
                yCoefficientVectorToPack.add(positionVectorStart + 3, 0, contactCoefficientMatrix.get(1, 3));
                zCoefficientVectorToPack.add(positionVectorStart + 3, 0, contactCoefficientMatrix.get(2, 3));
            }
            zCoefficientVectorToPack.add(positionVectorStart + 3, 0, -0.5 * this.gravityZ);
        }
    }

    private static void computeVRPBoundaryConditionsFromCoefficients(int startRow, DMatrixRMaj coefficientArray, double omega, double duration, FixedFramePoint3DBasics startPosition, FixedFrameVector3DBasics startVelocity, FixedFramePoint3DBasics endPosition, FixedFrameVector3DBasics endVelocity) {
        startPosition.checkReferenceFrameMatch(ReferenceFrame.getWorldFrame());
        startVelocity.checkReferenceFrameMatch(ReferenceFrame.getWorldFrame());
        endPosition.checkReferenceFrameMatch(ReferenceFrame.getWorldFrame());
        endVelocity.checkReferenceFrameMatch(ReferenceFrame.getWorldFrame());
        double omega2 = omega * omega;
        double t2 = duration * duration;
        double t3 = duration * t2;
        for (Axis3D axis : Axis3D.values) {
            int element = axis.ordinal();
            double startPositionElement = coefficientArray.get(startRow + 5, element) - 2.0 / omega2 * coefficientArray.get(startRow + 3, element);
            double startVelocityElement = coefficientArray.get(startRow + 4, element) - 6.0 / omega2 * coefficientArray.get(startRow + 2, element);
            startPosition.setElement(element, startPositionElement);
            startVelocity.setElement(element, startVelocityElement);
            double endPositionElement = coefficientArray.get(startRow + 2, element) * t3 + coefficientArray.get(startRow + 3, element) * t2 + startVelocityElement * duration + startPositionElement;
            double endVelocityElement = 3.0 * coefficientArray.get(startRow + 2, element) * t2 + 2.0 * coefficientArray.get(startRow + 3, element) * duration + startVelocityElement;
            endPosition.setElement(element, endPositionElement);
            endVelocity.setElement(element, endVelocityElement);
        }
    }

    private static void computeVRPBoundaryConditionsFromCoefficients(CoMTrajectorySegment segment, double duration, double omega, FixedFramePoint3DBasics startPosition, FixedFrameVector3DBasics startVelocity, FixedFramePoint3DBasics endPosition, FixedFrameVector3DBasics endVelocity) {
        startPosition.checkReferenceFrameMatch(ReferenceFrame.getWorldFrame());
        startVelocity.checkReferenceFrameMatch(ReferenceFrame.getWorldFrame());
        endPosition.checkReferenceFrameMatch(ReferenceFrame.getWorldFrame());
        endVelocity.checkReferenceFrameMatch(ReferenceFrame.getWorldFrame());
        double omega2 = omega * omega;
        double t2 = duration * duration;
        double t3 = duration * t2;
        for (Axis3D axis : Axis3D.values) {
            int element = axis.ordinal();
            double startPositionElement = segment.getSixthCoefficient().getElement(element) - 2.0 / omega2 * segment.getFourthCoefficient().getElement(element);
            double startVelocityElement = segment.getFifthCoefficient().getElement(element) - 6.0 / omega2 * segment.getThirdCoefficient().getElement(element);
            startPosition.setElement(element, startPositionElement);
            startVelocity.setElement(element, startVelocityElement);
            double endPositionElement = segment.getThirdCoefficient().getElement(element) * t3 + segment.getFourthCoefficient().getElement(element) * t2 + startVelocityElement * duration + startPositionElement;
            double endVelocityElement = 3.0 * segment.getThirdCoefficient().getElement(element) * t2 + 2.0 * segment.getFourthCoefficient().getElement(element) * duration + startVelocityElement;
            endPosition.setElement(element, endPositionElement);
            endVelocity.setElement(element, endVelocityElement);
        }
    }
}

