/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.modelPredictiveController.ioHandling;

import us.ihmc.commonWalkingControlModules.modelPredictiveController.ContactPlaneProvider;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.robotics.time.TimeIntervalBasics;

public class ContactSegmentHelper {
    private final FramePoint3D modifiedCoPLocation = new FramePoint3D();
    private final ContactPlaneProvider splitSegmentRemaining = new ContactPlaneProvider();

    public void cropInitialSegmentLength(ContactPlaneProvider contact, double timeAtStartOfWindow) {
        TimeIntervalBasics timeInterval = contact.getTimeInterval();
        if (timeAtStartOfWindow > timeInterval.getEndTime()) {
            throw new IllegalArgumentException("Bad initial segment.");
        }
        double segmentDuration = Math.min(timeInterval.getDuration(), 10.0);
        double alphaIntoSegment = (timeAtStartOfWindow - timeInterval.getStartTime()) / segmentDuration;
        this.modifiedCoPLocation.interpolate((FrameTuple3DReadOnly)contact.getECMPStartPosition(), (FrameTuple3DReadOnly)contact.getECMPEndPosition(), alphaIntoSegment);
        timeInterval.setStartTime(timeAtStartOfWindow);
        contact.setStartECMPPosition((FramePoint3DReadOnly)this.modifiedCoPLocation);
    }

    public ContactPlaneProvider trimFinalSegmentLength(ContactPlaneProvider contact, double timeAtStartOfSegment, double maxEndTime) {
        double maxSegmentDuration = maxEndTime - timeAtStartOfSegment;
        TimeIntervalBasics timeInterval = contact.getTimeInterval();
        if (maxSegmentDuration > timeInterval.getDuration()) {
            return null;
        }
        double segmentDuration = Math.min(timeInterval.getDuration(), 10.0);
        double alphaIntoSegment = maxSegmentDuration / segmentDuration;
        this.modifiedCoPLocation.interpolate((FrameTuple3DReadOnly)contact.getECMPStartPosition(), (FrameTuple3DReadOnly)contact.getECMPEndPosition(), alphaIntoSegment);
        this.splitSegmentRemaining.set(contact);
        double splitTime = maxSegmentDuration + timeInterval.getStartTime();
        contact.setEndTime(splitTime);
        contact.setEndECMPPosition((FramePoint3DReadOnly)this.modifiedCoPLocation);
        this.splitSegmentRemaining.setStartTime(splitTime);
        this.splitSegmentRemaining.setStartECMPPosition((FramePoint3DReadOnly)this.modifiedCoPLocation);
        return this.splitSegmentRemaining;
    }
}

