/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.modelPredictiveController.customPolicies;

import java.util.List;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ConstraintType;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.ContactStateProvider;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.commands.CoMPositionCommand;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.commands.MPCCommand;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.customPolicies.CustomMPCPolicy;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.customPolicies.CustomPolicyTools;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.ioHandling.MPCContactHandler;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.robotics.screwTheory.SelectionMatrix3D;

public class CustomCoMPositionPolicy
implements CustomMPCPolicy {
    private final FramePoint3D desiredCoMPosition = new FramePoint3D();
    private final SelectionMatrix3D selectionMatrix = new SelectionMatrix3D();
    private double timeOfPolicy;
    private double weight;
    private final CoMPositionCommand mpcCommand = new CoMPositionCommand();

    public FramePoint3DBasics getDesiredComPosition() {
        return this.desiredCoMPosition;
    }

    public void setDesiredCoMPosition(FramePoint3DReadOnly desiredCoMPosition) {
        this.desiredCoMPosition.setIncludingFrame((FrameTuple3DReadOnly)desiredCoMPosition);
    }

    public SelectionMatrix3D getSelectionMatrix() {
        return this.selectionMatrix;
    }

    public void setTimeOfPolicy(double timeOfPolicy) {
        this.timeOfPolicy = timeOfPolicy;
    }

    public void setPolicyWeight(double weight) {
        this.weight = weight;
    }

    @Override
    public MPCCommand<?> computeMPCCommand(MPCContactHandler contactHandler, List<? extends ContactStateProvider<?>> contactStateProviders, double omega) {
        int segmentNumber = CustomPolicyTools.getSegmentNumber(this.timeOfPolicy, contactStateProviders);
        double timeInSegment = CustomPolicyTools.getTimeInSegment(segmentNumber, this.timeOfPolicy, contactStateProviders);
        timeInSegment = Math.min(timeInSegment, 10.0);
        if (segmentNumber < 0) {
            return null;
        }
        this.mpcCommand.clear();
        this.mpcCommand.setSegmentNumber(segmentNumber);
        this.mpcCommand.setTimeOfObjective(timeInSegment);
        this.mpcCommand.setObjective((FrameTuple3DReadOnly)this.desiredCoMPosition);
        this.mpcCommand.setWeight(this.weight);
        this.mpcCommand.setOmega(omega);
        this.mpcCommand.setConstraintType(ConstraintType.LEQ_INEQUALITY);
        this.mpcCommand.getSelectionMatrix().set(this.selectionMatrix);
        for (int i = 0; i < contactHandler.getNumberOfContactPlanesInSegment(segmentNumber); ++i) {
            this.mpcCommand.addContactPlaneHelper(contactHandler.getContactPlane(segmentNumber, i));
        }
        return this.mpcCommand;
    }

    @Override
    public MPCCommand<?> getMPCCommand() {
        return this.mpcCommand;
    }
}

