/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.modelPredictiveController.core;

import java.util.ArrayList;
import java.util.List;
import org.ejml.data.DMatrix;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.commands.VRPTrackingCommand;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.core.LinearMPCIndexHandler;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.ioHandling.MPCContactPlane;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.ioHandling.MPCContactPoint;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.robotics.MatrixMissingTools;

public class VRPTrackingCostCalculator {
    private final LinearMPCIndexHandler indexHandler;
    private final double gravityZ;
    private final List<FrameVector3DReadOnly> allBasisVectors = new ArrayList<FrameVector3DReadOnly>();
    private final FrameVector3D vrpChange = new FrameVector3D();
    private final FrameVector3D c0Desired = new FrameVector3D();
    private final FrameVector3D c1Desired = new FrameVector3D();
    private final FrameVector3D c2Desired = new FrameVector3D();
    private final FrameVector3D c3Desired = new FrameVector3D();
    private final FramePoint3D desiredValuePosition = new FramePoint3D();
    private final FramePoint3D desiredValueVelocity = new FramePoint3D();

    public VRPTrackingCostCalculator(LinearMPCIndexHandler indexHandler, double gravityZ) {
        this.indexHandler = indexHandler;
        this.gravityZ = -Math.abs(gravityZ);
    }

    public boolean calculateVRPTrackingObjective(DMatrix costHessianToPack, DMatrix costGradientToPack, VRPTrackingCommand objective) {
        int segmentNumber = objective.getSegmentNumber();
        int startCoMIdx = this.indexHandler.getComCoefficientStartIndex(segmentNumber, 0);
        int startRhoIdx = this.indexHandler.getRhoCoefficientStartIndex(segmentNumber);
        if (VRPTrackingCostCalculator.hasValidVelocityBounds(objective)) {
            return this.calculateCubicVRPTrackingObjectiveInternal(costHessianToPack, costGradientToPack, objective, startCoMIdx, startRhoIdx);
        }
        return this.calculateLinearVRPTrackingObjectiveInternal(costHessianToPack, costGradientToPack, objective, startCoMIdx, startRhoIdx);
    }

    public boolean calculateCompactVRPTrackingObjective(DMatrix costHessianToPack, DMatrix costGradientToPack, VRPTrackingCommand objective) {
        if (VRPTrackingCostCalculator.hasValidVelocityBounds(objective)) {
            return this.calculateCubicVRPTrackingObjectiveInternal(costHessianToPack, costGradientToPack, objective, 0, 6);
        }
        return this.calculateLinearVRPTrackingObjectiveInternal(costHessianToPack, costGradientToPack, objective, 0, 6);
    }

    private static boolean hasValidVelocityBounds(VRPTrackingCommand objective) {
        return !objective.getStartVRPVelocity().containsNaN() && !objective.getEndVRPVelocity().containsNaN();
    }

    private boolean calculateLinearVRPTrackingObjectiveInternal(DMatrix costHessianToPack, DMatrix costGradientToPack, VRPTrackingCommand objective, int startCoMIdx, int startRhoIdx) {
        double omega = objective.getOmega();
        double w2 = omega * omega;
        double w4 = w2 * w2;
        double tEnd = objective.getSegmentDuration();
        double t2End = tEnd * tEnd;
        double t3End = tEnd * t2End;
        double t4End = tEnd * t3End;
        double t5End = tEnd * t4End;
        double t6End = tEnd * t5End;
        double t7End = tEnd * t6End;
        double c0c0End = t3End / 3.0;
        double c0c1End = 0.5 * t2End;
        double gc0End = t4End / 8.0 - 0.5 * t2End / w2;
        double gc1End = t3End / 6.0 - tEnd / w2;
        costHessianToPack.set(startCoMIdx, startCoMIdx, c0c0End);
        costHessianToPack.set(startCoMIdx, startCoMIdx + 1, c0c1End);
        costHessianToPack.set(startCoMIdx + 1, startCoMIdx, c0c1End);
        costHessianToPack.set(startCoMIdx + 1, startCoMIdx + 1, tEnd);
        costHessianToPack.set(startCoMIdx + 2, startCoMIdx + 2, c0c0End);
        costHessianToPack.set(startCoMIdx + 2, startCoMIdx + 3, c0c1End);
        costHessianToPack.set(startCoMIdx + 3, startCoMIdx + 2, c0c1End);
        costHessianToPack.set(startCoMIdx + 3, startCoMIdx + 3, tEnd);
        costHessianToPack.set(startCoMIdx + 4, startCoMIdx + 4, c0c0End);
        costHessianToPack.set(startCoMIdx + 4, startCoMIdx + 5, c0c1End);
        costHessianToPack.set(startCoMIdx + 5, startCoMIdx + 4, c0c1End);
        costHessianToPack.set(startCoMIdx + 5, startCoMIdx + 5, tEnd);
        costGradientToPack.set(startCoMIdx + 4, 0, gc0End * this.gravityZ);
        costGradientToPack.set(startCoMIdx + 5, 0, gc1End * this.gravityZ);
        this.allBasisVectors.clear();
        for (int contactPlaneIdx = 0; contactPlaneIdx < objective.getNumberOfContacts(); ++contactPlaneIdx) {
            MPCContactPlane contactPlane = objective.getContactPlaneHelper(contactPlaneIdx);
            for (int contactPointIdx = 0; contactPointIdx < contactPlane.getNumberOfContactPoints(); ++contactPointIdx) {
                MPCContactPoint contactPoint = contactPlane.getContactPointHelper(contactPointIdx);
                for (int i = 0; i < contactPoint.getRhoSize(); ++i) {
                    this.allBasisVectors.add(contactPoint.getBasisVector(i));
                }
            }
        }
        double a2a2End = t7End / 7.0 - 12.0 * t5End / (5.0 * w2) + 12.0 / w4 * t3End;
        double a2a3End = t6End / 6.0 - 2.0 * t4End / w2 + 6.0 / w4 * t2End;
        double a3a3End = t5End / 5.0 - 1.3333333333333333 * t3End / w2 + 4.0 / w4 * tEnd;
        double a2c0End = t5End / 5.0 - 2.0 * t3End / w2;
        double a3c0End = t4End / 4.0 - t2End / w2;
        double a2c1End = t4End / 4.0 - 3.0 * t2End / w2;
        double a3c1End = t3End / 3.0 - 2.0 * tEnd / w2;
        double a2DeltaEnd = t4End / 5.0 - 2.0 * t2End / w2;
        double a3DeltaEnd = t3End / 4.0 - tEnd / w2;
        double a2Start = a2c1End;
        double a3Start = a3c1End;
        double ga2End = t6End / 12.0 - t4End / w2 + 3.0 * t2End / w4;
        double ga3End = t5End / 10.0 - 2.0 * t3End / (3.0 * w2) + 2.0 / w4 * tEnd;
        this.c3Desired.set((FrameTuple3DReadOnly)objective.getStartVRP());
        this.c2Desired.sub((FrameTuple3DReadOnly)objective.getEndVRP(), (FrameTuple3DReadOnly)objective.getStartVRP());
        for (int ordinal = 0; ordinal < 3; ++ordinal) {
            int offset = 2 * ordinal + startCoMIdx;
            double c0 = t2End / 3.0 * this.c2Desired.getElement(ordinal) + t2End / 2.0 * this.c3Desired.getElement(ordinal);
            double c1 = tEnd / 2.0 * this.c2Desired.getElement(ordinal) + tEnd * this.c3Desired.getElement(ordinal);
            MatrixMissingTools.unsafe_add((DMatrix)costGradientToPack, (int)offset, (int)0, (double)(-c0));
            MatrixMissingTools.unsafe_add((DMatrix)costGradientToPack, (int)(offset + 1), (int)0, (double)(-c1));
        }
        for (int i = 0; i < this.allBasisVectors.size(); ++i) {
            int idxI = 4 * i + startRhoIdx + 2;
            FrameVector3DReadOnly basisVector = this.allBasisVectors.get(i);
            MatrixMissingTools.unsafe_add((DMatrix)costHessianToPack, (int)idxI, (int)idxI, (double)a2a2End);
            MatrixMissingTools.unsafe_add((DMatrix)costHessianToPack, (int)idxI, (int)(idxI + 1), (double)a2a3End);
            MatrixMissingTools.unsafe_add((DMatrix)costHessianToPack, (int)(idxI + 1), (int)idxI, (double)a2a3End);
            MatrixMissingTools.unsafe_add((DMatrix)costHessianToPack, (int)(idxI + 1), (int)(idxI + 1), (double)a3a3End);
            for (int j = i + 1; j < this.allBasisVectors.size(); ++j) {
                FrameVector3DReadOnly otherBasisVector = this.allBasisVectors.get(j);
                double basisDot = basisVector.dot(otherBasisVector);
                int idxJ = 4 * j + startRhoIdx + 2;
                MatrixMissingTools.unsafe_add((DMatrix)costHessianToPack, (int)idxI, (int)idxJ, (double)(basisDot * a2a2End));
                MatrixMissingTools.unsafe_add((DMatrix)costHessianToPack, (int)idxI, (int)(idxJ + 1), (double)(basisDot * a2a3End));
                MatrixMissingTools.unsafe_add((DMatrix)costHessianToPack, (int)(idxI + 1), (int)idxJ, (double)(basisDot * a2a3End));
                MatrixMissingTools.unsafe_add((DMatrix)costHessianToPack, (int)(idxI + 1), (int)(idxJ + 1), (double)(basisDot * a3a3End));
                MatrixMissingTools.unsafe_add((DMatrix)costHessianToPack, (int)idxJ, (int)idxI, (double)(basisDot * a2a2End));
                MatrixMissingTools.unsafe_add((DMatrix)costHessianToPack, (int)(idxJ + 1), (int)idxI, (double)(basisDot * a2a3End));
                MatrixMissingTools.unsafe_add((DMatrix)costHessianToPack, (int)idxJ, (int)(idxI + 1), (double)(basisDot * a2a3End));
                MatrixMissingTools.unsafe_add((DMatrix)costHessianToPack, (int)(idxJ + 1), (int)(idxI + 1), (double)(basisDot * a3a3End));
            }
            for (int ordinal = 0; ordinal < 3; ++ordinal) {
                int offset = startCoMIdx + 2 * ordinal;
                double value = basisVector.getElement(ordinal);
                MatrixMissingTools.unsafe_add((DMatrix)costHessianToPack, (int)offset, (int)idxI, (double)(a2c0End * value));
                MatrixMissingTools.unsafe_add((DMatrix)costHessianToPack, (int)offset, (int)(idxI + 1), (double)(a3c0End * value));
                MatrixMissingTools.unsafe_add((DMatrix)costHessianToPack, (int)(offset + 1), (int)idxI, (double)(a2c1End * value));
                MatrixMissingTools.unsafe_add((DMatrix)costHessianToPack, (int)(offset + 1), (int)(idxI + 1), (double)(a3c1End * value));
                MatrixMissingTools.unsafe_add((DMatrix)costHessianToPack, (int)idxI, (int)offset, (double)(a2c0End * value));
                MatrixMissingTools.unsafe_add((DMatrix)costHessianToPack, (int)(idxI + 1), (int)offset, (double)(a3c0End * value));
                MatrixMissingTools.unsafe_add((DMatrix)costHessianToPack, (int)idxI, (int)(offset + 1), (double)(a2c1End * value));
                MatrixMissingTools.unsafe_add((DMatrix)costHessianToPack, (int)(idxI + 1), (int)(offset + 1), (double)(a3c1End * value));
            }
            double basisDotDelta = this.c2Desired.dot(basisVector);
            double basisDotStart = this.c3Desired.dot(basisVector);
            double basisDotG = basisVector.getZ() * this.gravityZ;
            MatrixMissingTools.unsafe_add((DMatrix)costGradientToPack, (int)idxI, (int)0, (double)(-basisDotDelta * a2DeltaEnd - basisDotStart * a2Start + basisDotG * ga2End));
            MatrixMissingTools.unsafe_add((DMatrix)costGradientToPack, (int)(idxI + 1), (int)0, (double)(-basisDotDelta * a3DeltaEnd - basisDotStart * a3Start + basisDotG * ga3End));
        }
        return true;
    }

    private boolean calculateCubicVRPTrackingObjectiveInternal(DMatrix costHessianToPack, DMatrix costGradientToPack, VRPTrackingCommand objective, int startCoMIdx, int startRhoIdx) {
        double omega = objective.getOmega();
        double w2 = omega * omega;
        double w4 = w2 * w2;
        double duration = objective.getSegmentDuration();
        double t2 = duration * duration;
        double t3 = duration * t2;
        double tEnd = objective.getSegmentDuration();
        double t2End = tEnd * tEnd;
        double t3End = tEnd * t2End;
        double t4End = tEnd * t3End;
        double t5End = tEnd * t4End;
        double t6End = tEnd * t5End;
        double t7End = tEnd * t6End;
        double c0c0End = t3End / 3.0;
        double c0c1End = 0.5 * t2End;
        double gc0End = t4End / 8.0 - 0.5 * t2End / w2;
        double gc1End = t3End / 6.0 - tEnd / w2;
        costHessianToPack.set(startCoMIdx, startCoMIdx, c0c0End);
        costHessianToPack.set(startCoMIdx, startCoMIdx + 1, c0c1End);
        costHessianToPack.set(startCoMIdx + 1, startCoMIdx, c0c1End);
        costHessianToPack.set(startCoMIdx + 1, startCoMIdx + 1, tEnd);
        costHessianToPack.set(startCoMIdx + 2, startCoMIdx + 2, c0c0End);
        costHessianToPack.set(startCoMIdx + 2, startCoMIdx + 3, c0c1End);
        costHessianToPack.set(startCoMIdx + 3, startCoMIdx + 2, c0c1End);
        costHessianToPack.set(startCoMIdx + 3, startCoMIdx + 3, tEnd);
        costHessianToPack.set(startCoMIdx + 4, startCoMIdx + 4, c0c0End);
        costHessianToPack.set(startCoMIdx + 4, startCoMIdx + 5, c0c1End);
        costHessianToPack.set(startCoMIdx + 5, startCoMIdx + 4, c0c1End);
        costHessianToPack.set(startCoMIdx + 5, startCoMIdx + 5, tEnd);
        costGradientToPack.set(startCoMIdx + 4, 0, gc0End * this.gravityZ);
        costGradientToPack.set(startCoMIdx + 5, 0, gc1End * this.gravityZ);
        this.allBasisVectors.clear();
        for (int contactPlaneIdx = 0; contactPlaneIdx < objective.getNumberOfContacts(); ++contactPlaneIdx) {
            MPCContactPlane contactPlane = objective.getContactPlaneHelper(contactPlaneIdx);
            for (int contactPointIdx = 0; contactPointIdx < contactPlane.getNumberOfContactPoints(); ++contactPointIdx) {
                MPCContactPoint contactPoint = contactPlane.getContactPointHelper(contactPointIdx);
                for (int i = 0; i < contactPoint.getRhoSize(); ++i) {
                    this.allBasisVectors.add(contactPoint.getBasisVector(i));
                }
            }
        }
        double a2a2End = t7End / 7.0 - 12.0 * t5End / (5.0 * w2) + 12.0 / w4 * t3End;
        double a2a3End = t6End / 6.0 - 2.0 * t4End / w2 + 6.0 / w4 * t2End;
        double a3a3End = t5End / 5.0 - 1.3333333333333333 * t3End / w2 + 4.0 / w4 * tEnd;
        double a2c0End = t5End / 5.0 - 2.0 * t3End / w2;
        double a3c0End = t4End / 4.0 - t2End / w2;
        double a2c1End = t4End / 4.0 - 3.0 * t2End / w2;
        double a3c1End = t3End / 3.0 - 2.0 * tEnd / w2;
        double a2c0DesiredEnd = t7End / 7.0 - 6.0 * t5End / (5.0 * w2);
        double a3c0DesiredEnd = t6End / 6.0 - t4End / (2.0 * w2);
        double a2c1DesiredEnd = t6End / 6.0 - 3.0 * t4End / (2.0 * w2);
        double a3c1DesiredEnd = t5End / 5.0 - 2.0 * t3End / (3.0 * w2);
        double a2c2DesiredEnd = t5End / 5.0 - 2.0 * t3End / w2;
        double a3c2DesiredEnd = t4End / 4.0 - t2End / w2;
        double a2c3DesiredEnd = t4End / 4.0 - 3.0 * t2End / w2;
        double a3c3DesiredEnd = t3End / 3.0 - 2.0 * tEnd / w2;
        double ga2End = t6End / 12.0 - t4End / w2 + 3.0 * t2End / w4;
        double ga3End = t5End / 10.0 - 2.0 * t3End / (3.0 * w2) + 2.0 / w4 * tEnd;
        this.vrpChange.sub((FrameTuple3DReadOnly)objective.getEndVRP(), (FrameTuple3DReadOnly)objective.getStartVRP());
        this.c0Desired.add((FrameTuple3DReadOnly)objective.getEndVRPVelocity(), (FrameTuple3DReadOnly)objective.getStartVRPVelocity());
        this.c0Desired.scale(1.0 / t2);
        this.c0Desired.scaleAdd(-2.0 / t3, (FrameTuple3DReadOnly)this.vrpChange, (FrameTuple3DReadOnly)this.c0Desired);
        this.c1Desired.add((FrameTuple3DReadOnly)objective.getEndVRPVelocity(), (FrameTuple3DReadOnly)objective.getStartVRPVelocity());
        this.c1Desired.add((FrameTuple3DReadOnly)objective.getStartVRPVelocity());
        this.c1Desired.scale(-1.0 / duration);
        this.c1Desired.scaleAdd(3.0 / t2, (FrameTuple3DReadOnly)this.vrpChange, (FrameTuple3DReadOnly)this.c1Desired);
        this.c2Desired.set((FrameTuple3DReadOnly)objective.getStartVRPVelocity());
        this.c3Desired.set((FrameTuple3DReadOnly)objective.getStartVRP());
        this.desiredValuePosition.setAndScale(t5End / 5.0, (FrameTuple3DReadOnly)this.c0Desired);
        this.desiredValuePosition.scaleAdd(t4End / 4.0, (FrameTuple3DReadOnly)this.c1Desired, (FrameTuple3DReadOnly)this.desiredValuePosition);
        this.desiredValuePosition.scaleAdd(t3End / 3.0, (FrameTuple3DReadOnly)this.c2Desired, (FrameTuple3DReadOnly)this.desiredValuePosition);
        this.desiredValuePosition.scaleAdd(t2End / 2.0, (FrameTuple3DReadOnly)this.c3Desired, (FrameTuple3DReadOnly)this.desiredValuePosition);
        this.desiredValueVelocity.setAndScale(t4End / 4.0, (FrameTuple3DReadOnly)this.c0Desired);
        this.desiredValueVelocity.scaleAdd(t3End / 3.0, (FrameTuple3DReadOnly)this.c1Desired, (FrameTuple3DReadOnly)this.desiredValueVelocity);
        this.desiredValueVelocity.scaleAdd(t2End / 2.0, (FrameTuple3DReadOnly)this.c2Desired, (FrameTuple3DReadOnly)this.desiredValueVelocity);
        this.desiredValueVelocity.scaleAdd(tEnd, (FrameTuple3DReadOnly)this.c3Desired, (FrameTuple3DReadOnly)this.desiredValueVelocity);
        for (int ordinal = 0; ordinal < 3; ++ordinal) {
            int offset = 2 * ordinal + startCoMIdx;
            MatrixMissingTools.unsafe_add((DMatrix)costGradientToPack, (int)offset, (int)0, (double)(-this.desiredValuePosition.getElement(ordinal)));
            MatrixMissingTools.unsafe_add((DMatrix)costGradientToPack, (int)(offset + 1), (int)0, (double)(-this.desiredValueVelocity.getElement(ordinal)));
        }
        for (int i = 0; i < this.allBasisVectors.size(); ++i) {
            int idxI = 4 * i + startRhoIdx + 2;
            FrameVector3DReadOnly basisVector = this.allBasisVectors.get(i);
            MatrixMissingTools.unsafe_add((DMatrix)costHessianToPack, (int)idxI, (int)idxI, (double)a2a2End);
            MatrixMissingTools.unsafe_add((DMatrix)costHessianToPack, (int)idxI, (int)(idxI + 1), (double)a2a3End);
            MatrixMissingTools.unsafe_add((DMatrix)costHessianToPack, (int)(idxI + 1), (int)idxI, (double)a2a3End);
            MatrixMissingTools.unsafe_add((DMatrix)costHessianToPack, (int)(idxI + 1), (int)(idxI + 1), (double)a3a3End);
            for (int j = i + 1; j < this.allBasisVectors.size(); ++j) {
                FrameVector3DReadOnly otherBasisVector = this.allBasisVectors.get(j);
                double basisDot = basisVector.dot(otherBasisVector);
                int idxJ = 4 * j + startRhoIdx + 2;
                MatrixMissingTools.unsafe_add((DMatrix)costHessianToPack, (int)idxI, (int)idxJ, (double)(basisDot * a2a2End));
                MatrixMissingTools.unsafe_add((DMatrix)costHessianToPack, (int)idxI, (int)(idxJ + 1), (double)(basisDot * a2a3End));
                MatrixMissingTools.unsafe_add((DMatrix)costHessianToPack, (int)(idxI + 1), (int)idxJ, (double)(basisDot * a2a3End));
                MatrixMissingTools.unsafe_add((DMatrix)costHessianToPack, (int)(idxI + 1), (int)(idxJ + 1), (double)(basisDot * a3a3End));
                MatrixMissingTools.unsafe_add((DMatrix)costHessianToPack, (int)idxJ, (int)idxI, (double)(basisDot * a2a2End));
                MatrixMissingTools.unsafe_add((DMatrix)costHessianToPack, (int)(idxJ + 1), (int)idxI, (double)(basisDot * a2a3End));
                MatrixMissingTools.unsafe_add((DMatrix)costHessianToPack, (int)idxJ, (int)(idxI + 1), (double)(basisDot * a2a3End));
                MatrixMissingTools.unsafe_add((DMatrix)costHessianToPack, (int)(idxJ + 1), (int)(idxI + 1), (double)(basisDot * a3a3End));
            }
            for (int ordinal = 0; ordinal < 3; ++ordinal) {
                int offset = startCoMIdx + 2 * ordinal;
                double value = basisVector.getElement(ordinal);
                MatrixMissingTools.unsafe_add((DMatrix)costHessianToPack, (int)offset, (int)idxI, (double)(a2c0End * value));
                MatrixMissingTools.unsafe_add((DMatrix)costHessianToPack, (int)offset, (int)(idxI + 1), (double)(a3c0End * value));
                MatrixMissingTools.unsafe_add((DMatrix)costHessianToPack, (int)(offset + 1), (int)idxI, (double)(a2c1End * value));
                MatrixMissingTools.unsafe_add((DMatrix)costHessianToPack, (int)(offset + 1), (int)(idxI + 1), (double)(a3c1End * value));
                MatrixMissingTools.unsafe_add((DMatrix)costHessianToPack, (int)idxI, (int)offset, (double)(a2c0End * value));
                MatrixMissingTools.unsafe_add((DMatrix)costHessianToPack, (int)(idxI + 1), (int)offset, (double)(a3c0End * value));
                MatrixMissingTools.unsafe_add((DMatrix)costHessianToPack, (int)idxI, (int)(offset + 1), (double)(a2c1End * value));
                MatrixMissingTools.unsafe_add((DMatrix)costHessianToPack, (int)(idxI + 1), (int)(offset + 1), (double)(a3c1End * value));
            }
            double basisDotC0 = this.c0Desired.dot(basisVector);
            double basisDotC1 = this.c1Desired.dot(basisVector);
            double basisDotC2 = this.c2Desired.dot(basisVector);
            double basisDotC3 = this.c3Desired.dot(basisVector);
            double basisDotG = basisVector.getZ() * this.gravityZ;
            MatrixMissingTools.unsafe_add((DMatrix)costGradientToPack, (int)idxI, (int)0, (double)(-basisDotC0 * a2c0DesiredEnd - basisDotC1 * a2c1DesiredEnd - basisDotC2 * a2c2DesiredEnd - basisDotC3 * a2c3DesiredEnd + basisDotG * ga2End));
            MatrixMissingTools.unsafe_add((DMatrix)costGradientToPack, (int)(idxI + 1), (int)0, (double)(-basisDotC0 * a3c0DesiredEnd - basisDotC1 * a3c1DesiredEnd - basisDotC2 * a3c2DesiredEnd - basisDotC3 * a3c3DesiredEnd + basisDotG * ga3End));
        }
        return true;
    }
}

