/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.modelPredictiveController.core;

import java.util.List;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.misc.UnrolledInverseFromMinor_DDRM;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.core.CoMCoefficientJacobianCalculator;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.core.ContactPlaneJacobianCalculator;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.core.DiscretizationCalculator;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.core.EfficientFirstOrderHoldDiscretizationCalculator;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.ioHandling.MPCContactPlane;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.ioHandling.MPCContactPoint;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.CommonMatrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.matrixlib.MatrixTools;
import us.ihmc.robotics.MatrixMissingTools;

public class OrientationDynamicsCalculator {
    private final DMatrixRMaj gravityVector = new DMatrixRMaj(3, 1);
    private final FrameVector3D desiredNetAngularMomentumRate = new FrameVector3D();
    private final FrameVector3D desiredBodyAngularMomentumRate = new FrameVector3D();
    private final FrameVector3D rotatedBodyAngularMomentumRate = new FrameVector3D();
    private final DMatrixRMaj skewRotatedBodyAngularMomentumRate = new DMatrixRMaj(3, 3);
    private final CommonMatrix3DBasics desiredRotationMatrix = new RotationMatrix();
    private final DMatrixRMaj rotationMatrix = new DMatrixRMaj(3, 3);
    private final DMatrixRMaj inertiaMatrixInBody = new DMatrixRMaj(3, 3);
    private final DMatrixRMaj inverseInertia = new DMatrixRMaj(3, 3);
    private final DMatrixRMaj desiredBodyAngularVelocity = new DMatrixRMaj(3, 1);
    private final DMatrixRMaj skewDesiredBodyAngularVelocity = new DMatrixRMaj(3, 3);
    private final FrameVector3D desiredContactForce = new FrameVector3D();
    private final DMatrixRMaj skewDesiredContactForce = new DMatrixRMaj(3, 3);
    private final DMatrixRMaj comPositionJacobian = new DMatrixRMaj(3, 0);
    private final DMatrixRMaj contactPointForceJacobian = new DMatrixRMaj(3, 0);
    final DMatrixRMaj contactOriginTorqueJacobian = new DMatrixRMaj(3, 0);
    private final DMatrixRMaj b0 = new DMatrixRMaj(3, 1);
    private final DMatrixRMaj b1 = new DMatrixRMaj(3, 3);
    private final DMatrixRMaj b2 = new DMatrixRMaj(3, 3);
    private final DMatrixRMaj b3 = new DMatrixRMaj(3, 3);
    private final DMatrixRMaj b4 = new DMatrixRMaj(3, 3);
    private final DMatrixRMaj A = new DMatrixRMaj(6, 6);
    private final DMatrixRMaj B = new DMatrixRMaj(6, 0);
    private final DMatrixRMaj C = new DMatrixRMaj(6, 1);
    private DiscretizationCalculator discretizationCalculator = new EfficientFirstOrderHoldDiscretizationCalculator();
    private final DMatrixRMaj Ad = new DMatrixRMaj(6, 6);
    private final DMatrixRMaj Bd = new DMatrixRMaj(6, 0);
    private final DMatrixRMaj Cd = new DMatrixRMaj(6, 1);
    private final double mass;
    private static final DMatrixRMaj identity3 = CommonOps_DDRM.identity((int)3);
    private final DMatrixRMaj IR = new DMatrixRMaj(3, 3);
    private final DMatrixRMaj angularMomentum = new DMatrixRMaj(3, 1);
    private final DMatrixRMaj skewAngularMomentum = new DMatrixRMaj(3, 3);
    private final Vector3D torqueAboutPoint = new Vector3D();
    private final DMatrixRMaj torqueAboutPointVector = new DMatrixRMaj(3, 1);
    private final FrameVector3D momentArm = new FrameVector3D();
    private final DMatrixRMaj momentArmSkew = new DMatrixRMaj(3, 3);

    public OrientationDynamicsCalculator(double mass, double gravity) {
        this.mass = mass;
        this.gravityVector.set(2, 0, -Math.abs(gravity));
    }

    public void setDiscretizationCalculator(DiscretizationCalculator discretizationCalculator) {
        this.discretizationCalculator = discretizationCalculator;
    }

    public void setMomentumOfInertiaInBodyFrame(Matrix3DReadOnly inertiaMatrixInBody) {
        inertiaMatrixInBody.get((DMatrix)this.inertiaMatrixInBody);
    }

    public boolean compute(FramePoint3DReadOnly desiredComPosition, FrameVector3DReadOnly desiredCoMAcceleration, FrameOrientation3DReadOnly desiredBodyOrientation, Vector3DReadOnly desiredBodyAngularVelocityInBodyFrame, Vector3DReadOnly desiredNetAngularMomentumRate, Vector3DReadOnly desiredInternalAngularMomentumRate, List<MPCContactPlane> contactPlanes, double timeOfConstraint, double durationOfHold, double omega) {
        this.reset(contactPlanes);
        this.getAllTheTermsFromTheCommandInput(desiredCoMAcceleration, desiredBodyOrientation, desiredBodyAngularVelocityInBodyFrame, desiredNetAngularMomentumRate, desiredInternalAngularMomentumRate);
        this.calculateStateJacobians(desiredComPosition, contactPlanes, timeOfConstraint, omega);
        this.calculateAffineAxisAngleErrorTerms(desiredComPosition, desiredBodyAngularVelocityInBodyFrame, desiredNetAngularMomentumRate);
        this.computeAffineTimeInvariantTerms(timeOfConstraint, desiredBodyAngularVelocityInBodyFrame);
        if (!Double.isFinite(durationOfHold)) {
            throw new IllegalArgumentException("The duration of the hold is not finite.");
        }
        this.discretizationCalculator.compute(this.A, this.B, this.C, this.Ad, this.Bd, this.Cd, durationOfHold);
        return true;
    }

    DiscretizationCalculator getDiscretizationCalculator() {
        return this.discretizationCalculator;
    }

    DMatrixRMaj getContinuousAMatrix() {
        return this.A;
    }

    DMatrixRMaj getContinuousBMatrix() {
        return this.B;
    }

    DMatrixRMaj getContinuousCMatrix() {
        return this.C;
    }

    DMatrixRMaj getDiscreteAMatrix() {
        return this.Ad;
    }

    DMatrixRMaj getDiscreteBMatrix() {
        return this.Bd;
    }

    DMatrixRMaj getDiscreteCMatrix() {
        return this.Cd;
    }

    DMatrixRMaj getB0() {
        return this.b0;
    }

    DMatrixRMaj getB1() {
        return this.b1;
    }

    DMatrixRMaj getB2() {
        return this.b2;
    }

    DMatrixRMaj getB3() {
        return this.b3;
    }

    DMatrixRMaj getB4() {
        return this.b4;
    }

    private void reset(List<MPCContactPlane> contactPlanes) {
        int rhoCoefficientsInSegment = 0;
        for (int i = 0; i < contactPlanes.size(); ++i) {
            rhoCoefficientsInSegment += contactPlanes.get(i).getCoefficientSize();
        }
        int coefficientsInSegment = 6 + rhoCoefficientsInSegment;
        this.comPositionJacobian.reshape(3, coefficientsInSegment);
        this.contactOriginTorqueJacobian.reshape(3, rhoCoefficientsInSegment);
        this.B.reshape(6, coefficientsInSegment);
        this.Bd.reshape(6, coefficientsInSegment);
        this.comPositionJacobian.zero();
        this.contactOriginTorqueJacobian.zero();
        this.b0.zero();
        this.b1.zero();
        this.b2.zero();
        this.b3.zero();
        this.b4.zero();
        this.A.zero();
        this.B.zero();
        this.C.zero();
        this.Ad.zero();
        this.Bd.zero();
        this.Cd.zero();
    }

    private void getAllTheTermsFromTheCommandInput(FrameVector3DReadOnly desiredCoMAcceleration, FrameOrientation3DReadOnly desiredBodyOrientation, Vector3DReadOnly desiredBodyAngularVelocityInBodyFrame, Vector3DReadOnly desiredNetAngularMomentumRate, Vector3DReadOnly desiredInternalAngularMomentumRate) {
        this.desiredNetAngularMomentumRate.set((Tuple3DReadOnly)desiredNetAngularMomentumRate);
        this.desiredBodyAngularMomentumRate.sub((Tuple3DReadOnly)desiredNetAngularMomentumRate, (Tuple3DReadOnly)desiredInternalAngularMomentumRate);
        desiredBodyOrientation.get(this.desiredRotationMatrix);
        this.desiredRotationMatrix.get((DMatrix)this.rotationMatrix);
        desiredBodyAngularVelocityInBodyFrame.get((DMatrix)this.desiredBodyAngularVelocity);
        this.desiredContactForce.set((FrameTuple3DReadOnly)desiredCoMAcceleration);
        this.desiredContactForce.addZ(-this.gravityVector.get(2, 0));
        this.desiredContactForce.scale(this.mass);
        MatrixMissingTools.toSkewSymmetricMatrix((Tuple3DReadOnly)this.desiredContactForce, (DMatrixRMaj)this.skewDesiredContactForce);
        MatrixMissingTools.toSkewSymmetricMatrix((Tuple3DReadOnly)desiredBodyAngularVelocityInBodyFrame, (DMatrixRMaj)this.skewDesiredBodyAngularVelocity);
        UnrolledInverseFromMinor_DDRM.inv3((DMatrixRMaj)this.inertiaMatrixInBody, (DMatrixRMaj)this.inverseInertia, (double)1.0);
    }

    private void calculateStateJacobians(FramePoint3DReadOnly desiredCoMPosition, List<MPCContactPlane> contactPlanes, double timeOfConstraint, double omega) {
        int rhoStartIndex = 0;
        CoMCoefficientJacobianCalculator.calculateCoMJacobian(0, timeOfConstraint, (DMatrix)this.comPositionJacobian, 0, 1.0);
        for (int i = 0; i < contactPlanes.size(); ++i) {
            MPCContactPlane contactPlane = contactPlanes.get(i);
            ContactPlaneJacobianCalculator.computeLinearJacobian(0, timeOfConstraint, omega, 6 + rhoStartIndex, contactPlane, (DMatrix)this.comPositionJacobian);
            this.computeTorqueJacobian(rhoStartIndex, timeOfConstraint, omega, desiredCoMPosition, contactPlane, this.contactOriginTorqueJacobian);
            rhoStartIndex += contactPlane.getCoefficientSize();
        }
    }

    private void calculateAffineAxisAngleErrorTerms(FramePoint3DReadOnly desiredCoMPosition, Vector3DReadOnly desiredBodyAngularVelocityInBodyFrame, Vector3DReadOnly desiredNetAngularMomentumRate) {
        CommonOps_DDRM.multTransB((DMatrix1Row)this.inverseInertia, (DMatrix1Row)this.rotationMatrix, (DMatrix1Row)this.IR);
        CommonOps_DDRM.mult((DMatrix1Row)this.IR, (DMatrix1Row)this.skewDesiredContactForce, (DMatrix1Row)this.b1);
        CommonOps_DDRM.mult((DMatrix1Row)this.IR, (DMatrix1Row)this.contactOriginTorqueJacobian, (DMatrix1Row)this.b2);
        this.desiredRotationMatrix.inverseTransform((Tuple3DReadOnly)this.desiredBodyAngularMomentumRate, (Tuple3DBasics)this.rotatedBodyAngularMomentumRate);
        MatrixMissingTools.toSkewSymmetricMatrix((Tuple3DReadOnly)this.rotatedBodyAngularMomentumRate, (DMatrixRMaj)this.skewRotatedBodyAngularMomentumRate);
        CommonOps_DDRM.mult((DMatrix1Row)this.inverseInertia, (DMatrix1Row)this.skewRotatedBodyAngularMomentumRate, (DMatrix1Row)this.b3);
        CommonOps_DDRM.mult((DMatrix1Row)this.inertiaMatrixInBody, (DMatrix1Row)this.desiredBodyAngularVelocity, (DMatrix1Row)this.angularMomentum);
        MatrixMissingTools.toSkewSymmetricMatrix((DMatrix1Row)this.angularMomentum, (DMatrixRMaj)this.skewAngularMomentum);
        OrientationDynamicsCalculator.crossSub(this.skewAngularMomentum, desiredBodyAngularVelocityInBodyFrame, this.inertiaMatrixInBody);
        CommonOps_DDRM.mult((DMatrix1Row)this.inverseInertia, (DMatrix1Row)this.skewAngularMomentum, (DMatrix1Row)this.b4);
        this.torqueAboutPoint.cross((Tuple3DReadOnly)this.desiredContactForce, (Tuple3DReadOnly)desiredCoMPosition);
        this.torqueAboutPoint.add((Tuple3DReadOnly)desiredNetAngularMomentumRate);
        this.torqueAboutPoint.scale(-1.0);
        this.torqueAboutPoint.get((DMatrix)this.torqueAboutPointVector);
        CommonOps_DDRM.mult((DMatrix1Row)this.IR, (DMatrix1Row)this.torqueAboutPointVector, (DMatrix1Row)this.b0);
    }

    private void computeTorqueJacobian(int colStart, double timeOfConstraint, double omega, FramePoint3DReadOnly desiredCoMPosition, MPCContactPlane contactPlane, DMatrixRMaj jacobianToPack) {
        for (int i = 0; i < contactPlane.getNumberOfContactPoints(); ++i) {
            MPCContactPoint contactPoint = contactPlane.getContactPointHelper(i);
            this.momentArm.sub((FrameTuple3DReadOnly)contactPoint.getBasisVectorOrigin(), (FrameTuple3DReadOnly)desiredCoMPosition);
            MatrixMissingTools.toSkewSymmetricMatrix((Tuple3DReadOnly)this.momentArm, (DMatrixRMaj)this.momentArmSkew);
            this.contactPointForceJacobian.reshape(3, contactPoint.getCoefficientsSize());
            ContactPlaneJacobianCalculator.computeContactPointAccelerationJacobian(this.mass, timeOfConstraint, omega, 0, 0, contactPoint, (DMatrix)this.contactPointForceJacobian);
            MatrixMissingTools.multSetBlock((DMatrix1Row)this.momentArmSkew, (DMatrix1Row)this.contactPointForceJacobian, (DMatrix1Row)jacobianToPack, (int)0, (int)colStart);
            colStart += contactPoint.getCoefficientsSize();
        }
    }

    private void computeAffineTimeInvariantTerms(double timeOfConstraint, Vector3DReadOnly desiredBodyAngularVelocityInBodyFrame) {
        MatrixMissingTools.toSkewSymmetricMatrix((double)-1.0, (Tuple3DReadOnly)desiredBodyAngularVelocityInBodyFrame, (DMatrixRMaj)this.A, (int)0, (int)0);
        MatrixTools.setMatrixBlock((DMatrix)this.A, (int)0, (int)0, (DMatrix)this.skewDesiredBodyAngularVelocity, (int)0, (int)0, (int)3, (int)3, (double)-1.0);
        MatrixTools.setMatrixBlock((DMatrix)this.A, (int)0, (int)3, (DMatrix)identity3, (int)0, (int)0, (int)3, (int)3, (double)1.0);
        MatrixTools.setMatrixBlock((DMatrix)this.A, (int)3, (int)0, (DMatrix)this.b3, (int)0, (int)0, (int)3, (int)3, (double)1.0);
        MatrixTools.setMatrixBlock((DMatrix)this.A, (int)3, (int)3, (DMatrix)this.b4, (int)0, (int)0, (int)3, (int)3, (double)1.0);
        MatrixMissingTools.multSetBlock((DMatrix1Row)this.b1, (DMatrix1Row)this.comPositionJacobian, (DMatrix1Row)this.B, (int)3, (int)0);
        MatrixTools.addMatrixBlock((DMatrix)this.B, (int)3, (int)6, (DMatrix1Row)this.b2, (int)0, (int)0, (int)3, (int)this.b2.getNumCols(), (double)1.0);
        MatrixTools.setMatrixBlock((DMatrix)this.C, (int)3, (int)0, (DMatrix)this.b0, (int)0, (int)0, (int)3, (int)1, (double)1.0);
        MatrixTools.multAddBlock((double)(0.5 * timeOfConstraint * timeOfConstraint), (DMatrix1Row)this.b1, (DMatrix1Row)this.gravityVector, (DMatrix1Row)this.C, (int)3, (int)0);
    }

    private static void crossSub(DMatrixRMaj result, Vector3DReadOnly vector, DMatrixRMaj matrix) {
        if (result.getNumCols() != 3 || result.getNumRows() != 3) {
            throw new IllegalArgumentException("Improperly sized results matrix!");
        }
        result.add(0, 0, vector.getZ() * matrix.get(1, 0) - vector.getY() * matrix.get(2, 0));
        result.add(0, 1, vector.getZ() * matrix.get(1, 1) - vector.getY() * matrix.get(2, 1));
        result.add(0, 2, vector.getZ() * matrix.get(1, 2) - vector.getY() * matrix.get(2, 2));
        result.add(1, 0, vector.getX() * matrix.get(2, 0) - vector.getZ() * matrix.get(0, 0));
        result.add(1, 1, vector.getX() * matrix.get(2, 1) - vector.getZ() * matrix.get(0, 1));
        result.add(1, 2, vector.getX() * matrix.get(2, 2) - vector.getZ() * matrix.get(0, 2));
        result.add(2, 0, vector.getY() * matrix.get(0, 0) - vector.getX() * matrix.get(1, 0));
        result.add(2, 1, vector.getY() * matrix.get(0, 1) - vector.getX() * matrix.get(1, 1));
        result.add(2, 2, vector.getY() * matrix.get(0, 2) - vector.getX() * matrix.get(1, 2));
    }
}

