/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.modelPredictiveController.core;

import org.ejml.data.DMatrix;
import us.ihmc.commons.MathTools;
import us.ihmc.robotics.MatrixMissingTools;

public class CoMCoefficientJacobianCalculator {
    public static void calculateCoMJacobian(int startIndex, double time, DMatrix jacobianToPack, int derivative, double scale) {
        switch (derivative) {
            case 0: {
                CoMCoefficientJacobianCalculator.calculatePositionJacobian(startIndex, time, jacobianToPack, scale);
                break;
            }
            case 1: {
                CoMCoefficientJacobianCalculator.calculateVelocityJacobian(startIndex, jacobianToPack, scale);
                break;
            }
            case 2: {
                CoMCoefficientJacobianCalculator.calculateAccelerationJacobian();
                break;
            }
            case 3: {
                CoMCoefficientJacobianCalculator.calculateJerkJacobian();
                break;
            }
            default: {
                throw new IllegalArgumentException("Derivative order must be less than 4.");
            }
        }
    }

    public static void calculateDCMJacobian(int startIndex, double omega, double time, DMatrix jacobianToPack, int derivative, double scale) {
        CoMCoefficientJacobianCalculator.calculateCoMJacobian(startIndex, time, jacobianToPack, derivative, scale);
        CoMCoefficientJacobianCalculator.calculateCoMJacobian(startIndex, time, jacobianToPack, derivative + 1, scale / omega);
    }

    public static void calculateVRPJacobian(int startIndex, double omega, double time, DMatrix jacobianToPack, int derivative, double scale) {
        CoMCoefficientJacobianCalculator.calculateCoMJacobian(startIndex, time, jacobianToPack, derivative, scale);
        CoMCoefficientJacobianCalculator.calculateCoMJacobian(startIndex, time, jacobianToPack, derivative + 2, -scale / (omega * omega));
    }

    private static void calculatePositionJacobian(int startIndex, double time, DMatrix positionJacobianToPack, double scale) {
        if (positionJacobianToPack.getNumRows() < 3 || startIndex < 0 || positionJacobianToPack.getNumCols() < startIndex + 6) {
            throw new IllegalArgumentException("Outside of matrix bounds");
        }
        double c1 = scale;
        MatrixMissingTools.unsafe_add((DMatrix)positionJacobianToPack, (int)0, (int)(startIndex + 1), (double)c1);
        MatrixMissingTools.unsafe_add((DMatrix)positionJacobianToPack, (int)1, (int)(startIndex + 3), (double)c1);
        MatrixMissingTools.unsafe_add((DMatrix)positionJacobianToPack, (int)2, (int)(startIndex + 5), (double)c1);
        if (!MathTools.epsilonEquals((double)time, (double)0.0, (double)1.0E-5)) {
            time = Math.min(5.0, time);
            double c0 = time * c1;
            MatrixMissingTools.unsafe_add((DMatrix)positionJacobianToPack, (int)0, (int)startIndex, (double)c0);
            MatrixMissingTools.unsafe_add((DMatrix)positionJacobianToPack, (int)1, (int)(startIndex + 2), (double)c0);
            MatrixMissingTools.unsafe_add((DMatrix)positionJacobianToPack, (int)2, (int)(startIndex + 4), (double)c0);
        }
    }

    private static void calculateVelocityJacobian(int startIndex, DMatrix velocityJacobianToPack, double scale) {
        if (velocityJacobianToPack.getNumRows() < 3 || startIndex < 0 || velocityJacobianToPack.getNumCols() < startIndex + 6) {
            throw new IllegalArgumentException("Outside of matrix bounds");
        }
        MatrixMissingTools.unsafe_add((DMatrix)velocityJacobianToPack, (int)0, (int)startIndex, (double)scale);
        MatrixMissingTools.unsafe_add((DMatrix)velocityJacobianToPack, (int)1, (int)(startIndex + 2), (double)scale);
        MatrixMissingTools.unsafe_add((DMatrix)velocityJacobianToPack, (int)2, (int)(startIndex + 4), (double)scale);
    }

    private static void calculateAccelerationJacobian() {
    }

    private static void calculateJerkJacobian() {
    }
}

