/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.modelPredictiveController.core;

import java.util.function.IntUnaryOperator;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.core.LinearMPCIndexHandler;
import us.ihmc.convexOptimization.quadraticProgram.InverseMatrixCalculator;
import us.ihmc.matrixlib.NativeMatrix;

public class BlockInverseCalculator
implements InverseMatrixCalculator<NativeMatrix> {
    private final LinearMPCIndexHandler indexHandler;
    private final NativeMatrix blockToInvert = new NativeMatrix(0, 0);
    private final NativeMatrix invertedBlock = new NativeMatrix(0, 0);
    private final IntUnaryOperator blockStartProvider;
    private final IntUnaryOperator blockSizeProvider;

    public BlockInverseCalculator(LinearMPCIndexHandler indexHandler, IntUnaryOperator blockStartProvider, IntUnaryOperator blockSizeProvider) {
        this.indexHandler = indexHandler;
        this.blockStartProvider = blockStartProvider;
        this.blockSizeProvider = blockSizeProvider;
    }

    public void computeInverse(NativeMatrix matrix, NativeMatrix inverseMatrixToPack) {
        inverseMatrixToPack.reshape(this.indexHandler.getTotalProblemSize(), this.indexHandler.getTotalProblemSize());
        inverseMatrixToPack.zero();
        for (int i = 0; i < this.indexHandler.getNumberOfSegments(); ++i) {
            int start = this.blockStartProvider.applyAsInt(i);
            int blockSize = this.blockSizeProvider.applyAsInt(i);
            int end = start + blockSize;
            this.blockToInvert.reshape(blockSize, blockSize);
            this.invertedBlock.reshape(blockSize, blockSize);
            this.blockToInvert.insert(matrix, start, end, start, end, 0, 0);
            this.invertedBlock.invert(this.blockToInvert);
            inverseMatrixToPack.insert(this.invertedBlock, start, start);
        }
    }
}

