/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.modelPredictiveController.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.function.DoubleConsumer;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.commands.MPCCommand;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.commands.MPCCommandType;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.ioHandling.MPCContactPlane;

public class RhoRateTrackingCommand
implements MPCCommand<RhoRateTrackingCommand> {
    private int commandId;
    private final List<MPCContactPlane> contactPlaneHelpers = new ArrayList<MPCContactPlane>();
    private int segmentNumber;
    private double omega;
    private double weight;
    private double segmentDuration;
    private double objectiveValue = 0.0;
    private DoubleConsumer costToGoConsumer;

    @Override
    public MPCCommandType getCommandType() {
        return MPCCommandType.RHO_RATE_TRACKING;
    }

    public void clear() {
        this.segmentNumber = -1;
        this.costToGoConsumer = null;
        this.segmentDuration = Double.NaN;
        this.objectiveValue = 0.0;
        this.contactPlaneHelpers.clear();
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public void setSegmentDuration(double duration) {
        this.segmentDuration = duration;
    }

    public void setObjectiveValue(double objectiveValue) {
        this.objectiveValue = objectiveValue;
    }

    public void addContactPlaneHelper(MPCContactPlane contactPlaneHelper) {
        this.contactPlaneHelpers.add(contactPlaneHelper);
    }

    public void setSegmentNumber(int segmentNumber) {
        this.segmentNumber = segmentNumber;
    }

    public void setOmega(double omega) {
        this.omega = omega;
    }

    public int getSegmentNumber() {
        return this.segmentNumber;
    }

    public double getWeight() {
        return this.weight;
    }

    public double getSegmentDuration() {
        return this.segmentDuration;
    }

    public double getObjectiveValue() {
        return this.objectiveValue;
    }

    public double getOmega() {
        return this.omega;
    }

    public int getNumberOfContacts() {
        return this.contactPlaneHelpers.size();
    }

    public MPCContactPlane getContactPlaneHelper(int i) {
        return this.contactPlaneHelpers.get(i);
    }

    public void setCostToGoConsumer(DoubleConsumer costToGoConsumer) {
        this.costToGoConsumer = costToGoConsumer;
    }

    public DoubleConsumer getCostToGoConsumer() {
        return this.costToGoConsumer;
    }

    public void setCostToGo(double costToGo) {
        if (this.costToGoConsumer != null) {
            this.costToGoConsumer.accept(costToGo);
        }
    }

    public void set(RhoRateTrackingCommand other) {
        this.clear();
        this.setCommandId(other.getCommandId());
        this.setSegmentNumber(other.getSegmentNumber());
        this.setOmega(other.getOmega());
        this.setWeight(other.getWeight());
        this.setCostToGoConsumer(other.getCostToGoConsumer());
        this.setSegmentDuration(other.getSegmentDuration());
        this.setObjectiveValue(other.getObjectiveValue());
        for (int i = 0; i < other.getNumberOfContacts(); ++i) {
            this.addContactPlaneHelper(other.getContactPlaneHelper(i));
        }
    }

    @Override
    public void setCommandId(int id) {
        this.commandId = id;
    }

    @Override
    public int getCommandId() {
        return this.commandId;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof RhoRateTrackingCommand) {
            RhoRateTrackingCommand other = (RhoRateTrackingCommand)object;
            if (this.commandId != other.commandId) {
                return false;
            }
            if (this.segmentNumber != other.segmentNumber) {
                return false;
            }
            if (this.omega != other.omega) {
                return false;
            }
            if (this.weight != other.weight) {
                return false;
            }
            if (this.segmentDuration != other.segmentDuration) {
                return false;
            }
            if (this.contactPlaneHelpers.size() != other.contactPlaneHelpers.size()) {
                return false;
            }
            if (this.objectiveValue != other.objectiveValue) {
                return false;
            }
            for (int i = 0; i < this.contactPlaneHelpers.size(); ++i) {
                if (this.contactPlaneHelpers.get(i).equals(other.contactPlaneHelpers.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        String string = this.getClass().getSimpleName() + ": segment number: " + this.segmentNumber + ", omega: " + this.omega + ", weight: " + this.weight + ".";
        for (int i = 0; i < this.getNumberOfContacts(); ++i) {
            string = string + "\ncontact " + i + ": " + this.contactPlaneHelpers.get(i);
        }
        return string;
    }
}

