/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.modelPredictiveController.commands;

import gnu.trove.list.array.TDoubleArrayList;
import java.util.ArrayList;
import java.util.List;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ConstraintType;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.commands.MPCCommand;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.commands.MPCCommandType;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.ioHandling.MPCContactPlane;

public class RhoBoundCommand
implements MPCCommand<RhoBoundCommand> {
    private int commandId;
    private final List<MPCContactPlane> contactPlanes = new ArrayList<MPCContactPlane>();
    private final TDoubleArrayList rhoValues = new TDoubleArrayList();
    private ConstraintType constraintType;
    private int segmentNumber;
    private double segmentDuration;
    private double omega;
    private double slackVariableWeight = Double.NaN;

    public void clear() {
        this.contactPlanes.clear();
        this.rhoValues.reset();
        this.segmentNumber = -1;
        this.segmentDuration = Double.NaN;
        this.slackVariableWeight = Double.NaN;
        this.constraintType = null;
    }

    public void addContactPlane(MPCContactPlane contactPlane, double rhoValue) {
        this.contactPlanes.add(contactPlane);
        this.rhoValues.add(rhoValue);
    }

    public void setSegmentNumber(int segmentNumber) {
        this.segmentNumber = segmentNumber;
    }

    public void setSegmentDuration(double segmentDuration) {
        this.segmentDuration = segmentDuration;
    }

    public void setOmega(double omega) {
        this.omega = omega;
    }

    public void setSlackVariableWeight(double slackVariableWeight) {
        this.slackVariableWeight = slackVariableWeight;
    }

    public int getSegmentNumber() {
        return this.segmentNumber;
    }

    public double getSegmentDuration() {
        return this.segmentDuration;
    }

    public double getOmega() {
        return this.omega;
    }

    public int getNumberOfContacts() {
        return this.contactPlanes.size();
    }

    public MPCContactPlane getContactPlane(int i) {
        return this.contactPlanes.get(i);
    }

    public double getRhoValue(int i) {
        return this.rhoValues.get(i);
    }

    public double getSlackVariableWeight() {
        return this.slackVariableWeight;
    }

    public void setConstraintType(ConstraintType constraintType) {
        this.constraintType = constraintType;
    }

    public ConstraintType getConstraintType() {
        return this.constraintType;
    }

    @Override
    public MPCCommandType getCommandType() {
        return MPCCommandType.RHO_BOUND;
    }

    public void set(RhoBoundCommand other) {
        this.clear();
        this.setCommandId(other.getCommandId());
        this.setSegmentNumber(other.getSegmentNumber());
        this.setSegmentDuration(other.getSegmentDuration());
        this.setOmega(other.getOmega());
        this.setConstraintType(other.getConstraintType());
        this.setSlackVariableWeight(other.getSlackVariableWeight());
        for (int i = 0; i < other.getNumberOfContacts(); ++i) {
            this.addContactPlane(other.getContactPlane(i), other.getRhoValue(i));
        }
    }

    @Override
    public void setCommandId(int id) {
        this.commandId = id;
    }

    @Override
    public int getCommandId() {
        return this.commandId;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof RhoBoundCommand) {
            RhoBoundCommand other = (RhoBoundCommand)object;
            if (this.commandId != other.commandId) {
                return false;
            }
            if (this.segmentNumber != other.segmentNumber) {
                return false;
            }
            if (this.segmentDuration != other.segmentDuration) {
                return false;
            }
            if (this.omega != other.omega) {
                return false;
            }
            if (this.constraintType != other.constraintType) {
                return false;
            }
            if (this.getNumberOfContacts() != other.getNumberOfContacts()) {
                return false;
            }
            if (this.slackVariableWeight != other.slackVariableWeight) {
                return false;
            }
            for (int i = 0; i < this.getNumberOfContacts(); ++i) {
                if (!this.contactPlanes.get(i).equals(other.contactPlanes.get(i))) {
                    return false;
                }
                if (this.rhoValues.get(i) == other.getRhoValue(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        String string = this.getClass().getSimpleName() + ": segment number: " + this.segmentNumber + ", time of objective: " + this.segmentDuration + ", omega: " + this.omega;
        for (int i = 0; i < this.getNumberOfContacts(); ++i) {
            string = string + "\ncontact " + i + " : " + this.contactPlanes.get(i);
        }
        return string;
    }
}

