/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.modelPredictiveController.commands;

import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.commands.MPCCommand;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.commands.MPCCommandType;
import us.ihmc.commons.lists.RecyclingArrayList;

public class OrientationTrajectoryCommand
implements MPCCommand<OrientationTrajectoryCommand> {
    private int commandId = -1;
    private int segmentNumber = -1;
    private final RecyclingArrayList<DMatrixRMaj> AMatricesInSegment = new RecyclingArrayList(() -> new DMatrixRMaj(6, 6));
    private final RecyclingArrayList<DMatrixRMaj> BMatricesInSegment = new RecyclingArrayList(() -> new DMatrixRMaj(6, 0));
    private final RecyclingArrayList<DMatrixRMaj> CMatricesInSegment = new RecyclingArrayList(() -> new DMatrixRMaj(6, 1));
    private double angleErrorMinimizationWeight;
    private double velocityErrorMinimizationWeight;

    @Override
    public MPCCommandType getCommandType() {
        return MPCCommandType.ORIENTATION_TRAJECTORY;
    }

    @Override
    public void setCommandId(int id) {
        this.commandId = id;
    }

    @Override
    public int getCommandId() {
        return this.commandId;
    }

    public void reset() {
        this.angleErrorMinimizationWeight = 0.0;
        this.velocityErrorMinimizationWeight = 0.0;
        this.segmentNumber = -1;
        this.AMatricesInSegment.clear();
        this.BMatricesInSegment.clear();
        this.CMatricesInSegment.clear();
    }

    public int getSegmentNumber() {
        return this.segmentNumber;
    }

    public void setSegmentNumber(int segmentNumber) {
        this.segmentNumber = segmentNumber;
    }

    public int getNumberOfTicksInSegment() {
        return this.AMatricesInSegment.size();
    }

    public void setAngleErrorMinimizationWeight(double angleErrorMinimizationWeight) {
        this.angleErrorMinimizationWeight = angleErrorMinimizationWeight;
    }

    public void setVelocityErrorMinimizationWeight(double velocityErrorMinimizationWeight) {
        this.velocityErrorMinimizationWeight = velocityErrorMinimizationWeight;
    }

    public double getAngleErrorMinimizationWeight() {
        return this.angleErrorMinimizationWeight;
    }

    public double getVelocityErrorMinimizationWeight() {
        return this.velocityErrorMinimizationWeight;
    }

    public DMatrixRMaj addAMatrix() {
        return (DMatrixRMaj)this.AMatricesInSegment.add();
    }

    public DMatrixRMaj addBMatrix() {
        return (DMatrixRMaj)this.BMatricesInSegment.add();
    }

    public DMatrixRMaj addCMatrix() {
        return (DMatrixRMaj)this.CMatricesInSegment.add();
    }

    public DMatrixRMaj getAMatrix(int tick) {
        return (DMatrixRMaj)this.AMatricesInSegment.get(tick);
    }

    public DMatrixRMaj getBMatrix(int tick) {
        return (DMatrixRMaj)this.BMatricesInSegment.get(tick);
    }

    public DMatrixRMaj getCMatrix(int tick) {
        return (DMatrixRMaj)this.CMatricesInSegment.get(tick);
    }

    public DMatrixRMaj getLastAMatrix() {
        return (DMatrixRMaj)this.AMatricesInSegment.getLast();
    }

    public DMatrixRMaj getLastBMatrix() {
        return (DMatrixRMaj)this.BMatricesInSegment.getLast();
    }

    public DMatrixRMaj getLastCMatrix() {
        return (DMatrixRMaj)this.CMatricesInSegment.getLast();
    }

    public void set(OrientationTrajectoryCommand other) {
        this.reset();
        this.setCommandId(other.getCommandId());
        this.setSegmentNumber(other.getSegmentNumber());
        this.setAngleErrorMinimizationWeight(other.getAngleErrorMinimizationWeight());
        this.setVelocityErrorMinimizationWeight(other.getVelocityErrorMinimizationWeight());
        for (int tick = 0; tick < other.getNumberOfTicksInSegment(); ++tick) {
            this.addAMatrix().set((DMatrixD1)other.getAMatrix(tick));
            this.addBMatrix().set((DMatrixD1)other.getBMatrix(tick));
            this.addCMatrix().set((DMatrixD1)other.getCMatrix(tick));
        }
    }
}

