/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.modelPredictiveController.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.function.DoubleConsumer;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ConstraintType;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.commands.MPCCommand;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.commands.MPCCommandType;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.commands.MPCValueType;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.ioHandling.MPCContactPlane;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.robotics.screwTheory.SelectionMatrix3D;

public abstract class MPCValueCommand
implements MPCCommand<MPCValueCommand> {
    private int commandId;
    private final FramePoint3D objective = new FramePoint3D();
    private final List<MPCContactPlane> contactPlaneHelpers = new ArrayList<MPCContactPlane>();
    private final SelectionMatrix3D selectionMatrix = new SelectionMatrix3D();
    private int segmentNumber;
    private double timeOfObjective;
    private double omega;
    private double weight;
    private ConstraintType constraintType = ConstraintType.OBJECTIVE;
    private DoubleConsumer costToGoConsumer;

    @Override
    public MPCCommandType getCommandType() {
        return MPCCommandType.VALUE;
    }

    public void setConstraintType(ConstraintType constraintType) {
        this.constraintType = constraintType;
    }

    public ConstraintType getConstraintType() {
        return this.constraintType;
    }

    public abstract int getDerivativeOrder();

    public abstract MPCValueType getValueType();

    public void clear() {
        this.costToGoConsumer = null;
        this.segmentNumber = -1;
        this.timeOfObjective = Double.NaN;
        this.objective.setToNaN();
        this.contactPlaneHelpers.clear();
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public void addContactPlaneHelper(MPCContactPlane contactPlaneHelper) {
        this.contactPlaneHelpers.add(contactPlaneHelper);
    }

    public void setObjective(FrameTuple3DReadOnly objective) {
        this.objective.set(objective);
    }

    public void setSegmentNumber(int segmentNumber) {
        this.segmentNumber = segmentNumber;
    }

    public void setTimeOfObjective(double timeOfObjective) {
        this.timeOfObjective = timeOfObjective;
    }

    public void setOmega(double omega) {
        this.omega = omega;
    }

    public int getSegmentNumber() {
        return this.segmentNumber;
    }

    public double getWeight() {
        return this.weight;
    }

    public double getTimeOfObjective() {
        return this.timeOfObjective;
    }

    public double getOmega() {
        return this.omega;
    }

    public FrameTuple3DReadOnly getObjective() {
        return this.objective;
    }

    public SelectionMatrix3D getSelectionMatrix() {
        return this.selectionMatrix;
    }

    public int getNumberOfContacts() {
        return this.contactPlaneHelpers.size();
    }

    public MPCContactPlane getContactPlaneHelper(int i) {
        return this.contactPlaneHelpers.get(i);
    }

    public void setCostToGoConsumer(DoubleConsumer costToGoConsumer) {
        this.costToGoConsumer = costToGoConsumer;
    }

    public DoubleConsumer getCostToGoConsumer() {
        return this.costToGoConsumer;
    }

    public void setCostToGo(double costToGo) {
        if (this.costToGoConsumer != null) {
            this.costToGoConsumer.accept(costToGo);
        }
    }

    public void set(MPCValueCommand other) {
        if (this.getValueType() != other.getValueType()) {
            throw new IllegalArgumentException("Cannot set a command of type " + (Object)((Object)this.getValueType()) + " from a command of type " + (Object)((Object)other.getValueType()));
        }
        if (this.getDerivativeOrder() != other.getDerivativeOrder()) {
            throw new IllegalArgumentException("Cannot set a command of derivative order " + this.getDerivativeOrder() + " from a command of derivative order " + other.getDerivativeOrder());
        }
        this.clear();
        this.setCommandId(other.getCommandId());
        this.setObjective(other.getObjective());
        this.setSegmentNumber(other.getSegmentNumber());
        this.setTimeOfObjective(other.getTimeOfObjective());
        this.setOmega(other.getOmega());
        this.setWeight(other.getWeight());
        this.setConstraintType(other.getConstraintType());
        this.setCostToGoConsumer(other.getCostToGoConsumer());
        for (int i = 0; i < other.getNumberOfContacts(); ++i) {
            this.addContactPlaneHelper(other.getContactPlaneHelper(i));
        }
    }

    @Override
    public void setCommandId(int id) {
        this.commandId = id;
    }

    @Override
    public int getCommandId() {
        return this.commandId;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof MPCValueCommand) {
            MPCValueCommand other = (MPCValueCommand)object;
            if (this.commandId != other.commandId) {
                return false;
            }
            if (this.constraintType != other.constraintType) {
                return false;
            }
            if (this.getValueType() != other.getValueType()) {
                return false;
            }
            if (this.getDerivativeOrder() != other.getDerivativeOrder()) {
                return false;
            }
            if (this.segmentNumber != other.segmentNumber) {
                return false;
            }
            if (this.timeOfObjective != other.timeOfObjective) {
                return false;
            }
            if (this.omega != other.omega) {
                return false;
            }
            if (this.weight != other.weight) {
                return false;
            }
            if (!this.objective.equals((FrameTuple3DReadOnly)other.objective)) {
                return false;
            }
            if (this.contactPlaneHelpers.size() != other.contactPlaneHelpers.size()) {
                return false;
            }
            for (int i = 0; i < this.contactPlaneHelpers.size(); ++i) {
                if (this.contactPlaneHelpers.get(i).equals(other.contactPlaneHelpers.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        String string = this.getClass().getSimpleName() + ": value: " + (Object)((Object)this.getValueType()) + ", derivative order: " + this.getDerivativeOrder() + ", segment number: " + this.segmentNumber + ", constraint type: " + (Object)((Object)this.constraintType) + ", time of objective: " + this.timeOfObjective + ", omega: " + this.omega + ", weight: " + this.weight + ", objective: " + this.objective + ".";
        for (int i = 0; i < this.getNumberOfContacts(); ++i) {
            string = string + "\ncontact " + i + ": " + this.contactPlaneHelpers.get(i);
        }
        return string;
    }
}

