/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.modelPredictiveController.commands;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.commands.MPCCommand;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.commands.MPCCommandType;

public class MPCCommandList
implements MPCCommand<MPCCommandList> {
    private int commandId;
    private final List<MPCCommand<?>> commandList = new ArrayList();

    @Override
    public MPCCommandType getCommandType() {
        return MPCCommandType.LIST;
    }

    public void addCommand(MPCCommand<?> command) {
        if (command != null) {
            if (MPCCommandType.LIST == command.getCommandType()) {
                this.addCommandList((MPCCommandList)command);
            } else {
                this.commandList.add(command);
            }
        }
    }

    public void addCommandList(MPCCommandList commandList) {
        if (commandList == null) {
            return;
        }
        for (int i = 0; i < commandList.getNumberOfCommands(); ++i) {
            this.addCommand(commandList.getCommand(i));
        }
    }

    public void clear() {
        this.commandId = 0;
        this.commandList.clear();
    }

    public MPCCommand<?> getCommand(int commandIndex) {
        return this.commandList.get(commandIndex);
    }

    public int getNumberOfCommands() {
        return this.commandList.size();
    }

    @Override
    public void setCommandId(int id) {
        this.commandId = id;
    }

    @Override
    public int getCommandId() {
        return this.commandId;
    }

    public void set(MPCCommandList other) {
        this.clear();
        this.setCommandId(other.getCommandId());
        for (int i = 0; i < other.getNumberOfCommands(); ++i) {
            this.addCommand(other.getCommand(i));
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof MPCCommandList) {
            MPCCommandList other = (MPCCommandList)object;
            if (this.commandId != other.commandId) {
                return false;
            }
            if (this.getNumberOfCommands() != other.getNumberOfCommands()) {
                return false;
            }
            for (int commandIndex = 0; commandIndex < this.getNumberOfCommands(); ++commandIndex) {
                if (this.getCommand(commandIndex).equals(other.getCommand(commandIndex))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return "Nb of commands: " + this.getNumberOfCommands() + "\n" + this.commandList;
    }
}

