/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.modelPredictiveController.commands;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.commands.MPCCommand;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.commands.MPCCommandType;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.ioHandling.MPCContactPlane;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;

public class ForceTrackingCommand
implements MPCCommand<ForceTrackingCommand> {
    private int commandId;
    private final List<MPCContactPlane> contactPlaneHelpers = new ArrayList<MPCContactPlane>();
    private int segmentNumber;
    private double omega;
    private double weight;
    private double duration;
    private final FrameVector3D objectiveValue = new FrameVector3D();

    @Override
    public MPCCommandType getCommandType() {
        return MPCCommandType.FORCE_TRACKING;
    }

    public void clear() {
        this.segmentNumber = -1;
        this.duration = Double.NaN;
        this.objectiveValue.setToNaN();
        this.contactPlaneHelpers.clear();
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public void addContactPlaneHelper(MPCContactPlane contactPlaneHelper) {
        this.contactPlaneHelpers.add(contactPlaneHelper);
    }

    public void setSegmentNumber(int segmentNumber) {
        this.segmentNumber = segmentNumber;
    }

    public void setOmega(double omega) {
        this.omega = omega;
    }

    public void setSegmentDuration(double segmentDuration) {
        this.duration = segmentDuration;
    }

    public void setObjectiveValue(FrameVector3DReadOnly objectiveValue) {
        this.objectiveValue.set((FrameTuple3DReadOnly)objectiveValue);
    }

    public int getSegmentNumber() {
        return this.segmentNumber;
    }

    public double getWeight() {
        return this.weight;
    }

    public double getOmega() {
        return this.omega;
    }

    public int getNumberOfContacts() {
        return this.contactPlaneHelpers.size();
    }

    public MPCContactPlane getContactPlaneHelper(int i) {
        return this.contactPlaneHelpers.get(i);
    }

    public FrameVector3DReadOnly getObjectiveValue() {
        return this.objectiveValue;
    }

    public double getSegmentDuration() {
        return this.duration;
    }

    public void set(ForceTrackingCommand other) {
        this.clear();
        this.setCommandId(other.getCommandId());
        this.setSegmentNumber(other.getSegmentNumber());
        this.setOmega(other.getOmega());
        this.setWeight(other.getWeight());
        this.setObjectiveValue(other.getObjectiveValue());
        this.setSegmentDuration(other.getSegmentDuration());
        for (int i = 0; i < other.getNumberOfContacts(); ++i) {
            this.addContactPlaneHelper(other.getContactPlaneHelper(i));
        }
    }

    @Override
    public void setCommandId(int id) {
        this.commandId = id;
    }

    @Override
    public int getCommandId() {
        return this.commandId;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ForceTrackingCommand) {
            ForceTrackingCommand other = (ForceTrackingCommand)object;
            if (this.commandId != other.commandId) {
                return false;
            }
            if (this.segmentNumber != other.segmentNumber) {
                return false;
            }
            if (this.omega != other.omega) {
                return false;
            }
            if (this.weight != other.weight) {
                return false;
            }
            if (this.duration != other.duration) {
                return false;
            }
            if (this.objectiveValue != other.objectiveValue) {
                return false;
            }
            if (this.contactPlaneHelpers.size() != other.contactPlaneHelpers.size()) {
                return false;
            }
            for (int i = 0; i < this.contactPlaneHelpers.size(); ++i) {
                if (this.contactPlaneHelpers.get(i).equals(other.contactPlaneHelpers.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        String string = this.getClass().getSimpleName() + ": segment number: " + this.segmentNumber + ", omega: " + this.omega + ", weight: " + this.weight + ": duration: " + this.duration + ": objective value: " + this.objectiveValue + ".";
        for (int i = 0; i < this.getNumberOfContacts(); ++i) {
            string = string + "\ncontact " + i + ": " + this.contactPlaneHelpers.get(i);
        }
        return string;
    }
}

