/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.modelPredictiveController;

import gnu.trove.list.TIntList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntUnaryOperator;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ConstraintType;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.ContactPlaneProvider;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.EuclideanModelPredictiveController;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.MPCParameters;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.commands.DirectOrientationValueCommand;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.commands.MPCCommand;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.commands.OrientationContinuityCommand;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.commands.OrientationTrajectoryCommand;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.commands.OrientationValueCommand;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.core.OrientationTrajectoryConstructor;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.core.SE3MPCIndexHandler;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.core.SE3MPCQPSolver;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.customPolicies.CustomMPCPolicy;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.ioHandling.MPCContactPlane;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.ioHandling.OrientationMPCTrajectoryHandler;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.tools.MPCAngleTools;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.visualization.SE3MPCTrajectoryViewer;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.log.LogTools;
import us.ihmc.matrixlib.NativeMatrix;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.spatial.interfaces.WrenchBasics;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.robotics.math.trajectories.FixedFramePolynomialEstimator3D;
import us.ihmc.robotics.math.trajectories.generators.MultipleSegmentPositionTrajectoryGenerator;
import us.ihmc.yoVariables.euclid.YoVector3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameQuaternion;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;

public class SE3ModelPredictiveController
extends EuclideanModelPredictiveController {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private static final boolean defaultIncludeIntermediateOrientationTracking = true;
    private final double gravityZ;
    protected final double mass;
    protected final SE3MPCIndexHandler indexHandler;
    private final FrameOrientation3DBasics desiredBodyOrientation = new FrameQuaternion(worldFrame);
    private final FrameOrientation3DBasics referenceBodyOrientation = new FrameQuaternion(worldFrame);
    private final FrameVector3DBasics desiredBodyAngularVelocity = new FrameVector3D(worldFrame);
    private final FrameVector3DBasics referenceBodyAngularVelocity = new FrameVector3D(worldFrame);
    private final FrameVector3DBasics desiredBodyAngularAcceleration = new FrameVector3D(worldFrame);
    private final WrenchBasics desiredWrench = new Wrench(worldFrame, worldFrame);
    protected final YoFrameQuaternion currentBodyOrientation = new YoFrameQuaternion("currentBodyOrientation", worldFrame, this.registry);
    protected final YoFrameVector3D currentBodyAngularVelocity = new YoFrameVector3D("currentBodyAngularVelocity", worldFrame, this.registry);
    private final YoFrameQuaternion orientationAtEndOfWindow = new YoFrameQuaternion("orientationAtEndOfWindow", worldFrame, this.registry);
    private final YoFrameVector3D angularVelocityAtEndOfWindow = new YoFrameVector3D("angularVelocityAtEndOfWindow", worldFrame, this.registry);
    protected final YoVector3D currentBodyAxisAngleError = new YoVector3D("currentBodyAxisAngleError", this.registry);
    private final OrientationTrajectoryConstructor orientationTrajectoryConstructor;
    final OrientationMPCTrajectoryHandler orientationTrajectoryHandler;
    private SE3MPCTrajectoryViewer trajectoryViewer = null;
    final SE3MPCQPSolver qpSolver;
    protected final Matrix3DReadOnly momentOfInertia;
    private final MPCAngleTools angleTools = new MPCAngleTools();
    protected final YoVector3D currentBodyAngularVelocityError = new YoVector3D("currentBodyAngularVelocityError", this.registry);
    private final YoBoolean includeIntermediateOrientationTracking = new YoBoolean("includeIntermediateOrientationTracking", this.registry);
    private final IntUnaryOperator firstVariableIndex;
    private final List<CustomMPCPolicy> customMPCPoliciesToProcess = new ArrayList<CustomMPCPolicy>();
    private final DMatrixRMaj initialError = new DMatrixRMaj(6, 1);
    private final FrameVector3D desiredMomentArm = new FrameVector3D();
    private final FrameVector3D desiredPointTorque = new FrameVector3D();

    public SE3ModelPredictiveController(Matrix3DReadOnly momentOfInertia, MPCParameters mpcParameters, double gravityZ, double nominalCoMHeight, double mass, double dt, YoRegistry parentRegistry) {
        this(new SE3MPCIndexHandler(4), momentOfInertia, mpcParameters, gravityZ, nominalCoMHeight, mass, dt, parentRegistry);
    }

    public SE3ModelPredictiveController(SE3MPCIndexHandler indexHandler, Matrix3DReadOnly momentOfInertia, MPCParameters mpcParameters, double gravityZ, double nominalCoMHeight, double mass, double dt, YoRegistry parentRegistry) {
        super(indexHandler, mpcParameters, mass, gravityZ, nominalCoMHeight, parentRegistry);
        this.indexHandler = indexHandler;
        this.gravityZ = Math.abs(gravityZ);
        this.mass = mass;
        this.registry.addChild(indexHandler.getRegistry());
        this.firstVariableIndex = indexHandler::getOrientationStartIndex;
        this.orientationTrajectoryConstructor = new OrientationTrajectoryConstructor(indexHandler, mpcParameters.getOrientationAngleTrackingWeightProvider(), mpcParameters.getOrientationVelocityTrackingWeightProvider(), this.omega, mass, gravityZ);
        this.orientationTrajectoryHandler = new OrientationMPCTrajectoryHandler(indexHandler, this.orientationTrajectoryConstructor);
        this.registry.addChild(this.orientationTrajectoryHandler.getRegistry());
        this.momentOfInertia = momentOfInertia;
        this.qpSolver = new SE3MPCQPSolver(indexHandler, dt, gravityZ, this.registry);
        this.qpSolver.setMaxNumberOfIterations(10);
        this.qpSolver.setFirstOrientationVariableRegularization(1.0E-10);
        this.qpSolver.setSecondOrientationVariableRegularization(1.0E-10);
        this.includeIntermediateOrientationTracking.set(true);
        parentRegistry.addChild(this.registry);
    }

    public void addCustomPolicyToProcess(CustomMPCPolicy policyToProcess) {
        this.customMPCPoliciesToProcess.add(policyToProcess);
    }

    @Override
    protected void initializeIndexHandler() {
        List<ContactPlaneProvider> planningWindow = this.previewWindowCalculator.getPlanningWindow();
        this.indexHandler.initialize(planningWindow);
    }

    @Override
    protected void solveForTrajectoryOutsidePreviewWindow(List<ContactPlaneProvider> contactSequence) {
        super.solveForTrajectoryOutsidePreviewWindow(contactSequence);
        this.orientationTrajectoryHandler.solveForTrajectoryOutsidePreviewWindow(contactSequence);
        this.orientationTrajectoryHandler.computeDiscretizedReferenceTrajectory(this.currentTimeInState.getDoubleValue());
        this.orientationTrajectoryHandler.computeReferenceValue(this.previewWindowCalculator.getPreviewWindowDuration() + this.currentTimeInState.getDoubleValue());
    }

    @Override
    protected void setTerminalConditions() {
        super.setTerminalConditions();
        this.orientationAtEndOfWindow.set(this.orientationTrajectoryHandler.getReferenceBodyOrientation());
        this.angularVelocityAtEndOfWindow.set((FrameTuple3DReadOnly)this.orientationTrajectoryHandler.getReferenceBodyVelocity());
    }

    @Override
    protected void extractSolution(DMatrixRMaj solutionCoefficients) {
        super.extractSolution(solutionCoefficients);
        this.orientationTrajectoryHandler.extractSolutionForPreviewWindow(solutionCoefficients, this.currentTimeInState.getDoubleValue(), this.previewWindowCalculator.getPreviewWindowDuration(), (FrameQuaternionReadOnly)this.currentBodyOrientation, (FrameVector3DReadOnly)this.currentBodyAngularVelocity);
    }

    @Override
    protected void computeObjectives(List<ContactPlaneProvider> contactSequence) {
        super.computeObjectives(contactSequence);
        this.computeOrientationObjectives();
        this.computeCustomMPCPolicyObjectives(contactSequence);
    }

    private void computeOrientationObjectives() {
        this.computeInitialError();
        this.orientationTrajectoryConstructor.compute(this.previewWindowCalculator.getPlanningWindow(), this.momentOfInertia, this.linearTrajectoryHandler, this.orientationTrajectoryHandler, this.contactHandler.getContactPlanes());
        int numberOfSegments = this.indexHandler.getNumberOfSegments();
        for (int i = 0; i < numberOfSegments; ++i) {
            if (this.includeIntermediateOrientationTracking.getBooleanValue()) {
                this.mpcCommands.addCommand(this.orientationTrajectoryConstructor.getOrientationTrajectoryCommands().get(i));
            }
            if (i >= numberOfSegments - 1) continue;
            this.mpcCommands.addCommand(this.computeOrientationContinuityCommand(i, this.commandProvider.getNextOrientationContinuityCommand()));
        }
        this.mpcCommands.addCommand(this.computeInitialOrientationErrorCommand(this.commandProvider.getNextDirectOrientationValueCommand()));
        this.mpcCommands.addCommand(this.computeFinalOrientationMinimizationCommand(this.commandProvider.getNextOrientationValueCommand()));
    }

    private void computeCustomMPCPolicyObjectives(List<ContactPlaneProvider> contactSequence) {
        for (int i = 0; i < this.customMPCPoliciesToProcess.size(); ++i) {
            this.mpcCommands.addCommand(this.customMPCPoliciesToProcess.get(i).computeMPCCommand(this.contactHandler, contactSequence, this.omega.getValue()));
        }
        this.customMPCPoliciesToProcess.clear();
    }

    private void computeInitialError() {
        this.orientationTrajectoryHandler.computeReferenceValue(this.currentTimeInState.getDoubleValue());
        FrameOrientation3DReadOnly referenceOrientation = this.orientationTrajectoryHandler.getReferenceBodyOrientation();
        this.angleTools.computeRotationError((Orientation3DReadOnly)referenceOrientation, (Orientation3DReadOnly)this.currentBodyOrientation, (Vector3DBasics)this.currentBodyAxisAngleError);
        this.currentBodyAxisAngleError.get((DMatrix)this.initialError);
        this.currentBodyAngularVelocityError.sub((Tuple3DReadOnly)this.currentBodyAngularVelocity, (Tuple3DReadOnly)this.orientationTrajectoryHandler.getReferenceBodyVelocity());
        referenceOrientation.inverseTransform((Tuple3DBasics)this.currentBodyAngularVelocityError);
        this.currentBodyAngularVelocityError.get(3, (DMatrix)this.initialError);
    }

    private MPCCommand<?> computeInitialOrientationErrorCommand(DirectOrientationValueCommand commandToPack) {
        commandToPack.reset();
        commandToPack.setSegmentNumber(0);
        commandToPack.setObjectiveValue(this.initialError);
        commandToPack.setConstraintType(ConstraintType.OBJECTIVE);
        commandToPack.setObjectiveWeight(this.mpcParameters.getInitialOrientationWeight());
        return commandToPack;
    }

    private MPCCommand<?> computeFinalOrientationMinimizationCommand(OrientationValueCommand commandToPack) {
        commandToPack.reset();
        int segmentNumber = this.indexHandler.getNumberOfSegments() - 1;
        commandToPack.setSegmentNumber(segmentNumber);
        OrientationTrajectoryCommand trajectoryCommand = this.orientationTrajectoryConstructor.getOrientationTrajectoryCommands().get(segmentNumber);
        commandToPack.setAMatrix(trajectoryCommand.getLastAMatrix());
        commandToPack.setBMatrix(trajectoryCommand.getLastBMatrix());
        commandToPack.setCMatrix(trajectoryCommand.getLastCMatrix());
        commandToPack.getObjectiveValue().zero();
        commandToPack.setConstraintType(ConstraintType.OBJECTIVE);
        commandToPack.setObjectiveWeight(this.mpcParameters.getFinalOrientationWeight());
        return commandToPack;
    }

    private MPCCommand<?> computeOrientationContinuityCommand(int segmentNumber, OrientationContinuityCommand commandToPack) {
        commandToPack.reset();
        commandToPack.setSegmentNumber(segmentNumber);
        OrientationTrajectoryCommand trajectoryCommand = this.orientationTrajectoryConstructor.getOrientationTrajectoryCommands().get(segmentNumber);
        commandToPack.setAMatrix(trajectoryCommand.getLastAMatrix());
        commandToPack.setBMatrix(trajectoryCommand.getLastBMatrix());
        commandToPack.setCMatrix(trajectoryCommand.getLastCMatrix());
        commandToPack.setConstraintType(ConstraintType.EQUALITY);
        return commandToPack;
    }

    @Override
    public void setupCoMTrajectoryViewer(YoGraphicsListRegistry yoGraphicsListRegistry) {
        this.trajectoryViewer = new SE3MPCTrajectoryViewer(this.registry, yoGraphicsListRegistry);
    }

    @Override
    protected void updateCoMTrajectoryViewer() {
        if (this.trajectoryViewer != null) {
            this.trajectoryViewer.compute(this, this.currentTimeInState.getDoubleValue());
        }
    }

    @Override
    protected void resetActiveSet() {
        this.qpSolver.notifyResetActiveSet();
        this.qpSolver.resetRateRegularization();
    }

    @Override
    protected NativeMatrix solveQP() {
        this.qpSolver.initialize();
        this.qpSolver.submitMPCCommandList(this.mpcCommands);
        this.qpSolver.setUseWarmStart(this.useWarmStart.getBooleanValue());
        if (this.useWarmStart.getBooleanValue()) {
            this.assembleActiveSet(this.firstVariableIndex);
            this.qpSolver.setPreviousSolution(this.previousSolution);
            this.qpSolver.setActiveInequalityIndices((TIntList)this.activeInequalityConstraints);
        }
        if (!this.qpSolver.solve()) {
            LogTools.info((String)"Failed to find solution");
            this.extractNewActiveSetData(false, this.qpSolver, this.firstVariableIndex);
            return null;
        }
        this.extractNewActiveSetData(true, this.qpSolver, this.firstVariableIndex);
        return this.qpSolver.getSolution();
    }

    @Override
    public void compute(double timeInPhase, FixedFramePoint3DBasics comPositionToPack, FixedFrameVector3DBasics comVelocityToPack, FixedFrameVector3DBasics comAccelerationToPack, FixedFramePoint3DBasics dcmPositionToPack, FixedFrameVector3DBasics dcmVelocityToPack, FixedFramePoint3DBasics vrpPositionToPack, FixedFrameVector3DBasics vrpVelocityToPack, FixedFramePoint3DBasics ecmpPositionToPack) {
        this.linearTrajectoryHandler.compute(timeInPhase);
        this.wrenchTrajectoryHandler.compute(timeInPhase);
        this.orientationTrajectoryHandler.compute(timeInPhase);
        comPositionToPack.setMatchingFrame((FrameTuple3DReadOnly)this.linearTrajectoryHandler.getDesiredCoMPosition());
        comVelocityToPack.setMatchingFrame((FrameTuple3DReadOnly)this.linearTrajectoryHandler.getDesiredCoMVelocity());
        comAccelerationToPack.setMatchingFrame((FrameTuple3DReadOnly)this.linearTrajectoryHandler.getDesiredCoMAcceleration());
        dcmPositionToPack.setMatchingFrame((FrameTuple3DReadOnly)this.linearTrajectoryHandler.getDesiredDCMPosition());
        dcmVelocityToPack.setMatchingFrame((FrameTuple3DReadOnly)this.linearTrajectoryHandler.getDesiredDCMVelocity());
        vrpPositionToPack.setMatchingFrame((FrameTuple3DReadOnly)this.linearTrajectoryHandler.getDesiredVRPPosition());
        vrpVelocityToPack.setMatchingFrame((FrameTuple3DReadOnly)this.linearTrajectoryHandler.getDesiredVRPVelocity());
        this.referenceBodyOrientation.setMatchingFrame(this.orientationTrajectoryHandler.getReferenceBodyOrientation());
        this.referenceBodyAngularVelocity.setMatchingFrame((FrameTuple3DReadOnly)this.orientationTrajectoryHandler.getReferenceBodyVelocity());
        this.desiredBodyOrientation.setMatchingFrame(this.orientationTrajectoryHandler.getDesiredBodyOrientation());
        this.desiredBodyAngularVelocity.setMatchingFrame((FrameTuple3DReadOnly)this.orientationTrajectoryHandler.getDesiredAngularVelocity());
        this.desiredBodyAngularAcceleration.setMatchingFrame((FrameTuple3DReadOnly)this.orientationTrajectoryHandler.getDesiredAngularAcceleration());
        this.desiredWrench.setMatchingFrame(this.wrenchTrajectoryHandler.getDesiredWrench());
        ecmpPositionToPack.setMatchingFrame((FrameTuple3DReadOnly)vrpPositionToPack);
        double nominalHeight = this.gravityZ / MathTools.square((double)this.omega.getValue());
        ecmpPositionToPack.set((FrameTuple3DReadOnly)this.desiredVRPPosition);
        ecmpPositionToPack.subZ(nominalHeight);
    }

    public void setInitialBodyOrientationState(FrameOrientation3DReadOnly bodyOrientation, FrameVector3DReadOnly bodyAngularVelocity) {
        this.orientationTrajectoryHandler.setInitialBodyOrientationState(bodyOrientation, bodyAngularVelocity);
    }

    public void setCurrentState(FramePoint3DReadOnly centerOfMassPosition, FrameVector3DReadOnly centerOfMassVelocity, FrameOrientation3DReadOnly bodyOrientation, FrameVector3DReadOnly bodyAngularVelocity, double timeInState) {
        this.setCurrentCenterOfMassState(centerOfMassPosition, centerOfMassVelocity, timeInState);
        this.currentBodyOrientation.setMatchingFrame(bodyOrientation);
        this.currentBodyAngularVelocity.setMatchingFrame((FrameTuple3DReadOnly)bodyAngularVelocity);
    }

    public void setInternalAngularMomentumTrajectory(MultipleSegmentPositionTrajectoryGenerator<FixedFramePolynomialEstimator3D> internalAngularMomentumTrajectory) {
        this.orientationTrajectoryHandler.setInternalAngularMomentumTrajectory(internalAngularMomentumTrajectory);
    }

    public FrameOrientation3DReadOnly getDesiredBodyOrientationSolution() {
        return this.desiredBodyOrientation;
    }

    public FrameVector3DReadOnly getDesiredBodyAngularVelocitySolution() {
        return this.desiredBodyAngularVelocity;
    }

    public FrameVector3DReadOnly getDesiredBodyAngularAccelerationSolution() {
        return this.desiredBodyAngularAcceleration;
    }

    public FrameOrientation3DReadOnly getReferenceBodyOrientation() {
        return this.referenceBodyOrientation;
    }

    public FrameVector3DReadOnly getReferenceBodyAngularVelocity() {
        return this.referenceBodyAngularVelocity;
    }

    public WrenchReadOnly getDesiredWrench() {
        return this.desiredWrench;
    }

    public void computeTorque(double time, FixedFrameVector3DBasics torqueToPack) {
        List<MPCContactPlane> contactPlanes = this.contactHandler.getContactPlanesForSegment(0);
        this.linearTrajectoryHandler.compute(time);
        torqueToPack.setToZero();
        time -= this.currentTimeInState.getDoubleValue();
        for (int planeIdx = 0; planeIdx < contactPlanes.size(); ++planeIdx) {
            MPCContactPlane contactPlane = contactPlanes.get(planeIdx);
            contactPlane.computeContactForce(this.omega.getValue(), time);
            for (int pointIdx = 0; pointIdx < contactPlane.getNumberOfContactPoints(); ++pointIdx) {
                this.desiredMomentArm.sub((FrameTuple3DReadOnly)contactPlane.getContactPointHelper(pointIdx).getBasisVectorOrigin(), (FrameTuple3DReadOnly)this.linearTrajectoryHandler.getDesiredCoMPosition());
                this.desiredPointTorque.cross((FrameVector3DReadOnly)this.desiredMomentArm, contactPlane.getContactPointHelper(pointIdx).getContactAcceleration());
                this.desiredPointTorque.scale(this.mass);
                torqueToPack.add((FrameTuple3DReadOnly)this.desiredPointTorque);
            }
        }
    }
}

