/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.modelPredictiveController;

import gnu.trove.list.TIntList;
import java.util.List;
import java.util.function.IntUnaryOperator;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.ContactPlaneProvider;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.EuclideanModelPredictiveController;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.MPCParameters;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.core.LinearMPCIndexHandler;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.core.LinearMPCQPSolver;
import us.ihmc.log.LogTools;
import us.ihmc.matrixlib.NativeMatrix;
import us.ihmc.yoVariables.registry.YoRegistry;

public class CoMTrajectoryModelPredictiveController
extends EuclideanModelPredictiveController {
    protected static final boolean debug = false;
    final LinearMPCQPSolver qpSolver;
    private final LinearMPCIndexHandler indexHandler;
    private final IntUnaryOperator firstVariableIndex;

    public CoMTrajectoryModelPredictiveController(MPCParameters mpcParameters, double mass, double gravityZ, double nominalCoMHeight, double dt, YoRegistry parentRegistry) {
        this(new LinearMPCIndexHandler(4), mpcParameters, mass, gravityZ, nominalCoMHeight, dt, parentRegistry);
    }

    public CoMTrajectoryModelPredictiveController(LinearMPCIndexHandler indexHandler, MPCParameters mpcParameters, double mass, double gravityZ, double nominalCoMHeight, double dt, YoRegistry parentRegistry) {
        super(indexHandler, mpcParameters, mass, gravityZ, nominalCoMHeight, parentRegistry);
        this.indexHandler = indexHandler;
        this.firstVariableIndex = indexHandler::getComCoefficientStartIndex;
        this.qpSolver = new LinearMPCQPSolver(indexHandler, dt, gravityZ, this.registry);
        parentRegistry.addChild(this.registry);
    }

    @Override
    protected void initializeIndexHandler() {
        List<ContactPlaneProvider> planningWindow = this.previewWindowCalculator.getPlanningWindow();
        this.indexHandler.initialize(planningWindow);
    }

    @Override
    protected void resetActiveSet() {
        this.qpSolver.notifyResetActiveSet();
        this.qpSolver.resetRateRegularization();
    }

    @Override
    protected NativeMatrix solveQP() {
        this.qpSolver.initialize();
        this.qpSolver.submitMPCCommandList(this.mpcCommands);
        this.qpSolver.setUseWarmStart(this.useWarmStart.getBooleanValue());
        if (this.useWarmStart.getBooleanValue()) {
            this.assembleActiveSet(this.firstVariableIndex);
            this.qpSolver.setPreviousSolution(this.previousSolution);
            this.qpSolver.setActiveInequalityIndices((TIntList)this.activeInequalityConstraints);
        }
        if (!this.qpSolver.solve()) {
            LogTools.info((String)"Failed to find solution");
            this.extractNewActiveSetData(false, this.qpSolver, this.firstVariableIndex);
            return null;
        }
        NativeMatrix solutionCoefficients = this.qpSolver.getSolution();
        this.extractNewActiveSetData(true, this.qpSolver, this.firstVariableIndex);
        return solutionCoefficients;
    }
}

